<?php if ( !defined( 'ABSPATH' ) ) {die;} // Cannot access directly.

CSF::createWidget( 'bixola_footer_info_three', array(
    'title'       => 'Bixola Footer Info Three',
    'classname'   => 'bixola_footer_info_three',
    'description' => 'Show Footer Info Three Widget By Bixola',
    'fields'      => array(

        array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => esc_html__( 'Title', 'bixola-core' ),
        ),

		array(
			'id'       => 'logo',
			'type'     => 'upload',
			'title'    => esc_html__( 'Logo', 'bixola-core' ),
			'subtitle' => esc_html__( 'Upload Your Logo.', 'bixola-core' ),
			'default'  => get_template_directory_uri() . '/assets/images/resources/footer-logo-2.png',
			'library'  => 'image',
			'preview'  => true,
		),

        array(
            'id'      => 'description',
            'type'    => 'textarea',
            'title'   => esc_html__( 'Description', 'bixola-core' ),
            'default' => __( 'Lorem Ipsum is simply dummy text of <br> printing and typesetting industry.', 'bixola-core' ),
        ),

        array(
            'id'    => 'mail_id',
            'type'  => 'text',
            'title' => esc_html__( 'Mail ID', 'bixola-core' ),
            'default' => esc_html__( 'info@example.com', 'bixola-core' ),
        ),

    ),
) );

if ( !function_exists( 'bixola_footer_info_three' ) ) {
    function bixola_footer_info_three( $args, $instance ) {

        echo $args['before_widget'];

        if ( ! empty( $instance['title'] ) ) {
          	echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
        }

		?>

			<div class="footer-widget-three__column footer-widget-three__about">
				<div class="footer-widget-two__logo">
					<a href="<?php print home_url();?>">
						<img src="<?php print esc_url( $instance['logo'] );?>" alt="">
					</a>
				</div>
				<?php if( !empty ( $instance['description'] ) ): ?>
					<p class="footer-widget-three__about-text">
						<?php print twinkle_kses($instance['description']); ?>
					</p>
				<?php endif; ?>
				<?php if ( !empty( $instance['mail_id'] ) ): ?>
					<div class="footer-widget-three__email">
						<a href="mailto:<?php print esc_url( $instance['mail_id'] );?>">
							<span class="icon-gmail"></span>
							<?php print esc_html( $instance['mail_id'] );?>
						</a>
					</div>
				<?php endif; ?>
			</div>

		<?php

        echo $args['after_widget'];

    }
}