<?php if ( !defined( 'ABSPATH' ) ) {die;} // Cannot access directly.

CSF::createWidget( 'bixola_footer_contact_info_one', array(
    'title'       => 'Bixola Footer Contact Info One',
    'classname'   => 'bixola_footer_contact_info_one',
    'description' => 'Show Footer Contact Info One Widget By Bixola',
    'fields'      => array(

        array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => esc_html__( 'Title', 'bixola-core' ),
        ),

        array(
            'id'    => 'address_label',
            'type'  => 'text',
            'title' => esc_html__( 'Address Label', 'bixola-core' ),
            'default' => esc_html__( 'Location', 'bixola-core' ),
        ),

        array(
            'id'    => 'address',
            'type'  => 'text',
            'title' => esc_html__( 'Address', 'bixola-core' ),
            'default' => esc_html__( '915 Hill Street, USA', 'bixola-core' ),
        ),

        array(
            'id'    => 'phone_label',
            'type'  => 'text',
            'title' => esc_html__( 'Phone Label', 'bixola-core' ),
            'default' => esc_html__( 'Get a quote', 'bixola-core' ),
        ),

        array(
            'id'    => 'phone_number',
            'type'  => 'text',
            'title' => esc_html__( 'Phone Number', 'bixola-core' ),
            'default' => esc_html__( '+1(333) 000-0000', 'bixola-core' ),
        ),

        array(
            'id'    => 'phone_number_link',
            'type'  => 'text',
            'title' => esc_html__( 'Title', 'bixola-core' ),
            'default' => '+13330000000',
        ),

        array(
            'id'    => 'mail_label',
            'type'  => 'text',
            'title' => esc_html__( 'Mail Label', 'bixola-core' ),
            'default' => esc_html__( 'Send a mail', 'bixola-core' ),
        ),

        array(
            'id'    => 'mail',
            'type'  => 'text',
            'title' => esc_html__( 'Mail ID', 'bixola-core' ),
            'default' => esc_html__( 'example@email.com', 'bixola-core' ),
        ),

        array(
            'id'    => 'mail_link',
            'type'  => 'text',
            'title' => esc_html__( 'Mail Link', 'bixola-core' ),
            'default' => 'example@email.com',
        ),

    ),
) );

if ( !function_exists( 'bixola_footer_contact_info_one' ) ) {
    function bixola_footer_contact_info_one( $args, $instance ) {

        echo $args['before_widget'];

		?>

			<div class="footer-widget__column footer-widget__contact">
				<div class="footer-widget__title-box">
					<?php if ( ! empty( $instance['title'] ) ) {
						echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
					} ?>
				</div>
				<ul class="footer-widget__contact-list list-unstyled">
					<?php if( !empty ( $instance['address'] ) ): ?>
						<li>
							<div class="icon">
								<span class="icon-location-1"></span>
							</div>
							<div class="content">
								<h3><?php print esc_html($instance['address_label']); ?></h3>
								<p><?php print esc_html($instance['address']); ?></p>
							</div>
						</li>
					<?php endif; ?>
					<?php if( !empty ( $instance['phone_number'] ) ): ?>
						<li>
							<div class="icon">
								<span class="icon-phone"></span>
							</div>
							<div class="content">
								<h3><?php print esc_html($instance['phone_label']); ?></h3>
								<p><a href="tel:<?php print esc_attr($instance['phone_number_link']); ?>"><?php print esc_html($instance['phone_number']); ?></a></p>
							</div>
						</li>
					<?php endif; ?>
					<?php if( !empty ( $instance['mail'] ) ): ?>
						<li>
							<div class="icon">
								<span class="icon-envelope"></span>
							</div>
							<div class="content">
								<h3><?php print esc_html($instance['mail_label']); ?></h3>
								<p><a href="mailto:<?php print esc_attr($instance['mail_link']); ?>"><?php print esc_html($instance['mail']); ?></a></p>
							</div>
						</li>
					<?php endif; ?>
				</ul>
			</div>

		<?php

        echo $args['after_widget'];

    }
}