<?php
namespace BixolaCore\Widgets;

use \Elementor\Widget_Base;
use \Elementor\Control_Media;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Css_Filter;
use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * OptiBoom Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Bixola_Portfolio_Masonry extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bixola_portfolio_masonry';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Portfolio Masonry', 'bixola-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'bixola-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bixola_core' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'bixola-core' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

        $this->start_controls_section(
            '_content_design_layout',
            [
                'label' => esc_html__( 'Design Layout',  'bixola-core'  ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label' => esc_html__('Select Layout', 'bixola-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'bixola-core'),
                    'layout-2' => esc_html__('Layout 2', 'bixola-core'),
                ],
                'default' => 'layout-1',
            ]
        );
        
        $this->end_controls_section();
        
        $this->start_controls_section(
            '_content_title',
            [
                'label' => esc_html__( 'Title & Content',  'bixola-core'  ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );
        
        $this->add_control(
            'section_subheading',
            [
                'label' => esc_html__( 'Subheading', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'RECENT CASE STUDIES', 'bixola-core' ),
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'section_title',
            [
                'label' => esc_html__( 'Title', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'We Are Specialist For Many <br> Consulting Cases', 'bixola-core' ),
                'label_block' => true,
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            'bixola_filter',
            [
                'label' => esc_html__('Portfolio Masonry List', 'bixola-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'all_masonry',
            [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('all', 'bixola-core'),
                'label_block' => true,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'bixola_filter_tags', [
                'label' => esc_html__('Tag Name', 'bixola-core'),
                'description' => esc_html__('Please added only one tag using small letter.', 'bixola-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('exterior', 'bixola-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'bixola_filter_tags_label', [
                'label' => esc_html__('Tag Label', 'bixola-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'bixola_filter_list',
            [
                'label' => esc_html__('Tag - List', 'bixola-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'bixola_filter_tags_label' => esc_html__('Business Strategy', 'bixola-core'),
                        'bixola_filter_tags' => esc_html__('business', 'bixola-core'),
                    ],
                    [
                        'bixola_filter_tags_label' => esc_html__('Financial', 'bixola-core'),
                        'bixola_filter_tags' => esc_html__('financial', 'bixola-core'),
                    ],
                    [
                        'bixola_filter_tags_label' => esc_html__('Planning', 'bixola-core'),
                        'bixola_filter_tags' => esc_html__('planning', 'bixola-core'),
                    ],
                    [
                        'bixola_filter_tags_label' => esc_html__('Tax Strategy', 'bixola-core'),
                        'bixola_filter_tags' => esc_html__('tax', 'bixola-core'),
                    ],
                    [
                        'bixola_filter_tags_label' => esc_html__('Investment', 'bixola-core'),
                        'bixola_filter_tags' => esc_html__('investment', 'bixola-core'),
                    ],
                ],
                'title_field' => '{{{ bixola_filter_tags_label }}}',
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'portfolio_masonary_info_tags',
            [
                'label' => esc_html__('Tags', 'optiboom-core'),
                'description' => esc_html__('Please write tags using small letter. For Multiple tags use space. Example: exterior view', 'optiboom-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'portfolio_masonary_image',
            [
                'label' => esc_html__( 'Choose Image', 'bixola-core' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        
        $repeater->add_control(
            'portfolio_masonary_title',
            [
                'label' => esc_html__( 'Title', 'bixola-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'portfolio_masonary_subheading',
            [
                'label' => esc_html__( 'Subheading', 'bixola-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );
        
        $repeater->add_control(
            'portfolio_masonary_button_link_type',
            [
                'label' => esc_html__( 'Button Link Type', 'bixola-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'portfolio_masonary_button_link',
            [
                'label' => esc_html__( 'Button link', 'bixola-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('https://your-link.com', 'bixola-core'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'condition' => [
                    'portfolio_masonary_button_link_type' => '1',
                ],
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'portfolio_masonary_button_page_link',
            [
                'label' => esc_html__( 'Select Button Page', 'bixola-core' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => bixola_get_all_pages(),
                'condition' => [
                    'portfolio_masonary_button_link_type' => '2',
                ]
            ]
        );

        $this->add_control(
            'portfolio_masonary_list',
            [
                'label' => esc_html__( 'Portfolio Masonary List', 'bixola-core' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'portfolio_masonary_subheading' => __( 'Business Audit', 'bixola-core' ),
                        'portfolio_masonary_title' => __( 'Our Business Growth', 'bixola-core' ),
                        'portfolio_masonary_info_tags' => __( 'business investment tax', 'bixola-core' ),
                    ],
                    [
                        'portfolio_masonary_subheading' => __( 'Business Audit', 'bixola-core' ),
                        'portfolio_masonary_title' => __( 'Our Womens Empowerment', 'bixola-core' ),
                        'portfolio_masonary_info_tags' => __( 'financial investment', 'bixola-core' ),
                    ],
                    [
                        'portfolio_masonary_subheading' => __( 'Business Audit', 'bixola-core' ),
                        'portfolio_masonary_title' => __( 'Our Business Audit', 'bixola-core' ),
                        'portfolio_masonary_info_tags' => __( 'financial investment', 'bixola-core' ),
                    ],
                    [
                        'portfolio_masonary_subheading' => __( 'Business Audit', 'bixola-core' ),
                        'portfolio_masonary_title' => __( 'Our Business Planning', 'bixola-core' ),
                        'portfolio_masonary_info_tags' => __( 'financial', 'bixola-core' ),
                    ],
                    [
                        'portfolio_masonary_subheading' => __( 'Business Audit', 'bixola-core' ),
                        'portfolio_masonary_title' => __( 'Our Financial Advices', 'bixola-core' ),
                        'portfolio_masonary_info_tags' => __( 'business investment tax', 'bixola-core' ),
                    ],
                ],
                'title_field' => '{{{ portfolio_masonary_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_column',
            [
                'label' => esc_html__( 'Column',  'bixola-core'  ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'column_desktop',
            [
                'label' => esc_html__( 'Columns for Desktop', 'bixola-core' ),
                'description' => esc_html__( 'Screen width equal to or greater than 1200px', 'bixola-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    12 => esc_html__( '1 Columns', 'bixola-core' ),
                    6 => esc_html__( '2 Columns', 'bixola-core' ),
                    4 => esc_html__( '3 Columns', 'bixola-core' ),
                    3 => esc_html__( '4 Columns', 'bixola-core' ),
                    5 => esc_html__( '5 Columns (For Carousel Item)', 'bixola-core' ),
                    2 => esc_html__( '6 Columns', 'bixola-core' ),
                    1 => esc_html__( '12 Columns', 'bixola-core' ),
                ],
                'separator' => 'before',
                'default' => 4,
                'style_transfer' => true,
            ]
        );

        $this->add_control(
            'column_laptop',
            [
                'label' => esc_html__( 'Columns for Large', 'bixola-core' ),
                'description' => esc_html__( 'Screen width equal to or greater than 992px', 'bixola-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    12 => esc_html__( '1 Columns', 'bixola-core' ),
                    6 => esc_html__( '2 Columns', 'bixola-core' ),
                    4 => esc_html__( '3 Columns', 'bixola-core' ),
                    3 => esc_html__( '4 Columns', 'bixola-core' ),
                    5 => esc_html__( '5 Columns (For Carousel Item)', 'bixola-core' ),
                    2 => esc_html__( '6 Columns', 'bixola-core' ),
                    1 => esc_html__( '12 Columns', 'bixola-core' ),
                ],
                'separator' => 'before',
                'default' => 4,
                'style_transfer' => true,
            ]
        );

        $this->add_control(
            'column_tablet',
            [
                'label' => esc_html__( 'Columns for Tablet', 'bixola-core' ),
                'description' => esc_html__( 'Screen width equal to or greater than 768px', 'bixola-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    12 => esc_html__( '1 Columns', 'bixola-core' ),
                    6 => esc_html__( '2 Columns', 'bixola-core' ),
                    4 => esc_html__( '3 Columns', 'bixola-core' ),
                    3 => esc_html__( '4 Columns', 'bixola-core' ),
                    5 => esc_html__( '5 Columns (For Carousel Item)', 'bixola-core' ),
                    2 => esc_html__( '6 Columns', 'bixola-core' ),
                    1 => esc_html__( '12 Columns', 'bixola-core' ),
                ],
                'separator' => 'before',
                'default' => 6,
                'style_transfer' => true,
            ]
        );

        $this->add_control(
            'column_mobile',
            [
                'label' => esc_html__( 'Columns for Mobile', 'bixola-core' ),
                'description' => esc_html__( 'Screen width less than 767px', 'bixola-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    12 => esc_html__( '1 Columns', 'bixola-core' ),
                    6 => esc_html__( '2 Columns', 'bixola-core' ),
                    4 => esc_html__( '3 Columns', 'bixola-core' ),
                    3 => esc_html__( '4 Columns', 'bixola-core' ),
                    5 => esc_html__( '5 Columns (For Carousel Item)', 'bixola-core' ),
                    2 => esc_html__( '6 Columns', 'bixola-core' ),
                    1 => esc_html__( '12 Columns', 'bixola-core' ),
                ],
                'separator' => 'before',
                'default' => 12,
                'style_transfer' => true,
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            '_style_design_layout',
            [
                'label' => __( 'Design Layout', 'bixola-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'design_layout_margin',
            [
                'label' => __( 'Margin', 'bixola-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'design_layout_padding',
            [
                'label' => __( 'Padding', 'bixola-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'design_layout_background',
            [
                'label' => __( 'Background', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_style_title',
            [
                'label' => esc_html__( 'Title & Content',  'bixola-core'  ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );
        
        $this->add_control(
            '_heading_style_section_subheading',
            [
                'label' => esc_html__( 'Subheading', 'bixola-core' ),
                'type' => Controls_Manager::HEADING,
            ]
        );
        
        $this->add_responsive_control(
            'section_subheading_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .section-title-three__tagline' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'section_subheading_color',
            [
                'label' => __( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title-three__tagline' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'section_subheading_typography',
                'selector' => '{{WRAPPER}} .section-title-three__tagline',
            ]
        );

        $this->add_control(
            '_heading_style_section_title',
            [
                'label' => esc_html__( 'Title', 'bixola-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        
        $this->add_responsive_control(
            'section_title_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .section-title-three__title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'section_title_color',
            [
                'label' => __( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title-three__title' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'section_title_typography',
                'selector' => '{{WRAPPER}} .section-title-three__title',
            ]
        );

        $this->add_control(
            '_heading_style_section_title_layout',
            [
                'label' => esc_html__( 'Layout', 'bixola-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'section_title_layout_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-three__filter' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_section();
    
        $this->start_controls_section(
            '_style_masonry_filter',
            [
                'label' => __( 'Filter Menu', 'bixola-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( '_tabs_masonry_filter' );
        
        $this->start_controls_tab(
            'masonry_filter_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'bixola-core' ),
            ]
        );
        
        $this->add_control(
            'masonry_filter_color',
            [
                'label'     => esc_html__( 'Color', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-three__filter.style1 li .filter-text' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .portfolio-page__filter.style1 li .filter-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'masonry_filter_background',
            [
                'label'     => esc_html__( 'Background', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-three__filter.style1 li .filter-text' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .portfolio-page__filter.style1 li .filter-text' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'masonry_filter_border',
            [
                'label'     => esc_html__( 'Border', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-three__filter.style1 li .filter-text' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .portfolio-page__filter.style1 li .filter-text' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'masonry_filter_active_tab',
            [
                'label' => esc_html__( 'Active', 'bixola-core' ),
            ]
        );
        
        $this->add_control(
            'masonry_filter_color_active',
            [
                'label'     => esc_html__( 'Color', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-three__filter.style1 li:hover .filter-text' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .portfolio-three__filter.style1 li.active .filter-text' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .portfolio-page__filter.style1 li:hover .filter-text' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .portfolio-page__filter.style1 li.active .filter-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'masonry_filter_background_active',
            [
                'label'     => esc_html__( 'Background', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-three__filter.style1 li:hover .filter-text' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .portfolio-three__filter.style1 li.active .filter-text' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .portfolio-page__filter.style1 li:hover .filter-text' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .portfolio-page__filter.style1 li.active .filter-text' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'masonry_filter_border_active',
            [
                'label'     => esc_html__( 'Border', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-three__filter.style1 li:hover .filter-text' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .portfolio-three__filter.style1 li.active .filter-text' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .portfolio-page__filter.style1 li:hover .filter-text' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .portfolio-page__filter.style1 li.active .filter-text' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_tab();
        
        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            '_style_portfolio_masonary',
            [
                'label' => esc_html__( 'Portfolio Masonary List', 'bixola-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            '_heading_style_portfolio_masonary_title',
            [
                'label' => esc_html__( 'Title', 'bixola-core' ),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_responsive_control(
            'portfolio_masonary_title_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-three__title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'portfolio_masonary_title_color',
            [
                'label' => esc_html__( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-three__title a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'portfolio_masonary_title_color_hover',
            [
                'label' => esc_html__( 'Color (Hover)', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-three__single:hover .portfolio-three__title a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'portfolio_masonary_title_typography',
                'selector' => '{{WRAPPER}} .portfolio-three__title a',
            ]
        );

        $this->add_control(
            '_heading_style_portfolio_masonary_subheading',
            [
                'label' => esc_html__( 'Subheading', 'bixola-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'portfolio_masonary_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'text-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-three__sub-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'portfolio_masonary_subheading_color',
            [
                'label' => esc_html__( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-three__sub-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'portfolio_masonary_subheading_color_hover',
            [
                'label' => esc_html__( 'Color (Hover)', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-three__single:hover .portfolio-three__sub-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'portfolio_masonary_subheading_typography',
                'selector' => '{{WRAPPER}} .portfolio-three__sub-title',
            ]
        );

        $this->add_control(
            '_heading_style_portfolio_masonary',
            [
                'label' => esc_html__( 'Layout', 'bixola-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'portfolio_masonary_padding',
            [
                'label' => esc_html__( 'Padding', 'bixola-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-three__content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'portfolio_masonary_image_hover',
            [
                'label' => esc_html__( 'Image Hover', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-three__img:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'portfolio_masonary_background',
            [
                'label' => esc_html__( 'Background', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-three__content' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'portfolio_masonary_background_hover',
            [
                'label' => esc_html__( 'Background (Hover)', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-three__content::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

        if ( !empty($settings['section_image']['url']) ) {
            $section_image = !empty($settings['section_image']['id']) ? wp_get_attachment_image_url( $settings['section_image']['id'], 'full') : $settings['section_image']['url'];
            $section_image_alt = get_post_meta($settings["section_image"]["id"], "_wp_attachment_image_alt", true);
        }

		?>

        <?php if ( $settings['design_style']  == 'layout-1' ): ?>

            <section class="bixola-el-section portfolio-three">
                <?php if ( !empty( $settings['shape_switch'] ) ) : ?>
                    <div class="portfolio-three__shape-1 zoominout">
                        <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/portfolio-three-shape-1.png" alt="">
                    </div>
                    <div class="portfolio-three__shape-2 float-bob-y">
                        <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/portfolio-three-shape-2.png" alt="">
                    </div>
                <?php endif; ?>
                <div class="container">
                    <div class="section-title-three text-center">
                        <?php if ( !empty( $settings['section_subheading'] ) ) : ?>
                            <div class="section-title-three__tagline-box">
                                <p class="section-title-three__tagline">
                                    <?php print twinkle_kses($settings['section_subheading']); ?>
                                </p>
                            </div>
                        <?php endif; ?>
                        <?php if ( !empty( $settings['section_title'] ) ) : ?>
                            <h2 class="section-title-three__title">
                                <?php print twinkle_kses($settings['section_title']); ?>
                            </h2>
                        <?php endif; ?>
                    </div>
                    <div class="portfolio-three__filter-box">
                        <ul class="portfolio-three__filter style1 post-filter list-unstyled clearfix">
                            <li data-filter=".filter-item" class="active">
                                <span class="filter-text"><?php print esc_html($settings['all_masonry']); ?></span>
                            </li>
                            <?php foreach ($settings['bixola_filter_list'] as $key => $item) : ?>
                                <li data-filter=".<?php print esc_attr($item['bixola_filter_tags']); ?>">
                                    <span class="filter-text">
                                        <?php print esc_html($item['bixola_filter_tags_label']); ?>
                                    </span>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <div class="row filter-layout">
                        <?php foreach ($settings['portfolio_masonary_list'] as $key => $item) : 
                        
                            if ( !empty($item['portfolio_masonary_image']['url']) ) {
                                $portfolio_masonary_image = !empty($item['portfolio_masonary_image']['id']) ? wp_get_attachment_image_url( $item['portfolio_masonary_image']['id'], 'full') : $item['portfolio_masonary_image']['url'];
                                $portfolio_masonary_image_alt = get_post_meta($item["portfolio_masonary_image"]["id"], "_wp_attachment_image_alt", true);
                            }

                            if ('2' == $item['portfolio_masonary_button_link_type']) {
                                $link = get_permalink($item['portfolio_masonary_button_page_link']);
                                $target = '_self';
                                $rel = 'nofollow';
                            } else {
                                $link = !empty($item['portfolio_masonary_button_link']['url']) ? $item['portfolio_masonary_button_link']['url'] : '';
                                $target = !empty($item['portfolio_masonary_button_link']['is_external']) ? '_blank' : '';
                                $rel = !empty($item['portfolio_masonary_button_link']['nofollow']) ? 'nofollow' : '';
                            }
                        
                        ?>
                        <div class="col-xl-<?php print esc_attr($settings['column_desktop']); ?> col-lg-<?php print esc_attr($settings['column_laptop']); ?> col-md-<?php print esc_attr($settings['column_tablet']); ?> col-sm-<?php print esc_attr($settings['column_mobile']); ?> <?php print esc_attr($item['portfolio_masonary_info_tags']); ?> filter-item">
                            <div class="portfolio-three__single">
                                <div class="portfolio-three__img-box">
                                    <div class="portfolio-three__img">
                                        <img src="<?php print esc_url($portfolio_masonary_image); ?>" alt="<?php print esc_attr($portfolio_masonary_image_alt); ?>">
                                    </div>
                                </div>
                                <div class="portfolio-three__content">
                                    <?php if ( !empty( $item['portfolio_masonary_subheading'] ) ) : ?>
                                        <p class="portfolio-three__sub-title">
                                            <?php print twinkle_kses($item['portfolio_masonary_subheading']); ?>
                                        </p>
                                    <?php endif; ?>
                                    <h3 class="portfolio-three__title">
                                        <a target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>">
                                            <?php print twinkle_kses($item['portfolio_masonary_title']); ?>
                                        </a>
                                    </h3>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </section>

        <?php elseif ( $settings['design_style']  == 'layout-2' ): ?>

            <section class="bixola-el-section portfolio-page">
                <div class="container">
                    <div class="portfolio-page__top">
                        <div class="portfolio-page__filter-box">
                            <?php if ( !empty( $settings['section_subheading'] ) ) : ?>
                                <span class="portfolio-page__filter-title">
                                    <?php print twinkle_kses($settings['section_subheading']); ?>
                                </span>
                            <?php endif; ?>
                            <ul class="portfolio-page__filter style1 post-filter list-unstyled clearfix">
                                <li data-filter=".filter-item" class="active">
                                    <span class="filter-text"><?php print esc_html($settings['all_masonry']); ?></span>
                                </li>
                                <?php foreach ($settings['bixola_filter_list'] as $key => $item) : ?>
                                    <li data-filter=".<?php print esc_attr($item['bixola_filter_tags']); ?>">
                                        <span class="filter-text">
                                            <?php print esc_html($item['bixola_filter_tags_label']); ?>
                                        </span>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                    <div class="row filter-layout">
                        <?php foreach ($settings['portfolio_masonary_list'] as $key => $item) : 
                            
                            if ( !empty($item['portfolio_masonary_image']['url']) ) {
                                $portfolio_masonary_image = !empty($item['portfolio_masonary_image']['id']) ? wp_get_attachment_image_url( $item['portfolio_masonary_image']['id'], 'full') : $item['portfolio_masonary_image']['url'];
                                $portfolio_masonary_image_alt = get_post_meta($item["portfolio_masonary_image"]["id"], "_wp_attachment_image_alt", true);
                            }

                            if ('2' == $item['portfolio_masonary_button_link_type']) {
                                $link = get_permalink($item['portfolio_masonary_button_page_link']);
                                $target = '_self';
                                $rel = 'nofollow';
                            } else {
                                $link = !empty($item['portfolio_masonary_button_link']['url']) ? $item['portfolio_masonary_button_link']['url'] : '';
                                $target = !empty($item['portfolio_masonary_button_link']['is_external']) ? '_blank' : '';
                                $rel = !empty($item['portfolio_masonary_button_link']['nofollow']) ? 'nofollow' : '';
                            }
                        
                        ?>
                        <div class="col-xl-<?php print esc_attr($settings['column_desktop']); ?> col-lg-<?php print esc_attr($settings['column_laptop']); ?> col-md-<?php print esc_attr($settings['column_tablet']); ?> col-sm-<?php print esc_attr($settings['column_mobile']); ?> <?php print esc_attr($item['portfolio_masonary_info_tags']); ?> filter-item">
                            <div class="portfolio-three__single">
                                <div class="portfolio-three__img-box">
                                    <div class="portfolio-three__img">
                                        <img src="<?php print esc_url($portfolio_masonary_image); ?>" alt="<?php print esc_attr($portfolio_masonary_image_alt); ?>">
                                    </div>
                                </div>
                                <div class="portfolio-three__content">
                                    <?php if ( !empty( $item['portfolio_masonary_subheading'] ) ) : ?>
                                        <p class="portfolio-three__sub-title">
                                            <?php print twinkle_kses($item['portfolio_masonary_subheading']); ?>
                                        </p>
                                    <?php endif; ?>
                                    <h3 class="portfolio-three__title">
                                        <a target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>">
                                            <?php print twinkle_kses($item['portfolio_masonary_title']); ?>
                                        </a>
                                    </h3>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </section>

        <?php endif;
	}

}

$widgets_manager->register( new Bixola_Portfolio_Masonry() );