<?php
/**
* Plugin Name: Bixola Core
* Description: This is a core plugins for Bixola WordPress Theme
* Plugin URI:  https://twinkletheme.com/themeforest/wp/elementor/bixola/
* Version:     1.0.3
* Author:      TwinkleTheme
* Author URI:  https://themeforest.net/user/twinkletheme
* Text Domain: bixola-core
* Elementor tested up to: 3.28.9
* Elementor Pro tested up to: 3.28.9
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use Elementor\Controls_Manager;

/**
 * Define
*/
define('BIXOLA_CORE_ADDONS_URL', plugins_url('/', __FILE__));
define('BIXOLA_CORE_ADDONS_DIR', dirname(__FILE__));
define('BIXOLA_CORE_ADDONS_PATH', plugin_dir_path(__FILE__));
define('BIXOLA_CORE_ELEMENTS_PATH', BIXOLA_CORE_ADDONS_DIR . '/include/elementor');
define('BIXOLA_CORE_WIDGET_PATH', BIXOLA_CORE_ADDONS_DIR . '/include/widgets');
define('BIXOLA_CORE_INCLUDE_PATH', BIXOLA_CORE_ADDONS_DIR . '/include');
define('BIXOLA_CORE_ADDONS_ASSETS', trailingslashit( BIXOLA_CORE_ADDONS_URL . 'assets/' ) );

/**
 * Include all files
*/
include_once(BIXOLA_CORE_ADDONS_DIR . '/lib/csf/codestar-framework.php');
include_once(BIXOLA_CORE_ADDONS_DIR . '/include/custom-post-header.php');
include_once(BIXOLA_CORE_ADDONS_DIR . '/include/custom-post-footer.php');
include_once(BIXOLA_CORE_ADDONS_DIR . '/include/custom-post-services.php');
include_once(BIXOLA_CORE_ADDONS_DIR . '/include/common-functions.php');
include_once(BIXOLA_CORE_ADDONS_DIR . '/include/class-ocdi-importer.php');
include_once(BIXOLA_CORE_ADDONS_DIR . '/include/allow-svg.php');
include_once(BIXOLA_CORE_ADDONS_DIR . '/include/icons/custom-icon.php');

/**
 * Bixola Core Custom Widget
*/
include_once(BIXOLA_CORE_WIDGET_PATH . '/bixola-footer-info-one.php');
include_once(BIXOLA_CORE_WIDGET_PATH . '/bixola-footer-info-two.php');
include_once(BIXOLA_CORE_WIDGET_PATH . '/bixola-footer-info-three.php');
include_once(BIXOLA_CORE_WIDGET_PATH . '/bixola-footer-contact-info-one.php');
include_once(BIXOLA_CORE_WIDGET_PATH . '/bixola-footer-contact-info-two.php');
include_once(BIXOLA_CORE_WIDGET_PATH . '/bixola-footer-image-gallery-one.php');
include_once(BIXOLA_CORE_WIDGET_PATH . '/bixola-footer-blog-posts-one.php');
include_once(BIXOLA_CORE_WIDGET_PATH . '/bixola-footer-subscriber-one.php');
include_once(BIXOLA_CORE_WIDGET_PATH . '/bixola-footer-subscriber-two.php');
include_once(BIXOLA_CORE_WIDGET_PATH . '/bixola-sidebar-blog-posts-one.php');
include_once(BIXOLA_CORE_WIDGET_PATH . '/bixola-sidebar-image-gallery-one.php');

/**
 * Main Bixola Core Class
 *
 * The init class that runs the Hello World plugin.
 * Intended To make sure that the plugin's minimum requirements are met.
 *
 * You should only modify the constants to match your plugin's needs.
 *
 * Any custom code should go inside Plugin Class in the plugin.php file.
 * @since 1.2.0
 */
final class Bixola_Core {

	/**
	 * Plugin Version
	 *
	 * @since 1.0.0
	 * @var string The plugin version.
	 */
	const VERSION = '1.0.0';

	/**
	 * Minimum Elementor Version
	 *
	 * @since 1.2.0
	 * @var string Minimum Elementor version required to run the plugin.
	 */
	const MINIMUM_ELEMENTOR_VERSION = '3.10.0';

	/**
	 * Minimum PHP Version
	 *
	 * @since 1.2.0
	 * @var string Minimum PHP version required to run the plugin.
	 */
	const MINIMUM_PHP_VERSION = '7.4';

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function __construct() {

		// Init Plugin
		add_action( 'plugins_loaded', array( $this, 'init' ) );
	}

	/**
	 * Initialize the plugin
	 *
	 * Validates that Elementor is already loaded.
	 * Checks for basic plugin requirements, if one check fail don't continue,
	 * if all check have passed include the plugin class.
	 *
	 * Fired by `plugins_loaded` action hook.
	 *
	 * @since 1.2.0
	 * @access public
	 */
	public function init() {

		// Check if Elementor installed and activated
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', array( $this, 'admin_notice_missing_main_plugin' ) );
			return;
		}

		// Check for required Elementor version
		if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
			add_action( 'admin_notices', array( $this, 'admin_notice_minimum_elementor_version' ) );
			return;
		}

		// Check for required PHP version
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', array( $this, 'admin_notice_minimum_php_version' ) );
			return;
		}

	
		// Once we get here, We have passed all validation checks so we can safely include our plugin
		require_once( 'plugin.php' );
	}


	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have Elementor installed or activated.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function admin_notice_missing_main_plugin() {
		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor */
			esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'bixola-core' ),
			'<strong>' . esc_html__( 'Bixola Core', 'bixola-core' ) . '</strong>',
			'<strong><a href="'.esc_url( admin_url( 'plugin-install.php?s=elementor&tab=search&type=term' ) ).'">' . esc_html__( 'Elementor', 'bixola-core' ) . '</a></strong>'
		
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have a minimum required Elementor version.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function admin_notice_minimum_elementor_version() {
		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'bixola-core' ),
			'<strong>' . esc_html__( 'Bixola Core', 'bixola-core' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'bixola-core' ) . '</strong>',
			self::MINIMUM_ELEMENTOR_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have a minimum required PHP version.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function admin_notice_minimum_php_version() {
		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}

		$message = sprintf(
			/* translators: 1: Plugin name 2: PHP 3: Required PHP version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'bixola-core' ),
			'<strong>' . esc_html__( 'Bixola Core', 'bixola-core' ) . '</strong>',
			'<strong>' . esc_html__( 'PHP', 'bixola-core' ) . '</strong>',
			self::MINIMUM_PHP_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
	}
}

// Instantiate Bixola_Core.
new Bixola_Core();