<?php 

/**
* Template part for displaying header side information
*
* @link https://developer.wordpress.org/themes/basics/template-hierarchy/
* @package bixola
*/

$bixola_side_hide = bixola_get_option( 'bixola_side_hide', false );
$bixola_logo = get_template_directory_uri() . '/assets/images/resources/logo-1.png';
$bixola_side_logo = bixola_get_option( 'bixola_side_logo', $bixola_logo );
$bixola_site_logo_alt = get_post_meta( $bixola_side_logo, "_wp_attachment_image_alt", true);

$bixola_side_mail_id = bixola_get_option( 'bixola_side_mail_id', __( 'needhelp@bixola.com', 'bixola' ) );
$bixola_side_phone = bixola_get_option( 'bixola_side_phone', __( '666 888 0000', 'bixola' ) );
$bixola_side_phone_link = bixola_get_option( 'bixola_side_phone_link', __( '+6668880000', 'bixola' ) );

?>

<div class="mobile-nav__wrapper">
   <div class="mobile-nav__overlay mobile-nav__toggler"></div>
   <!-- /.mobile-nav__overlay -->
   <div class="mobile-nav__content">
      <span class="mobile-nav__close mobile-nav__toggler"><i class="fa fa-times"></i></span>
      
      <?php if ( !empty( $bixola_side_logo ) ): ?>
         <div class="logo-box">
            <a href="<?php print esc_url( home_url( '/' ) );?>" aria-label="logo image">
               <img src="<?php print esc_url($bixola_side_logo); ?>" width="145" alt="<?php print esc_attr($bixola_site_logo_alt); ?>" />
            </a>
         </div>
      <?php endif;?>
      <!-- /.logo-box -->
      <div class="mobile-nav__container"></div>
      <!-- /.mobile-nav__container -->

      <?php if ( !empty( $bixola_side_hide ) ): ?>
         <ul class="mobile-nav__contact list-unstyled">
            <?php if ( !empty( $bixola_side_mail_id ) ): ?>
               <li>
                  <i class="fa fa-envelope"></i>
                  <a href="mailto:<?php print esc_attr($bixola_side_mail_id); ?>"><?php print esc_html($bixola_side_mail_id); ?></a>
               </li>
            <?php endif;?>
            <?php if ( !empty( $bixola_side_phone ) ): ?>
               <li>
                  <i class="fa fa-phone-alt"></i>
                  <a href="tel:<?php print esc_attr($bixola_side_phone_link); ?>"><?php print esc_html($bixola_side_phone); ?></a>
               </li>
            <?php endif;?>
         </ul><!-- /.mobile-nav__contact -->
         <div class="mobile-nav__top">
               <div class="mobile-nav__social">
                  <?php bixola_header_social_profiles() ?>
               </div><!-- /.mobile-nav__social -->
         </div><!-- /.mobile-nav__top -->
      <?php endif;?>



   </div>
   <!-- /.mobile-nav__content -->
</div>
<!-- /.mobile-nav__wrapper -->

<div class="search-popup">
   <div class="search-popup__overlay search-toggler"></div>
   <!-- /.search-popup__overlay -->
   <div class="search-popup__content">
      <form action="<?php print esc_url( home_url( '/' ) );?>" method="get">
            <label for="search" class="sr-only"><?php print esc_html( 'search here', 'bixola' ); ?></label><!-- /.sr-only -->
            <input type="search" id="search" value="<?php print esc_attr( get_search_query() )?>" name="s" placeholder="<?php print esc_attr__( 'Search Here...', 'bixola' );?>" />
            <button type="submit" aria-label="search submit" class="thm-btn">
               <i class="icon-magnifying-glass"></i>
            </button>
      </form>
   </div>
   <!-- /.search-popup__content -->
</div>
<!-- /.search-popup -->