<?php 

/**
 * Template part for displaying header layout four
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package bixola
*/

// header top
$bixola_header_top_switch = bixola_get_option( 'bixola_header_top_switch', false );
$bixola_header_top_office_time = bixola_get_option( 'bixola_header_top_office_time', __( 'Mon to Fri: 9:00am to 6:00pm', 'bixola' ) );
$bixola_header_top_mail_id = bixola_get_option( 'bixola_header_top_mail_id', __( 'demo@example.com', 'bixola' ) );
$bixola_header_top_address = bixola_get_option( 'bixola_header_top_address', __( '88 Broklyn Golden Street. New York', 'bixola' ) );

// header right
$bixola_header_right = bixola_get_option( 'bixola_header_right' );
$bixola_header_phone = bixola_get_option( 'bixola_header_phone' );
$bixola_phone_label = bixola_get_option( 'bixola_phone_label', __( 'Need help?', 'bixola' ) );
$bixola_phone_text = bixola_get_option( 'bixola_phone_text', __( '+1 212 333 400', 'bixola' ) );
$bixola_phone_link = bixola_get_option( 'bixola_phone_link', __( '+1212333400', 'bixola' ) );
$bixola_button_text = bixola_get_option( 'bixola_button_text', __( 'Get Started', 'bixola' ) );
$bixola_button_link = bixola_get_option( 'bixola_button_link', __( '#', 'bixola' ) );

// header sticky
$bixola_sticky_hide = bixola_get_option( 'bixola_sticky_hide', false );

?>

<header class="main-header">
    <?php if ( !empty( $bixola_header_top_switch ) ): ?>
        <div class="main-header__top">
            <div class="container">
                <div class="main-header__top-inner">
                    <div class="main-header__top-left">
                        <ul class="list-unstyled main-header__contact-list">
                            <?php if ( !empty( $bixola_header_top_office_time ) ): ?>
                                <li>
                                    <div class="icon">
                                        <i class="fas fa-clock"></i>
                                    </div>
                                    <div class="text">
                                        <p><?php echo esc_html($bixola_header_top_office_time); ?></p>
                                    </div>
                                </li>
                            <?php endif; ?>
                            <?php if ( !empty( $bixola_header_top_mail_id ) ): ?>
                                <li>
                                    <div class="icon">
                                        <i class="fas fa-envelope"></i>
                                    </div>
                                    <div class="text">
                                        <p>
                                            <a href="mailto:<?php echo esc_attr($bixola_header_top_mail_id); ?>">
                                                <?php echo esc_html($bixola_header_top_mail_id); ?>
                                            </a>
                                        </p>
                                    </div>
                                </li>
                            <?php endif; ?>
                            <?php if ( !empty( $bixola_header_top_address ) ): ?>
                                <li>
                                    <div class="icon">
                                        <i class="fas fa-map-marker"></i>
                                    </div>
                                    <div class="text">
                                        <p><?php echo esc_html($bixola_header_top_address); ?></p>
                                    </div>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="main-header__top-right">
                        <?php bixola_header_four_top_menu();?>
                        <div class="main-header__social">
                            <?php bixola_header_social_profiles() ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <nav class="main-menu">
        <div class="main-menu__wrapper">
            <div class="container">
                <div class="main-menu__wrapper-inner">
                    <div class="main-menu__logo">
                        <?php bixola_header_logo_white(); ?>
                    </div>
                    <div class="main-menu__main-menu-box">
                        <a href="#" class="mobile-nav__toggler"><i class="fa fa-bars"></i></a>
                        <?php bixola_header_menu();?>
                    </div>
                    <?php if ( !empty( $bixola_header_right ) ): ?>
                        <div class="main-menu__right">
                            <?php if ( !empty( $bixola_phone_text ) ): ?>
                                <div class="main-menu__call">
                                    <div class="main-menu__call-icon">
                                        <span class="icon-phone"></span>
                                    </div>
                                    <div class="main-menu__call-content">
                                        <p class="main-menu__call-sub-title">
                                            <?php echo esc_html($bixola_phone_label); ?>
                                        </p>
                                        <h5 class="main-menu__call-number">
                                            <a href="tel:<?php echo esc_attr($bixola_phone_link); ?>">
                                                <?php echo esc_html($bixola_phone_text); ?>
                                            </a>
                                        </h5>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if ( !empty( $bixola_button_text ) ): ?>
                                <div class="main-menu__btn-box">
                                    <a href="<?php echo esc_url($bixola_button_link); ?>" class="main-menu__btn thm-btn">
                                        <?php echo esc_html($bixola_button_text); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </nav>
</header>

<?php if ( !empty( $bixola_sticky_hide ) ): ?>
    <div class="stricky-header stricked-menu">
        <div class="sticky-header__content"></div><!-- /.sticky-header__content -->
    </div><!-- /.stricky-header -->
<?php endif;?>

<?php get_template_part( 'template-parts/header/header-side-info' ); ?>