<?php 

/**
 * Template part for displaying footer layout one
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package bixola
*/

$bixola_page_info = get_post_meta( get_the_ID(), 'bixola_page_info', true);
$bixola_footer_bg_color_from_page = !empty ( $bixola_page_info['footer_bg_color'] ) ? $bixola_page_info['footer_bg_color'] : '';
$footer_bg_color = bixola_get_option( 'bixola_footer_bg_color', '#ffffff' );
$footer_social_switch = bixola_get_option( 'footer_social_switch', false );
$footer_shape_switch = bixola_get_option( 'footer_shape_switch', false );

$footer_contact_info = bixola_get_option( 'footer_contact_info', false );
$footer_contact_location_heading = bixola_get_option( 'footer_contact_location_heading', 'Office Location' );
$footer_contact_location = bixola_get_option( 'footer_contact_location', '91195 Brock Walks, Pittsburg,<br> Ohio 75843, USA' );
$footer_contact_phone_heading = bixola_get_option( 'footer_contact_phone_heading', 'Get a quote' );
$footer_contact_phone_label_one = bixola_get_option( 'footer_contact_phone_label_one', '+1(333) 000-0000' );
$footer_contact_phone_one = bixola_get_option( 'footer_contact_phone_one', '+13330000000' );
$footer_contact_phone_label_two = bixola_get_option( 'footer_contact_phone_label_two', '+1(333) 000-0000' );
$footer_contact_phone_two = bixola_get_option( 'footer_contact_phone_two', '+13330000000' );
$footer_contact_working_time_heading = bixola_get_option( 'footer_contact_working_time_heading', 'Working Time' );
$footer_contact_working_time = bixola_get_option( 'footer_contact_working_time', 'Mon - Sat: 9:00 AM - 5:00 PM Sunday Close' );


// bg color
$bg_color = !empty( $bixola_footer_bg_color_from_page ) ? $bixola_footer_bg_color_from_page : $footer_bg_color;

// footer_columns
$footer_columns = 0;
$footer_widgets = bixola_get_option( 'footer_widget_number', 4 );

for ( $num = 1; $num <= $footer_widgets; $num++ ) {
    if ( is_active_sidebar( 'footer-3-' . $num ) ) {
        $footer_columns++;
    }
}

switch ( $footer_columns ) {
case '1':
    $footer_class[1] = 'col-lg-12';
    break;
case '2':
    $footer_class[1] = 'col-lg-6 col-md-6';
    $footer_class[2] = 'col-lg-6 col-md-6';
    break;
case '3':
    $footer_class[1] = 'col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-12';
    $footer_class[2] = 'col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-12';
    $footer_class[3] = 'col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-12';
    break;
case '4':
    $footer_class[1] = 'col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-7';
    $footer_class[2] = 'col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-5';
    $footer_class[3] = 'col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-5';
    $footer_class[4] = 'col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-7';
    break;
default:
    $footer_class = 'col-xl-3 col-lg-3 col-md-6';
    break;
}

?>

<footer class="site-footer-three footer-3" data-bg-color="<?php print esc_attr( $bg_color );?>">
    <?php if ( !empty ( $footer_shape_switch ) ) : ?>
        <div class="site-footer-three__shape-1 float-bob-y">
            <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/site-footer-three-shape-1.png" alt="<?php print esc_attr( 'shape', 'bixola' ); ?>">
        </div>
        <div class="site-footer-three__shape-2 img-bounce">
            <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/site-footer-three-shape-2.png" alt="<?php print esc_attr( 'shape', 'bixola' ); ?>">
        </div>
        <div class="site-footer-three__shape-3 zoominout">
            <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/site-footer-three-shape-3.png" alt="<?php print esc_attr( 'shape', 'bixola' ); ?>">
        </div>
    <?php endif; ?>
    <div class="container">
        <?php if ( !empty ($footer_contact_info) ) : ?>
            <div class="site-footer-three__top">
                <ul class="site-footer-three__contact-list list-unstyled">
                    <?php if ( !empty( $footer_contact_location_heading ) ): ?>
                        <li>
                            <div class="site-footer-three__contact-list-single">
                                <div class="icon">
                                    <span class="icon-location-1"></span>
                                </div>
                                <div class="content">
                                    <?php if ( !empty( $footer_contact_location_heading ) ): ?>
                                        <h3><?php print bixola_kses($footer_contact_location_heading); ?></h3>
                                    <?php endif; ?>
                                    <?php if ( !empty( $footer_contact_location ) ): ?>
                                        <p><?php print bixola_kses($footer_contact_location); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </li>
                    <?php endif; ?>
                    <?php if ( !empty( $footer_contact_phone_heading ) ): ?>
                        <li>
                            <div class="site-footer-three__contact-list-single">
                                <div class="icon">
                                    <span class="icon-phone"></span>
                                </div>
                                <div class="content">
                                    <?php if ( !empty( $footer_contact_phone_heading ) ): ?>
                                        <h3><?php print bixola_kses($footer_contact_phone_heading); ?></h3>
                                    <?php endif; ?>
                                    <?php if ( !empty( $footer_contact_phone_label_one ) ): ?>
                                        <p>
                                            <a href="tel:<?php print bixola_kses($footer_contact_phone_one); ?>">
                                                <?php print bixola_kses($footer_contact_phone_label_one); ?>
                                            </a>
                                        </p>
                                    <?php endif; ?>
                                    <?php if ( !empty( $footer_contact_phone_label_two ) ): ?>
                                        <p>
                                            <a href="tel:<?php print bixola_kses($footer_contact_phone_two); ?>">
                                                <?php print bixola_kses($footer_contact_phone_label_two); ?>
                                            </a>
                                        </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </li>
                    <?php endif; ?>
                    <?php if ( !empty( $footer_contact_working_time_heading ) ): ?>
                        <li>
                            <div class="site-footer-three__contact-list-single">
                                <div class="icon">
                                    <span class="icon-time"></span>
                                </div>
                                <div class="content">
                                    <?php if ( !empty( $footer_contact_working_time_heading ) ): ?>
                                        <h3><?php print bixola_kses($footer_contact_working_time_heading); ?></h3>
                                    <?php endif; ?>
                                    <?php if ( !empty( $footer_contact_working_time ) ): ?>
                                        <p><?php print bixola_kses($footer_contact_working_time); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        <?php endif; ?>
        <?php if ( is_active_sidebar('footer-3-1') OR is_active_sidebar('footer-3-2') OR is_active_sidebar('footer-3-3') OR is_active_sidebar('footer-3-4') ): ?>
            <div class="site-footer-three__middle">
                <div class="row">
                    <?php if ( $footer_columns > 4 ) {
                        print '<div class="col-xl-3 col-lg-6 col-md-6">';
                        dynamic_sidebar( 'footer-3-1' );
                        print '</div>';

                        print '<div class="col-xl-3 col-lg-6 col-md-6">';
                        dynamic_sidebar( 'footer-3-2' );
                        print '</div>';

                        print '<div class="col-xl-3 col-lg-6 col-md-6">';
                        dynamic_sidebar( 'footer-3-3' );
                        print '</div>';

                        print '<div class="col-xl-3 col-lg-6 col-md-6">';
                        dynamic_sidebar( 'footer-3-4' );
                        print '</div>';
                        } else {
                            for ( $num = 1; $num <= $footer_columns; $num++ ) {
                                if ( !is_active_sidebar( 'footer-3-' . $num ) ) {
                                    continue;
                                }
                                print '<div class="' . esc_attr( $footer_class[$num] ) . '">';
                                dynamic_sidebar( 'footer-3-' . $num );
                                print '</div>';
                            }
                        }
                    ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
    <div class="site-footer-three__bottom">
        <div class="container">
            <div class="site-footer-three__bottom-inner">
                <p class="site-footer-three__bottom-text"><?php print bixola_copyright_text(); ?></p>
                <?php if ( !empty ( $footer_social_switch ) ) : ?>
                    <div class="site-footer-three__bottom-social">
                        <?php bixola_header_social_profiles(); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</footer>