<?php 

/**
 * Template part for displaying post meta
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package bixola
 */

$categories = get_the_terms( $post->ID, 'category' );
$bixola_blog_author = bixola_get_option( 'bixola_blog_author', true );
$bixola_blog_date = bixola_get_option( 'bixola_blog_date', true );
$bixola_blog_cat = bixola_get_option( 'bixola_blog_cat', true );
$bixola_blog_comments = bixola_get_option( 'bixola_blog_comments', true );

?>

<ul class="list-unstyled news-page-three__meta">
    <?php if ( !empty($bixola_blog_date) ): 
        $archive_year  = get_the_time( 'Y' ); 
        $archive_month = get_the_time( 'm' ); 
        $archive_day   = get_the_time( 'd' ); 
        ?>
        <li>
            <a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
                <span class="icon-date11"></span><?php the_time( get_option('date_format') ); ?>
            </a>
        </li>
    <?php endif;?>
    <?php if ( !empty($bixola_blog_author) ): ?>
        <li>
            <a href="<?php print esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) );?>">
                <span class="icon-user-2"></span> <?php print esc_html('By', 'bixola'); ?> <?php print get_the_author(); ?>
            </a>
        </li>
    <?php endif;?>
    <?php if ( !empty($bixola_blog_cat) ): ?>
        <?php if ( !empty( $categories[0]->name ) ): ?>  
            <li>
                <a href="<?php print esc_url(get_category_link($categories[0]->term_id)); ?>">
                    <span class="fas fa-tag"></span>
                    <?php echo esc_html($categories[0]->name); ?>
                </a>
            </li>
        <?php endif;?>
    <?php endif;?>
    <?php if ( !empty($bixola_blog_comments) ): ?>
        <li>
            <a href="<?php comments_link();?>">
                <span class="icon-chat"></span> <?php comments_number(); ?>
            </a>
        </li>
    <?php endif;?>
</ul>