<?php 

/**
 * Template part for displaying post meta
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package bixola
 */

$bixola_blog_btn = get_theme_mod( 'bixola_blog_btn', 'Read More' );
$bixola_blog_btn_switch = get_theme_mod( 'bixola_blog_btn_switch', true );
$bixola_blog_comments = get_theme_mod( 'bixola_blog_comments', true );

?>

<div class="blog__item-bottom d-flex justify-content-between">
    <?php if ( !empty( $bixola_blog_btn_switch ) ): ?>
        <div class="blog__item-bottom__left">
            <a href="<?php the_permalink();?>" class="blog__item-readmore"><?php print esc_html( $bixola_blog_btn );?> <i class="fa-solid fa-arrow-right-long"></i></a>
        </div>
    <?php endif;?>
    <div class="blog__item-bottom__right">
        <ul class="blog__item-list d-flex flex-row">
            <?php if ( !empty($bixola_blog_comments) ): ?>
                <li><a href="<?php comments_link();?>"><i class="fa-regular fa-message"></i><?php comments_number(); ?></a></li>
            <?php endif;?>
        </ul>
    </div>
</div>