<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package bixola
 */

get_header();

$class_main = 'col-xl-12 col-lg-12';
if(is_active_sidebar('blog-sidebar')){ 
  	$class_main = 'col-xl-8 col-lg-7';
}

?>

<div class="tp-blog-area news-details pt-120 pb-120">
    <div class="container">
        <div class="row">
			<div class="<?php echo esc_attr($class_main) ?>">
				<div class="postbox__wrapper postbox__details news-details__left">
					<?php
						while ( have_posts() ):
						the_post();

						get_template_part( 'template-parts/content', get_post_format() );

    				?>
				</div>
				
				<?php

					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ):
						comments_template();
					endif;

					endwhile; // End of the loop.
				?>	
			</div>
			<?php if ( is_active_sidebar( 'blog-sidebar' ) ): ?>
				<div class="col-xl-4 col-lg-5">
					<div class="sidebar">
						<?php get_sidebar();?>
					</div>
				</div>
			<?php endif;?>
		</div>
	</div>
</div>

<?php
get_footer();