<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package bixola
 */

get_header();

$class_main = 'col-lg-12';
if(is_active_sidebar('blog-sidebar')){ 
  	$class_main = 'col-lg-8';
}

?>

<section class="tp-blog-area news-details pt-120 pb-120">
    <div class="container">
        <div class="row">
			<div class="<?php echo esc_attr($class_main) ?>">
				<?php
					if ( have_posts() ):
					if ( is_home() && !is_front_page() ):
				?>
				
				<header>
					<h1 class="page-title screen-reader-text"><?php single_post_title();?></h1>
				</header>
				<?php
					endif;?>
				<?php
					/* Start the Loop */
					while ( have_posts() ): the_post(); ?>
						<?php
							/*
							* Include the Post-Type-specific template for the content.
							* If you want to override this in a child theme, then include a file
							* called content-___.php (where ___ is the Post Type name) and that will be used instead.
							*/
							get_template_part( 'template-parts/content', get_post_format() );
						?>
					<?php
						endwhile;
					?>
						<div class="blog__pagination pagination-wrap text-center">
							<?php bixola_pagination( '<i class="fa-solid fa-chevron-left"></i>', '<i class="fa-solid fa-chevron-right"></i>', '', ['class' => ''] );?>
						</div>
					<?php
					else:
						get_template_part( 'template-parts/content', 'none' );
					endif;
				?>
			</div>

			<?php if ( is_active_sidebar( 'blog-sidebar' ) ): ?>
		        <div class="col-lg-4">
					<div class="sidebar">
						<?php get_sidebar();?>
					</div>
				</div>
			<?php endif;?>
        </div>
    </div>
</section>

<?php
get_footer();
