<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package bixola
 */

/** 
 *
 * bixola header
 */

function get_header_style($style){
    if ( $style == 'header-style-2'  ) {
        get_template_part( 'template-parts/header/header-2' );
    }
    elseif ( $style == 'header-style-3'  ) {
        get_template_part( 'template-parts/header/header-3' );
    }
    elseif ( $style == 'header-style-4'  ) {
        get_template_part( 'template-parts/header/header-4' );
    }
    else{
        get_template_part( 'template-parts/header/header-1');
    }
}

function bixola_check_header() {
    $bixola_page_info = get_post_meta( get_the_ID(), 'bixola_page_info', true);
    
    $header_tabs = !empty( $bixola_page_info['header_tabs'] ) ? $bixola_page_info['header_tabs'] : false;
    $header_style_meta = !empty( $bixola_page_info['header_style'] ) ? $bixola_page_info['header_style'] : '';
    $elementor_header_template_meta = !empty( $bixola_page_info['header_templates'] ) ? $bixola_page_info['header_templates'] : false;

    $header_elementor_switch = bixola_get_option('header_elementor_switch', false);
    $header_default_style_customizer = bixola_get_option( 'choose_default_header' );
    $elementor_header_templates_customizer = bixola_get_option( 'header_templates' );
    
    if($header_tabs == 'default'){
        if($header_elementor_switch){
            if($elementor_header_templates_customizer){
                echo \Elementor\Plugin::$instance->frontend->get_builder_content($elementor_header_templates_customizer);
            }
        }else{ 
            if($header_default_style_customizer){
                get_header_style($header_default_style_customizer);
            }else{
                get_template_part( 'template-parts/header/header-1' );
            }
        }
    }elseif($header_tabs == 'custom'){
        if ($header_style_meta) {
            get_header_style($header_style_meta);
        }else{
            get_header_style($header_default_style_customizer);
        }  
    }elseif($header_tabs == 'elementor'){
        if($elementor_header_template_meta){
            echo \Elementor\Plugin::$instance->frontend->get_builder_content($elementor_header_template_meta);
        }else{
            echo \Elementor\Plugin::$instance->frontend->get_builder_content($elementor_header_templates_customizer);
        }
    }else{
        if($header_elementor_switch){

            if($elementor_header_templates_customizer){
                echo \Elementor\Plugin::$instance->frontend->get_builder_content($elementor_header_templates_customizer);
            }else{
                get_template_part( 'template-parts/header/header-1' );
            }
        }else{
            get_header_style($header_default_style_customizer);

        }
        
    }

}
add_action( 'bixola_header_style', 'bixola_check_header', 10 );

/**
 * [bixola_header_lang description]
 * @return [type] [description]
 */
function bixola_header_lang_default() {
    $bixola_header_lang = bixola_get_option( 'bixola_header_lang', false );
    if ( $bixola_header_lang ): ?>

    <ul>
        <li><a href="javascript:void(0)"><?php print esc_html__( 'English', 'bixola' );?> <i class="fas fa-angle-down"></i></a>
        <?php do_action( 'bixola_language' );?>
        </li>
    </ul>

    <?php endif;?>
<?php
}

/**
 * [bixola_language_list description]
 * @return [type] [description]
 */
function _bixola_language( $mar ) {
    return $mar;
}
function bixola_language_list() {

    $mar = '';
    $languages = apply_filters( 'wpml_active_languages', NULL, 'orderby=id&order=desc' );
    if ( !empty( $languages ) ) {
        $mar = '<ul>';
        foreach ( $languages as $lan ) {
            $active = $lan['active'] == 1 ? 'active' : '';
            $mar .= '<li class="' . $active . '"><a href="' . $lan['url'] . '">' . $lan['translated_name'] . '</a></li>';
        }
        $mar .= '</ul>';
    } else {
        //remove this code when send themeforest reviewer team
        $mar .= '<ul>';
        $mar .= '<li><a href="#">' . esc_html__( 'England', 'bixola' ) . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__( 'France', 'bixola' ) . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__( 'Germany', 'bixola' ) . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__( 'Italy', 'bixola' ) . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__( 'Span', 'bixola' ) . '</a></li>';
        $mar .= ' </ul>';
    }
    print _bixola_language( $mar );
}
add_action( 'bixola_language', 'bixola_language_list' );


// header white
function bixola_header_logo_white() { ?>
    <?php
    $bixola_logo = get_template_directory_uri() . '/assets/images/resources/logo-1.png';
    $bixola_site_logo = bixola_get_option( 'logo', $bixola_logo );
    $bixola_site_logo_alt = get_post_meta( $bixola_site_logo, "_wp_attachment_image_alt", true);
    ?>

        <a href="<?php print esc_url( home_url( '/' ) );?>">
            <img src="<?php print esc_url( $bixola_site_logo );?>" alt="<?php print esc_attr($bixola_site_logo_alt); ?>">
        </a>
    
    <?php
}

// header black
function bixola_header_logo_black() { ?>
    <?php
    $bixola_logo_black = get_template_directory_uri() . '/assets/images/resources/logo-2.png';
    $bixola_secondary_logo = bixola_get_option( 'secondary_logo', $bixola_logo_black );
    $bixola_secondary_logo_alt = get_post_meta( $bixola_secondary_logo, "_wp_attachment_image_alt", true);
    ?>
        <a href="<?php print esc_url( home_url( '/' ) );?>">
            <img src="<?php print esc_url( $bixola_secondary_logo );?>" alt="<?php print esc_attr($bixola_secondary_logo_alt); ?>">
        </a>
    
    <?php
}

// header logo
function bixola_header_sticky_logo() {?>
    <?php
        $bixola_logo_black = get_template_directory_uri() . '/assets/images/resources/logo-1.png';
        $bixola_secondary_logo = bixola_get_option( 'seconday_logo', $bixola_logo_black );
    ?>
      <a class="sticky-logo" href="<?php print esc_url( home_url( '/' ) );?>">
          <img src="<?php print esc_url( $bixola_secondary_logo );?>" alt="<?php print esc_attr__( 'logo', 'bixola' );?>" />
      </a>
    <?php
}

function bixola_mobile_logo() {
    // side info
    $bixola_mobile_logo_hide = bixola_get_option( 'bixola_mobile_logo_hide', false );

    $bixola_site_logo = bixola_get_option( 'logo', get_template_directory_uri() . '/assets/img/logo/logo.png' );

    ?>

    <?php if ( !empty( $bixola_mobile_logo_hide ) ): ?>
    <div class="side__logo mb-25">
        <a class="sideinfo-logo" href="<?php print esc_url( home_url( '/' ) );?>">
            <img src="<?php print esc_url( $bixola_site_logo );?>" alt="<?php print esc_attr__( 'logo', 'bixola' );?>" />
        </a>
    </div>
    <?php endif;?>



<?php }

/**
 * [bixola_header_social_profiles description]
 * @return [type] [description]
 */
function bixola_header_social_profiles() {
    $bixola_topbar_fb_url = bixola_get_option( 'bixola_topbar_fb_url', __( '#', 'bixola' ) );
    $bixola_topbar_twitter_url = bixola_get_option( 'bixola_topbar_twitter_url', __( '#', 'bixola' ) );
    $bixola_topbar_instagram_url = bixola_get_option( 'bixola_topbar_instagram_url', __( '#', 'bixola' ) );
    $bixola_topbar_pinterest_url = bixola_get_option( 'bixola_topbar_pinterest_url' );
    $bixola_topbar_linkedin_url = bixola_get_option( 'bixola_topbar_linkedin_url', __( '#', 'bixola' ) );
    $bixola_topbar_dribbble_url = bixola_get_option( 'bixola_topbar_dribbble_url' );
    $bixola_topbar_whatsapp_url = bixola_get_option( 'bixola_topbar_whatsapp_url' );
    $bixola_topbar_tiktok_url = bixola_get_option( 'bixola_topbar_tiktok_url' );
    $bixola_topbar_soundcloud_url = bixola_get_option( 'bixola_topbar_soundcloud_url' );
    $bixola_topbar_vimeo_url = bixola_get_option( 'bixola_topbar_vimeo_url' );
    $bixola_topbar_youtube_url = bixola_get_option( 'bixola_topbar_youtube_url' );
    ?>       
        <?php if ( !empty( $bixola_topbar_fb_url ) ): ?>
            <a href="<?php print esc_url( $bixola_topbar_fb_url );?>"><i class="fa-brands fa-facebook-f"></i></a>
        <?php endif;?>
        <?php if ( !empty( $bixola_topbar_twitter_url ) ): ?>
            <a href="<?php print esc_url( $bixola_topbar_twitter_url );?>"><i class="fa-brands fa-x-twitter"></i></a>
        <?php endif;?>
        <?php if ( !empty( $bixola_topbar_instagram_url ) ): ?>
            <a href="<?php print esc_url( $bixola_topbar_instagram_url );?>"><i class="fa-brands fa-instagram"></i></a>
        <?php endif;?>
        <?php if ( !empty( $bixola_topbar_pinterest_url ) ): ?>
            <a href="<?php print esc_url( $bixola_topbar_pinterest_url );?>"><i class="fa-brands fa-pinterest-p"></i></a>
        <?php endif;?>
        <?php if ( !empty( $bixola_topbar_linkedin_url ) ): ?>
            <a href="<?php print esc_url( $bixola_topbar_linkedin_url );?>"><i class="fa-brands fa-linkedin"></i></a>
        <?php endif;?>
        <?php if ( !empty( $bixola_topbar_dribbble_url ) ): ?>
            <a href="<?php print esc_url( $bixola_topbar_dribbble_url );?>"><i class="fa-brands fa-dribbble"></i></a>
        <?php endif;?>
        <?php if ( !empty( $bixola_topbar_whatsapp_url ) ): ?>
            <a href="<?php print esc_url( $bixola_topbar_whatsapp_url );?>"><i class="fa-brands fa-whatsapp"></i></a>
        <?php endif;?>
        <?php if ( !empty( $bixola_topbar_tiktok_url ) ): ?>
            <a href="<?php print esc_url( $bixola_topbar_tiktok_url );?>"><i class="fa-brands fa-tiktok"></i></a>
        <?php endif;?>
        <?php if ( !empty( $bixola_topbar_soundcloud_url ) ): ?>
            <a href="<?php print esc_url( $bixola_topbar_soundcloud_url );?>"><i class="fa-brands fa-soundcloud"></i></a>
        <?php endif;?>
        <?php if ( !empty( $bixola_topbar_vimeo_url ) ): ?>
            <a href="<?php print esc_url( $bixola_topbar_vimeo_url );?>"><i class="fa-brands fa-vimeo-v"></i></a>
        <?php endif;?>
        <?php if ( !empty( $bixola_topbar_youtube_url ) ): ?>
            <a href="<?php print esc_url( $bixola_topbar_youtube_url );?>"><i class="fa-brands fa-youtube"></i></a>
        <?php endif;?>
    <?php
}

/**
 * [bixola_header_menu description]
 * @return [type] [description]
 */
function bixola_header_menu() {
    ?>
    <?php
        wp_nav_menu( [
            'theme_location' => 'main-menu',
            'menu_class'     => 'main-menu__list',
            'container'      => '',
            'fallback_cb'    => 'Bixola_Navwalker_Class::fallback',
            'walker'         => new Bixola_Navwalker_Class,
        ] );
    ?>
    <?php
}

/**
 * [bixola_header_one_top_menu description]
 * @return [type] [description]
 */
function bixola_header_one_top_menu() {
    ?>
    <?php
        wp_nav_menu( [
            'theme_location' => 'header-one-top',
            'menu_class'     => 'list-unstyled main-header-four__top-menu',
            'container'      => '',
            'fallback_cb'    => 'Bixola_Navwalker_Class::fallback',
            'walker'         => new Bixola_Navwalker_Class,
        ] );
    ?>
    <?php
}

/**
 * [bixola_header_four_top_menu description]
 * @return [type] [description]
 */
function bixola_header_four_top_menu() {
    ?>
    <?php
        wp_nav_menu( [
            'theme_location' => 'header-four-top',
            'menu_class'     => 'list-unstyled main-header__top-menu',
            'container'      => '',
            'fallback_cb'    => 'Bixola_Navwalker_Class::fallback',
            'walker'         => new Bixola_Navwalker_Class,
        ] );
    ?>
    <?php
}

/**
 * [bixola_footer_bottom_menu description]
 * @return [type] [description]
 */
function bixola_footer_bottom_menu() {
    ?>
    <?php
        wp_nav_menu( [
            'theme_location' => 'footer-bottom-menu',
            'menu_class'     => 'copy-list',
            'container'      => '',
            'fallback_cb'    => 'Bixola_Navwalker_Class::fallback',
            'walker'         => new Bixola_Navwalker_Class,
        ] );
    ?>
    <?php
}

/**
 * [bixola_header_menu description]
 * @return [type] [description]
 */
function bixola_mobile_menu() {
    ?>
    <?php
        $bixola_menu = wp_nav_menu( [
            'theme_location' => 'main-menu',
            'menu_class'     => '',
            'container'      => '',
            'menu_id'        => 'mobile-menu',
            'echo'           => false,
        ] );

    $bixola_menu = str_replace( "menu-item-has-children", "menu-item-has-children has-children", $bixola_menu );
        echo wp_kses_post( $bixola_menu );
    ?>
    <?php
}

/**
 *
 * bixola footer
 */
function get_footer_style($style){
    if ( $style == 'footer-style-2'  ) {
        get_template_part( 'template-parts/footer/footer-2' );
    }
    elseif ( $style == 'footer-style-3'  ) {
        get_template_part( 'template-parts/footer/footer-3' );
    }
    elseif ( $style == 'footer-style-4'  ) {
        get_template_part( 'template-parts/footer/footer-4' );
    }
    else{
        get_template_part( 'template-parts/footer/footer-1');
    }
}

function bixola_check_footer() {
    $bixola_page_info = get_post_meta( get_the_ID(), 'bixola_page_info', true);
    
    $footer_tabs = !empty( $bixola_page_info['footer_tabs'] ) ? $bixola_page_info['footer_tabs'] : false;
    $footer_style_meta = !empty( $bixola_page_info['footer_style'] ) ? $bixola_page_info['footer_style'] : '';
    $elementor_footer_template_meta = !empty( $bixola_page_info['footer_templates'] ) ? $bixola_page_info['footer_templates'] : false;

    $footer_elementor_switch = bixola_get_option('footer_elementor_switch', false);
    $footer_default_style_customizer = bixola_get_option( 'choose_default_footer' );
    $elementor_footer_templates_customizer = bixola_get_option( 'footer_templates' );
    
    if($footer_tabs == 'default'){
        if($footer_elementor_switch){
            if($elementor_footer_templates_customizer){
                echo \Elementor\Plugin::$instance->frontend->get_builder_content($elementor_footer_templates_customizer);
            }
        }else{ 
            if($footer_default_style_customizer){
                get_footer_style($footer_default_style_customizer);
            }else{
                get_template_part( 'template-parts/footer/footer-1' );
            }
        }
    }elseif($footer_tabs == 'custom'){
        if ($footer_style_meta) {
            get_footer_style($footer_style_meta);
        }else{
            get_footer_style($footer_default_style_customizer);
        }  
    }elseif($footer_tabs == 'elementor'){
        if($elementor_footer_template_meta){
            echo \Elementor\Plugin::$instance->frontend->get_builder_content($elementor_footer_template_meta);
        }else{
            echo \Elementor\Plugin::$instance->frontend->get_builder_content($elementor_footer_templates_customizer);
        }
    }else{
        if($footer_elementor_switch){

            if($elementor_footer_templates_customizer){
                echo \Elementor\Plugin::$instance->frontend->get_builder_content($elementor_footer_templates_customizer);
            }else{
                get_template_part( 'template-parts/footer/footer-1' );
            }
        }else{
            get_footer_style($footer_default_style_customizer);

        }
        
    }

}
add_action( 'bixola_footer_style', 'bixola_check_footer', 10 );

// bixola_copyright_text
function bixola_copyright_text() {
    print bixola_get_option( 'bixola_copyright', esc_html__( '© Copyright bixola 2024. All rights reserved.', 'bixola' ) );
}


/**
 *
 * pagination
 */
if ( !function_exists( 'bixola_pagination' ) ) {

    function _bixola_pagi_callback( $pagination ) {
        return $pagination;
    }

    //page navegation
    function bixola_pagination( $prev, $next, $pages, $args ) {
        global $wp_query, $wp_rewrite;
        $menu = '';
        $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;

        if ( $pages == '' ) {
            global $wp_query;
            $pages = $wp_query->max_num_pages;

            if ( !$pages ) {
                $pages = 1;
            }

        }

        $pagination = [
            'base'      => add_query_arg( 'paged', '%#%' ),
            'format'    => '',
            'total'     => $pages,
            'current'   => $current,
            'prev_text' => $prev,
            'next_text' => $next,
            'type'      => 'array',
        ];

        //rewrite permalinks
        if ( $wp_rewrite->using_permalinks() ) {
            $pagination['base'] = user_trailingslashit( trailingslashit( remove_query_arg( 's', get_pagenum_link( 1 ) ) ) . 'page/%#%/', 'paged' );
        }

        if ( !empty( $wp_query->query_vars['s'] ) ) {
            $pagination['add_args'] = ['s' => get_query_var( 's' )];
        }

        $pagi = '';
        if ( paginate_links( $pagination ) != '' ) {
            $paginations = paginate_links( $pagination );
            $pagi .= '<ul>';
            foreach ( $paginations as $key => $pg ) {
                $pagi .= '<li>' . $pg . '</li>';
            }
            $pagi .= '</ul>';
        }

        print _bixola_pagi_callback( $pagi );
    }
}

// Post Navigation
if ( !function_exists('bixola_post_navigation') ) {
	function bixola_post_navigation(){
		$bixola_next_post = get_next_post();
		$bixola_prev_post = get_previous_post();
		
		if ( $bixola_next_post || $bixola_prev_post ) : ?>

            <div class="blog__details-pagination">
                <?php if ( !empty($bixola_prev_post) ): ?>
                    <a href="<?php echo get_permalink( $bixola_prev_post ); ?>"><i class="fa-solid fa-arrow-left"></i></a>
                <?php endif;?>
                <?php if ( !empty($bixola_next_post) ): ?>
                    <a href="<?php echo get_permalink( $bixola_next_post ); ?>"><i class="fa-solid fa-arrow-right"></i></a>
                <?php endif;?>
            </div>
		
		<?php endif;
	}
}

// theme color
function bixola_custom_color() {
    $bixola_color_option_prim = bixola_get_option( 'bixola_color_option_prim', '#F52549' );
    $bixola_color_option_prim_rgb = bixola_get_option( 'bixola_color_option_prim_rgb', '65, 70, 81' );
    $bixola_color_option_sec = bixola_get_option( 'bixola_color_option_sec', '#F7F9FA' );
    $bixola_color_option_sec_rgb = bixola_get_option( 'bixola_color_option_sec_rgb', '247, 249, 250' );
    $breadcrumb_color_one = bixola_get_option( 'breadcrumb_color_one', '#000000' );
    $breadcrumb_color_two = bixola_get_option( 'breadcrumb_color_two', '34, 34, 34, 0.5' );
    $bixola_color_option_black = bixola_get_option( 'bixola_color_option_black', '#0D121E' );
    $bixola_color_option_black_rgb = bixola_get_option( 'bixola_color_option_black_rgb', '13, 18, 30' );
    $bixola_color_option_white = bixola_get_option( 'bixola_color_option_white', '#fff' );
    $bixola_color_option_white_rgb = bixola_get_option( 'bixola_color_option_white_rgb', '255, 255, 255' );
    $bixola_color_option_gray = bixola_get_option( 'bixola_color_option_gray', '#414651' );
    $bixola_color_option_gray_rgb = bixola_get_option( 'bixola_color_option_white_rgb', '65, 70, 81' );
  
    wp_enqueue_style( 'bixola-custom', BIXOLA_THEME_ASSETS . 'css/bixola-custom.css', [] );
  
    if ( !empty($bixola_color_option_prim) || !empty($bixola_color_option_prim_rgb) || !empty($bixola_color_option_sec) || !empty($bixola_color_option_sec_rgb) || !empty($breadcrumb_color_one) || !empty($breadcrumb_color_two) || !empty($bixola_color_option_black) || !empty($bixola_color_option_black_rgb) || !empty($bixola_color_option_white) || !empty($bixola_color_option_white_rgb) || !empty($bixola_color_option_gray) || !empty($bixola_color_option_gray_rgb) ) {
        $custom_css = '';
  
        $custom_css .= "html:root{ 
            --bixola-base: " . $bixola_color_option_prim . ";
            --bixola-base-rgb: " . $bixola_color_option_prim_rgb . ";
            --bixola-primary: " . $bixola_color_option_sec . ";
            --bixola-gray: " . $bixola_color_option_gray . ";
            --bixola-gray-rgb: " . $bixola_color_option_gray_rgb . ";
            --bixola-black: " . $bixola_color_option_black . ";
            --bixola-black-rgb: " . $bixola_color_option_black_rgb . ";
            --bixola-white: " . $bixola_color_option_white . "; 
            --bixola-white-rgb: " . $bixola_color_option_white_rgb . "; 
        }";

        $custom_css .= ".page-header__bg::before { background: linear-gradient(180deg, " . $breadcrumb_color_one . " 0%,  " . $breadcrumb_color_two . " 100%)!important;}";
            
        wp_add_inline_style( 'bixola-custom', $custom_css );
    }
}
add_action( 'wp_enqueue_scripts', 'bixola_custom_color' );

// bixola_kses_intermediate
function bixola_kses_intermediate( $string = '' ) {
    return wp_kses( $string, bixola_get_allowed_html_tags( 'intermediate' ) );
}

function bixola_get_allowed_html_tags( $level = 'basic' ) {
    $allowed_html = [
        'b'      => [],
        'i'      => [],
        'u'      => [],
        'em'     => [],
        'br'     => [],
        'abbr'   => [
            'title' => [],
        ],
        'span'   => [
            'class' => [],
        ],
        'strong' => [],
        'a'      => [
            'href'  => [],
            'title' => [],
            'class' => [],
            'id'    => [],
        ],
    ];

    if ($level === 'intermediate') {
        $allowed_html['a'] = [
            'href' => [],
            'title' => [],
            'class' => [],
            'id' => [],
        ];
        $allowed_html['div'] = [
            'class' => [],
            'id' => [],
        ];
        $allowed_html['img'] = [
            'src' => [],
            'class' => [],
            'alt' => [],
        ];
        $allowed_html['del'] = [
            'class' => [],
        ];
        $allowed_html['ins'] = [
            'class' => [],
        ];
        $allowed_html['bdi'] = [
            'class' => [],
        ];
        $allowed_html['i'] = [
            'class' => [],
            'data-rating-value' => [],
        ];
    }

    return $allowed_html;
}


// WP kses allowed tags
// ----------------------------------------------------------------------------------------
function bixola_kses($raw){

   $allowed_tags = array(
      'a'                         => array(
         'class'   => array(),
         'href'    => array(),
         'rel'  => array(),
         'title'   => array(),
         'target' => array(),
      ),
      'abbr'                      => array(
         'title' => array(),
      ),
      'b'                         => array(),
      'blockquote'                => array(
         'cite' => array(),
      ),
      'cite'                      => array(
         'title' => array(),
      ),
      'code'                      => array(),
      'del'                    => array(
         'datetime'   => array(),
         'title'      => array(),
      ),
      'dd'                     => array(),
      'div'                    => array(
         'class'   => array(),
         'title'   => array(),
         'style'   => array(),
      ),
      'dl'                     => array(),
      'dt'                     => array(),
      'em'                     => array(),
      'h1'                     => array(),
      'h2'                     => array(),
      'h3'                     => array(),
      'h4'                     => array(),
      'h5'                     => array(),
      'h6'                     => array(),
      'i'                         => array(
         'class' => array(),
      ),
      'img'                    => array(
         'alt'  => array(),
         'class'   => array(),
         'height' => array(),
         'src'  => array(),
         'width'   => array(),
      ),
      'li'                     => array(
         'class' => array(),
      ),
      'ol'                     => array(
         'class' => array(),
      ),
      'p'                         => array(
         'class' => array(),
      ),
      'q'                         => array(
         'cite'    => array(),
         'title'   => array(),
      ),
      'span'                      => array(
         'class'   => array(),
         'title'   => array(),
         'style'   => array(),
      ),
      'iframe'                 => array(
         'width'         => array(),
         'height'     => array(),
         'scrolling'     => array(),
         'frameborder'   => array(),
         'allow'         => array(),
         'src'        => array(),
      ),
      'strike'                 => array(),
      'br'                     => array(),
      'strong'                 => array(),
      'data-wow-duration'            => array(),
      'data-wow-delay'            => array(),
      'data-wallpaper-options'       => array(),
      'data-stellar-background-ratio'   => array(),
      'ul'                     => array(
         'class' => array(),
      ),
      'svg' => array(
           'class' => true,
           'aria-hidden' => true,
           'aria-labelledby' => true,
           'role' => true,
           'xmlns' => true,
           'width' => true,
           'height' => true,
           'viewbox' => true, // <= Must be lower case!
       ),
       'g'     => array( 'fill' => true ),
       'title' => array( 'title' => true ),
       'path'  => array( 'd' => true, 'fill' => true,  ),
      );

   if (function_exists('wp_kses')) { // WP is here
      $allowed = wp_kses($raw, $allowed_tags);
   } else {
      $allowed = $raw;
   }

   return $allowed;
}

/**
 * Blog Social Share
 */
if ( !function_exists('bixola_blog_social') ) {
function bixola_blog_social(){
    $post_url = get_the_permalink();
    ?>
    <div class="news-page-three__post-share">
        <div class="news-page-three__post-share-icon">
            <span class="icon-share"></span>
        </div>
        <div class="news-page-three__social">
            <a href="https://twitter.com/share?url=<?php echo esc_url($post_url);?>" target="_blank"><i class="fa-brands fa-x-twitter"></i></a>
            <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url($post_url);?>" target="_blank"><i class="fa-brands fa-facebook"></i></a>
            <a href="https://www.pinterest.com/cws/share?url=<?php echo esc_url($post_url);?>" target="_blank"><i class="fa-brands fa-pinterest-p"></i></a>
            <a href="https://www.instagram.com/sharer.php?u=<?php echo esc_url($post_url);?>" target="_blank"><i class="fa-brands fa-instagram"></i></a>
        </div>
    </div>
   <?php return false;
    }
}

/**
 * Single Blog Social Share
 */
if ( !function_exists('bixola_blog_single_social') ) {
function bixola_blog_single_social(){
    $post_url = get_the_permalink();
    ?>
    <div class="news-details__social">
        <span><?php print esc_html('Share on:', 'bixola'); ?></span>
        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url($post_url);?>" target="_blank"><i class="fa-brands fa-facebook"></i></a>
        <a href="https://twitter.com/share?url=<?php echo esc_url($post_url);?>" target="_blank"><i class="fa-brands fa-x-twitter"></i></a>
        <a href="https://www.instagram.com/sharer.php?u=<?php echo esc_url($post_url);?>" target="_blank"><i class="fa-brands fa-instagram"></i></a>
        <a href="https://www.linkedin.com/cws/share?url=<?php echo esc_url($post_url);?>" target="_blank"><i class="fa-brands fa-linkedin"></i></a>
    </div>
   <?php return false;
    }
}