<?php if ( ! defined( 'ABSPATH' )  ) { die; } // Cannot access directly.

// Control core classes for avoid errors
if( class_exists( 'CSF' ) ) {

    $bixola_page_info = 'bixola_page_info';
    $bixola_post_format_audio_video = 'bixola_post_format_audio_video';
    $bixola_post_format_gallery = 'bixola_post_format_gallery';

    CSF::createMetabox( $bixola_page_info, array(
      'title'        => 'Page Info',
      'post_type'    => 'page',
    ) );

    CSF::createMetabox( $bixola_post_format_audio_video, array(
      'title'        => 'Post Format',
      'post_type'    => 'post',
      'post_formats' => [ 'audio', 'video', ],
    ) );

    CSF::createMetabox( $bixola_post_format_gallery, array(
      'title'        => 'Post Format',
      'post_type'    => 'post',
      'post_formats' => 'gallery',
    ) );

    CSF::createSection( $bixola_page_info, array(
        'fields' => array(

            array(
                'id'    => 'is_it_invisible_breadcrumb',
                'type'  => 'switcher',
                'title' => 'Is it invisible breadcrumb?',
                'default' => false,
            ),

            array(
                'id'    => 'breadcrumb_background_image',
                'type'  => 'media',
                'title' => 'Breadcrumb Background Image',
                'dependency' => array( 'is_it_invisible_breadcrumb', '==', 'false' )
            ),

            array(
                'id'      => 'is_enable_sec_logo',
                'type'    => 'checkbox',
                'title'   => 'Enable Secondary Logo',
                'subtitle'  => 'For Enable Secondary Logo Please Go Here',
            ),

            array(
                'id'         => 'header_tabs',
                'type'       => 'radio',
                'title'      => 'Header Option',
                'options'    => array(
                  'default' => 'Default',
                  'custom' => 'Custom',
                  'elementor' => 'Elementor',
                ),
                'default'    => 'default'
            ),

            array(
                'id'          => 'header_style',
                'type'        => 'select',
                'title'       => 'Header Style',
                'subtitle'    => 'Please chose header style.',
                'options'     => array(
                    'header-style-1'  => 'Header Style 1',
                    'header-style-2'  => 'Header Style 2',
                    'header-style-3'  => 'Header Style 3',
                    'header-style-4'  => 'Header Style 4',
                ),
                'default'     => 'header-style-1',
                'dependency' => array( 'header_tabs', '==', 'custom' ),
            ),

            array(
                'id'          => 'header_templates',
                'type'        => 'select',
                'title'       => 'Header Style',
                'subtitle'    => 'Please chose header style.',
                'options'     => 'pages',
                'query_args'  => array(
                    'post_type' => 'bixola-header'
                ),
                'default'     => '',
                'dependency' => array( 'header_tabs', '==', 'elementor' ),
            ),

            array(
                'id'         => 'footer_tabs',
                'type'       => 'radio',
                'title'      => 'Footer Option',
                'options'    => array(
                  'default' => 'Default',
                  'custom' => 'Custom',
                  'elementor' => 'Elementor',
                ),
                'default'    => 'default'
            ),

            array(
                'id'          => 'footer_style',
                'type'        => 'select',
                'title'       => 'Footer Style',
                'subtitle'    => 'Please chose footer style.',
                'options'     => array(
                    'footer-style-1'  => 'Footer Style 1',
                    'footer-style-2'  => 'Footer Style 2',
                    'footer-style-3'  => 'Footer Style 3',
                    'footer-style-4'  => 'Footer Style 4',
                ),
                'default'     => 'footer-style-1',
                'dependency' => array( 'footer_tabs', '==', 'custom' ),
            ),

            array(
                'id'          => 'footer_templates',
                'type'        => 'select',
                'title'       => 'Footer Style',
                'subtitle'    => 'Please chose footer style.',
                'options'     => 'pages',
                'query_args'  => array(
                    'post_type' => 'bixola-footer'
                ),
                'default'     => '',
                'dependency' => array( 'footer_tabs', '==', 'elementor' ),
            ),

            array(
                'id'    => 'footer_bg',
                'type'  => 'media',
                'title' => 'Footer BG Image',
            ),

            array(
                'id'    => 'footer_bg_color',
                'type'  => 'color',
                'title' => 'Footer BG Color',
            ),

        )
    ));

    CSF::createSection( $bixola_post_format_audio_video, array(
        'fields' => array(

            array(
                'id'    => 'format_style',
                'type'  => 'text',
                'title' => 'Format Link',
            ),
        )
    ));

    CSF::createSection( $bixola_post_format_gallery, array(
        'fields' => array(

            array(
                'id'    => 'gallery_images',
                'type'  => 'gallery',
                'title' => 'Gallery Images',
            ),
        )
    ));

}