<?php

// Control core classes for avoid errors
if ( class_exists( 'CSF' ) ) {

    //
    // Set a unique slug-like ID
    $prefix = 'bixola';

    //
    // Create customize options
    CSF::createCustomizeOptions( $prefix );

    CSF::createSection( $prefix, array(
        'id'       => 'bixola_customizer',
        'title'    => 'Bixola Customizer',
        'priority' => 1,
    ) );

    CSF::createSection( $prefix, array(
        'parent' => 'bixola_customizer',
        'title'  => 'Header Info Settings',
        'fields' => array(

            array(
                'id'    => 'bixola_header_top_switch',
                'type'  => 'switcher',
                'title' => esc_html__( 'Header Topbar', 'bixola' ),
                'default' => false,
            ),

            array(
                'id'         => 'bixola_header_top_office_time',
                'type'       => 'text',
                'title'      => esc_html__( 'Office Time', 'bixola' ),
                'default'    => esc_html__( 'Mon to Fri: 9:00am to 6:00pm', 'bixola' ),
                'dependency' => array(
                    'bixola_header_top_switch', '==', 'true',
                ),
            ),

            array(
                'id'         => 'bixola_header_top_mail_id',
                'type'       => 'text',
                'title'      => esc_html__( 'Mail', 'bixola' ),
                'default'    => esc_html__( 'demo@example.com', 'bixola' ),
                'dependency' => array(
                    'bixola_header_top_switch', '==', 'true',
                ),
            ),

            array(
                'id'         => 'bixola_header_top_address',
                'type'       => 'text',
                'title'      => esc_html__( 'Address', 'bixola' ),
                'default'    => esc_html__( '88 Broklyn Golden Street. New York', 'bixola' ),
                'dependency' => array(
                    'bixola_header_top_switch', '==', 'true',
                ),
            ),

            array(
                'id'         => 'bixola_header_top_phone',
                'type'       => 'text',
                'title'      => esc_html__( 'Phone', 'bixola' ),
                'default'    => __( '+1 (232) 102 345', 'bixola' ),
                'dependency' => array(
                    'bixola_header_top_switch', '==', 'true',
                ),
            ),

            array(
                'id'         => 'bixola_header_top_phone_number',
                'type'       => 'text',
                'title'      => esc_html__( 'Phone URL', 'bixola' ),
                'default'    => __( '+1232102345', 'bixola' ),
                'dependency' => array(
                    'bixola_header_top_switch', '==', 'true',
                ),
            ),

            array(
                'id'    => 'bixola_sticky_hide',
                'type'  => 'switcher',
                'title' => esc_html__( 'Sticky On/Off', 'bixola' ),
                'default' => false,
            ),

            array(
                'id'    => 'bixola_preloader',
                'type'  => 'switcher',
                'title' => esc_html__( 'Preloader On/Off', 'bixola' ),
                'default' => false,
            ),

            array(
                'id'    => 'bixola_backtotop',
                'type'  => 'switcher',
                'title' => esc_html__( 'Back To Top On/Off', 'bixola' ),
                'default' => false,
            ),

            array(
                'id'    => 'bixola_header_right',
                'type'  => 'switcher',
                'title' => esc_html__( 'Header Right On/Off', 'bixola' ),
                'default' => false,
            ),

            array(
                'id'    => 'bixola_search_switch',
                'type'  => 'switcher',
                'title' => esc_html__( 'Search On/Off', 'bixola' ),
                'default' => false,
            ),

            array(
                'id'         => 'bixola_header_phone',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Header Phone On/Off', 'bixola' ),
                'default' => false,
            ),

            array(
                'id'         => 'bixola_phone_label',
                'type'       => 'text',
                'title'      => esc_html__( 'Phone Label', 'bixola' ),
                'default'    => esc_html__( 'Need help?', 'bixola' ),
                'dependency' => array( 'bixola_header_phone', '==', 'true' ),
            ),

            array(
                'id'         => 'bixola_phone_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Phone Text', 'bixola' ),
                'default'    => esc_html__( '+1 212 333 400', 'bixola' ),
                'dependency' => array( 'bixola_header_phone', '==', 'true' ),
            ),

            array(
                'id'         => 'bixola_phone_link',
                'type'       => 'text',
                'title'      => esc_html__( 'Phone Link', 'bixola' ),
                'default'    => '+1212333400',
                'dependency' => array( 'bixola_header_phone', '==', 'true' ),
            ),

            array(
                'id'         => 'bixola_header_button',
                'type'       => 'switcher',
                'title'      => 'Header Button On/Off',
                'default' => false,
            ),

            array(
                'id'         => 'bixola_button_text',
                'type'       => 'text',
                'title'      => 'Button Text',
                'default'    => esc_html__( 'Get Started', 'bixola' ),
                'dependency' => array( 'bixola_header_button', '==', 'true' ),
            ),

            array(
                'id'         => 'bixola_button_link',
                'type'       => 'text',
                'title'      => 'Button Text',
                'default'    => '#',
                'dependency' => array( 'bixola_header_button', '==', 'true' ),
            ),

        ),
    ) );

    CSF::createSection( $prefix, array(
        'parent'      => 'bixola_customizer',
        'title'       => 'Header Social',
        'fields'      => array(

            array(
                'id'      => 'bixola_topbar_fb_url',
                'type'    => 'text',
                'title'   => esc_html__( 'Facebook Url', 'bixola' ),
                'default' => '#',
            ),

            array(
                'id'      => 'bixola_topbar_twitter_url',
                'type'    => 'text',
                'title'   => esc_html__( 'Twitter Url', 'bixola' ),
                'default' => '#',
            ),

            array(
                'id'      => 'bixola_topbar_instagram_url',
                'type'    => 'text',
                'title'   => esc_html__( 'Instagram Url', 'bixola' ),
                'default' => '#',
            ),

            array(
                'id'      => 'bixola_topbar_pinterest_url',
                'type'    => 'text',
                'title'   => esc_html__( 'Pinterest Url', 'bixola' ),
                'default' => '#',
            ),

            array(
                'id'    => 'bixola_topbar_linkedin_url',
                'type'  => 'text',
                'title' => esc_html__( 'Linkedin Url', 'bixola' ),
            ),

            array(
                'id'    => 'bixola_topbar_dribbble_url',
                'type'  => 'text',
                'title' => esc_html__( 'Dribbble Url', 'bixola' ),
            ),

            array(
                'id'    => 'bixola_topbar_whatsapp_url',
                'type'  => 'text',
                'title' => esc_html__( 'Whatsapp Url', 'bixola' ),
            ),

            array(
                'id'    => 'bixola_topbar_tiktok_url',
                'type'  => 'text',
                'title' => esc_html__( 'Tiktok Url', 'bixola' ),
            ),

            array(
                'id'    => 'bixola_topbar_soundcloud_url',
                'type'  => 'text',
                'title' => esc_html__( 'Soundcloud Url', 'bixola' ),
            ),

            array(
                'id'    => 'bixola_topbar_vimeo_url',
                'type'  => 'text',
                'title' => esc_html__( 'Vimeo Url', 'bixola' ),
            ),

            array(
                'id'    => 'bixola_topbar_youtube_url',
                'type'  => 'text',
                'title' => esc_html__( 'Youtube Url', 'bixola' ),
            ),

        ),
    ) );

    CSF::createSection( $prefix, array(
        'parent' => 'bixola_customizer',
        'title'  => 'Header Setting',
        'fields' => array(

            array(
                'id'    => 'header_elementor_switch',
                'type'  => 'switcher',
                'title' => esc_html__( 'Header Custom/Elementor Switch', 'bixola' ),
                'default' => false,
            ),

            array(
                'id'      => 'choose_default_header',
                'type'    => 'image_select',
                'title'   => 'Select Header Style',
                'options' => array(
                    'header-style-1' => get_template_directory_uri() . '/inc/img/header/header-1.png',
                    'header-style-2' => get_template_directory_uri() . '/inc/img/header/header-2.png',
                    'header-style-3' => get_template_directory_uri() . '/inc/img/header/header-3.png',
                    'header-style-4' => get_template_directory_uri() . '/inc/img/header/header-4.png',
                ),
                'default' => 'header-style-1',
                'dependency' => array( 'header_elementor_switch', '==', false ),
            ),

            array(
                'id'          => 'header_templates',
                'type'        => 'select',
                'title'       => 'Elementor Header Template',
                'subtitle'    => 'Please chose elementor header style.',
                'options'     => 'pages',
                'query_args'  => array(
                    'post_type' => 'tp-header'
                ),
                'default'     => '',
                'dependency' => array( 'header_elementor_switch', '==', true ),
            ),

            array(
                'id'       => 'logo',
                'type'     => 'upload',
                'title'    => esc_html__( 'Header Logo', 'bixola' ),
                'subtitle' => esc_html__( 'Upload Your Logo.', 'bixola' ),
                'default'  => get_template_directory_uri() . '/assets/images/resources/logo-1.png',
                'library'  => 'image',
                'preview'  => true,
            ),

            array(
                'id'      => 'secondary_logo',
                'type'    => 'upload',
                'title'   => esc_html__( 'Header Secondary Logo', 'bixola' ),
                'subtitle' => esc_html__( 'Upload Your Header Logo White', 'bixola' ),
                'default' => get_template_directory_uri() . '/assets/images/resources/logo-2.png',
                'library' => 'image',
                'preview' => true,
            ),

            array(
                'id'      => 'preloader_logo',
                'type'    => 'upload',
                'title'   => esc_html__( 'Preloader Logo', 'bixola' ),
                'subtitle' => esc_html__( 'Upload Your Preloader Logo.', 'bixola' ),
                'default' => get_template_directory_uri() . '/assets/images/loader.png',
                'library' => 'image',
                'preview' => true,
            ),
        ),
    ) );

    CSF::createSection( $prefix, array(
        'parent' => 'bixola_customizer',
        'title'  => 'Side Info',
        'fields' => array(

            array(
                'id'    => 'side_hide',
                'type'  => 'switcher',
                'title' => esc_html__( 'Side Info On/Off', 'bixola' ),
                'default' => false,
            ),

            array(
                'id'       => 'side_logo',
                'type'     => 'upload',
                'title'    => esc_html__( 'Logo Side', 'bixola' ),
                'subtitle' => esc_html__( 'Logo Side', 'bixola' ),
                'default'  => get_template_directory_uri() . '/assets/images/resources/logo-1.png',
                'library'  => 'image',
                'preview'  => true,
            ),

            array(
                'id'      => 'bixola_side_mail_id',
                'type'    => 'text',
                'title'   => esc_html__( 'Mail Address', 'bixola' ),
                'default' => __( 'needhelp@bixola.com', 'bixola' ),
            ),

            array(
                'id'      => 'bixola_side_phone',
                'type'    => 'text',
                'title'   => esc_html__( 'Phone Text', 'bixola' ),
                'default' => __( '666 888 0000', 'bixola' ),
            ),

            array(
                'id'      => 'bixola_side_phone_link',
                'type'    => 'text',
                'title'   => esc_html__( 'Phone Text', 'bixola' ),
                'default' => __( '+6668880000', 'bixola' ),
            ),

        ),
    ) );

    CSF::createSection( $prefix, array(
        'parent' => 'bixola_customizer',
        'title'  => 'Breadcrumb Setting',
        'fields' => array(

            array(
                'id'    => 'breadcrumb_switch',
                'type'  => 'switcher',
                'title' => esc_html__( 'Breadcrumb Hide', 'bixola' ),
                'default' => true,
            ),

            array(
                'id'    => 'breadcrumb_shape_switch',
                'type'  => 'switcher',
                'title' => esc_html__( 'Breadcrumb Shape', 'bixola' ),
                'default' => true,
            ),

            array(
                'id'       => 'breadcrumb_bg_img',
                'type'     => 'upload',
                'title'    => esc_html__( 'Breadcrumb Background Image', 'bixola' ),
                'subtitle' => esc_html__( 'Breadcrumb Background Image', 'bixola' ),
                'default'  => get_template_directory_uri() . '/assets/images/backgrounds/page-header-bg.jpg',
                'library'  => 'image',
                'preview'  => true,
            ),

            array(
                'id'    => 'breadcrumb_info_switch',
                'type'  => 'switcher',
                'title' => esc_html__( 'Breadcrumb Info switch', 'bixola' ),
                'default' => true,
            ),

            array(
                'id'     => 'breadcrumb_color_one',
                'type'   => 'color',
                'title'  => esc_html__( 'Breadcrumb Color 1', 'bixola' ),
            ),

            array(
                'id'     => 'breadcrumb_color_two',
                'type'   => 'color',
                'title'  => esc_html__( 'Breadcrumb Color 2', 'bixola' ),
            ),
        ),
    ) );

    CSF::createSection( $prefix, array(
        'parent' => 'bixola_customizer',
        'title'  => 'Blog Setting',
        'fields' => array(

            array(
                'id'    => 'bixola_blog_btn_switch',
                'type'  => 'switcher',
                'title' => esc_html__( 'Blog BTN On/Off', 'bixola' ),
                'default' => true,
            ),

            array(
                'id'    => 'bixola_blog_cat',
                'type'  => 'switcher',
                'title' => esc_html__( 'Blog Category Meta On/Off', 'bixola' ),
                'default' => true,
            ),

            array(
                'id'    => 'bixola_blog_author',
                'type'  => 'switcher',
                'title' => esc_html__( 'Blog Author Meta On/Off', 'bixola' ),
                'default' => true,
            ),

            array(
                'id'    => 'bixola_blog_date',
                'type'  => 'switcher',
                'title' => esc_html__( 'Blog Date Meta On/Off', 'bixola' ),
                'default' => true,
            ),

            array(
                'id'    => 'bixola_blog_comments',
                'type'  => 'switcher',
                'title' => esc_html__( 'Blog Comments Meta On/Off', 'bixola' ),
                'default' => true,
            ),

            array(
                'id'      => 'bixola_blog_btn',
                'type'    => 'text',
                'title'   => esc_html__( 'Blog Button text', 'bixola' ),
                'default' => __( 'Read More', 'bixola' ),
            ),

            array(
                'id'      => 'breadcrumb_blog_title',
                'type'    => 'text',
                'title'   => esc_html__( 'Blog Title', 'bixola' ),
                'default' => __( 'Blog', 'bixola' ),
            ),

            array(
                'id'      => 'breadcrumb_blog_title_details',
                'type'    => 'text',
                'title'   => esc_html__( 'Blog Details Title', 'bixola' ),
                'default' => __( 'Blog Details', 'bixola' ),
            ),
        ),
    ) );

    CSF::createSection( $prefix, array(
        'parent' => 'bixola_customizer',
        'title'  => 'Footer Info Setting',
        'fields' => array(

            array(
                'id'    => 'footer_shape_switch',
                'type'  => 'switcher',
                'title' => esc_html__( 'Footer Shape On/Off', 'bixola' ),
                'default' => false,
            ),
            
            array(
                'id'    => 'footer_social_switch',
                'type'  => 'switcher',
                'title' => esc_html__( 'Footer Social On/Off', 'bixola' ),
                'default' => false,
            ),

            array(
                'id'    => 'footer_contact_info',
                'type'  => 'switcher',
                'title' => esc_html__( 'Footer Contact Info On/Off', 'bixola' ),
                'default' => false,
            ),

            array(
                'id'      => 'footer_contact_location_heading',
                'type'    => 'text',
                'title'   => esc_html__( 'Location Title', 'bixola' ),
                'default' => __( 'Office Location', 'bixola' ),
                'dependency' => array( 'footer_contact_info', '==', 'true' ),
            ),

            array(
                'id'      => 'footer_contact_location',
                'type'    => 'text',
                'title'   => esc_html__( 'Location', 'bixola' ),
                'default' => __( '91195 Brock Walks, Pittsburg,<br> Ohio 75843, USA', 'bixola' ),
                'dependency' => array( 'footer_contact_info', '==', 'true' ),
            ),

            array(
                'id'      => 'footer_contact_phone_heading',
                'type'    => 'text',
                'title'   => esc_html__( 'Phone Title', 'bixola' ),
                'default' => __( 'Get a quote', 'bixola' ),
                'dependency' => array( 'footer_contact_info', '==', 'true' ),
            ),

            array(
                'id'      => 'footer_contact_phone_label_one',
                'type'    => 'text',
                'title'   => esc_html__( 'Phone One Label', 'bixola' ),
                'default' => __( '+1(333) 000-0000', 'bixola' ),
                'dependency' => array( 'footer_contact_info', '==', 'true' ),
            ),

            array(
                'id'      => 'footer_contact_phone_one',
                'type'    => 'text',
                'title'   => esc_html__( 'Phone One Link', 'bixola' ),
                'default' => __( '+13330000000', 'bixola' ),
                'dependency' => array( 'footer_contact_info', '==', 'true' ),
            ),

            array(
                'id'      => 'footer_contact_phone_label_two',
                'type'    => 'text',
                'title'   => esc_html__( 'Phone One Label', 'bixola' ),
                'default' => __( '+1(333) 000-0000', 'bixola' ),
                'dependency' => array( 'footer_contact_info', '==', 'true' ),
            ),

            array(
                'id'      => 'footer_contact_phone_two',
                'type'    => 'text',
                'title'   => esc_html__( 'Phone One Link', 'bixola' ),
                'default' => __( '+13330000000', 'bixola' ),
                'dependency' => array( 'footer_contact_info', '==', 'true' ),
            ),

            array(
                'id'      => 'footer_contact_working_time_heading',
                'type'    => 'text',
                'title'   => esc_html__( 'Working Time Title', 'bixola' ),
                'default' => __( 'Working Time', 'bixola' ),
                'dependency' => array( 'footer_contact_info', '==', 'true' ),
            ),

            array(
                'id'      => 'footer_contact_working_time',
                'type'    => 'text',
                'title'   => esc_html__( 'Working Time', 'bixola' ),
                'default' => __( 'Mon - Sat: 9:00 AM - 5:00 PM Sunday Close', 'bixola' ),
                'dependency' => array( 'footer_contact_info', '==', 'true' ),
            ),

            array(
                'id'    => 'bixola_footer_bg_switch',
                'type'  => 'switcher',
                'title' => esc_html__( 'Footer Background Image On/Off', 'bixola' ),
                'default' => false,
            ),

            array(
                'id'         => 'bixola_footer_bg',
                'type'       => 'media',
                'title'      => esc_html__( 'Footer Background Image.', 'bixola' ),
                'subtitle'   => esc_html__( 'Footer Background Image.', 'bixola' ),
                'default'    => get_template_directory_uri() . '/assets/img/bg-img/footer-bg.jpg',
                'library'    => 'image',
                'preview'    => true,
                'dependency' => array( 'bixola_footer_bg_switch', '==', 'true' ),
            ),

            array(
                'id'     => 'bixola_footer_bg_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Footer BG Color', 'bixola' ),
                'default' => '#ffffff',
                'output' => array( 'background-color' => '.element-1', 'color' => '.element-2', 'border-color' => '.element-3' ),
            ),

            array(
                'id'      => 'bixola_copyright',
                'type'    => 'text',
                'title'   => esc_html__( 'Copy Right', 'bixola' ),
                'default' => __( '© Copyright Bixola 2024. All rights reserved.', 'bixola' ),
            ),

            array(
                'id'    => 'bixola_footer_bottom_menu',
                'type'  => 'switcher',
                'title' => esc_html__( 'Footer Bottom Menu On/Off', 'bixola' ),
                'default' => false,
            ),
        ),
    ) );

    CSF::createSection( $prefix, array(
        'parent' => 'bixola_customizer',
        'title'  => 'Footer Setting',
        'fields' => array(

            array(
                'id'      => 'choose_default_footer',
                'type'    => 'image_select',
                'title'   => 'Select Footer Style',
                'options' => array(
                    'footer-style-1' => get_template_directory_uri() . '/inc/img/footer/footer-1.png',
                    'footer-style-2' => get_template_directory_uri() . '/inc/img/footer/footer-2.png',
                    'footer-style-3' => get_template_directory_uri() . '/inc/img/footer/footer-3.png',
                    'footer-style-4' => get_template_directory_uri() . '/inc/img/footer/footer-4.png',
                ),
                'default' => 'footer-style-1',
            ),

            array(
                'id'          => 'footer_widget_number',
                'type'        => 'select',
                'title'       => esc_html__( 'Widget Number', 'bixola' ),
                'placeholder' => esc_html__( 'Select an option...', 'bixola' ),
                'options'     => array(
                    '4' => esc_html__( 'Widget Number 4', 'bixola' ),
                    '3' => esc_html__( 'Widget Number 3', 'bixola' ),
                    '2' => esc_html__( 'Widget Number 2', 'bixola' ),
                ),
                'default'     => '4',
            ),

            array(
                'id'    => 'footer_style_2_switch',
                'type'  => 'switcher',
                'title' => esc_html__( 'Footer Style 2 On/Off', 'bixola' ),
                'default' => true,
            ),

            array(
                'id'    => 'footer_style_3_switch',
                'type'  => 'switcher',
                'title' => esc_html__( 'Footer Style 3 On/Off', 'bixola' ),
                'default' => true,
            ),

            array(
                'id'    => 'footer_style_4_switch',
                'type'  => 'switcher',
                'title' => esc_html__( 'Footer Style 4 On/Off', 'bixola' ),
                'default' => true,
            ),
        ),
    ) );

    CSF::createSection( $prefix, array(
        'parent' => 'bixola_customizer',
        'title'  => 'Color Setting',
        'fields' => array(

            array(
                'id'       => 'bixola_color_option_prim',
                'type'     => 'color',
                'title'    => esc_html__( 'Primary Color', 'bixola' ),
                'subtitle' => esc_html__( 'Site main color.', 'bixola' ),
                'default'  => '#F52549',
                'rgba'     => true,
            ),

            array(
                'id'       => 'bixola_color_option_prim_rgb',
                'type'     => 'color',
                'title'    => esc_html__( 'Primary RGBA Color', 'bixola' ),
                'subtitle' => esc_html__( 'Site main rgba color.', 'bixola' ),
                'default'  => '65, 70, 81',
                'rgba'     => true,
            ),

            array(
                'id'       => 'bixola_color_option_sec',
                'type'     => 'color',
                'title'    => esc_html__( 'Secondary Color', 'bixola' ),
                'subtitle' => esc_html__( 'Site secondary color.', 'bixola' ),
                'default'  => '#F7F9FA',
                'rgba'     => true,
            ),

            array(
                'id'       => 'bixola_color_option_sec_rgb',
                'type'     => 'color',
                'title'    => esc_html__( 'Secondary RGBA Color', 'bixola' ),
                'subtitle' => esc_html__( 'Site secondary rgba color.', 'bixola' ),
                'default'  => '247, 249, 250',
                'rgba'     => true,
            ),

            array(
                'id'       => 'breadcrumb_color_one',
                'type'     => 'color',
                'title'    => esc_html__( 'BreadCrumb Gradient 1', 'bixola' ),
                'subtitle' => esc_html__( 'Site breadCrumb gradient 1 color.', 'bixola' ),
                'default'  => '#000000',
                'rgba'     => true,
            ),

            array(
                'id'       => 'breadcrumb_color_two',
                'type'     => 'color',
                'title'    => esc_html__( 'BreadCrumb Gradient 2', 'bixola' ),
                'subtitle' => esc_html__( 'Site breadCrumb gradient 2 color.', 'bixola' ),
                'default'  => '34, 34, 34, 0.5',
                'rgba'     => true,
            ),

            array(
                'id'       => 'bixola_color_option_black',
                'type'     => 'color',
                'title'    => esc_html__( 'Black Color', 'bixola' ),
                'subtitle' => esc_html__( 'Site black color.', 'bixola' ),
                'default'  => '#0D121E',
                'rgba'     => true,
            ),

            array(
                'id'       => 'bixola_color_option_black_rgb',
                'type'     => 'color',
                'title'    => esc_html__( 'Black RGBA Color', 'bixola' ),
                'subtitle' => esc_html__( 'Site black rgba color.', 'bixola' ),
                'default'  => '13, 18, 30',
                'rgba'     => true,
            ),

            array(
                'id'       => 'bixola_color_option_white',
                'type'     => 'color',
                'title'    => esc_html__( 'White Color', 'bixola' ),
                'subtitle' => esc_html__( 'Site white color.', 'bixola' ),
                'default'  => '#fff',
                'rgba'     => true,
            ),

            array(
                'id'       => 'bixola_color_option_white_rgb',
                'type'     => 'color',
                'title'    => esc_html__( 'White RGBA Color', 'bixola' ),
                'subtitle' => esc_html__( 'Site white rgba color.', 'bixola' ),
                'default'  => '255, 255, 255',
                'rgba'     => true,
            ),

            array(
                'id'       => 'bixola_color_option_gray',
                'type'     => 'color',
                'title'    => esc_html__( 'Gray Color', 'bixola' ),
                'subtitle' => esc_html__( 'Site gray color.', 'bixola' ),
                'default'  => '#414651',
                'rgba'     => true,
            ),

            array(
                'id'       => 'bixola_color_option_gray_rgb',
                'type'     => 'color',
                'title'    => esc_html__( 'Gray RGBA Color', 'bixola' ),
                'subtitle' => esc_html__( 'Site gray rgba color.', 'bixola' ),
                'default'  => '65, 70, 81',
                'rgba'     => true,
            ),
        ),
    ) );

    CSF::createSection( $prefix, array(
        'parent' => 'bixola_customizer',
        'title'  => '404',
        'fields' => array(

            array(
                'id'      => 'bixola_error_title',
                'type'    => 'text',
                'title'   => esc_html__( 'Page can’t be found', 'bixola' ),
                'default' => __( '404', 'bixola' ),
            ),

            array(
                'id'      => 'bixola_error_subtitle',
                'type'    => 'text',
                'title'   => esc_html__( 'Subheading', 'bixola' ),
                'default' => __( 'Sorry we cant find that page!', 'bixola' ),
            ),

            array(
                'id'      => 'bixola_error_description',
                'type'    => 'textarea',
                'title'   => esc_html__( '404 Description', 'bixola' ),
                'default' => __( 'The page you are looking for was never existed.', 'bixola' ),
            ),

            array(
                'id'      => 'bixola_error_link_text',
                'type'    => 'text',
                'title'   => esc_html__( '404 Link Text', 'bixola' ),
                'default' => __( 'Back to Home', 'bixola' ),
            ),

        ),
    ) );

    CSF::createSection( $prefix, array(
        'parent' => 'bixola_customizer',
        'title'  => 'Typography',
        'fields' => array(

            array(
                'id'      => 'typography_body_setting',
                'type'    => 'typography',
                'title'   => esc_html__( 'Body Font', 'bixola' ),
                'output'  => 'body',
                'default' => array(
                    'color'          => '',
                    'font-family'    => '',
                    'font-size'      => '',
                    'line-height'    => '',
                    'letter-spacing' => '0',
                    'unit'           => 'px',
                    'type'           => 'google',
                ),
            ),

            array(
                'id'      => 'typography_h1_setting',
                'type'    => 'typography',
                'title'   => esc_html__( 'Heading h1 Fonts', 'bixola' ),
                'output'  => 'h1',
                'default' => array(
                    'color'          => '',
                    'font-family'    => '',
                    'font-size'      => '',
                    'line-height'    => '',
                    'letter-spacing' => '0',
                    'unit'           => 'px',
                    'type'           => 'google',
                ),
            ),

            array(
                'id'      => 'typography_h2_setting',
                'type'    => 'typography',
                'title'   => esc_html__( 'Heading h2 Fonts', 'bixola' ),
                'output'  => 'h2',
                'default' => array(
                    'color'          => '',
                    'font-family'    => '',
                    'font-size'      => '',
                    'line-height'    => '',
                    'letter-spacing' => '0',
                    'unit'           => 'px',
                    'type'           => 'google',
                ),
            ),

            array(
                'id'      => 'typography_h3_setting',
                'type'    => 'typography',
                'title'   => esc_html__( 'Heading h3 Fonts', 'bixola' ),
                'output'  => 'h3',
                'default' => array(
                    'color'          => '',
                    'font-family'    => '',
                    'font-size'      => '',
                    'line-height'    => '',
                    'letter-spacing' => '0',
                    'unit'           => 'px',
                    'type'           => 'google',
                ),
            ),

            array(
                'id'      => 'typography_h4_setting',
                'type'    => 'typography',
                'title'   => esc_html__( 'Heading h4 Fonts', 'bixola' ),
                'output'  => 'h4',
                'default' => array(
                    'color'          => '',
                    'font-family'    => '',
                    'font-size'      => '',
                    'line-height'    => '',
                    'letter-spacing' => '0',
                    'unit'           => 'px',
                    'type'           => 'google',
                ),
            ),

            array(
                'id'      => 'typography_h5_setting',
                'type'    => 'typography',
                'title'   => esc_html__( 'Heading h5 Fonts', 'bixola' ),
                'output'  => 'h5',
                'default' => array(
                    'color'          => '',
                    'font-family'    => '',
                    'font-size'      => '',
                    'line-height'    => '',
                    'letter-spacing' => '0',
                    'unit'           => 'px',
                    'type'           => 'google',
                ),
            ),

            array(
                'id'      => 'typography_h6_setting',
                'type'    => 'typography',
                'title'   => esc_html__( 'Heading h6 Fonts', 'bixola' ),
                'output'  => 'h6',
                'default' => array(
                    'color'          => '',
                    'font-family'    => '',
                    'font-size'      => '',
                    'line-height'    => '',
                    'letter-spacing' => '0',
                    'unit'           => 'px',
                    'type'           => 'google',
                ),
            ),

        ),
    ) );

}


if ( class_exists( 'CSF' ) ) {
    // Set a unique slug-like ID
    $prefix = 'parent_theme_options';
  
    // Create the main parent section
    CSF::createSection( $prefix, array(
      'title'  => 'Parent Section',
      'fields' => array(
        array(
          'id'    => 'parent_text',
          'type'  => 'text',
          'title' => 'Parent Text',
        ),
        // Start of child section
        array(
          'type'    => 'subheading',
          'content' => 'Child Section',
        ),
        array(
          'id'    => 'child_text',
          'type'  => 'text',
          'title' => 'Child Text',
        ),
        // Start of grandchild section
        array(
          'type'    => 'subheading',
          'content' => 'Grandchild Section',
        ),
        array(
          'id'    => 'grandchild_text',
          'type'  => 'text',
          'title' => 'Grandchild Text',
        ),
      )
    ) );
  }