<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package bixola
 */
?>

<!doctype html>
<html <?php language_attributes();?>>
<head>
	<meta charset="<?php bloginfo( 'charset' );?>">
    <?php if ( is_singular() && pings_open( get_queried_object() ) ): ?>
    <?php endif;?>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head();?>
</head>

<body <?php body_class();?>>

    <?php wp_body_open();?>


    <?php

        $bixola_preloader = bixola_get_option( 'bixola_preloader' );
        $bixola_backtotop = bixola_get_option( 'bixola_backtotop' );
        $preloader_logo_default = get_template_directory_uri() . '/assets/images/loader.png';
        $preloader_logo = bixola_get_option( 'preloader_logo', $preloader_logo_default );
    ?>

    <?php if ( !empty( $bixola_preloader ) ): ?>
        <div class="preloader">
            <div class="preloader__image" data-background="<?php print esc_url($preloader_logo); ?>"></div>
        </div>
    <?php endif; ?>

    <?php if ( !empty( $bixola_backtotop ) ): ?>
        <a href="#" data-target="html" class="scroll-to-target scroll-to-top">
            <i class="icon-right-arrow"></i>
        </a>
    <?php endif; ?>

    
    <!-- header start -->
    <?php do_action( 'bixola_header_style' );?>
    <!-- header end -->
    
    <!-- wrapper-box start -->
    <?php do_action( 'bixola_before_main_content' );?>