<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Bixola
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
    return;
}
?>

<div id="comments" class="comments-area news-details__bottom">
	<?php
        // You can start editing here -- including this comment!
        if ( have_comments() ): ?>

            <h4 class="comments-title comment-one__title">
                <?php
                    comments_number(
                        esc_html__( '0 Comments', 'bixola' ),
                        esc_html__( '1 Comments', 'bixola' ),
                        esc_html__( '% Comments', 'bixola' )
                    );
                ?>
            </h4>
            <!-- Comment List -->
            <div class="news-details__comment-and-form">
                <div class="comment-one">
                    <ul class="comment-list">
                        <?php
                            wp_list_comments( [
                                'walker'      => new Bixola_Comment_Walker(),
                                'avatar_size' => 100,
                                'short_ping'  => true,
                            ] );
                        ?>
                    </ul>
                </div>
            </div>

            <?php
                the_comments_navigation();

                // If comments are closed and there are comments, let's leave a little note, shall we?
                if ( ! comments_open() ): ?>
                <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'bixola' );?></p>
                <?php endif;
            ?>

        <?php endif;

        /**
         * Custom comments_args
         * @link https://developer.wordpress.org/reference/functions/comment_form/
         */
        $commenter = wp_get_current_commenter();

        $comments_args = [
            'title_reply_before' => wp_kses_post( '<h3 id="reply-title" class="comment-reply-title comment-form__title"><span>' ),
            'title_reply_after'  => wp_kses_post( '</span></h3>' ),
            'title_reply'        => esc_html__( 'Leave a Reply', 'bixola' ),
            'comment_notes_before'        => __( '<span>Your email address will not be published. Required fields are marked *</span>', 'bixola' ),
            'fields'             => apply_filters( 'comment_form_default_fields', [
                'author' => '<div class="row"><div class="col-xl-6"><div class="comment-form__input-box"><div class="comment-form__input-box-name"><p>' . esc_attr__( 'Full Name', 'bixola' ) . '</p></div><input id="author" name="author" type="text" placeholder="' . esc_attr__( 'Name *', 'bixola' ) . '" required /></div></div>',
                'email'  => '<div class="col-xl-6"><div class="comment-form__input-box"><div class="comment-form__input-box-name"><p>' . esc_attr__( 'Email Address', 'bixola' ) . '</p></div><input id="email" name="email" type="email" placeholder="' . esc_attr__( 'Email *', 'bixola' ) . '" required /></div></div>',
                'url'    => '<div class="col-xl-12"><div class="comment-form__input-box"><div class="comment-form__input-box-name"><p>' . esc_attr__( 'Website', 'bixola' ) . '</p></div><input id="url" name="url" type="url" placeholder="' . esc_attr__( 'Website (Optional)', 'bixola' ) . '" /></div></div></div>',
            ] ),
            'comment_field'      => '<div class="row"><div class="col-xl-12"><div class="comment-form__input-box text-message-box"><div class="comment-form__input-box-name"><p>' . esc_attr__( 'Message', 'bixola' ) . '</p></div><textarea id="comment" name="comment" aria-required="true" placeholder="' . esc_attr__( 'Write Comment', 'bixola' ) . '" required /></textarea></div></div></div>',
            'class_submit'       => 'submit-btn',
            'label_submit'       => esc_html__( 'Post Comment', 'bixola' ),
            'submit_button'        => '<div class="comment-form__btn-box"><button type="submit" class="comment-form__btn">%4$s</button></div>',
            'format'             => 'xhtml',
        ];

        comment_form( $comments_args );
    ?>
</div>
