(function($) {
    "use strict";

    function thmOwlInit() {
        // owl slider

        if ($(".thm-owl__carousel").length) {
            $(".thm-owl__carousel").each(function() {
                let elm = $(this);
                let options = elm.data('owl-options');
                let thmOwlCarousel = elm.owlCarousel(options);
            });
        }

        if ($(".thm-owl__carousel--custom-nav").length) {
            $(".thm-owl__carousel--custom-nav").each(function() {
                let elm = $(this);
                let owlNavPrev = elm.data('owl-nav-prev');
                let owlNavNext = elm.data('owl-nav-next');
                $(owlNavPrev).on("click", function(e) {
                    elm.trigger('prev.owl.carousel');
                    e.preventDefault();
                })

                $(owlNavNext).on("click", function(e) {
                    elm.trigger('next.owl.carousel');
                    e.preventDefault();
                })
            });
        }


    }

    //===Language switcher===
    function languageSwitcher() {

        if ($("#polyglot-language-options").length) {
            $('#polyglotLanguageSwitcher').polyglotLanguageSwitcher({
                effect: 'slide',
                animSpeed: 500,
                testMode: true,
                onChange: function(evt) {
                    alert("The selected language is: " + evt.selectedItem);
                }

            });
        };
    }


    //Pricing Tabs
    if ($(".pricing-tabs").length) {
        $(".pricing-tabs .tab-btns .tab-btn").on("click", function(e) {
            e.preventDefault();
            var target = $($(this).attr("data-tab"));

            if ($(target).hasClass("actve-tab")) {
                return false;
            } else {
                $(".pricing-tabs .tab-btns .tab-btn").removeClass("active-btn");
                $(this).addClass("active-btn");
                $(".pricing-tabs .pr-content .pr-tab").removeClass("active-tab");
                $(target).addClass("active-tab");
            }
        });
    }


    if ($(".portfolio-one__list li").length) {
        $(".portfolio-one__list li").each(function() {
            let self = $(this);

            self.on("mouseenter", function() {
                console.log($(this));
                $(".portfolio-one__list li").removeClass("active");
                $(this).addClass("active");
            });
        });
    }

    if ($(".odometer").length) {
        var odo = $(".odometer");
        odo.each(function() {
            $(this).appear(function() {
                var countNumber = $(this).attr("data-count");
                $(this).html(countNumber);
            });
        });
    }

    if ($(".dynamic-year").length) {
        let date = new Date();
        $(".dynamic-year").html(date.getFullYear());
    }

    if ($(".wow").length) {
        var wow = new WOW({
            boxClass: "wow", // animated element css class (default is wow)
            animateClass: "animated", // animation css class (default is animated)
            mobile: true, // trigger animations on mobile devices (default is true)
            live: true // act on asynchronously loaded content (default is true)
        });
        wow.init();
    }

    if ($("#donate-amount__predefined").length) {
        let donateInput = $("#donate-amount");
        $("#donate-amount__predefined")
            .find("li")
            .on("click", function(e) {
                e.preventDefault();
                let amount = $(this).find("a").text();
                donateInput.val(amount);
                $("#donate-amount__predefined").find("li").removeClass("active");
                $(this).addClass("active");
            });
    }

    if ($(".thm-accordion").length) {
        let accordionWrapper = $(".thm-accordion");
        accordionWrapper.each(function() {
            let $this = $(this);
            let accordionID = $this.attr("id");
            let accordionTitle = $this.find(".thm-accordion__title");
            $this.addClass(accordionID);
            // default hide
            let mainAccordionContent = $this.find(".thm-accordion__content").hide();
            $this.find(".active-item .thm-accordion__content").show();
            // on title click
            accordionTitle.on("click", function(e) {
                e.preventDefault();
                let $this = $(this);
                let accordionItem = $(this).parent();
                if (false === accordionItem.hasClass("active-item")) {
                    $("#" + accordionID)
                        .find(".thm-accordion__item")
                        .removeClass("active-item");
                    accordionItem.addClass("active-item");
                    mainAccordionContent.slideUp();
                    accordionItem.find(".thm-accordion__content").slideDown();
                }
            });
        });
    }

    if ($(".tabs-box").length) {
        $(".tabs-box .tab-buttons .tab-btn").on("click", function(e) {
            e.preventDefault();
            var target = $($(this).attr("data-tab"));

            if ($(target).is(":visible")) {
                return false;
            } else {
                target
                    .parents(".tabs-box")
                    .find(".tab-buttons")
                    .find(".tab-btn")
                    .removeClass("active-btn");
                $(this).addClass("active-btn");
                target
                    .parents(".tabs-box")
                    .find(".tabs-content")
                    .find(".tab")
                    .fadeOut(0);
                target
                    .parents(".tabs-box")
                    .find(".tabs-content")
                    .find(".tab")
                    .removeClass("active-tab");
                $(target).fadeIn(300);
                $(target).addClass("active-tab");
            }
        });
    }


    // custom coursor
    if ($(".custom-cursor").length) {

        var cursor = document.querySelector('.custom-cursor__cursor');
        var cursorinner = document.querySelector('.custom-cursor__cursor-two');
        var a = document.querySelectorAll('a');

        document.addEventListener('mousemove', function(e) {
            var x = e.clientX;
            var y = e.clientY;
            cursor.style.transform = `translate3d(calc(${e.clientX}px - 50%), calc(${e.clientY}px - 50%), 0)`
        });

        document.addEventListener('mousemove', function(e) {
            var x = e.clientX;
            var y = e.clientY;
            cursorinner.style.left = x + 'px';
            cursorinner.style.top = y + 'px';
        });

        document.addEventListener('mousedown', function() {
            cursor.classList.add('click');
            cursorinner.classList.add('custom-cursor__innerhover')
        });

        document.addEventListener('mouseup', function() {
            cursor.classList.remove('click')
            cursorinner.classList.remove('custom-cursor__innerhover')
        });

        a.forEach(item => {
            item.addEventListener('mouseover', () => {
                cursor.classList.add('custom-cursor__hover');
            });
            item.addEventListener('mouseleave', () => {
                cursor.classList.remove('custom-cursor__hover');
            });
        })
    }

    if ($(".listing-details__contact-info-phone").length) {
        $(".listing-details__contact-info-phone").on("click", function(e) {
            e.preventDefault();
            var textElement = $(this).find(".text h5");
            var mainText = textElement.data("number");
            var toggleText = textElement.data("toggle-number");
            if (textElement.text() == mainText) {
                textElement.text(toggleText);
            } else {
                textElement.text(mainText);
            }
        });
    }

    if ($(".listing-top__map-show-hide").length) {
        $(".listing-top__map-show-hide").on("click", function() {
            $(this).toggleClass("hidden");
            var textElement = $(this).find(".listing-top__map-show-hide-text span");
            if (textElement.text() == textElement.data("text")) {
                textElement.text(textElement.data("toggle-text"));
            } else {
                textElement.text(textElement.data("text"));
            }
            $(".listing__map").toggleClass("hidden");
            $(".listing__content").toggleClass("hidden");
        });
    }

    // Type Effect
    if ($(".typed-effect").length) {
        $(".typed-effect").each(function() {
            var typedStrings = $(this).data("strings");
            var typedTag = $(this).attr("id");
            var typed = new Typed("#" + typedTag, {
                typeSpeed: 100,
                backSpeed: 100,
                fadeOut: true,
                loop: true,
                strings: typedStrings.split(",")
            });
        });
    }

    // Popular Causes Progress Bar
    if ($(".count-bar").length) {
        $(".count-bar").appear(
            function() {
                var el = $(this);
                var percent = el.data("percent");
                $(el).css("width", percent).addClass("counted");
            }, {
                accY: -50
            }
        );
    }

    //Progress Bar / Levels
    if ($(".progress-levels .progress-box .bar-fill").length) {
        $(".progress-box .bar-fill").each(
            function() {
                $(".progress-box .bar-fill").appear(function() {
                    var progressWidth = $(this).attr("data-percent");
                    $(this).css("width", progressWidth + "%");
                });
            }, {
                accY: 0
            }
        );
    }

    //Fact Counter + Text Count
    if ($(".count-box").length) {
        $(".count-box").appear(
            function() {
                var $t = $(this),
                    n = $t.find(".count-text").attr("data-stop"),
                    r = parseInt($t.find(".count-text").attr("data-speed"), 10);

                if (!$t.hasClass("counted")) {
                    $t.addClass("counted");
                    $({
                        countNum: $t.find(".count-text").text()
                    }).animate({
                        countNum: n
                    }, {
                        duration: r,
                        easing: "linear",
                        step: function() {
                            $t.find(".count-text").text(Math.floor(this.countNum));
                        },
                        complete: function() {
                            $t.find(".count-text").text(this.countNum);
                        }
                    });
                }
            }, {
                accY: 0
            }
        );
    }

    // Accrodion
    if ($(".accrodion-grp").length) {
        var accrodionGrp = $(".accrodion-grp");
        accrodionGrp.each(function() {
            var accrodionName = $(this).data("grp-name");
            var Self = $(this);
            var accordion = Self.find(".accrodion");
            Self.addClass(accrodionName);
            Self.find(".accrodion .accrodion-content").hide();
            Self.find(".accrodion.active").find(".accrodion-content").show();
            accordion.each(function() {
                $(this)
                    .find(".accrodion-title")
                    .on("click", function() {
                        if ($(this).parent().hasClass("active") === false) {
                            $(".accrodion-grp." + accrodionName)
                                .find(".accrodion")
                                .removeClass("active");
                            $(".accrodion-grp." + accrodionName)
                                .find(".accrodion")
                                .find(".accrodion-content")
                                .slideUp();
                            $(this).parent().addClass("active");
                            $(this).parent().find(".accrodion-content").slideDown();
                        }
                    });
            });
        });
    }

    if ($(".scroll-to-target").length) {
        $(".scroll-to-target").on("click", function() {
            var target = $(this).attr("data-target");
            // animate
            $("html, body").animate({
                    scrollTop: $(target).offset().top
                },
                1000
            );

            return false;
        });
    }

    if ($(".video-popup").length) {
        $(".video-popup").magnificPopup({
            type: "iframe",
            mainClass: "mfp-fade",
            removalDelay: 160,
            preloader: true,

            fixedContentPos: false
        });
    }

    if ($(".img-popup").length) {
        var groups = {};
        $(".img-popup").each(function() {
            var id = parseInt($(this).attr("data-group"), 10);

            if (!groups[id]) {
                groups[id] = [];
            }

            groups[id].push(this);
        });

        $.each(groups, function() {
            $(this).magnificPopup({
                type: "image",
                closeOnContentClick: true,
                closeBtnInside: false,
                gallery: {
                    enabled: true
                }
            });
        });
    }

    function dynamicCurrentMenuClass(selector) {
        let FileName = window.location.href.split("/").reverse()[0];

        selector.find("li").each(function() {
            let anchor = $(this).find("a");
            if ($(anchor).attr("href") == FileName) {
                $(this).addClass("current");
            }
        });
        // if any li has .current elmnt add class
        selector.children("li").each(function() {
            if ($(this).find(".current").length) {
                $(this).addClass("current");
            }
        });
        // if no file name return
        if ("" == FileName) {
            selector.find("li").eq(0).addClass("current");
        }
    }

    if ($(".main-menu__list").length) {
        // dynamic current class
        let mainNavUL = $(".main-menu__list");
        dynamicCurrentMenuClass(mainNavUL);
    }
    if ($(".service-details__sidebar-service-list").length) {
        // dynamic current class
        let mainNavUL = $(".service-details__sidebar-service-list");
        dynamicCurrentMenuClass(mainNavUL);
    }

    if ($(".main-menu__list").length && $(".mobile-nav__container").length) {
        let navContent = document.querySelector(".main-menu__list").outerHTML;
        let mobileNavContainer = document.querySelector(".mobile-nav__container");
        mobileNavContainer.innerHTML = navContent;
    }
    if ($(".sticky-header__content").length) {
        let navContent = document.querySelector(".main-menu").innerHTML;
        let mobileNavContainer = document.querySelector(".sticky-header__content");
        mobileNavContainer.innerHTML = navContent;
    }

    if ($(".mobile-nav__container .main-menu__list").length) {
        let dropdownAnchor = $(
            ".mobile-nav__container .main-menu__list .dropdown > a"
        );
        dropdownAnchor.each(function() {
            let self = $(this);
            let toggleBtn = document.createElement("BUTTON");
            toggleBtn.setAttribute("aria-label", "dropdown toggler");
            toggleBtn.innerHTML = "<i class='fa fa-angle-down'></i>";
            self.append(function() {
                return toggleBtn;
            });
            self.find("button").on("click", function(e) {
                e.preventDefault();
                let self = $(this);
                self.toggleClass("expanded");
                self.parent().toggleClass("expanded");
                self.parent().parent().children("ul").slideToggle();
            });
        });
    }

    if ($(".mobile-nav__toggler").length) {
        $(".mobile-nav__toggler").on("click", function(e) {
            e.preventDefault();
            $(".mobile-nav__wrapper").toggleClass("expanded");
            $("body").toggleClass("locked");
        });
    }

    if ($(".search-toggler").length) {
        $(".search-toggler").on("click", function(e) {
            e.preventDefault();
            $(".search-popup").toggleClass("active");
            $(".mobile-nav__wrapper").removeClass("expanded");
            $("body").toggleClass("locked");
        });
    }

    $(".add").on("click", function() {
        if ($(this).prev().val() < 999) {
            $(this)
                .prev()
                .val(+$(this).prev().val() + 1);
        }
    });
    $(".sub").on("click", function() {
        if ($(this).next().val() > 1) {
            if ($(this).next().val() > 1)
                $(this)
                .next()
                .val(+$(this).next().val() - 1);
        }
    });

    function thmTinyInit() {
        // tiny slider
        const tinyElm = document.querySelectorAll(".thm-tiny__slider");
        tinyElm.forEach(function(tinyElm) {
            const tinyOptions = JSON.parse(tinyElm.dataset.tinyOptions);
            let thmTinySlider = tns(tinyOptions);
        });
    }

    //Client Testimonial Carousel
    if (
        $(".testimonial-two__carousel").length &&
        $(".testimonial-two__thumb-carousel").length
    ) {
        var bigimage = $(".testimonial-two__carousel");
        var thumbs = $(".testimonial-two__thumb-carousel");
        //var totalslides = 10;
        var syncedSecondary = true;

        bigimage
            .owlCarousel({
                items: 1,
                slideSpeed: 2000,
                nav: true,
                autoplay: true,
                dots: false,
                loop: true,
                navText: [
                    '<i class="icon-left-arrow1" aria-hidden="true"></i>',
                    '<i class="icon-right-arrow" aria-hidden="true"></i>'
                ]
            })
            .on("changed.owl.carousel", syncPosition);

        thumbs
            .on("initialized.owl.carousel", function() {
                thumbs.find(".owl-item").eq(0).addClass("current");
            })
            .owlCarousel({
                items: 3,
                margin: 10,
                dots: true,
                nav: true,
                navText: [
                    '<i class="icon-left-arrow" aria-hidden="true"></i>',
                    '<i class="icon-right-arrow" aria-hidden="true"></i>'
                ],
                smartSpeed: 700,
                slideBy: 3
            })
            .on("changed.owl.carousel", syncPosition2);

        function syncPosition(el) {
            //if loop is set to false, then you have to uncomment the next line
            //var current = el.item.index;

            //to disable loop, comment this block
            var count = el.item.count - 1;
            var current = Math.round(el.item.index - el.item.count / 2 - 0.5);

            if (current < 0) {
                current = count;
            }
            if (current > count) {
                current = 0;
            }
            //to this
            thumbs
                .find(".owl-item")
                .removeClass("current")
                .eq(current)
                .addClass("current");
            var onscreen = thumbs.find(".owl-item.active").length - 1;
            var start = thumbs.find(".owl-item.active").first().index();
            var end = thumbs.find(".owl-item.active").last().index();

            if (current > end) {
                thumbs.data("owl.carousel").to(current, 500, true);
            }
            if (current < start) {
                thumbs.data("owl.carousel").to(current - onscreen, 500, true);
            }
        }

        function syncPosition2(el) {
            if (syncedSecondary) {
                var number = el.item.index;
                bigimage.data("owl.carousel").to(number, 500, true);
            }
        }

        thumbs.on("click", ".owl-item", function(e) {
            e.preventDefault();
            var number = $(this).index();
            bigimage.data("owl.carousel").to(number, 500, true);
        });
    }

    // ===Portfolio===
    function projectMasonaryLayout() {
        if ($(".masonary-layout").length) {
            $(".masonary-layout").isotope({
                layoutMode: "masonry"
            });
        }
        if ($(".post-filter").length) {
            $(".post-filter li")
                .children(".filter-text")
                .on("click", function() {
                    var Self = $(this);
                    var selector = Self.parent().attr("data-filter");
                    $(".post-filter li").removeClass("active");
                    Self.parent().addClass("active");
                    $(".filter-layout").isotope({
                        filter: selector,
                        animationOptions: {
                            duration: 500,
                            easing: "linear",
                            queue: false
                        }
                    });
                    return false;
                });
        }

        if ($(".post-filter.has-dynamic-filters-counter").length) {
            // var allItem = $('.single-filter-item').length;
            var activeFilterItem = $(".post-filter.has-dynamic-filters-counter").find(
                "li"
            );
            activeFilterItem.each(function() {
                var filterElement = $(this).data("filter");
                var count = $(".filter-layout").find(filterElement).length;
                $(this)
                    .children(".filter-text")
                    .append('<span class="count">(' + count + ")</span>");
            });
        }
    }


    // ===Checkout Payment===
    if ($(".checkout__payment__title").length) {

        $(".checkout__payment__item").find('.checkout__payment__content').hide();
        $(".checkout__payment__item--active").find('.checkout__payment__content').show();

        $(".checkout__payment__title").on("click", function(e) {
            e.preventDefault();


            $(this).parents('.checkout__payment').find('.checkout__payment__item').removeClass("checkout__payment__item--active");
            $(this).parents(".checkout__payment").find(".checkout__payment__content").slideUp();

            $(this).parent().addClass("checkout__payment__item--active");
            $(this).parent().find(".checkout__payment__content").slideDown();

        })
    }

    //Single Vertical Carousel
    if ($('.single-vertical-carousel').length) {
        $('.single-vertical-carousel').slick({
            dots: true,
            autoplay: false,
            loop: true,
            autoplaySpeed: 5000,
            infinite: true,
            responsive: true,
            slidesToShow: 2,
            vertical: true,
            slidesToScroll: 1,
            prevArrow: "<div class='prev-btn'><span class='fa fa-angle-up'></span></div>",
            nextArrow: "<div class='next-btn'><span class='fa fa-angle-down'></span></div>"
        });
    }




    if ($(".circle-progress").length) {
        $(".circle-progress").appear(function() {
            let circleProgress = $(".circle-progress");
            circleProgress.each(function() {
                let progress = $(this);
                let progressOptions = progress.data("options");
                progress.circleProgress(progressOptions);
            });
        });
    }

    function SmoothMenuScroll() {
        var anchor = $(".scrollToLink");
        if (anchor.length) {
            anchor.children("a").bind("click", function(event) {
                if ($(window).scrollTop() > 10) {
                    var headerH = "90";
                } else {
                    var headerH = "90";
                }
                var target = $(this);
                $("html, body")
                    .stop()
                    .animate({
                            scrollTop: $(target.attr("href")).offset().top - headerH + "px"
                        },
                        1200,
                        "easeInOutExpo"
                    );
                anchor.removeClass("current");
                anchor.removeClass("current-menu-ancestor");
                anchor.removeClass("current_page_item");
                anchor.removeClass("current-menu-parent");
                target.parent().addClass("current");
                event.preventDefault();
            });
        }
    }
    SmoothMenuScroll();

    function OnePageMenuScroll() {
        var windscroll = $(window).scrollTop();
        if (windscroll >= 117) {
            var menuAnchor = $(".one-page-scroll-menu .scrollToLink").children("a");
            menuAnchor.each(function() {
                var sections = $(this).attr("href");
                $(sections).each(function() {
                    if ($(this).offset().top <= windscroll + 100) {
                        var Sectionid = $(sections).attr("id");
                        $(".one-page-scroll-menu").find("li").removeClass("current");
                        $(".one-page-scroll-menu").find("li").removeClass("current-menu-ancestor");
                        $(".one-page-scroll-menu").find("li").removeClass("current_page_item");
                        $(".one-page-scroll-menu").find("li").removeClass("current-menu-parent");
                        $(".one-page-scroll-menu")
                            .find("a[href*=\\#" + Sectionid + "]")
                            .parent()
                            .addClass("current");
                    }
                });
            });
        } else {
            $(".one-page-scroll-menu li.current").removeClass("current");
            $(".one-page-scroll-menu li:first").addClass("current");
        }
    }


    // window load event

    $(window).on("load", function() {
        if ($(".preloader").length) {
            $(".preloader").fadeOut();
        }
        thmOwlInit();
        projectMasonaryLayout();
        languageSwitcher()


        if ($('.curved-circle').length) {
            $('.curved-circle').circleType({
                position: 'absolute',
                dir: 1,
                radius: 105,
                forceHeight: true,
                forceWidth: true
            });
        }

        if ($('.curved-circle-2').length) {
            $('.curved-circle-2').circleType({
                position: 'absolute',
                dir: 1,
                radius: 105,
                forceHeight: true,
                forceWidth: true
            });
        }

        if ($('.curved-circle-3').length) {
            $('.curved-circle-3').circleType({
                position: 'absolute',
                dir: 1,
                radius: 85,
                forceHeight: true,
                forceWidth: true
            });
        }


        //Jquery Spinner / Quantity Spinner
        if ($('.quantity-spinner').length) {
            $("input.quantity-spinner").TouchSpin({
                verticalbuttons: true
            });
        }



        if ($(".post-filter").length) {
            var postFilterList = $(".post-filter li");
            // for first init
            $(".filter-layout").isotope({
                filter: ".filter-item",
                animationOptions: {
                    duration: 500,
                    easing: "linear",
                    queue: false
                }
            });
            // on click filter links
            postFilterList.on("click", function() {
                var Self = $(this);
                var selector = Self.attr("data-filter");
                postFilterList.removeClass("active");
                Self.addClass("active");

                $(".filter-layout").isotope({
                    filter: selector,
                    animationOptions: {
                        duration: 500,
                        easing: "linear",
                        queue: false
                    }
                });
                return false;
            });
        }

        if ($(".post-filter.has-dynamic-filter-counter").length) {
            // var allItem = $('.single-filter-item').length;

            var activeFilterItem = $(".post-filter.has-dynamic-filter-counter").find(
                "li"
            );

            activeFilterItem.each(function() {
                var filterElement = $(this).data("filter");
                var count = $(".filter-layout").find(filterElement).length;
                $(this).append("<sup>[" + count + "]</sup>");
            });
        }

        //Testimonials Two
        if ($(".listing-details__gallery .bxslider").length) {
            $(".listing-details__gallery .bxslider").bxSlider({
                nextSelector: ".listing-details__gallery #slider-next",
                prevSelector: ".listing-details__gallery #slider-prev",
                nextText: '<i class="icon-right-arrow1"></i>',
                prevText: '<i class="icon-right-arrow1 icon-prev"></i>',
                mode: "horizontal",
                auto: "true",
                speed: "1000",
                pagerCustom: ".listing-details__gallery .slider-pager .listing-details__thumb-box"
            });
        }



        if ($("#testimonials-one__thumb").length) {
            let testimonialsThumb = new Swiper("#testimonials-one__thumb", {
                slidesPerView: 4,
                spaceBetween: 0,
                speed: 1400,
                watchSlidesVisibility: true,
                watchSlidesProgress: true,
                loop: true,
                autoplay: {
                    delay: 5000
                }
            });

            let testimonialsCarousel = new Swiper("#testimonials-one__carousel", {
                observer: true,
                observeParents: true,
                speed: 1400,
                mousewheel: true,
                slidesPerView: 1,
                autoplay: {
                    delay: 5000
                },
                thumbs: {
                    swiper: testimonialsThumb
                },
                pagination: {
                    el: '#testimonials-one__carousel-pagination',
                    type: 'bullets',
                    clickable: true
                },
            });
        }











    });

    // window scroll event

    $(window).on("scroll", function() {
        if ($(".stricked-menu").length) {
            var headerScrollPos = 130;
            var stricky = $(".stricked-menu");
            if ($(window).scrollTop() > headerScrollPos) {
                stricky.addClass("stricky-fixed");
            } else if ($(this).scrollTop() <= headerScrollPos) {
                stricky.removeClass("stricky-fixed");
            }
        }
        if ($(".scroll-to-top").length) {
            var strickyScrollPos = 100;
            if ($(window).scrollTop() > strickyScrollPos) {
                $(".scroll-to-top").fadeIn(500);
            } else if ($(this).scrollTop() <= strickyScrollPos) {
                $(".scroll-to-top").fadeOut(500);
            }
        }

        OnePageMenuScroll();

    });

    if ($(".before-after-twentytwenty").length) {
        $(".before-after-twentytwenty").each(function() {
            var Self = $(this);
            var objName = Self.attr("id");
            $("#" + objName).twentytwenty();

            // hack for bs tab
            $(document).on("shown.bs.tab", 'a[data-toggle="tab"]', function(e) {
                var paneTarget = $(e.target).attr("data-target");
                var $thePane = $(".tab-pane" + paneTarget);
                var twentyTwentyContainer = "#" + objName;
                var twentyTwentyHeight = $thePane.find(twentyTwentyContainer).height();
                if (0 === twentyTwentyHeight) {
                    $thePane.find(twentyTwentyContainer).trigger("resize");
                }
            });
        });
    }



})(jQuery);