<?php 

/**
 * Template part for displaying header layout one
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package bixola
*/

// header top
$bixola_header_top_switch = bixola_get_option( 'bixola_header_top_switch', false );
$bixola_header_top_phone = bixola_get_option( 'bixola_header_top_phone', __( '+1 (232) 102 345', 'bixola' ) );
$bixola_header_top_phone_number = bixola_get_option( 'bixola_header_top_phone_number', __( '+1232102345', 'bixola' ) );
$bixola_header_top_office_time = bixola_get_option( 'bixola_header_top_office_time', __( 'Monday - Friday / 8AM - 11PM', 'bixola' ) );
$bixola_header_top_mail_id = bixola_get_option( 'bixola_header_top_mail_id', __( 'demo@example.com', 'bixola' ) );
$bixola_header_top_address = bixola_get_option( 'bixola_header_top_address', __( '88 Broklyn Golden Street. New York', 'bixola' ) );

// header right
$bixola_header_right = bixola_get_option( 'bixola_header_right' );
$bixola_search_switch = bixola_get_option( 'bixola_search_switch' );
$bixola_header_phone = bixola_get_option( 'bixola_header_phone' );
$bixola_phone_label = bixola_get_option( 'bixola_phone_label', __( 'Need help?', 'bixola' ) );
$bixola_phone_text = bixola_get_option( 'bixola_phone_text', __( '+1 212 333 400', 'bixola' ) );
$bixola_phone_link = bixola_get_option( 'bixola_phone_link', __( '+1212333400', 'bixola' ) );
$bixola_button_text = bixola_get_option( 'bixola_button_text', __( 'Get Started', 'bixola' ) );
$bixola_button_link = bixola_get_option( 'bixola_button_link', __( '#', 'bixola' ) );

// header sticky
$bixola_sticky_hide = bixola_get_option( 'bixola_sticky_hide', false );

?>

<header class="main-header-three">
    <?php if ( !empty( $bixola_header_top_switch ) ): ?>
        <div class="main-header-three__top">
            <div class="container">
                <div class="main-header-three__top-inner">
                    <div class="main-header-three__top-left">
                        <ul class="list-unstyled main-header-three__contact-list">
                            <?php if ( !empty( $bixola_header_top_phone ) ): ?>
                                <li>
                                    <div class="icon">
                                        <i class="icon-phone"></i>
                                    </div>
                                    <div class="text">
                                        <p><a href="tel:<?php echo esc_html($bixola_header_top_phone_number); ?>"><?php echo esc_html($bixola_header_top_phone); ?></a></p>
                                    </div>
                                </li>
                            <?php endif; ?>
                            <?php if ( !empty( $bixola_header_top_mail_id ) ): ?>
                                <li>
                                    <div class="icon">
                                        <i class="icon-envelope"></i>
                                    </div>
                                    <div class="text">
                                        <p>
                                            <a href="mailto:<?php echo esc_html($bixola_header_top_mail_id); ?>">
                                                <?php echo esc_html($bixola_header_top_mail_id); ?>
                                            </a>
                                        </p>
                                    </div>
                                </li>
                            <?php endif; ?>
                            <?php if ( !empty( $bixola_header_top_address ) ): ?>
                                <li>
                                    <div class="icon">
                                        <i class="icon-location-1"></i>
                                    </div>
                                    <div class="text">
                                        <p><?php echo esc_html($bixola_header_top_address); ?></p>
                                    </div>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="main-header-three__top-text-and-social">
                        <?php if ( !empty( $bixola_header_top_office_time ) ): ?>
                            <div class="main-header-three__top-text">
                                <p><span class="icon-three-o-clock-clock"></span><?php echo esc_html($bixola_header_top_office_time); ?></p>
                            </div>
                        <?php endif; ?>
                        <div class="main-header-three__top-social">
                            <?php bixola_header_social_profiles() ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <nav class="main-menu main-menu-three">
        <div class="main-menu-three__wrapper">
            <div class="container">
                <div class="main-menu-three__wrapper-inner">
                    <div class="main-menu-three__logo">
                        <?php bixola_header_logo_black(); ?>
                    </div>
                    <div class="main-menu-three__main-menu-box">
                        <button class="mobile-nav__toggler"><i class="fa fa-bars"></i></button>
                        <?php bixola_header_menu();?>
                    </div>
                    <?php if ( !empty( $bixola_header_right ) ): ?>
                        <div class="main-menu-three__right">
                            <?php if ( !empty( $bixola_search_switch ) ): ?>
                                <div class="main-menu-three__search-box">
                                    <a href="<?php print esc_attr( get_search_query() ); ?>" class="main-menu-three__search search-toggler icon-magnifying-glass"></a>
                                </div>
                            <?php endif; ?>
                            <?php if ( !empty( $bixola_button_text ) ): ?>
                                <div class="main-menu-three__btn-box">
                                    <a href="<?php echo esc_url($bixola_button_link); ?>" class="thm-btn main-menu-three__btn thm-btn">
                                        <?php echo esc_html($bixola_button_text); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </nav>
</header>

<?php if ( !empty( $bixola_sticky_hide ) ): ?>
    <div class="stricky-header stricked-menu main-menu-three">
        <div class="sticky-header__content"></div><!-- /.sticky-header__content -->
    </div><!-- /.stricky-header -->
<?php endif;?>

<?php get_template_part( 'template-parts/header/header-side-info' ); ?>