<?php 

/**
 * Template part for displaying header layout one
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package bixola
*/

// header top
$bixola_header_top_switch = bixola_get_option( 'bixola_header_top_switch', false );
$bixola_header_top_office_time = bixola_get_option( 'bixola_header_top_office_time', __( 'Monday - Friday / 8AM - 11PM', 'bixola' ) );
$bixola_header_top_mail_id = bixola_get_option( 'bixola_header_top_mail_id', __( 'demo@example.com', 'bixola' ) );
$bixola_header_top_address = bixola_get_option( 'bixola_header_top_address', __( '88 Broklyn Golden Street. New York', 'bixola' ) );

// header right
$bixola_header_right = bixola_get_option( 'bixola_header_right' );
$bixola_search_switch = bixola_get_option( 'bixola_search_switch' );
$bixola_header_phone = bixola_get_option( 'bixola_header_phone' );
$bixola_phone_label = bixola_get_option( 'bixola_phone_label', __( 'Need help?', 'bixola' ) );
$bixola_phone_text = bixola_get_option( 'bixola_phone_text', __( '+1 212 333 400', 'bixola' ) );
$bixola_phone_link = bixola_get_option( 'bixola_phone_link', __( '+1212333400', 'bixola' ) );
$bixola_button_text = bixola_get_option( 'bixola_button_text', __( 'Get Started', 'bixola' ) );
$bixola_button_link = bixola_get_option( 'bixola_button_link', __( '#', 'bixola' ) );

// header sticky
$bixola_sticky_hide = bixola_get_option( 'bixola_sticky_hide', false );

?>

<header class="main-header-two">
    <?php if ( !empty( $bixola_header_top_switch ) ): ?>
        <div class="main-header-two__top">
            <div class="main-header-two__top-inner">
                <?php if ( !empty( $bixola_header_top_office_time ) ): ?>
                    <div class="main-header-two__text">
                        <p><?php echo esc_html($bixola_header_top_office_time); ?></p>
                    </div>
                <?php endif; ?>
                <div class="main-header-two__contact-and-social">
                    <ul class="list-unstyled main-header-two__contact-list">
                        <?php if ( !empty( $bixola_header_top_mail_id ) ): ?>
                            <li>
                                <div class="icon">
                                    <i class="icon-envelope"></i>
                                </div>
                                <div class="text">
                                    <p>
                                        <a href="mailto:<?php echo esc_attr($bixola_header_top_mail_id); ?>">
                                            <?php echo esc_html($bixola_header_top_mail_id); ?>
                                        </a>
                                    </p>
                                </div>
                            </li>
                        <?php endif; ?>
                        <?php if ( !empty( $bixola_header_top_address ) ): ?>
                            <li>
                                <div class="icon">
                                    <i class="icon-location-1"></i>
                                </div>
                                <div class="text">
                                    <p><?php echo esc_html($bixola_header_top_address); ?></p>
                                </div>
                            </li>
                        <?php endif; ?>
                    </ul>
                    <div class="main-header-two__top-social">
                        <?php bixola_header_social_profiles() ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <nav class="main-menu main-menu-two">
        <div class="main-menu-two__wrapper">
            <div class="main-menu-two__wrapper-inner">
                <div class="main-menu-two__left">
                    <div class="main-menu-two__logo">
                        <?php bixola_header_logo_black(); ?>
                    </div>
                    <div class="main-menu-two__main-menu-box">
                        <a href="#" class="mobile-nav__toggler"><i class="fa fa-bars"></i></a>
                        <?php bixola_header_menu();?>
                    </div>
                </div>
                <?php if ( !empty( $bixola_header_right ) ): ?>
                    <div class="main-menu-two__right">
                        <?php if ( !empty( $bixola_search_switch ) ): ?>
                            <div class="main-menu-two__search-cart-box">
                                <div class="main-menu-two__search-box">
                                    <a href="<?php print esc_attr( get_search_query() ); ?>" class="main-menu-two__search search-toggler icon-magnifying-glass"></a>
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="main-menu-two__button-and-call-box">
                            <?php if ( !empty( $bixola_button_text ) ): ?>
                                <div class="main-menu-two__btn-box">
                                    <a href="<?php echo esc_url($bixola_button_link); ?>" class="main-menu-two__btn">
                                        <?php echo esc_html($bixola_button_text); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                            <?php if ( !empty( $bixola_phone_text ) ): ?>
                                <div class="main-menu-two__call">
                                    <div class="main-menu-two__call-icon">
                                        <span class="icon-phone"></span>
                                    </div>
                                    <div class="main-menu-two__call-content">
                                        <p class="main-menu-two__call-sub-title"><?php echo esc_html($bixola_phone_label); ?></p>
                                        <h5 class="main-menu-two__call-number">
                                            <a href="tel:<?php echo esc_attr($bixola_phone_link); ?>">
                                                <?php echo esc_html($bixola_phone_text); ?>
                                            </a>
                                        </h5>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </nav>
</header>

<?php if ( !empty( $bixola_sticky_hide ) ): ?>
    <div class="stricky-header stricked-menu main-menu-two">
        <div class="sticky-header__content"></div><!-- /.sticky-header__content -->
    </div><!-- /.stricky-header -->
<?php endif;?>

<?php get_template_part( 'template-parts/header/header-side-info' ); ?>