<?php 

/**
 * Template part for displaying header layout four
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package bixola
*/

// header top
$bixola_header_top_switch = bixola_get_option( 'bixola_header_top_switch', false );
$bixola_header_top_office_time = bixola_get_option( 'bixola_header_top_office_time', __( 'Mon to Fri: 9:00am to 6:00pm', 'bixola' ) );
$bixola_header_top_mail_id = bixola_get_option( 'bixola_header_top_mail_id', __( 'demo@example.com', 'bixola' ) );
$bixola_header_top_address = bixola_get_option( 'bixola_header_top_address', __( '88 Broklyn Golden Street. New York', 'bixola' ) );

// header right
$bixola_header_right = bixola_get_option( 'bixola_header_right', false );
$bixola_search_switch = bixola_get_option( 'bixola_search_switch', false );
$bixola_header_phone = bixola_get_option( 'bixola_header_phone', false );
$bixola_phone_label = bixola_get_option( 'bixola_phone_label', __( 'Need help?', 'bixola' ) );
$bixola_phone_text = bixola_get_option( 'bixola_phone_text', __( '+1 212 333 400', 'bixola' ) );
$bixola_phone_link = bixola_get_option( 'bixola_phone_link', __( '+1212333400', 'bixola' ) );

// header sticky
$bixola_sticky_hide = bixola_get_option( 'bixola_sticky_hide', false );

?>

<header class="main-header-four">
    <?php if ( !empty( $bixola_header_top_switch ) ): ?>
        <div class="main-header-four__top">
            <div class="main-header-four__top-inner">
                <div class="main-header-four__top-left">
                    <ul class="list-unstyled main-header-four__contact-list">
                        <?php if ( !empty( $bixola_header_top_office_time ) ): ?>
                            <li>
                                <div class="icon">
                                    <i class="fas fa-clock"></i>
                                </div>
                                <div class="text">
                                    <p><?php echo esc_html($bixola_header_top_office_time); ?></p>
                                </div>
                            </li>
                        <?php endif; ?>
                        <?php if ( !empty( $bixola_header_top_mail_id ) ): ?>
                            <li>
                                <div class="icon">
                                    <i class="fas fa-envelope"></i>
                                </div>
                                <div class="text">
                                    <p>
                                        <a href="mailto:<?php echo esc_attr($bixola_header_top_mail_id); ?>">
                                            <?php echo esc_html($bixola_header_top_mail_id); ?>
                                        </a>
                                    </p>
                                </div>
                            </li>
                        <?php endif; ?>
                        <?php if ( !empty( $bixola_header_top_address ) ): ?>
                            <li>
                                <div class="icon">
                                    <i class="fas fa-map-marker"></i>
                                </div>
                                <div class="text">
                                    <p><?php echo esc_html($bixola_header_top_address); ?></p>
                                </div>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
                <div class="main-header-four__top-right">
                    <?php bixola_header_one_top_menu();?>
                    <div class="main-header-four__social">
                        <?php bixola_header_social_profiles() ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <nav class="main-menu main-menu-four">
        <div class="main-menu-four__wrapper">
            <div class="main-menu-four__wrapper-inner">
                <div class="main-menu-four__logo">
                    <?php bixola_header_logo_white(); ?>
                </div>
                <div class="main-menu-four__main-menu-box">
                    <a href="#" class="mobile-nav__toggler"><i class="fa fa-bars"></i></a>
                    <?php bixola_header_menu();?>
                </div>
                <?php if ( !empty( $bixola_header_right ) ): ?>
                    <div class="main-menu-four__right">
                        <?php if ( !empty( $bixola_phone_text ) ): ?>
                            <div class="main-menu-four__call">
                                <div class="main-menu-four__call-icon">
                                    <span class="icon-phone-call"></span>
                                </div>
                                <div class="main-menu-four__call-content">
                                    <p class="main-menu-four__call-sub-title"><?php echo esc_html($bixola_phone_label); ?></p>
                                    <h5 class="main-menu-four__call-number">
                                        <a href="tel:<?php echo esc_attr($bixola_phone_link); ?>">
                                            <?php echo esc_html($bixola_phone_text); ?> 
                                        </a>
                                    </h5>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if ( !empty( $bixola_search_switch ) ): ?>
                            <div class="main-menu-four__search-cart-box">
                                <div class="main-menu-four__search-box">
                                    <a href="<?php print esc_attr( get_search_query() ); ?>" class="main-menu-four__search search-toggler icon-magnifying-glass"></a>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </nav>
</header>

<?php if ( !empty( $bixola_sticky_hide ) ): ?>
    <div class="stricky-header stricked-menu main-menu-four">
        <div class="sticky-header__content"></div><!-- /.sticky-header__content -->
    </div><!-- /.stricky-header -->
<?php endif;?>

<?php get_template_part( 'template-parts/header/header-side-info' ); ?>