<?php 

/**
 * Template part for displaying footer layout one
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package bixola
*/

$bixola_page_info = get_post_meta( get_the_ID(), 'bixola_page_info', true);
$bixola_footer_bg_color_from_page = !empty ( $bixola_page_info['footer_bg_color'] ) ? $bixola_page_info['footer_bg_color'] : '';
$footer_shape_switch = bixola_get_option( 'footer_shape_switch', false );
$footer_bg_color = bixola_get_option( 'bixola_footer_bg_color', '#ffffff' );

// bg color
$bg_color = !empty( $bixola_footer_bg_color_from_page ) ? $bixola_footer_bg_color_from_page : $footer_bg_color;

// footer_columns
$footer_columns = 0;
$footer_widgets = bixola_get_option( 'footer_widget_number', 4 );

for ( $num = 1; $num <= $footer_widgets; $num++ ) {
    if ( is_active_sidebar( 'footer-4-' . $num ) ) {
        $footer_columns++;
    }
}

switch ( $footer_columns ) {
case '1':
    $footer_class[1] = 'col-lg-12';
    break;
case '2':
    $footer_class[1] = 'col-lg-6 col-md-6';
    $footer_class[2] = 'col-lg-6 col-md-6';
    break;
case '3':
    $footer_class[1] = 'col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-12';
    $footer_class[2] = 'col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-12';
    $footer_class[3] = 'col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-sm-12';
    break;
case '4':
    $footer_class[1] = 'col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-7';
    $footer_class[2] = 'col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-5';
    $footer_class[3] = 'col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-5';
    $footer_class[4] = 'col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-7';
    break;
default:
    $footer_class = 'col-xl-3 col-lg-3 col-md-6';
    break;
}

?>

<footer class="site-footer footer-4 footer-light" data-bg-color="<?php print esc_attr($bg_color); ?>">
    <?php if ( !empty ($footer_shape_switch) ): ?>
        <div class="site-footer__shape-1 img-bounce">
            <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/site-footer-shape-1.png" alt="<?php print esc_attr( 'shape', 'bixola-core' ); ?>">
        </div>
        <div class="site-footer__shape-2 float-bob-y">
            <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/site-footer-shape-2.png" alt="<?php print esc_attr( 'shape', 'bixola-core' ); ?>">
        </div>
    <?php endif; ?>
    <?php if ( is_active_sidebar('footer-4-1') OR is_active_sidebar('footer-4-2') OR is_active_sidebar('footer-4-3') OR is_active_sidebar('footer-4-4') ): ?>
        <div class="container">
            <div class="site-footer__top">
                <div class="row">
                    <?php if ( $footer_columns > 4 ) {
                        print '<div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-7" data-wow-delay="100ms">';
                        dynamic_sidebar( 'footer-4-1' );
                        print '</div>';

                        print '<div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-5" data-wow-delay="200ms">';
                        dynamic_sidebar( 'footer-4-2' );
                        print '</div>';

                        print '<div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-5" data-wow-delay="300ms">';
                        dynamic_sidebar( 'footer-4-3' );
                        print '</div>';

                        print '<div class="col-xxl-3 col-xl-3 col-lg-3 col-md-6 col-sm-7" data-wow-delay="400ms">';
                        dynamic_sidebar( 'footer-4-4' );
                        print '</div>';
                        } else {
                            for ( $num = 1; $num <= $footer_columns; $num++ ) {
                                if ( !is_active_sidebar( 'footer-4-' . $num ) ) {
                                    continue;
                                }
                                print '<div class="' . esc_attr( $footer_class[$num] ) . '">';
                                dynamic_sidebar( 'footer-4-' . $num );
                                print '</div>';
                            }
                        }
                    ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <div class="site-footer__bottom">
        <div class="container">
            <div class="site-footer__bottom-inner">
                <p class="site-footer__bottom-text">
                    <?php print bixola_copyright_text(); ?>
                </p>
            </div>
        </div>
    </div>
</footer>