<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package bixola
 */

$bixola_audio = get_post_meta( get_the_ID(), 'bixola_post_format_audio_video', true);
$bixola_audio_url = !empty( $bixola_audio['format_style'] ) ? $bixola_audio['format_style'] : '';
if ( is_single() ): 
?>

    <article id="post-<?php the_ID();?>" <?php post_class( 'postbox__item format-audio' );?>>
        <?php if ( !empty( $bixola_audio_url ) ): ?>
            <div class="postbox__thumb postbox__audio w-img p-relative mb-20">
                <?php echo wp_oembed_get( $bixola_audio_url ); ?>
            </div>
        <?php endif;?>
        <div class="blog__details-content">
            <div class="postbox__text">
                <?php the_content();?>
                <?php
                    wp_link_pages( [
                        'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'bixola' ),
                        'after'       => '</div>',
                        'link_before' => '<span class="page-number">',
                        'link_after'  => '</span>',
                    ] );
                ?>
            </div>
        </div>
        <div class="news-details__tag-and-social">
            <div class="row">
                <div class="col-xl-9 col-lg-8 col-md-7 col-sm-12">
                    <?php print bixola_get_tag();?>
                </div>
                <div class="col-xl-3 col-lg-4 col-md-5 col-sm-12 text-end">
                    <?php print bixola_blog_single_social(); ?>
                </div>
            </div>
        </div>
    </article>

<?php else: ?>

    <article id="post-<?php the_ID();?>" <?php post_class( 'postbox__item format-audio news-page-three__single wow fadeInUp' );?> data-wow-delay="100ms">
        <?php if ( !empty( $bixola_audio_url ) ): ?>
            <div class="postbox__thumb postbox__audio w-img p-relative">
                <?php echo wp_oembed_get( $bixola_audio_url ); ?>
            </div>
        <?php endif;?>
        <div class="news-page-three__content">
            <?php get_template_part( 'template-parts/blog/blog-meta' ); ?>
            <div class="news-page-three__title-box">
                <h3>
                    <a href="<?php the_permalink();?>">
                        <?php the_title();?>
                    </a>
                </h3>
            </div>
            <div class="news-page-three__text">
                <?php the_excerpt();?>
            </div>
            <div class="news-page-three__btn-and-post-share">
                <?php get_template_part( 'template-parts/blog/blog-btn' ); ?>
                <?php print bixola_blog_social(); ?>
            </div>
        </div>
    </article>

<?php
endif;?>