<?php 

/**
 * Template part for displaying post meta
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package bixola
 */

$categories = get_the_terms( $post->ID, 'category' );
$bixola_blog_author = bixola_get_option( 'bixola_blog_author', true );
$bixola_blog_date = bixola_get_option( 'bixola_blog_date', true );
$bixola_blog_cat = bixola_get_option( 'bixola_blog_cat', false );
$bixola_blog_comments = bixola_get_option( 'bixola_blog_comments', true );

?>

<div class="news-details__author-and-meta">
    <?php if ( !empty($bixola_blog_author) ): ?>
        <div class="news-details__author">
            <div class="news-details__author-img">
                <?php print get_avatar( get_the_author_meta( 'user_email' ), 36, '', '', [ 'class' => 'img-responsive' ] );?>
            </div>
            <p class="news-details__author-name"><?php print get_the_author(); ?></p>
        </div>
    <?php endif;?>
    <div class="news-details__meta">
        <?php if ( !empty($bixola_blog_date) ): ?>
            <p><span class="fas fa-calendar"></span><?php the_time( get_option('date_format') ); ?></p>
        <?php endif;?>
        <?php if ( !empty($bixola_blog_comments) ): ?>
            <p><span class="icon-chat"></span><?php comments_number(); ?></p>
        <?php endif;?>
        <?php if ( !empty($bixola_blog_cat) ): ?>
            <?php if ( !empty( $categories[0]->name ) ): ?>
                <p><span class="fas fa-tag"></span><?php echo esc_html($categories[0]->name); ?></p>
            <?php endif;?>
        <?php endif;?>
    </div>
</div>