<?php
/**
* The main template file
*
* This is the most generic template file in a WordPress theme
* and one of the two required files for a theme (the other being style.css).
* It is used to display a page when nothing more specific matches a query.
* E.g., it puts together the home page when no home.php file exists.
*
* @link https://developer.wordpress.org/themes/basics/template-hierarchy/
* @package bixola
*/

get_header();

$class_main = 'col-lg-12';
if(is_active_sidebar('blog-sidebar')){ 
	$class_main = 'col-xl-8 col-lg-7';
}

?>
 
<section class="tp-blog-area news-page-three news-list-three-right">
	<div class="container">
		<div class="row">
			<div class="<?php echo esc_attr($class_main) ?>">
				<div class="row">
					<div class="postbox__wrapper news-page-three__left">
						<div class="news-page-three__content-box">
							<?php
								if ( have_posts() ):
								if ( is_home() && !is_front_page() ):
							?>
							<header>
								<h1 class="page-title screen-reader-text"><?php single_post_title();?></h1>
							</header>
							<?php
								endif;?>
							<?php
								/* Start the Loop */
								while ( have_posts() ): the_post(); ?>
								<?php
									/*
									* Include the Post-Type-specific template for the content.
									* If you want to override this in a child theme, then include a file
									* called content-___.php (where ___ is the Post Type name) and that will be used instead.
									*/
									get_template_part( 'template-parts/content', get_post_format() );?>
								<?php
									endwhile;
								?>
									<div class="blog__pagination text-center">
										<?php bixola_pagination( '<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>', '', ['class' => ''] );?>
									</div>
								<?php
								else:
									get_template_part( 'template-parts/content', 'none' );
								endif;
							?>
						</div>
					</div>
				</div>
		 	</div>
			
			<?php if ( is_active_sidebar( 'blog-sidebar' ) ): ?>
				<div class="col-xl-4 col-lg-5">
					<div class="sidebar">
						<?php get_sidebar();?>
					</div>
				</div>
			<?php endif;?>
		</div>
	</div>
</section>
 
<?php
get_footer();