<?php 

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function bixola_widgets_init() {

    $footer_style_2_switch = bixola_get_option( 'footer_style_2_switch', true );
    $footer_style_3_switch = bixola_get_option( 'footer_style_3_switch', true );
    $footer_style_4_switch = bixola_get_option( 'footer_style_4_switch', true );

    /**
     * blog sidebar
     */
    register_sidebar( [
        'name'          => esc_html__( 'Blog Sidebar', 'bixola' ),
        'id'            => 'blog-sidebar',
        'description'   => esc_html__( 'Set Your Blog Widget', 'bixola' ),
        'before_widget' => '<div id="%1$s" class="sidebar__single %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<div class="sidebar__title-box"><h3 class="sidebar__title">',
        'after_title'   => '</h3></div>',
    ] );
    
    /**
     * blog sidebar
     */
    register_sidebar( [
        'name'          => esc_html__( 'Services Sidebar', 'bixola' ),
        'id'            => 'service-sidebar',
        'description'   => esc_html__( 'Set Your Sidebar Widget', 'bixola' ),
        'before_widget' => '<div id="%1$s" class="sidebar__widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="sidebar__widget-title">',
        'after_title'   => '</h2>',
    ] );
    
    $footer_widgets = bixola_get_option( 'footer_widget_number', 4 );

    // footer default
    for ( $num = 1; $num <= $footer_widgets; $num++ ) {
        register_sidebar( [
            'name'          => sprintf( esc_html__( 'Footer %1$s', 'bixola' ), $num ),
            'id'            => 'footer-' . $num,
            'description'   => sprintf( esc_html__( 'Footer column %1$s', 'bixola' ), $num ),
            'before_widget' => '<div id="%1$s" class="footer__widget footer-widget__column footer-col-'.$num.' %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<div class="footer-widget__title-box"><h3 class="footer-widget__title">',
            'after_title'   => '</h3></div>',
        ] );
    }

    // footer 2
    if ( $footer_style_2_switch ) {
        for ( $num = 1; $num <= $footer_widgets; $num++ ) {

            register_sidebar( [
                'name'          => sprintf( esc_html__( 'Footer Style 2 : %1$s', 'bixola' ), $num ),
                'id'            => 'footer-2-' . $num,
                'description'   => sprintf( esc_html__( 'Footer Style 2 : %1$s', 'bixola' ), $num ),
                'before_widget' => '<div id="%1$s" class="footer__widget footer-widget mb-30 footer__widget-2 footer-col-2-'.$num.' %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<div class="footer-widget-two__title-box"><h3 class="footer-widget-two__title">',
                'after_title'   => '</h3></div>',
            ] );
        }
    }

    // footer 3
    if ( $footer_style_3_switch ) {
        for ( $num = 1; $num <= $footer_widgets; $num++ ) {

            register_sidebar( [
                'name'          => sprintf( esc_html__( 'Footer Style 3 : %1$s', 'bixola' ), $num ),
                'id'            => 'footer-3-' . $num,
                'description'   => sprintf( esc_html__( 'Footer Style 3 : %1$s', 'bixola' ), $num ),
                'before_widget' => '<div id="%1$s" class="footer__widget footer-widget mb-30 footer__widget-3 footer-col-3-'.$num.' %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<div class="footer-widget-three__title-box"><h3 class="footer-widget-three__title">',
                'after_title'   => '</h3></div>',
            ] );
        }
    }

    // footer 4
    if ( $footer_style_4_switch ) {
        for ( $num = 1; $num <= $footer_widgets; $num++ ) {

            register_sidebar( [
                'name'          => sprintf( esc_html__( 'Footer Style 4 : %1$s', 'bixola' ), $num ),
                'id'            => 'footer-4-' . $num,
                'description'   => sprintf( esc_html__( 'Footer Style 4 : %1$s', 'bixola' ), $num ),
                'before_widget' => '<div id="%1$s" class="footer__widget footer-widget mb-30 footer__widget-3 footer-col-4-'.$num.' %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<div class="footer-widget__title-box"><h3 class="footer-widget__title">',
                'after_title'   => '</h3></div>',
            ] );
        }
    }
}
add_action( 'widgets_init', 'bixola_widgets_init' );