<?php
/**
 * Breadcrumbs for bixola theme.
 *
 * @package     bixola
 * @autor       TwinkleTheme
 * @copyright   Copyright (c) 2022, TwinkleTheme
 * @link        https://weblearnbd.net
 * @since       bixola 1.0.0
 */

function bixola_breadcrumb_func() {
    global $post;
    $breadcrumb_class = '';
    $breadcrumb_show = 1;

    if ( is_front_page() && is_home() ) {
        $title = bixola_get_option('breadcrumb_blog_title', __('Blog','bixola'));
        $breadcrumb_class = 'home_front_page';
    } elseif ( is_front_page() ) {
        $title = bixola_get_option('breadcrumb_blog_title', __('Blog','bixola'));
        $breadcrumb_show = 0;
    } elseif ( is_home() ) {
        if ( get_option('page_for_posts') ) {
            $title = get_the_title(get_option('page_for_posts'));
        }
    } elseif ( is_single() && 'post' == get_post_type() ) {
        $title = get_the_title();
    } elseif ( is_single() && 'product' == get_post_type() ) {
        $title = bixola_get_option('breadcrumb_product_details', __('Shop', 'bixola'));
    } elseif ( is_single() && 'courses' == get_post_type() ) {
        $title = esc_html__('Course Details', 'bixola');
    } elseif ( 'courses' == get_post_type() ) {
        $title = esc_html__('Courses', 'bixola');
    } elseif ( is_search() ) {
        $title = esc_html__('Search Results for: ', 'bixola') . get_search_query();
    } elseif ( is_404() ) {
        $title = esc_html__('Page Not Found', 'bixola');
    } elseif ( function_exists('is_woocommerce') && is_woocommerce() ) {
        $title = bixola_get_option('breadcrumb_shop', __('Shop', 'bixola'));
    } elseif ( is_archive() ) {
        $title = get_the_archive_title();
    } else {
        $title = get_the_title();
    }

    $_id = get_the_ID();
    if ( is_single() && 'product' == get_post_type() ) {
        $_id = $post->ID;
    } elseif ( function_exists("is_shop") && is_shop() ) {
        $_id = wc_get_page_id('shop');
    } elseif ( is_home() && get_option('page_for_posts') ) {
        $_id = get_option('page_for_posts');
    }

    $bixola_page_info = get_post_meta($_id, 'bixola_page_info', true);
    $is_breadcrumb = !empty($bixola_page_info['is_it_invisible_breadcrumb']) ? $bixola_page_info['is_it_invisible_breadcrumb'] : '';

    if ($is_breadcrumb == false && $breadcrumb_show == 1) {
        $bg_img_from_page = !empty($bixola_page_info['breadcrumb_background_image']) ? $bixola_page_info['breadcrumb_background_image'] : '';
        $breadcrumb_bg_color = bixola_get_option('bixola_breadcrumb_bg_color_two');
        
        $breadcrumb_switch = bixola_get_option('breadcrumb_switch');
        $breadcrumb_shape_switch = bixola_get_option('breadcrumb_shape_switch');
        $breadcrumb_info_switch = bixola_get_option('breadcrumb_info_switch');
        $breadcrumb_default = get_template_directory_uri() . '/assets/images/backgrounds/page-header-bg.jpg';
        $breadcrumb_shape_1 = get_template_directory_uri() . '/assets/images/shapes/page-header-shape-1.png';
        $breadcrumb_shape_2 = get_template_directory_uri() . '/assets/images/shapes/page-header-shape-2.png';
        $breadcrumb_shape_3 = get_template_directory_uri() . '/assets/images/shapes/page-header-shape-3.png';
        $breadcrumb_shape_4 = get_template_directory_uri() . '/assets/images/shapes/page-header-shape-4.png';
        $breadcrumb_bg_img = bixola_get_option('breadcrumb_bg_img', $breadcrumb_default);
        $bg_img = !empty($bg_img_from_page['url']) ? $bg_img_from_page['url'] : $breadcrumb_bg_img;

        if ($breadcrumb_switch): ?>
            <section class="page-header">
                <div class="page-header__bg" data-background="<?php echo esc_url($bg_img); ?>" data-bg-color="<?php echo esc_attr($breadcrumb_bg_color); ?>">
                </div>
                <?php if ($breadcrumb_shape_switch): ?>
                    <div class="page-header__shape-1 float-bob-y">
                        <img src="<?php echo esc_url($breadcrumb_shape_1); ?>" alt="<?php echo esc_attr('shape', 'bixola'); ?>">
                    </div>
                    <div class="page-header__shape-2 float-bob-x">
                        <img src="<?php echo esc_url($breadcrumb_shape_2); ?>" alt="<?php echo esc_attr('shape', 'bixola'); ?>">
                    </div>
                    <div class="page-header__shape-3 float-bob-y">
                        <img src="<?php echo esc_url($breadcrumb_shape_3); ?>" alt="<?php echo esc_attr('shape', 'bixola'); ?>">
                    </div>
                    <div class="page-header__shape-4 float-bob-x">
                        <img src="<?php echo esc_url($breadcrumb_shape_4); ?>" alt="<?php echo esc_attr('shape', 'bixola'); ?>">
                    </div>
                <?php endif; ?>
                <?php if ($breadcrumb_info_switch): ?>
                    <div class="container">
                        <div class="page-header__inner">
                            <h2><?php echo wp_kses_post($title); ?></h2>
                            <ul class="thm-breadcrumb list-unstyled">
                                <?php if (function_exists('bcn_display')) {
                                    bcn_display();
                                } ?>
                            </ul>
                        </div>
                    </div>
                <?php endif; ?>
            </section>
        <?php endif;
    }
}

add_action('bixola_before_main_content', 'bixola_breadcrumb_func');

// bixola_search_form
function bixola_search_form() {
    ?>
    <div class="search-wrapper p-relative transition-3 d-none">
        <div class="search-form transition-3">
            <form method="get" action="<?php echo esc_url(home_url('/')); ?>">
                <input type="search" name="s" value="<?php echo esc_attr(get_search_query()) ?>" placeholder="<?php echo esc_attr__('Enter Your Keyword', 'bixola'); ?>">
                <button type="submit" class="search-btn"><i class="far fa-search"></i></button>
            </form>
            <a href="javascript:void(0);" class="search-close"><i class="far fa-times"></i></a>
        </div>
    </div>
    <?php
}

add_action('bixola_before_main_content', 'bixola_search_form');
