(function($) {
    "use strict";

    function heroSection() {

        if ($(".main-slider__carousel").length) {
            $(".main-slider__carousel").owlCarousel({
                loop: true,
                items: 1,
                navText: ['<span class="icon-left-arrow"></span>', '<span class="icon-right-arrow"></span>'],
                margin: 0,
                dots: true,
                nav: false,
                active: true,
                smartSpeed: 1000,
                autoplay: true,
                autoplayTimeout: 7000,
                autoplayHoverPause: false,
            });
        }

        if ($(".main-slider-two__carousel").length) {
            $(".main-slider-two__carousel").owlCarousel({
                loop: true,
                items: 1,
                navText: ['<span class="icon-left-arrow"></span>', '<span class="icon-right-arrow"></span>'],
                margin: 0,
                dots: false,
                nav: false,
                active: true,
                smartSpeed: 1000,
                autoplay: true,
                autoplayTimeout: 7000,
                autoplayHoverPause: false,
            });
        }

        if ($(".main-slider-three__carousel").length) {
            $(".main-slider-three__carousel").owlCarousel({
                loop: true,
                items: 1,
                navText: ['<span class="icon-left-arrow"></span>', '<span class="icon-right-arrow"></span>'],
                margin: 0,
                dots: true,
                nav: false,
                active: true,
                smartSpeed: 1000,
                autoplay: true,
                autoplayTimeout: 7000,
                autoplayHoverPause: false,
            });
        }

        if ($(".main-slider-four__carousel").length) {
            $(".main-slider-four__carousel").owlCarousel({
                loop: true,
                items: 1,
                navText: ['<span class="icon-left-arrow"></span>', '<span class="icon-right-arrow"></span>'],
                margin: 0,
                dots: true,
                nav: false,
                active: true,
                smartSpeed: 1000,
                autoplay: true,
                autoplayTimeout: 7000,
                autoplayHoverPause: false,
            });
        }

        if ($(".main-slider-four__carousel").length) {
            $(".main-slider-four__carousel").owlCarousel({
                loop: true,
                items: 1,
                navText: ['<span class="icon-left-arrow"></span>', '<span class="icon-right-arrow"></span>'],
                margin: 0,
                dots: true,
                nav: false,
                active: true,
                smartSpeed: 1000,
                autoplay: true,
                autoplayTimeout: 7000,
                autoplayHoverPause: false,
            });
        }

        // Data Background
        $("[data-background").each(function() {
            $(this).css("background-image", "url( " + $(this).attr("data-background") + "  )");
        });
    }

    function brandSlider() {

        if ($(".brand-one__carousel").length) {
            $(".brand-one__carousel").owlCarousel({
                items: 3,
                margin: 30,
                smartSpeed: 700,
                loop: true,
                autoplay: true,
                autoplayTimeout: 6000,
                dots: false,
                nav: false,
                navText: ['<span class="fa fa-angle-left"></span>', '<span class="fa fa-angle-right"></span>'],
                responsive: {
                    0: {
                        items: 1
                    },
                    768: {
                        items: 3
                    },
                    992: {
                        items: 4
                    },
                    1200: {
                        items: 5
                    },
                }
            });
        }

        if ($(".brand-two__carousel").length) {
            $(".brand-two__carousel").owlCarousel({
                items: 3,
                margin: 30,
                smartSpeed: 700,
                loop: true,
                autoplay: true,
                autoplayTimeout: 6000,
                dots: false,
                nav: false,
                navText: ['<span class="fa fa-angle-left"></span>', '<span class="fa fa-angle-right"></span>'],
                responsive: {
                    0: {
                        items: 1
                    },
                    768: {
                        items: 3
                    },
                    992: {
                        items: 4
                    },
                    1200: {
                        items: 5
                    },
                }
            });
        }
    }

    function contactForm() {
        $("select").niceSelect();
    }

    function testimonialSlider() {

        if ($(".testimonial-one__carousel").length) {
            $(".testimonial-one__carousel").owlCarousel({
                loop: true,
                autoplay: true,
                margin: 48,
                nav: true,
                dots: false,
                smartSpeed: 500,
                autoplayTimeout: 10000,
                navText: ['<span class="icon-right-arrow-1"></span>', '<span class="icon-right-arrow-11"></span>'],
                responsive: {
                    0: {
                        items: 1
                    },
                    768: {
                        items: 1
                    },
                    992: {
                        items: 2
                    },
                    1200: {
                        items: 1.60999999999
                    }
                }
            });
        }

        if ($(".testimonial-two__carousel").length) {
            $(".testimonial-two__carousel").owlCarousel({
                loop: true,
                autoplay: true,
                margin: 30,
                nav: true,
                dots: false,
                smartSpeed: 500,
                autoplayTimeout: 10000,
                navText: ['<span class="icon-right-arrow-1"></span>', '<span class="icon-right-arrow11"></span>'],
                responsive: {
                    0: {
                        items: 1
                    },
                    768: {
                        items: 2
                    },
                    992: {
                        items: 3
                    },
                    1200: {
                        items: 3
                    }
                }
            });
        }

        if ($(".testimonial-three__carousel").length) {
            $(".testimonial-three__carousel").owlCarousel({
                loop: true,
                autoplay: true,
                margin: 70,
                nav: false,
                dots: true,
                smartSpeed: 500,
                autoplayTimeout: 10000,
                navText: ['<span class="icon-right-arrow-1"></span>', '<span class="icon-right-arrow11"></span>'],
                responsive: {
                    0: {
                        items: 1
                    },
                    768: {
                        items: 2
                    },
                    992: {
                        items: 2
                    },
                    1200: {
                        items: 3
                    }
                }
            });
        }

        if ($(".testimonials-carousel-style").length) {
            $(".testimonials-carousel-style").owlCarousel({
                items: 3,
                margin: 30,
                smartSpeed: 700,
                loop: true,
                autoplay: true,
                autoplayTimeout: 6000,
                dots: true,
                nav: false,
                navText: ['<span class="fa fa-angle-left"></span>', '<span class="fa fa-angle-right"></span>'],
                responsive: {
                    0: {
                        items: 1
                    },
                    768: {
                        items: 2
                    },
                    992: {
                        items: 3
                    }
                }
            });
        }

    }

    function teamSection() {

        if ($(".team-carousel").length) {
            $(".team-carousel").owlCarousel({
                items: 3,
                margin: 30,
                smartSpeed: 700,
                loop: true,
                autoplay: 6000,
                nav: false,
                dots: true,
                navText: ['<span class="fa fa-angle-left"></span>', '<span class="fa fa-angle-right"></span>'],
                responsive: {
                    0: {
                        items: 1
                    },
                    768: {
                        items: 2
                    },
                    992: {
                        items: 3
                    },
                }
            });
        }

        if ($(".team-two__carousel").length) {
            $(".team-two__carousel").owlCarousel({
                loop: true,
                autoplay: true,
                margin: 30,
                nav: true,
                dots: false,
                smartSpeed: 500,
                autoplayTimeout: 10000,
                navText: ['<span class="icon-right-arrow"></span>', '<span class="icon-right-arrow1"></span>'],

                items: 3,
                autoplay: true,
                responsive: {
                    0: {
                        items: 1
                    },
                    768: {
                        items: 2
                    },
                    992: {
                        items: 3
                    },
                    1200: {
                        items: 3
                    },
                }
            });
        }
    }

    function teamDetails() {

        // Popular Causes Progress Bar
        if ($(".count-bar").length) {
            $(".count-bar").appear(
                function() {
                    var el = $(this);
                    var percent = el.data("percent");
                    $(el).css("width", percent).addClass("counted");
                }, {
                    accY: -50
                }
            );
        }

        //Progress Bar / Levels
        if ($(".progress-levels .progress-box .bar-fill").length) {
            $(".progress-box .bar-fill").each(
                function() {
                    $(".progress-box .bar-fill").appear(function() {
                        var progressWidth = $(this).attr("data-percent");
                        $(this).css("width", progressWidth + "%");
                    });
                }, {
                    accY: 0
                }
            );
        }

        //Fact Counter + Text Count
        if ($(".count-box").length) {
            $(".count-box").appear(
                function() {
                    var $t = $(this),
                        n = $t.find(".count-text").attr("data-stop"),
                        r = parseInt($t.find(".count-text").attr("data-speed"), 10);

                    if (!$t.hasClass("counted")) {
                        $t.addClass("counted");
                        $({
                            countNum: $t.find(".count-text").text()
                        }).animate({
                            countNum: n
                        }, {
                            duration: r,
                            easing: "linear",
                            step: function() {
                                $t.find(".count-text").text(Math.floor(this.countNum));
                            },
                            complete: function() {
                                $t.find(".count-text").text(this.countNum);
                            }
                        });
                    }
                }, {
                    accY: 0
                }
            );
        }
    }

    function pricingSection() {

        if ($(".pricing-tabs").length) {
            $(".pricing-tabs .tab-btns .tab-btn").on("click", function(e) {
                e.preventDefault();
                var target = $($(this).attr("data-tab"));

                if ($(target).hasClass("actve-tab")) {
                    return false;
                } else {
                    $(".pricing-tabs .tab-btns .tab-btn").removeClass("active-btn");
                    $(this).addClass("active-btn");
                    $(".pricing-tabs .pr-content .pr-tab").removeClass("active-tab");
                    $(target).addClass("active-tab");
                }
            });
        }

        if ($(".tabs-box").length) {
            $(".tabs-box .tab-buttons .tab-btn").on("click", function(e) {
                e.preventDefault();
                var target = $($(this).attr("data-tab"));

                if ($(target).is(":visible")) {
                    return false;
                } else {
                    target
                        .parents(".tabs-box")
                        .find(".tab-buttons")
                        .find(".tab-btn")
                        .removeClass("active-btn");
                    $(this).addClass("active-btn");
                    target
                        .parents(".tabs-box")
                        .find(".tabs-content")
                        .find(".tab")
                        .fadeOut(0);
                    target
                        .parents(".tabs-box")
                        .find(".tabs-content")
                        .find(".tab")
                        .removeClass("active-tab");
                    $(target).fadeIn(300);
                    $(target).addClass("active-tab");
                }
            });
        }

        if ($(".pricing-carousel").length) {
            $(".pricing-carousel").owlCarousel({
                items: 3,
                margin: 30,
                smartSpeed: 700,
                loop: true,
                autoplay: 6000,
                nav: false,
                dots: true,
                autoplayTimeout: 10000,
                navText: ['<span class="fa fa-angle-left"></span>', '<span class="fa fa-angle-right"></span>'],
                responsive: {
                    0: {
                        items: 1
                    },
                    768: {
                        items: 2
                    },
                    992: {
                        items: 3
                    },
                }
            });
        }
    }

    function portfolioMasonry() {

        if ($(".masonary-layout").length) {
            $(".masonary-layout").isotope({
                layoutMode: "masonry"
            });
        }
        if ($(".post-filter").length) {
            $(".post-filter li")
                .children(".filter-text")
                .on("click", function() {
                    var Self = $(this);
                    var selector = Self.parent().attr("data-filter");
                    $(".post-filter li").removeClass("active");
                    Self.parent().addClass("active");
                    $(".filter-layout").isotope({
                        filter: selector,
                        animationOptions: {
                            duration: 500,
                            easing: "linear",
                            queue: false
                        }
                    });
                    return false;
                });
        }

        if ($(".post-filter.has-dynamic-filters-counter").length) {
            // var allItem = $('.single-filter-item').length;
            var activeFilterItem = $(".post-filter.has-dynamic-filters-counter").find(
                "li"
            );
            activeFilterItem.each(function() {
                var filterElement = $(this).data("filter");
                var count = $(".filter-layout").find(filterElement).length;
                $(this)
                    .children(".filter-text")
                    .append('<span class="count">(' + count + ")</span>");
            });
        }
    }

    function portfolioSlider() {

        if ($(".portfolio-carousel").length) {
            $(".portfolio-carousel").owlCarousel({
                items: 3,
                margin: 30,
                smartSpeed: 700,
                loop: true,
                autoplay: 6000,
                nav: false,
                dots: true,

                autoplayTimeout: 10000,
                navText: ['<span class="fa fa-angle-left"></span>', '<span class="fa fa-angle-right"></span>'],
                responsive: {
                    0: {
                        items: 1
                    },
                    768: {
                        items: 2
                    },
                    992: {
                        items: 3
                    },
                }
            });
        }
    }

    function funFact() {
        //Fact Counter + Text Count
        if ($(".count-box").length) {
            $(".count-box").appear(
                function() {
                    var $t = $(this),
                        n = $t.find(".count-text").attr("data-stop"),
                        r = parseInt($t.find(".count-text").attr("data-speed"), 10);

                    if (!$t.hasClass("counted")) {
                        $t.addClass("counted");
                        $({
                            countNum: $t.find(".count-text").text()
                        }).animate({
                            countNum: n
                        }, {
                            duration: r,
                            easing: "linear",
                            step: function() {
                                $t.find(".count-text").text(Math.floor(this.countNum));
                            },
                            complete: function() {
                                $t.find(".count-text").text(this.countNum);
                            }
                        });
                    }
                }, {
                    accY: 0
                }
            );
        }
    }

    function caseStudy() {
        if ($(".img-popup").length) {
            var groups = {};
            $(".img-popup").each(function() {
                var id = parseInt($(this).attr("data-group"), 10);

                if (!groups[id]) {
                    groups[id] = [];
                }

                groups[id].push(this);
            });

            $.each(groups, function() {
                $(this).magnificPopup({
                    type: "image",
                    closeOnContentClick: true,
                    closeBtnInside: false,
                    gallery: {
                        enabled: true
                    }
                });
            });
        }
    }

    function advancedTab() {
        if ($(".tabs-box").length) {
            $(".tabs-box .tab-buttons .tab-btn").on("click", function(e) {
                e.preventDefault();
                var target = $($(this).attr("data-tab"));

                if ($(target).is(":visible")) {
                    return false;
                } else {
                    target
                        .parents(".tabs-box")
                        .find(".tab-buttons")
                        .find(".tab-btn")
                        .removeClass("active-btn");
                    $(this).addClass("active-btn");
                    target
                        .parents(".tabs-box")
                        .find(".tabs-content")
                        .find(".tab")
                        .fadeOut(0);
                    target
                        .parents(".tabs-box")
                        .find(".tabs-content")
                        .find(".tab")
                        .removeClass("active-tab");
                    $(target).fadeIn(300);
                    $(target).addClass("active-tab");
                }
            });
        }
    }

    function faqSection() {

        if ($(".accrodion-grp").length) {
            var accrodionGrp = $(".accrodion-grp");
            accrodionGrp.each(function() {
                var accrodionName = $(this).data("grp-name");
                var Self = $(this);
                var accordion = Self.find(".accrodion");
                Self.addClass(accrodionName);
                Self.find(".accrodion .accrodion-content").hide();
                Self.find(".accrodion.active").find(".accrodion-content").show();
                accordion.each(function() {
                    $(this)
                        .find(".accrodion-title")
                        .on("click", function() {
                            if ($(this).parent().hasClass("active") === false) {
                                $(".accrodion-grp." + accrodionName)
                                    .find(".accrodion")
                                    .removeClass("active");
                                $(".accrodion-grp." + accrodionName)
                                    .find(".accrodion")
                                    .find(".accrodion-content")
                                    .slideUp();
                                $(this).parent().addClass("active");
                                $(this).parent().find(".accrodion-content").slideDown();
                            }
                        });
                });
            });
        }

        if ($(".thm-accordion").length) {
            let accordionWrapper = $(".thm-accordion");
            accordionWrapper.each(function() {
                let $this = $(this);
                let accordionID = $this.attr("id");
                let accordionTitle = $this.find(".thm-accordion__title");
                $this.addClass(accordionID);
                // default hide
                let mainAccordionContent = $this.find(".thm-accordion__content").hide();
                $this.find(".active-item .thm-accordion__content").show();
                // on title click
                accordionTitle.on("click", function(e) {
                    e.preventDefault();
                    let $this = $(this);
                    let accordionItem = $(this).parent();
                    if (false === accordionItem.hasClass("active-item")) {
                        $("#" + accordionID)
                            .find(".thm-accordion__item")
                            .removeClass("active-item");
                        accordionItem.addClass("active-item");
                        mainAccordionContent.slideUp();
                        accordionItem.find(".thm-accordion__content").slideDown();
                    }
                });
            });
        }
    }

    function aboutSection() {

        if ($(".count-box").length) {
            $(".count-box").appear(
                function() {
                    var $t = $(this),
                        n = $t.find(".count-text").attr("data-stop"),
                        r = parseInt($t.find(".count-text").attr("data-speed"), 10);

                    if (!$t.hasClass("counted")) {
                        $t.addClass("counted");
                        $({
                            countNum: $t.find(".count-text").text()
                        }).animate({
                            countNum: n
                        }, {
                            duration: r,
                            easing: "linear",
                            step: function() {
                                $t.find(".count-text").text(Math.floor(this.countNum));
                            },
                            complete: function() {
                                $t.find(".count-text").text(this.countNum);
                            }
                        });
                    }
                }, {
                    accY: 0
                }
            );
        }

        if ($(".video-popup").length) {
            $(".video-popup").magnificPopup({
                type: "iframe",
                mainClass: "mfp-fade",
                removalDelay: 160,
                preloader: true,

                fixedContentPos: false
            });
        }
    }



    $(window).on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/bixola_hero_slider.default', heroSection);
        elementorFrontend.hooks.addAction('frontend/element_ready/bixola_brand_slider.default', brandSlider);
        elementorFrontend.hooks.addAction('frontend/element_ready/bixola_contact_form.default', contactForm);
        elementorFrontend.hooks.addAction('frontend/element_ready/bixola_testimonial_slider.default', testimonialSlider);
        elementorFrontend.hooks.addAction('frontend/element_ready/bixola_team.default', teamSection);
        elementorFrontend.hooks.addAction('frontend/element_ready/bixola_team_details.default', teamDetails);
        elementorFrontend.hooks.addAction('frontend/element_ready/bixola_pricing.default', pricingSection);
        elementorFrontend.hooks.addAction('frontend/element_ready/bixola_portfolio_masonry.default', portfolioMasonry);
        elementorFrontend.hooks.addAction('frontend/element_ready/bixola_portfolio_slider.default', portfolioSlider);
        elementorFrontend.hooks.addAction('frontend/element_ready/bixola_counter.default', funFact);
        elementorFrontend.hooks.addAction('frontend/element_ready/bixola_counter.default', caseStudy);
        elementorFrontend.hooks.addAction('frontend/element_ready/bixola_advanced_tab.default', advancedTab);
        elementorFrontend.hooks.addAction('frontend/element_ready/bixola_about.default', aboutSection);
    });

})(jQuery);