<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package bixola
 */

get_header();

$bixola_error_title = bixola_get_option( 'bixola_error_title' );
$bixola_error_subtitle = bixola_get_option( 'bixola_error_subtitle' );
$bixola_error_description = bixola_get_option( 'bixola_error_description' );
$bixola_error_link_text = bixola_get_option( 'bixola_error_link_text' );
              
?>

<section class="error-page">
   <div class="container">
         <div class="row">
            <div class="col-xl-12">
               <div class="error-page__inner">
                     <?php if ( !empty( $bixola_error_title ) ): ?>
                        <div class="error-page__title-box">
                           <h2 class="error-page__title">
                              <?php print esc_html($bixola_error_title);?>
                           </h2>
                        </div>
                     <?php endif;?>
                     <?php if ( !empty( $bixola_error_subtitle ) ): ?>
                        <h3 class="error-page__tagline">
                           <?php print esc_html($bixola_error_subtitle);?>
                        </h3>
                     <?php endif;?>
                     <?php if ( !empty( $bixola_error_description ) ): ?>
                        <p class="error-page__text">
                           <?php print esc_html($bixola_error_description);?>
                        </p>
                     <?php endif;?>
                     <form class="error-page__form" method="get" action="<?php print esc_url( home_url( '/' ) );?>">
                        <div class="error-page__form-input">
                           <input type="search" name="s" value="<?php print esc_attr( get_search_query() )?>" placeholder="<?php print esc_attr__( 'Search Here', 'bixola' );?>">
                           <button type="submit"><i class="icon-magnifying-glass"></i></button>
                        </div>
                     </form>
                     <?php if ( !empty( $bixola_error_link_text ) ): ?>
                        <a href="<?php print esc_url(home_url('/'));?>" class="thm-btn error-page__btn">
                           <?php print esc_html($bixola_error_link_text);?>
                        </a>
                     <?php endif;?>
               </div>
            </div>
         </div>
   </div>
</section>

<?php
get_footer();