<?php if ( !defined( 'ABSPATH' ) ) {die;} // Cannot access directly.

CSF::createWidget( 'bixola_footer_subscribe_two', array(
    'title'       => 'Bixola Footer Subscribe Two',
    'classname'   => 'bixola_footer_subscribe_two',
    'description' => 'Show Footer Subscribe Two Widget By Bixola',
    'fields'      => array(

        array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => esc_html__( 'Title', 'bixola-core' ),
        ),

        array(
            'id'    => 'description',
            'type'  => 'textarea',
            'title' => esc_html__( 'Description', 'bixola-core' ),
        ),

        array(
            'id'    => 'shortcode',
            'type'  => 'text',
            'title' => esc_html__( 'Shortcode', 'bixola-core' ),
        ),

    ),
) );

if ( !function_exists( 'bixola_footer_subscribe_two' ) ) {
    function bixola_footer_subscribe_two( $args, $instance ) {

        echo $args['before_widget'];

        if ( ! empty( $instance['title'] ) ) {
            echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
        }

		?>

            <div class="footer-widget-three__subscribe">
                <?php if ( ! empty( $instance['description'] ) ) : ?>
                    <p class="footer-widget-three__subscribe-text">
                        <?php print twinkle_kses($instance['description']); ?>
                    </p>
                <?php endif; ?>
                <?php print do_shortcode($instance['shortcode']); ?>
                <div class="mc-form__response"></div>
            </div>

		<?php

        echo $args['after_widget'];

    }
}