<?php if ( !defined( 'ABSPATH' ) ) {die;} // Cannot access directly.

CSF::createWidget( 'bixola_footer_subscribe_one', array(
    'title'       => 'Bixola Footer Subscribe One',
    'classname'   => 'bixola_footer_subscribe_one',
    'description' => 'Show Footer Subscribe One Widget By Bixola',
    'fields'      => array(

        array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => esc_html__( 'Title', 'bixola-core' ),
        ),

        array(
            'id'    => 'description',
            'type'  => 'textarea',
            'title' => esc_html__( 'Description', 'bixola-core' ),
        ),

        array(
            'id'    => 'shortcode',
            'type'  => 'text',
            'title' => esc_html__( 'Shortcode', 'bixola-core' ),
        ),

    ),
) );

if ( !function_exists( 'bixola_footer_subscribe_one' ) ) {
    function bixola_footer_subscribe_one( $args, $instance ) {

        echo $args['before_widget'];

		?>

			<div class="footer-widget__column footer-widget__newsletter">
				<div class="footer-widget__title-box">
					<h3 class="footer-widget__title">
						<?php if ( ! empty( $instance['title'] ) ) {
							echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
						} ?>
					</h3>
				</div>
                <?php if ( ! empty( $instance['description'] ) ) : ?>
                    <p class="footer-widget__newsletter-text">
                        <?php print twinkle_kses($instance['description']); ?>
                    </p>
                <?php endif; ?>
				<?php print do_shortcode($instance['shortcode']); ?>
			</div>

		<?php

        echo $args['after_widget'];

    }
}