<?php if ( !defined( 'ABSPATH' ) ) {die;} // Cannot access directly.

CSF::createWidget( 'bixola_footer_info_one', array(
    'title'       => 'Bixola Footer Info One',
    'classname'   => 'bixola_footer_info_one',
    'description' => 'Show Footer Info One Widget By Bixola',
    'fields'      => array(

        array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => esc_html__( 'Title', 'bixola-core' ),
        ),

		array(
			'id'       => 'logo',
			'type'     => 'upload',
			'title'    => esc_html__( 'Logo', 'bixola' ),
			'subtitle' => esc_html__( 'Upload Your Logo.', 'bixola' ),
			'default'  => get_template_directory_uri() . '/assets/images/resources/footer-logo.png',
			'library'  => 'image',
			'preview'  => true,
		),

        array(
            'id'      => 'description',
            'type'    => 'textarea',
            'title'   => esc_html__( 'Description', 'bixola-core' ),
            'default' => __( 'Lorem Ipsum is simply dummy text of <br> printing and typesetting industry.', 'bixola-core' ),
        ),

        array(
            'id'    => 'facebook_url',
            'type'  => 'text',
            'title' => esc_html__( 'Facebook Url', 'bixola' ),
        ),

        array(
            'id'    => 'twitter_url',
            'type'  => 'text',
            'title' => esc_html__( 'Twitter Url', 'bixola' ),
        ),

        array(
            'id'    => 'instagram_url',
            'type'  => 'text',
            'title' => esc_html__( 'Instagram Url', 'bixola' ),
        ),

        array(
            'id'    => 'pinterest_url',
            'type'  => 'text',
            'title' => esc_html__( 'Pinterest Url', 'bixola' ),
        ),

        array(
            'id'    => 'linkedin_url',
            'type'  => 'text',
            'title' => esc_html__( 'Linkedin Url', 'bixola' ),
        ),

        array(
            'id'    => 'dribbble_url',
            'type'  => 'text',
            'title' => esc_html__( 'Dribbble Url', 'bixola' ),
        ),

        array(
            'id'    => 'whatsapp_url',
            'type'  => 'text',
            'title' => esc_html__( 'Whatsapp Url', 'bixola' ),
        ),

        array(
            'id'    => 'tiktok_url',
            'type'  => 'text',
            'title' => esc_html__( 'Tiktok Url', 'bixola' ),
        ),

        array(
            'id'    => 'soundcloud_url',
            'type'  => 'text',
            'title' => esc_html__( 'Soundcloud Url', 'bixola' ),
        ),

        array(
            'id'    => 'vimeo_url',
            'type'  => 'text',
            'title' => esc_html__( 'Vimeo Url', 'bixola' ),
        ),

        array(
            'id'    => 'youtube_url',
            'type'  => 'text',
            'title' => esc_html__( 'Youtube Url', 'bixola' ),
        ),

    ),
) );

if ( !function_exists( 'bixola_footer_info_one' ) ) {
    function bixola_footer_info_one( $args, $instance ) {

        echo $args['before_widget'];

        if ( ! empty( $instance['title'] ) ) {
          	echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
        }

		?>

			<div class="footer-widget__column footer-widget__about">
				<div class="footer-widget__logo">
					<a href="<?php print home_url();?>">
						<img src="<?php print esc_url( $instance['logo'] );?>" alt="">
					</a>
				</div>
				<?php if( !empty ( $instance['description'] ) ): ?>
					<p class="footer-widget__about-text">
						<?php print twinkle_kses($instance['description']); ?>
					</p>
				<?php endif; ?>
				<div class="site-footer__social">
					<?php if ( !empty( $instance['facebook_url'] ) ): ?>
						<a href="<?php print esc_url( $instance['facebook_url'] );?>"><i class="fa-brands fa-facebook-f"></i></a>
					<?php endif;?>
					<?php if ( !empty( $instance['twitter_url'] ) ): ?>
						<a href="<?php print esc_url( $instance['twitter_url'] );?>"><i class="fa-brands fa-x-twitter"></i></a>
					<?php endif;?>
					<?php if ( !empty( $instance['instagram_url'] ) ): ?>
						<a href="<?php print esc_url( $instance['instagram_url'] );?>"><i class="fa-brands fa-instagram"></i></a>
					<?php endif;?>
					<?php if ( !empty( $instance['pinterest_url'] ) ): ?>
						<a href="<?php print esc_url( $instance['pinterest_url'] );?>"><i class="fa-brands fa-pinterest-p"></i></a>
					<?php endif;?>
					<?php if ( !empty( $instance['linkedin_url'] ) ): ?>
						<a href="<?php print esc_url( $instance['linkedin_url'] );?>"><i class="fa-brands fa-linkedin-in"></i></a>
					<?php endif;?>
					<?php if ( !empty( $instance['dribbble_url'] ) ): ?>
						<a href="<?php print esc_url( $instance['dribbble_url'] );?>"><i class="fa-brands fa-dribbble"></i></a>
					<?php endif;?>
					<?php if ( !empty( $instance['whatsapp_url'] ) ): ?>
						<a href="<?php print esc_url( $instance['whatsapp_url'] );?>"><i class="fa-brands fa-whatsapp"></i></a>
					<?php endif;?>
					<?php if ( !empty( $instance['tiktok_url'] ) ): ?>
						<a href="<?php print esc_url( $instance['tiktok_url'] );?>"><i class="fa-brands fa-tiktok"></i></a>
					<?php endif;?>
					<?php if ( !empty( $instance['soundcloud_url'] ) ): ?>
						<a href="<?php print esc_url( $instance['soundcloud_url'] );?>"><i class="fa-brands fa-soundcloud"></i></a>
					<?php endif;?>
					<?php if ( !empty( $instance['vimeo_url'] ) ): ?>
						<a href="<?php print esc_url( $instance['vimeo_url'] );?>"><i class="fa-brands fa-vimeo-v"></i></a>
					<?php endif;?>
					<?php if ( !empty( $instance['youtube_url'] ) ): ?>
						<a href="<?php print esc_url( $instance['youtube_url'] );?>"><i class="fa-brands fa-youtube"></i></a>
					<?php endif;?>
				</div>
			</div>

		<?php

        echo $args['after_widget'];

    }
}