<?php if ( !defined( 'ABSPATH' ) ) {die;} // Cannot access directly.

CSF::createWidget( 'bixola_footer_blog_post_one', array(
    'title'       => 'Bixola Footer Blog Posts One',
    'classname'   => 'bixola_footer_blog_post_one',
    'description' => 'Show Footer Blog Posts One Widget By Bixola',
    'fields'      => array(

        array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => esc_html__( 'Title', 'bixola-core' ),
        ),

		array(
			'id'      => 'count',
			'type'    => 'number',
			'title'   => esc_html__( 'How many posts you want to show ?', 'bixola-core' ),
			'default' => 2,
		),

		array(
			'id'          => 'posts_order',
			'type'        => 'select',
			'title'       => esc_html__( 'Posts Order', 'bixola-core' ),
			'options'     => array(
				'ASC'  => esc_html__( 'ASC', 'bixola-core' ),
				'DESC'  => esc_html__( 'DESC', 'bixola-core' ),
			),
			'default'     => 'ASC'
		),

    ),
) );

if ( !function_exists( 'bixola_footer_blog_post_one' ) ) {
    function bixola_footer_blog_post_one( $args, $instance ) {

        echo $args['before_widget'];

        if ( ! empty( $instance['title'] ) ) {
          	echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
        }

        $q = new WP_Query( array(
            'post_type'      => 'post',
			'post__not_in' => get_option( 'sticky_posts' ),
            'posts_per_page' => ( $instance['count'] ) ? $instance['count'] : '3',
            'order'          => ( $instance['posts_order'] ) ? $instance['posts_order'] : 'DESC',
            'orderby'        => 'date',
        ) );

		?>

		<ul class="footer-widget-three__post-list list-unstyled">

        	<?php if ( $q->have_posts() ):
            	while ( $q->have_posts() ): $q->the_post();

                ?>

					<li>
						<?php if ( has_post_thumbnail() ): ?>
							<div class="footer-widget-three__post-img">
								<img src="<?php print esc_url( get_the_post_thumbnail_url( get_the_ID(), 'full' ) );?>" alt="">
							</div>
						<?php endif;?>
						<div class="footer-widget-three__post-content">
							<h3><a href="<?php the_permalink();?>"><?php print wp_trim_words( get_the_title() );?></a></h3>
							<p><span class="icon-time"></span><?php the_time( get_option('date_format') ); ?></p>
						</div>
					</li>

				<?php endwhile;
			endif;?>
				
		</ul>

		<?php

        echo $args['after_widget'];

    }
}