<?php
namespace BixolaCore\Widgets;

use \Elementor\Widget_Base;
use \Elementor\Control_Media;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Css_Filter;
use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Box_Shadow;
use BixolaCore\Elementor\Controls\Group_Control_BixolaBGGradient;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Bixola Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Bixola_Team_Details extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bixola_team_details';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Team Details', 'bixola-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'bixola-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bixola_core' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'bixola-core' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */

    protected static function get_profile_names()
    {
        return [
            '500px' => esc_html__('500px', 'bixola-core'),
            'apple' => esc_html__('Apple', 'bixola-core'),
            'behance' => esc_html__('Behance', 'bixola-core'),
            'bitbucket' => esc_html__('BitBucket', 'bixola-core'),
            'codepen' => esc_html__('CodePen', 'bixola-core'),
            'delicious' => esc_html__('Delicious', 'bixola-core'),
            'deviantart' => esc_html__('DeviantArt', 'bixola-core'),
            'digg' => esc_html__('Digg', 'bixola-core'),
            'dribbble' => esc_html__('Dribbble', 'bixola-core'),
            'email' => esc_html__('Email', 'bixola-core'),
            'facebook' => esc_html__('Facebook', 'bixola-core'),
            'flickr' => esc_html__('Flicker', 'bixola-core'),
            'foursquare' => esc_html__('FourSquare', 'bixola-core'),
            'github' => esc_html__('Github', 'bixola-core'),
            'houzz' => esc_html__('Houzz', 'bixola-core'),
            'instagram' => esc_html__('Instagram', 'bixola-core'),
            'jsfiddle' => esc_html__('JS Fiddle', 'bixola-core'),
            'linkedin' => esc_html__('LinkedIn', 'bixola-core'),
            'medium' => esc_html__('Medium', 'bixola-core'),
            'pinterest' => esc_html__('Pinterest', 'bixola-core'),
            'product-hunt' => esc_html__('Product Hunt', 'bixola-core'),
            'reddit' => esc_html__('Reddit', 'bixola-core'),
            'slideshare' => esc_html__('Slide Share', 'bixola-core'),
            'snapchat' => esc_html__('Snapchat', 'bixola-core'),
            'soundcloud' => esc_html__('SoundCloud', 'bixola-core'),
            'spotify' => esc_html__('Spotify', 'bixola-core'),
            'stack-overflow' => esc_html__('StackOverflow', 'bixola-core'),
            'tripadvisor' => esc_html__('TripAdvisor', 'bixola-core'),
            'tumblr' => esc_html__('Tumblr', 'bixola-core'),
            'twitch' => esc_html__('Twitch', 'bixola-core'),
            'twitter' => esc_html__('Twitter', 'bixola-core'),
            'vimeo' => esc_html__('Vimeo', 'bixola-core'),
            'vk' => esc_html__('VK', 'bixola-core'),
            'website' => esc_html__('Website', 'bixola-core'),
            'whatsapp' => esc_html__('WhatsApp', 'bixola-core'),
            'wordpress' => esc_html__('WordPress', 'bixola-core'),
            'xing' => esc_html__('Xing', 'bixola-core'),
            'yelp' => esc_html__('Yelp', 'bixola-core'),
            'youtube' => esc_html__('YouTube', 'bixola-core'),
        ];
    }


	protected function register_controls() {

        $this->start_controls_section(
            'bixola_section_title',
            [
                'label' => esc_html__('Title & Content', 'bixola-core'),
            ]
        );

        $this->add_control(
            'bixola_image',
            [
                'label' => esc_html__( 'Choose Image', 'bixola-core' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );     

        $this->add_control(
            'bixola_name',
            [
                'label' => esc_html__('Name', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('Susan Sarandom', 'bixola-core'),
                'label_block' => true,
            ]
        );  

        $this->add_control(
            'bixola_designation',
            [
                'label' => esc_html__('Designation', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Founder and CEO', 'bixola-core' ),
                'label_block' => true,
            ]
        );     

        $this->add_control(
            'bixola_about',
            [
                'label' => esc_html__('About', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.', 'bixola-core'),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_skills',
            [
                'label' => esc_html__( 'Skill',  'text-domain'  ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'skill_title',
            [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Professional Skills', 'bixola-core' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'skill_description',
            [
                'label' => esc_html__('Description', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.', 'bixola-core'),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'name',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__( 'Name', 'twinkle-core' ),
                'default' => esc_html__( 'Design', 'twinkle-core' ),
                'placeholder' => esc_html__( 'Type a skill name', 'twinkle-core' ),
            ]
        );

        $repeater->add_control(
			'level',
			[
				'label' => esc_html__( 'Price', 'textdomain' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 5,
				'max' => 100,
				'step' => 1,
				'default' => 70,
			]
		);

        $this->add_control(
            'skills',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{name}}',
                'default' => [
                    [
                        'name' => 'UI/IUX Design',
                        'level' => '90',
                    ],
                    [
                        'name' => 'Web Design',
                        'level' => '85',
                    ],
                    [
                        'name' => 'IT Consulting',
                        'level' => '80',
                    ],
                ]
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            '_content_contact_info',
            [
                'label' => esc_html__('Contact Info', 'bixola-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'contact_info_title',
            [
                'label' => esc_html__( 'Title', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Contact Info', 'bixola-core' ),
                'label_block' => true,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'bixola_info_type',
            [
                'label' => esc_html__('Info Type', 'bixola-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'phone' => esc_html__('Phone', 'bixola-core'),
                    'email' => esc_html__('Email', 'bixola-core'),
                    'url' => esc_html__('URL', 'bixola-core'),
                    'address' => esc_html__('address', 'bixola-core'),
                ],
                'default' => 'phone',
            ]
        );

        $repeater->add_control(
            'bixola_info_title', [
                'label' => esc_html__('Text', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'bixola_info_url',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => __( 'URL', 'bixola-core' ),
                'default' => __( '#', 'bixola-core' ),
                'placeholder' => __( 'Type url here', 'bixola-core' ),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'bixola_info_type' => [ 'url' ],
                ],
            ]
        );

        $repeater->add_control(
            'bixola_phone',
            [
                'label' => esc_html__('Phone URL', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('+0822155421', 'bixola-core'),
                'condition' => [
                    'bixola_info_type' => [ 'phone' ],
                ],
            ]
        );

        $repeater->add_control(
            'bixola_email',
            [
                'label' => esc_html__('Email URL', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'ahmmedsabbirbd@bixola.com',
                'condition' => [
                    'bixola_info_type' => [ 'email' ],
                ],
            ]
        );

        $this->add_control(
            'bixola_info_list',
            [
                'label' => esc_html__('Info List', 'bixola-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'bixola_info_title' => esc_html__('+9900 - 000 - 000 00', 'bixola-core'),
                        'bixola_phone' => '+990000000000',
                    ],
                    [
                        'bixola_info_title' => esc_html__('ahmmedsabbirbd@bixola.com', 'bixola-core'),
                        'bixola_email' => esc_html__('ahmmedsabbirbd@bixola.com', 'bixola-core'),
                    ],
                    [
                        'bixola_info_title' => esc_html__('Dhaka 102, utl 1216, road 45 house', 'bixola-core'),
                        'bixola_gallery_info_title' => esc_html__('bixola.com', 'bixola-core'),
                    ],
                ],
                'title_field' => '{{{ bixola_info_title }}}',
            ]
        );

        $this->add_control(
            'show_profiles',
            [
                'label' => esc_html__('Show Profiles', 'bixola-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'bixola-core'),
                'label_off' => esc_html__('Hide', 'bixola-core'),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
                'style_transfer' => true,
            ]
        );

        $this->add_control(
            'bixola_profile_label',
            [
                'label' => esc_html__('Social Label', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Follow us:', 'bixola-core'),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'name',
            [
                'label' => esc_html__('Profile Name', 'bixola-core'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'select2options' => [
                    'allowClear' => false,
                ],
                'options' => self::get_profile_names()
            ]
        );

        $repeater->add_control(
            'link', [
                'label' => esc_html__('Profile Link', 'bixola-core'),
                'placeholder' => esc_html__('Add your profile link', 'bixola-core'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'autocomplete' => false,
                'show_external' => false,
                'condition' => [
                    'name!' => 'email'
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );
        $this->add_control(
            'profiles',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '<# print(name.slice(0,1).toUpperCase() + name.slice(1)) #>',
                'default' => [
                    [
                        'link' => ['url' => 'https://facebook.com/'],
                        'name' => 'facebook'
                    ],
                    [
                        'link' => ['url' => 'https://linkedin.com/'],
                        'name' => 'linkedin'
                    ],
                    [
                        'link' => ['url' => 'https://twitter.com/'],
                        'name' => 'twitter'
                    ]
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'_style_design_layout',
			[
				'label' => __( 'Design Layout', 'bixola-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
            'design_layout_margin',
            [
                'label' => __( 'Margin', 'bixola-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->add_responsive_control(
            'design_layout_padding',
            [
                'label' => __( 'Padding', 'bixola-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->add_control(
            'design_layout_background',
            [
                'label' => __( 'Background', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'bixola_title_style',
			[
				'label' => __( 'Title & Content', 'bixola-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
            '_heading_name',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Name', 'bixola-core' ),
            ]
        );

        $this->add_responsive_control(
            'name_bottom_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .team-details__title-1' => 'margin-bottom: {{SIZE}}{{UNIT}}!important;',
                ],
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label' => __( 'Text', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-details__title-1' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'selector' => '{{WRAPPER}} .team-details__title-1',
            ]
        );

        $this->add_control(
            '_heading_designation',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Designation', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'designation_bottom_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .team-details__sub-title' => 'margin-bottom: {{SIZE}}{{UNIT}}!important;',
                ],
            ]
        );

        $this->add_control(
            'designation_color',
            [
                'label' => __( 'Text', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-details__sub-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'designation_typography',
                'selector' => '{{WRAPPER}} .team-details__sub-title',
            ]
        );

        // About
        $this->add_control(
            '_heading_about',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'About', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'about_bottom_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .team-details__text-1' => 'margin-bottom: {{SIZE}}{{UNIT}}!important;',
                ],
            ]
        );

        $this->add_control(
            'about_color',
            [
                'label' => __( 'About Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-details__text-1' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'about_typography',
                'selector' => '{{WRAPPER}} .team-details__text-1',
            ]
        );

		$this->end_controls_section();

        $this->start_controls_section(
            '_style_skill',
            [
                'label' => esc_html__( 'Skill',  'text-domain'  ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            '_heading_style_skill_title',
            [
                'label' => esc_html__( 'Title', 'text-domain' ),
                'type' => Controls_Manager::HEADING,
            ]
        );
        
        $this->add_responsive_control(
            'skill_title_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'text-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .team-details__title-2' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'skill_title_color',
            [
                'label' => esc_html__( 'Color', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-details__title-2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'skill_title_typography',
                'selector' => '{{WRAPPER}} .team-details__title-2',
            ]
        );

        $this->add_control(
            '_heading_style_skill_description',
            [
                'label' => esc_html__( 'Description', 'text-domain' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        
        $this->add_responsive_control(
            'skill_description_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'text-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .team-details__text-2' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'skill_description_color',
            [
                'label' => esc_html__( 'Color', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-details__text-2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'skill_description_typography',
                'selector' => '{{WRAPPER}} team-details__text-2',
            ]
        );

        $this->add_control(
            '_heading_style_skill_bar_text',
            [
                'label' => esc_html__( 'Bar', 'text-domain' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'skill_bar_title_color',
            [
                'label' => esc_html__( 'Title', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-details__progress-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'skill_bar_percent_color',
            [
                'label' => esc_html__( 'Percent', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-details__progress .count-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'skill_bar_inner_background',
            [
                'label' => esc_html__( 'Bar Fill', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-details__progress .bar-inner' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'skill_bar_background',
            [
                'label' => esc_html__( 'Bar', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-details__progress .bar' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            '_style_contact_info',
            [
                'label' => esc_html__( 'Contact Info',  'text-domain'  ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control(
            '_heading_style_contact_info_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Title', 'bixola-core' ),
            ]
        );

        $this->add_responsive_control(
            'contact_info_title_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'text-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .team-details__contact-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'contact_info_title_color',
            [
                'label' => esc_html__( 'Color', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-details__contact-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'contact_info_title_border_color',
            [
                'label' => esc_html__( 'Color', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-details__contact-title:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'contact_info_title_typography',
                'selector' => '{{WRAPPER}} .team-details__contact-title',
            ]
        );
        
        $this->add_control(
            '_heading_style_contact_info_list',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Info List', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'info_icon_color',
            [
                'label' => __( 'Icon Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-details__contact-list li .icon span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'info_icon_size',
            [
                'label' => __( 'Icon Size', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .team-details__contact-list li .icon span' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'info_color',
            [
                'label' => __( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-details__contact-list li p a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .team-details__contact-list li p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'info_color_hover',
            [
                'label' => __( 'Color (Hover)', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-details__contact-list li p a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'info_typography',
                'selector' => '{{WRAPPER}} .team-details__contact-list li p a, .team-details__contact-list li p',
            ]
        );

        $this->add_control(
            '_heading_style_social_profile',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Social Profile', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'social_profile_icon_size',
            [
                'label' => __( 'Icon Size', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .team-details__social a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'social_profile_color',
            [
                'label' => __( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-details__social a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'social_profile_color_hover',
            [
                'label' => __( 'Color (Hover)', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-details__social a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            '_heading_style_contact_info_layout',
            [
                'label' => esc_html__( 'Layout', 'text-domain' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'contact_info_layout_background',
            [
                'label' => esc_html__( 'Background', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-details__left' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'contact_layout_padding',
            [
                'label' => esc_html__( 'Padding', 'text-domain' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .team-details__contact-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

            if ( !empty($settings['bixola_image']['url']) ) {
                $bixola_image = !empty($settings['bixola_image']['id']) ? wp_get_attachment_image_url( $settings['bixola_image']['id'], 'full' ) : $settings['bixola_image']['url'];
                $bixola_image_alt = get_post_meta($settings["bixola_image"]["id"], "_wp_attachment_image_alt", true);
            }

		?>

            <section class="bixola-el-section team-details">
                <div class="container">
                    <div class="team-details__inner">
                        <div class="row">
                            <div class="col-xl-5 col-lg-5">
                                <div class="team-details__left">
                                    <?php if ( !empty ( $settings['bixola_image']['url'] ) ) : ?>
                                        <div class="team-details__img">
                                            <img src="<?php echo esc_url($bixola_image); ?>" alt="<?php echo esc_attr($bixola_image_alt); ?>">
                                        </div>
                                    <?php endif; ?>
                                    <div class="team-details__contact-box">
                                        <?php if ( !empty ( $settings['contact_info_title' ] ) ) : ?>
                                            <h3 class="team-details__contact-title">
                                                <?php echo twinkle_kses($settings['contact_info_title' ]); ?>
                                            </h3>
                                        <?php endif; ?>
                                        <ul class="team-details__contact-list list-unstyled">
                                            <?php foreach ($settings['bixola_info_list'] as $item) : ?>
                                                <?php if ( $item['bixola_info_type']  == 'phone' ): ?>
                                                    <li>
                                                        <div class="icon">
                                                            <span class="icon-telephone"></span>
                                                        </div>
                                                        <p>
                                                            <a href="tel:<?php echo esc_attr( $item['bixola_phone'] ); ?>">
                                                                <?php echo twinkle_kses($item['bixola_info_title' ]); ?>
                                                            </a>
                                                        </p>
                                                    </li>
                                                <?php elseif ( $item['bixola_info_type']  == 'email' ): ?>
                                                    <li>
                                                        <div class="icon">
                                                            <span class="icon-envelope"></span>
                                                        </div>
                                                        <p>
                                                            <a href="mailto:<?php echo esc_attr($item['bixola_email' ]); ?>">
                                                                <?php echo twinkle_kses($item['bixola_info_title' ]); ?>
                                                            </a>
                                                        </p>
                                                    </li>
                                                <?php elseif ( $item['bixola_info_type']  == 'url' ): ?>
                                                    <li>
                                                        <a href="<?php echo esc_url($item['bixola_info_url' ]); ?>">
                                                            <?php echo twinkle_kses($item['bixola_info_title' ]); ?>
                                                            <i class="fa-solid fa-location-dot"></i>
                                                        </a>
                                                    </li>
                                                <?php elseif ( $item['bixola_info_type']  == 'address' ): ?>
                                                    <li>
                                                        <div class="icon">
                                                            <span class="icon-location11"></span>
                                                        </div>
                                                        <p><?php echo twinkle_kses($item['bixola_info_title' ]); ?></p>
                                                    </li>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                        </ul>
                                        <?php if ($settings['show_profiles'] && is_array($settings['profiles'])) : ?>
                                            <div class="team-details__social">
                                                <?php
                                                foreach ($settings['profiles'] as $profile) :
                                                    $icon = $profile['name'];
                                                    $url = esc_url($profile['link']['url']);

                                                    printf('<a target="_blank" rel="noopener"  href="%s" class="elementor-repeater-item-%s"><i class="fab fa-%s" aria-hidden="true"></i></a>',
                                                        $url,
                                                        esc_attr($profile['_id']),
                                                        esc_attr($icon)
                                                    );
                                                endforeach; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-7 col-lg-7">
                                <div class="team-details__right">
                                    <?php if ( !empty($settings['bixola_name' ]) ) : ?>
                                        <h3 class="team-details__title-1">
                                            <?php echo twinkle_kses( $settings['bixola_name'] ); ?>
                                        </h3>
                                    <?php endif; ?>
                                    <?php if ( !empty($settings['bixola_designation' ]) ) : ?>
                                        <p class="team-details__sub-title"><?php echo twinkle_kses( $settings['bixola_designation'] ); ?></p>
                                    <?php endif; ?>
                                    <?php if ( !empty($settings['bixola_about']) ) : ?>
                                        <p class="team-details__text-1">
                                            <?php echo twinkle_kses( $settings['bixola_about'] ); ?>
                                        </p>
                                    <?php endif; ?>
                                    <?php if ( !empty($settings['skill_title']) ) : ?>
                                        <h3 class="team-details__title-2">
                                            <?php echo twinkle_kses( $settings['skill_title'] ); ?>
                                        </h3>
                                    <?php endif; ?>
                                    <?php if ( !empty($settings['skill_description']) ) : ?>
                                        <p class="team-details__text-2">
                                            <?php echo twinkle_kses( $settings['skill_description'] ); ?>
                                        </p>
                                    <?php endif; ?>
                                    <ul class="team-details__progress-list list-unstyled">
                                        <?php foreach ( $settings['skills'] as $index => $skill ) : ?>
                                            <li class="team-details__progress">
                                                <h4 class="team-details__progress-title"><?php echo esc_html( $skill['name'] ); ?></h4>
                                                <div class="bar">
                                                    <div class="bar-inner count-bar" data-percent="<?php echo esc_attr( $skill['level'] ); ?>%">
                                                        <div class="count-text"><?php echo esc_attr( $skill['level'] ); ?>%</div>
                                                    </div>
                                                </div>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        <?php
	}

}

$widgets_manager->register( new Bixola_Team_Details() );