<?php
namespace BixolaCore\Widgets;

use \Elementor\Widget_Base;
use \Elementor\Control_Media;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Css_Filter;
use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Box_Shadow;
use XlabCore\Elementor\Controls\Group_Control_XlabBGGradient;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Xlab Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Xlab_Process extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'xlab_process_bar';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Process', 'bixola-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'xlab-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'xlab_core' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'bixola-core' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {
        
     // xlab_section_title
     $this->start_controls_section(
        'xlab_section_title',
        [
            'label' => esc_html__('Title & Content', 'bixola-core'),
        ]
    );

    $this->add_control(
        'xlab_subheading',
        [
            'label' => esc_html__('Sub Title', 'bixola-core'),
            'description' => xlab_get_allowed_html_desc( 'basic' ),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('Services', 'bixola-core'),
            'placeholder' => esc_html__('Type Sub Heading Text', 'bixola-core'),
            'label_block' => true,
        ]
    );

    $this->add_control(
        'xlab_description',
        [
            'label' => esc_html__('desc', 'bixola-core'),
            'description' => xlab_get_allowed_html_desc( 'basic' ),
            'type' => Controls_Manager::TEXTAREA,
            'default' => esc_html__('Nulla vitae ex nunc. Morbi quis purus convallis, fermentum metus volutpat sodales purus. Nunc quis Nulla Nulla vitae ex nunc. Morbi quis purus convallis, fermentum metus volutpat', 'bixola-core'),
            'placeholder' => esc_html__('Type Sub Heading Text', 'bixola-core'),
            'label_block' => true,
        ]
    );

    $this->add_responsive_control(
        'xlab_subheading_align',
        [
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'label' => esc_html__( 'Alignment', 'bixola-core' ),
            'options' => [
                'flex-start' => [
                    'title' => esc_html__( 'Left', 'bixola-core' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'bixola-core' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'flex-end' => [
                    'title' => esc_html__( 'Right', 'bixola-core' ),
                    'icon' => 'eicon-text-align-right',
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'prefix_class' => 'content-align-%s',
            'selectors' => [
                '{{WRAPPER}} .section__subtitle' => 'justify-content: {{VALUE}};'
            ],
        ]
    );

    $this->add_control(
        'xlab_subheading_image_hide_show',
        [
            'label' => esc_html__( 'Show Icon', 'bixola-core' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Show', 'bixola-core' ),
            'label_off' => esc_html__( 'Hide', 'bixola-core' ),
            'return_value' => 'yes',
            'default' => 'yes',
        ]
    );

    $this->add_control(
        'xlab_subheading_image_icon_switcher',
        [
            'label' => esc_html__( 'Image Type', 'bixola-core' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'image',
            'options' => [
                'image' => esc_html__( 'Image', 'bixola-core' ),
                'icon' => esc_html__( 'Icon', 'bixola-core' ),
            ],
            'condition' => [
                'xlab_subheading_image_hide_show' => 'yes',
            ],
        ]
    );

    $this->add_control(
        'xlab_subheading_image',
        [
            'label' => esc_html__('Upload Image', 'bixola-core'),
            'type' => Controls_Manager::MEDIA,
            'default' => [
                'url' => 'https://rrdevs.net/demos/wp/xlab/wp-content/themes/xlab/assets/img/icons/xlab.svg',
            ],
            'condition' => [
                'xlab_subheading_image_icon_switcher' => 'image',
                'xlab_subheading_image_hide_show' => 'yes',
            ],
        ]
    );

    $this->add_control(
        'xlab_subheading_icon',
        [
            'label' => esc_html__( 'Icon', 'bixola-core' ),
            'type' => \Elementor\Controls_Manager::ICONS,
            'default' => [
                'value' => 'fas fa-circle',
                'library' => 'fa-solid',
            ],
            'recommended' => [
                'fa-solid' => [
                    'circle',
                    'dot-circle',
                    'square-full',
                ],
                'fa-regular' => [
                    'circle',
                    'dot-circle',
                    'square-full',
                ],
            ],
            'condition' => [
                'xlab_subheading_image_icon_switcher' => 'icon',
                'xlab_subheading_image_hide_show' => 'yes',
            ],
        ]
    );

    $this->add_control(
        'xlab_subheading_image_right',
        [
            'label' => esc_html__('Upload Right Image', 'bixola-core'),
            'type' => Controls_Manager::MEDIA,
            'default' => [
                'url' => 'https://rrdevs.net/demos/wp/xlab/wp-content/themes/xlab/assets/img/icons/arrow-right-circle.svg',
            ],
            'condition' => [
                'xlab_subheading_image_icon_switcher' => 'image',
                'xlab_subheading_image_hide_show' => 'yes',
                'xlab_design_style' => 'layout-2',
            ],
        ]
    );

    $this->add_control(
        'xlab_subheading_icon_right',
        [
            'label' => esc_html__( 'Icon Right', 'bixola-core' ),
            'type' => \Elementor\Controls_Manager::ICONS,
            'default' => [
                'value' => 'fas fa-circle',
                'library' => 'fa-solid',
            ],
            'recommended' => [
                'fa-solid' => [
                    'circle',
                    'dot-circle',
                    'square-full',
                ],
                'fa-regular' => [
                    'circle',
                    'dot-circle',
                    'square-full',
                ],
            ],
            'condition' => [
                'xlab_subheading_image_icon_switcher' => 'icon',
                'xlab_subheading_image_hide_show' => 'yes',
                'xlab_design_style' => 'layout-2',
            ],
        ]
    );

    $this->add_responsive_control(
        'xlab_subheading_icon_gap',
        [
            'type' => \Elementor\Controls_Manager::SLIDER,
            'label' => esc_html__( 'Icon Gap', 'bixola-core' ),
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'desktop_default' => [
                'size' => 10,
                'unit' => 'px',
            ],
            'tablet_default' => [
                'size' => 10,
                'unit' => 'px',
            ],
            'mobile_default' => [
                'size' => 10,
                'unit' => 'px',
            ],
            'selectors' => [
                '{{WRAPPER}} .section__title-wrapper .section__subtitle' => 'gap: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .section__subtitle-2' => 'gap: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'xlab_subheading_image_hide_show' => 'yes',
            ],
        ]
    );

    $this->add_control(
        'xlab_title_heading',
        [
            'label' => esc_html__( 'Title', 'bixola-core' ),
            'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
        ]
    );

    $this->add_control(
        'xlab_title',
        [
            'label' => esc_html__('Title', 'bixola-core'),
            'description' => xlab_get_allowed_html_desc( 'intermediate' ),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('What You Can expect to Get From Us', 'bixola-core'),
            'placeholder' => esc_html__('What You Can expect to Get From Us', 'bixola-core'),
            'label_block' => true,
        ]
    );

    $this->add_control(
        'xlab_title_tag',
        [
            'label' => esc_html__('Title HTML Tag', 'bixola-core'),
            'type' => Controls_Manager::CHOOSE,
            'options' => [
                'h1' => [
                    'title' => esc_html__('H1', 'bixola-core'),
                    'icon' => 'eicon-editor-h1'
                ],
                'h2' => [
                    'title' => esc_html__('H2', 'bixola-core'),
                    'icon' => 'eicon-editor-h2'
                ],
                'h3' => [
                    'title' => esc_html__('H3', 'bixola-core'),
                    'icon' => 'eicon-editor-h3'
                ],
                'h4' => [
                    'title' => esc_html__('H4', 'bixola-core'),
                    'icon' => 'eicon-editor-h4'
                ],
                'h5' => [
                    'title' => esc_html__('H5', 'bixola-core'),
                    'icon' => 'eicon-editor-h5'
                ],
                'h6' => [
                    'title' => esc_html__('H6', 'bixola-core'),
                    'icon' => 'eicon-editor-h6'
                ]
            ],
            'default' => 'h2',
            'toggle' => false,
        ]
    );

    $this->add_responsive_control(
        'xlab_title_align',
        [
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'label' => esc_html__( 'Alignment', 'bixola-core' ),
            'options' => [
                'left' => [
                    'title' => esc_html__( 'Left', 'bixola-core' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'bixola-core' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'right' => [
                    'title' => esc_html__( 'Right', 'bixola-core' ),
                    'icon' => 'eicon-text-align-right',
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'prefix_class' => 'content-align-%s',
            'selectors' => [
                '{{WRAPPER}} .section__title' => 'text-align: {{VALUE}};'
            ],
        ]
    );

    $this->end_controls_section();

    // style tab here
    $this->start_controls_section(
        '_section_style_content',
        [
            'label' => __( 'Section Title', 'bixola-core' ),
            'tab'   => Controls_Manager::TAB_STYLE,
        ]
    );

    $this->add_responsive_control(
        'content_padding',
        [
            'label' => __( 'Content Padding', 'bixola-core' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', 'em', '%' ],
            'selectors' => [
                '{{WRAPPER}} .section__title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );

    $this->add_responsive_control(
        'content_margin',
        [
            'label' => __( 'Content Margin', 'bixola-core' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', 'em', '%' ],
            'selectors' => [
                '{{WRAPPER}} .section__title-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );

    // Title
    $this->add_control(
        '_heading_title',
        [
            'type' => Controls_Manager::HEADING,
            'label' => __( 'Title', 'bixola-core' ),
            'separator' => 'before'
        ]
    );

    $this->add_control(
        '_title_color',
        [
            'label' => __( 'Text Color', 'bixola-core' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .section__title' => 'color: {{VALUE}}',
                
            ],
        ]
    );
    $this->add_control(
        '_title_bg',
        [
            'label' => __( 'Text Background Color', 'bixola-core' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .section__title' => 'color: {{VALUE}}',
                
            ],
        ]
    );

    $this->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'name' => 'title_typography',
            'selector' => '{{WRAPPER}} .section__title',
        ]
    );
    // desc
    $this->add_control(
        '_content_subheading_main',
        [
            'type' => Controls_Manager::HEADING,
            'label' => __( 'Desc', 'bixola-core' ),
            'separator' => 'before'
        ]
    );

        $this->add_control(
            '_section_desc_main_color',
            [
                'label' => __( 'Text Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .work-process__description p' => 'color: {{VALUE}}',
                    
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_main_typography',
                'selector' => '{{WRAPPER}} .work-process__description p',
            ]
        );

    // Subheding
    $this->add_control(
        '_content_subheading',
        [
            'type' => Controls_Manager::HEADING,
            'label' => __( 'Subheading', 'bixola-core' ),
            'separator' => 'before'
        ]
    );

    $this->add_responsive_control(
        'subheading_spacing',
        [
            'label' => __( 'Bottom Spacing', 'bixola-core' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => ['px'],
            'selectors' => [
                '{{WRAPPER}} .section__title-wrapper .section__subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .section__subtitle-2' => 'margin-bottom: {{SIZE}}{{UNIT}};',
            ],
        ]
    );

    $this->add_control(
        'subheading_color',
        [
            'label' => __( 'Text Color', 'bixola-core' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .section__title-wrapper .section__subtitle' => 'color: {{VALUE}}',
                '{{WRAPPER}} .section__subtitle-2' => 'color: {{VALUE}}',
            ],
        ]
    );

    $this->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'name' => 'subheading_typography',
            'selector' => '{{WRAPPER}} .section__title-wrapper .section__subtitle',
            'selector' => '{{WRAPPER}} .section__subtitle-2',
        ]
    );
    

    $this->add_responsive_control(
        'subheading_icon-size',
        [
            'type' => \Elementor\Controls_Manager::SLIDER,
            'label' => esc_html__( 'Icon Size', 'bixola-core' ),
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
            'desktop_default' => [
                'size' => 18,
                'unit' => 'px',
            ],
            'tablet_default' => [
                'size' => 18,
                'unit' => 'px',
            ],
            'mobile_default' => [
                'size' => 18,
                'unit' => 'px',
            ],
            'selectors' => [
                '{{WRAPPER}} .section__subtitle svg' => 'width: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .section__subtitle-2 svg' => 'width: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'xlab_subheading_image_icon_switcher' => 'icon',
            ],
        ]
    );

    $this->end_controls_section();
          // process group
          $this->start_controls_section(
            'xlab_process',
            [
                'label' => esc_html__('process List', 'rr-core'),
                'description' => esc_html__( 'Control all the style settings from Style tab', 'rr-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'xlab_process_hide_show',
            [
                'label' => esc_html__( 'Show Items', 'bixola-core' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'bixola-core' ),
                'label_off' => esc_html__( 'Hide', 'bixola-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'rr_process_icon_type',
            [
                'label' => esc_html__('Select Icon Type', 'rr-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'icon',
                'options' => [
                    'image' => esc_html__('Image', 'rr-core'),
                    'icon' => esc_html__('Icon', 'rr-core'),
                    'svg' => esc_html__('SVG', 'rr-core'),
                ],
            ]
        );

        $repeater->add_control(
            'rr_process_image',
            [
                'label' => esc_html__('Upload Icon Image', 'rr-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'rr_process_icon_type' => 'image',
                ]

            ]
        );

        $repeater->add_control(
            'rr_process_icon_svg',
            [
                    'show_label' => false,
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                    'placeholder' => esc_html__('SVG Code Here', 'rr-core'),
                    'condition' => [
                        'rr_process_icon_type' => 'svg'
                    ]
            ]
        );

        if (xlab_is_elementor_version('<', '2.6.0')) {
            $repeater->add_control(
                'rr_process_icon',
                [
                    'show_label' => false, 
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fa fa-star',
                    'condition' => [
                        'rr_process_icon_type' => 'icon'
                    ]
                ]
            );
        } else {
            $repeater->add_control(
                'rr_process_selected_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-star',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'rr_process_icon_type' => 'icon'
                    ]
                ]
            );
        }

        $repeater->add_control(
            'rr_process_title', [
                'label' => esc_html__('Title', 'rr-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Service Title', 'rr-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'rr_process_description',
            [
                'label' => esc_html__('Description', 'rr-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered.',
                'label_block' => true,
            ]
        );
    
        $repeater->add_control(
            'active_process',
            [
                'label' => __('Active process', 'rr-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'rr-core'),
                'label_off' => __('Hide', 'rr-core'),
                'return_value' => 'yes',
                'default' => false,
                'style_transfer' => true,
            ]
        );

        $this->add_control(
            'rr_process_list',
            [
                'label' => esc_html__('Services - List', 'rr-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'rr_process_title' => esc_html__('Discover', 'rr-core'),
                    ],
                    [
                        'rr_process_title' => esc_html__('Define', 'rr-core')
                    ],
                    [
                        'rr_process_title' => esc_html__('Develop', 'rr-core')
                    ]
                ],
                'title_field' => '{{{ rr_process_title }}}',
            ]
        );
        $this->end_controls_section(); 
    
              // TAB_STYLE
              $this->start_controls_section(
                'design_layout_style',
                [
                    'label' => __( 'Process Box Style', 'bixola-core' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                ]
            );
            $this->add_responsive_control(
                'content_padding_box',
                [
                    'label' => __( 'Content Padding', 'bixola-core' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .work-process__item__home' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
        
            $this->add_responsive_control(
                'content_margin_box',
                [
                    'label' => __( 'Content Margin', 'bixola-core' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .work-process__item__home' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'box_border_radius',
                [
                    'label'     => esc_html__( 'Border Radius', 'bixola-core' ),
                    'type'      => Controls_Manager::SLIDER,
                    'selectors' => [
                        '{{WRAPPER}} .work-process__item__home' => 'border-radius: {{SIZE}}px;',
                    ],
                ] 
            );
            $this->add_control(
                'box_border_radius_color',
                [
                    'label'     => esc_html__( 'Border Color', 'bixola-core' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .work-process__item__home' => 'border-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'content_box_bg',
                [
                    'label'     => esc_html__( 'Background', 'bixola-core' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .work-process__item__home' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
    
            $this->add_control(
                '__titile_heading',
                [
                    'label' => esc_html__( 'Title', 'text-domain' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'title_spacing',
                [
                    'label' => __( 'Bottom Spacing', 'bixola-core' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .work-process__item-heading h4' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
                    ],
                ]
            );
    
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Color', 'text-domain' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .work-process__item-heading h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
    
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography_title',
                    'selector' => '{{WRAPPER}} .work-process__item-heading h4',
                ]
            );
    
            $this->add_control(
                '_description_heading',
                [
                    'label' => esc_html__( 'Description', 'text-domain' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
    
            $this->add_responsive_control(
                'description_spacing',
                [
                    'label' => __( 'Bottom Spacing', 'bixola-core' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .work-process__item-body p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
    
            $this->add_control(
                'description_color',
                [
                    'label' => esc_html__( 'Color', 'text-domain' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .work-process__item-body p' => 'color: {{VALUE}}',
                    ],
                ]
            );
    
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'description_typography',
                    'selector' => '{{WRAPPER}} .work-process__item-body p',
                ]
            );
    
            $this->end_controls_section();  
            $this->start_controls_section(
                'design_icon_style',
                [
                    'label' => __( 'Icon Style', 'bixola-core' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                ]
            );
    
        $this->add_control(
            '_heading_icon',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Icon', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'icon_bottom_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .work-process__item-icon i' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __( 'Icon Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .work-process__item-icon i::before' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __( 'Icon Size', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .work-process__item-icon i::before' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
     
        $this->end_controls_section();
        $this->start_controls_section(
            '_heading_number',
            [
                'label' => __( 'Number Style', 'bixola-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        ); 
   
        $this->add_control(
            'icon_color_number',
            [
                'label' => __( 'Icon Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .work-process__item-icon span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_spacing_number',
            [
                'label' => __( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .work-process__item-icon span' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();       
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

        $this->add_render_attribute('title_args', 'class', 'section__title wow fadeIn  mb-0');
        $this->add_render_attribute('title_args', 'data-wow-delay', '.3s');

        if ( !empty($settings['xlab_image']['url']) ) {
            $xlab_image = !empty($settings['xlab_image']['id']) ? wp_get_attachment_image_url( $settings['xlab_image']['id'], 'full' ) : $settings['xlab_image']['url'];
            $xlab_image_alt = get_post_meta($settings["xlab_image"]["id"], "_wp_attachment_image_alt", true);
        }
		?>
<!-- WORK PROCESS area start -->
<section class="work-process__area section-space">
    <div class="container">
        <div class="row align-items-end">
            <div class="col-xl-5">
                <div class="section__title-wrapper section__title-wrapper__white">
                    <?php if($settings['xlab_subheading']): 
                if($settings['xlab_subheading_image']):
            ?>
                    <span class="section__subtitle uppercase mb-20 wow fadeIn animated" data-wow-delay=".1s"><img
                            class="xlab-img rightLeft" src="<?php echo $settings['xlab_subheading_image']['url']; ?>"
                            alt="arrow not found"><?php echo twinkle_kses( $settings['xlab_subheading' ] ) ?></span>
                    <?php elseif(!empty($settings['xlab_subheading_icon']) || !empty($settings['xlab_subheading_selected_icon']['value'])) : ?>
                    <span class="section__subtitle uppercase mb-20 wow fadeIn animated" data-wow-delay=".1s"> <span
                            class="xlab-img rightLeft"><?php \Elementor\Icons_Manager::render_icon( $settings['xlab_subheading_icon'], [ 'aria-hidden' => 'true' ] ); ?></span>
                        <?php echo twinkle_kses( $settings['xlab_subheading' ] ) ?></span>
                    <?php endif; endif; ?>
                    <?php
                if ( !empty($settings['xlab_title' ]) ) :
                    printf( '<%1$s %2$s>%3$s</%1$s>',
                        tag_escape( $settings['xlab_title_tag'] ),
                        $this->get_render_attribute_string( 'title_args' ),
                        twinkle_kses( $settings['xlab_title' ] )
                        );
                endif;
            ?>
                </div>

            </div>
            <div class="col-xl-7">
                <div class="work-process__description section__title-wrapper__white position-relative wow fadeIn animated"
                    data-wow-delay=".4s">
                    <?php if (!empty($settings['xlab_description'])): ?>
                    <p><?php echo xlab_kses($settings['xlab_description']); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="work-process__item-wrapper mt-60 mt-sm-50 mt-xs-40 d-flex flex-column">
                <?php foreach ($settings['rr_process_list'] as $key => $item) : 
                       $active_process = $item['active_process'] ? 'active' : '';
                    ?>
                <div class="work-process__item work-process__item__home <?php echo esc_attr($active_process); ?> d-flex align-items-center wow fadeIn animated"
                    data-wow-delay=".1s">
                    <div class="work-process__item-header d-flex align-items-center">
                        <div class="work-process__item-icon">
                        <?php if (!empty($settings['xlab_process_hide_show'])): ?>
                            <span>0<?php echo ($key+1); ;?></span>
                        <?php endif; ?>
                            <?php if($item['rr_process_icon_type'] == 'icon') : ?>
                            <?php if (!empty($item['rr_process_icon']) || !empty($item['rr_process_selected_icon']['value'])) : ?>
                            <div class="shape">
                                <?php xlab_render_icon($item, 'rr_process_icon', 'rr_process_selected_icon'); ?>
                            </div>
                            <?php endif; ?>
                            <?php elseif( $item['rr_process_icon_type'] == 'image' ) : ?>
                            <?php if (!empty($item['rr_process_image']['url'])): ?>
                            <div class="shape">
                                <img src="<?php echo $item['rr_process_image']['url']; ?>"
                                    alt="<?php echo get_post_meta(attachment_url_to_postid($item['rr_process_image']['url']), '_wp_attachment_image_alt', true); ?>">
                            </div>
                            <?php endif; ?>
                            <?php else : ?>
                            <?php if (!empty($item['rr_process_icon_svg'])): ?>
                            <div class="shape">
                                <?php echo $item['rr_process_icon_svg']; ?>
                            </div>
                            <?php endif; ?>
                            <?php endif; ?>
                        </div>
                        <?php if (!empty($item['rr_process_title'])): ?>
                        <div class="work-process__item-heading">
                            <h4><?php echo xlab_kses($item['rr_process_title' ]); ?></h4>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="work-process__item-body p d-flex align-items-center">
                        <?php if (!empty($item['rr_process_description' ])): ?>
                        <p><?php echo xlab_kses($item['rr_process_description']); ?></p>
                        <?php endif; ?>

                        <button><i class="fa-solid fa-angle-right"></i></button>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</section>
<!-- WORK PROCESS area end -->

<?php
	}

}

$widgets_manager->register( new Xlab_Process() );