<?php
namespace BixolaCore\Widgets;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;

use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Xlab Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class xlab_Features_List extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'xlab_features_list';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Features List', 'bixola-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'xlab-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'xlab_core' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'bixola-core' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

        // layout Panel
        $this->start_controls_section(
            'xlab_layout',
            [
                'label' => esc_html__('Design Layout', 'bixola-core'),
            ]
        );

        $this->add_control(
            'xlab_design_style',
            [
                'label' => esc_html__('Select Layout', 'bixola-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'bixola-core'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        // Features List
        $this->start_controls_section(
            'xlab_features_list_content',
            [
                'label' => esc_html__('Features List', 'bixola-core'),
                'description' => esc_html__( 'Control all the style settings from Style tab', 'bixola-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
			'xlab_features_icon_switcher',
			[
				'label' => esc_html__( 'Image Type', 'bixola-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'image',
				'options' => [
					'image' => esc_html__( 'Image', 'bixola-core' ),
					'icon' => esc_html__( 'Icon', 'bixola-core' ),
				],
			]
		);

        $repeater->add_control(
            'xlab_features_image',
            [
                'label' => esc_html__('Upload Image', 'bixola-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => 'https://rrdevs.net/demos/wp/xlab/wp-content/themes/xlab/assets/img/home1/latest-service__item-1.png',
                ],
                'condition' => [
                    'xlab_features_icon_switcher' => 'image',
                ],
            ]
        );

        if (xlab_is_elementor_version('<', '2.6.0')) {
            $repeater->add_control(
                'xlab_features_icon',
                [
                    'label' => esc_html__('Icon', 'bixola-core'),
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'icon-house',
                    'condition' => [
                        'xlab_features_icon_switcher' => 'icon',
                    ],
                ]
            );
        } else {
            $repeater->add_control(
                'xlab_features_selected_icon',
                [
                    'label' => esc_html__('Icon', 'bixola-core'),
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'icon-house',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'xlab_features_icon_switcher' => 'icon',
                    ],
                ]
            );
        }

        $repeater->add_control(
            'xlab_features_title', [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => xlab_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'xlab_features_subtitle', [
                'label' => esc_html__('Subtitle', 'bixola-core'),
                'description' => xlab_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'link_switcher',
            [
                'label' => esc_html__( 'Add link', 'bixola-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'bixola-core' ),
                'label_off' => esc_html__( 'No', 'bixola-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'link_text',
            [
                'label' => esc_html__('Button Text', 'bixola-core'),
                'description' => xlab_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Read More', 'bixola-core'),
                'label_block' => true,
                'condition' => [
                    'link_switcher' => 'yes'
                ]
            ]
        );

        $repeater->add_control(
            'link_type',
            [
                'label' => esc_html__( 'Link Type', 'bixola-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'condition' => [
                    'link_switcher' => 'yes'
                ]
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__( 'Link', 'bixola-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'https://your-link.com', 'bixola-core' ),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'condition' => [
                    'link_type' => '1',
                    'link_switcher' => 'yes',
                ]
            ]
        );

        $repeater->add_control(
            'page_link',
            [
                'label' => esc_html__( 'Select Page Link', 'bixola-core' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => xlab_get_all_pages(),
                'condition' => [
                    'link_type' => '2',
                    'link_switcher' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'xlab_features_list',
            [
                'label' => esc_html__('Features List', 'bixola-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'xlab_features_title' => esc_html__('Profit Curve Advisors', 'bixola-core'),
                        'xlab_features_subtitle' => esc_html__('Customer satisfaction is crucial for amohlodi business as it leads to customer loyalty loves positive word-of-mouth, repeat', 'bixola-core'),
                    ],
                    [
                        'xlab_features_title' => esc_html__('Growth Sphere Solutions', 'bixola-core'),
                        'xlab_features_subtitle' => esc_html__('Customer satisfaction is crucial for amohlodi business as it leads to customer loyalty loves positive word-of-mouth, repeat', 'bixola-core'),
                    ],
                    [
                        'xlab_features_title' => esc_html__('Success Fusion Partners', 'bixola-core'),
                        'xlab_features_subtitle' => esc_html__('Customer satisfaction is crucial for amohlodi business as it leads to customer loyalty loves positive word-of-mouth, repeat', 'bixola-core'),
                    ],
                ],
                'title_field' => '{{{ xlab_features_title }}}',
            ]
        );

        $this->end_controls_section();


        // Price Content
        $this->start_controls_section(
            'xlab_faq_price_content',
            [
                'label' => esc_html__('Price Info', 'bixola-core'),
                'description' => esc_html__( 'Xlab Price Info', 'bixola-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'xlab_design_style' => ['layout-2'],
                ],
            ]
        );

        $this->add_control(
            'xlab_price',
            [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => xlab_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Price', 'bixola-core'),
                'placeholder' => esc_html__('Type Heading Text', 'bixola-core'),
                'label_block' => true,
                'condition' => [
                    'xlab_design_style' => ['layout-2'],
                ],
            ]
        );

        $this->add_control(
            'xlab_price_btn',
            [
                'label' => esc_html__('Button Text', 'bixola-core'),
                'description' => xlab_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Free Try', 'bixola-core'),
                'placeholder' => esc_html__('Type Button Text', 'bixola-core'),
                'label_block' => true,
                'condition' => [
                    'xlab_design_style' => ['layout-2'],
                ],
            ]
        );

        $this->add_control(
            'xlab_price_btn_url',
            [
                'label' => esc_html__('URL', 'bixola-core'),
                'type' => Controls_Manager::TEXT,
                'default' => '#',
                'title' => esc_html__('BTN url', 'bixola-core'),
                'label_block' => true,
                'condition' => [
                    'xlab_design_style' => ['layout-2'],
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_features_list_style',
            [
                'label' => __( 'Features List', 'bixola-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            '_heading_layout',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Layout', 'bixola-core' ),
            ]
        );

        $this->add_responsive_control(
            'features_list_padding',
            [
                'label' => __( 'Padding', 'bixola-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .key-featured__item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'features_list_border_color',
            [
                'label' => __( 'Border', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .key-featured__item:first-child' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .key-featured__item' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            '_heading_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Title', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .key-featured__item-header h4' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .key-featured__item-header h4',
            ]
        );

        $this->add_control(
            '_heading_subtitle',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Subtitle', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => __( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .key-featured__item-body p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'selector' => '{{WRAPPER}} .key-featured__item-body p',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'xlab_button_style',
			[
				'label' => __( 'Button', 'bixola-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->start_controls_tabs( 'tabs_button_style' );

        $this->start_controls_tab(
            'button_tab',
            [
                'label' => esc_html__( 'Normal', 'bixola-core' ),
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label'     => esc_html__( 'Color', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rs-btn.btn-transparent'    => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_background',
            [
                'label'     => esc_html__( 'Background', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rs-btn.btn-transparent' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'label'    => esc_html__( 'Border', 'bixola-core' ),
                'name'     => 'button_border',
                'selector' => '{{WRAPPER}} .rs-btn.btn-transparent',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'button_box_shadow',
                'selector' => '{{WRAPPER}} .rs-btn.btn-transparent',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'bixola-core' ),
            ]
        );

        $this->add_control(
            'button_color_hover',
            [
                'label'     => esc_html__( 'Color', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rs-btn.btn-transparent:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_background_hover',
            [
                'label'     => esc_html__( 'Background', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rs-btn.btn-transparent::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'label'    => esc_html__( 'Border', 'bixola-core' ),
                'name'     => 'button_border_hover',
                'selector' => '{{WRAPPER}} .rs-btn.btn-transparent:hover',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'button_box_shadow_hover',
                'selector' => '{{WRAPPER}} .rs-btn.btn-transparent:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'button_border_radius',
            [
                'label'     => esc_html__( 'Border Radius', 'bixola-core' ),
                'type'      => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .rs-btn.btn-transparent' => 'border-radius: {{SIZE}}px;',
                    '{{WRAPPER}} .rs-btn.btn-transparent::before' => 'border-radius: {{SIZE}}px;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__( 'Typography', 'bixola-core' ),
                'name'     => 'button_typography',
                'selector' => '{{WRAPPER}} .rs-btn.btn-transparent',
            ]
        );

        $this->add_control(
            'button_padding',
            [
                'label'      => esc_html__( 'Padding', 'bixola-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .rs-btn.btn-transparent' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button_margin',
            [
                'label'      => esc_html__( 'Margin', 'bixola-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .rs-btn.btn-transparent' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
	?>
        <?php if ( $settings['xlab_design_style']  == 'layout-1' ) : ?>

            <div class="key-featured__item-wrapper">
                <?php foreach ($settings['xlab_features_list'] as $item) : 
                    
                    // Link
                    if ('2' == $item['link_type']) {
                        $link = get_permalink($item['page_link']);
                        $target = '_self';
                        $rel = 'nofollow';
                    } else {
                        $link = !empty($item['link']['url']) ? $item['link']['url'] : '';
                        $target = !empty($item['link']['is_external']) ? '_blank' : '';
                        $rel = !empty($item['link']['nofollow']) ? 'nofollow' : '';
                    }

                ?>
                <div class="key-featured__item d-flex align-items-center justify-content-between wow fadeIn animated" data-wow-delay=".1s">
                    <div class="key-featured__item-header d-flex align-items-center justify-content-between">
                        <?php if (!empty($item['xlab_features_image']['url'])): ?>
                            <div class="icon">
                                <img class="img-fluid" src="<?php echo $item['xlab_features_image']['url']; ?>" alt="<?php echo get_post_meta(attachment_url_to_postid($item['xlab_features_image']['url']), '_wp_attachment_image_alt', true); ?>">
                            </div>
                        <?php endif; ?>
                        <?php if (!empty($item['xlab_features_icon']) || !empty($item['xlab_features_selected_icon']['value'])) : ?>
                            <div class="icon">
                                <?php xlab_render_icon($item, 'xlab_features_icon', 'xlab_features_selected_icon'); ?>
                            </div>
                        <?php endif; ?>
                        
                        <h4><?php echo twinkle_kses($item['xlab_features_title' ]); ?></h4>
                    </div>
                    <div class="key-featured__item-body d-flex align-items-center justify-content-between">
                        <p><?php echo twinkle_kses($item['xlab_features_subtitle' ]); ?></p>
                        <a target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>" class="rs-btn btn-transparent">
                            <?php echo twinkle_kses($item['link_text' ]); ?>
                            <i class="fa-solid fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
                <?php endforeach; ?>
                
            </div>

        <?php elseif ( $settings['xlab_design_style']  == 'layout-2' ): ?>
            

            <?php endif; ?>
        <?php
	}
}

$widgets_manager->register( new xlab_Features_List() );