<?php
namespace BixolaCore\Widgets;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Bixola Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Bixola_Contact_Form extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bixola_contact_form';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Contact Form', 'bixola-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'bixola-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bixola_core' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'bixola-core' ];
	}


    public function get_bixola_contact_form(){
        if ( ! class_exists( 'WPCF7' ) ) {
            return;
        }
        $bixola_cfa         = array();
        $bixola_cf_args     = array( 'posts_per_page' => -1, 'post_type'=> 'wpcf7_contact_form' );
        $bixola_forms       = get_posts( $bixola_cf_args );
        $bixola_cfa         = ['0' => esc_html__( 'Select Form', 'bixola-core' ) ];
        if( $bixola_forms ){
            foreach ( $bixola_forms as $bixola_form ){
                $bixola_cfa[$bixola_form->ID] = $bixola_form->post_title;
            }
        }else{
            $bixola_cfa[ esc_html__( 'No contact form found', 'bixola-core' ) ] = 0;
        }
        return $bixola_cfa;
    }


	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

        $this->start_controls_section(
            '_content_design_layout',
            [
                'label' => esc_html__( 'Design Layout', 'bixola-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label' => esc_html__('Select Layout', 'bixola-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'bixola-core'),
                    'layout-2' => esc_html__('Layout 2', 'bixola-core'),
                    'layout-3' => esc_html__('Layout 3', 'bixola-core'),
                    'layout-4' => esc_html__('Layout 4', 'bixola-core'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->add_control(
            'shape_switch',
            [
                'label' => esc_html__( 'Shape ON/OFF', 'text-domain' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'text-domain' ),
                'label_off' => esc_html__( 'Hide', 'text-domain' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'design_style' => [ 'layout-3', 'layout-4' ],
                ],
            ]
        );

        $this->add_control(
            'section_image',
            [
                'label' => esc_html__( 'Choose Image', 'text-domain' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'design_style' => 'layout-3',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_title',
            [
                'label' => esc_html__('Title & Content', 'bixola-core'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'section_title',
            [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('What You Can expect to Get From Us', 'bixola-core'),
                'placeholder' => esc_html__('What You Can expect to Get From Us', 'bixola-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_title_tag',
            [
                'label' => esc_html__('Title HTML Tag', 'bixola-core'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => esc_html__('H1', 'bixola-core'),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2' => [
                        'title' => esc_html__('H2', 'bixola-core'),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3' => [
                        'title' => esc_html__('H3', 'bixola-core'),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4' => [
                        'title' => esc_html__('H4', 'bixola-core'),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5' => [
                        'title' => esc_html__('H5', 'bixola-core'),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6' => [
                        'title' => esc_html__('H6', 'bixola-core'),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h2',
                'toggle' => false,
            ]
        );

        $this->add_control(
            'section_description',
            [
                'label' => esc_html__( 'Description', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy', 'bixola-core' ),
                'label_block' => true,
                'condition' => [
                    'design_style' => [ 'layout-1', 'layout-2', 'layout-3' ],
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_contact_form',
            [
                'label' => esc_html__('Contact Form', 'bixola-core'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'select_contact_form',
            [
                'label'   => esc_html__( 'Select Form', 'bixola-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '0',
                'options' => $this->get_bixola_contact_form(),
            ]
        );

        $this->add_control(
            'google_map_url',
            [
                'label' => esc_html__( 'Google Map URL', 'bixola-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d4562.753041141002!2d-118.80123790098536!3d34.152323469614075!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x80e82469c2162619%3A0xba03efb7998eef6d!2sCostco+Wholesale!5e0!3m2!1sbn!2sbd!4v1562518641290!5m2!1sbn!2sbd', 'bixola-core' ),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_style_design_layout',
            [
                'label' => esc_html__( 'Design Layout',  'bixola-core'  ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_responsive_control(
            'design_layout_margin',
            [
                'label' => esc_html__( 'Margin', 'bixola-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .appointment-one__inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .cta-two__inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'design_layout_padding',
            [
                'label' => esc_html__( 'Padding', 'bixola-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .appointment-one__inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .cta-two__inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'design_layout_background',
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .bixola-el-section, .appointment-one__inner, .cta-two__inner',
            ]
        );

        $this->add_control(
            'design_layout_border_color',
            [
                'label' => esc_html__( 'Border Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-page__left' => 'border-color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => 'layout-2',
                ],
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            '_style_title',
            [
                'label' => esc_html__( 'Title / Content', 'bixola-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            '_heading_style_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Title', 'bixola-core' ),
            ]
        );
        
        $this->add_responsive_control(
            'section_title_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'section_title_color',
            [
                'label' => esc_html__( 'Text Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section-title' => 'color: {{VALUE}}',
                    
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'section_title_typography',
                'selector' => '{{WRAPPER}} .bixola-el-section-title',
            ]
        );

        $this->add_control(
            '_heading_style_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Description', 'bixola-core' ),
                'separator' => 'before',
                'condition' => [
                    'design_style' => [ 'layout-1', 'layout-2', 'layout-3' ],
                ],
            ]
        );

        $this->add_responsive_control(
            'section_description_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section-description' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => [ 'layout-1', 'layout-2', 'layout-3' ],
                ],
            ]
        );

        $this->add_control(
            'section_description_color',
            [
                'label' => esc_html__( 'Text Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section-description' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => [ 'layout-1', 'layout-2', 'layout-3' ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'section_description_typography',
                'selector' => '{{WRAPPER}} .bixola-el-section-description',
                'condition' => [
                    'design_style' => [ 'layout-1', 'layout-2', 'layout-3' ],
                ],
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'_style_contact_form',
			[
				'label' => esc_html__( 'Contact Form', 'bixola-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
            '_heading_style_input_label',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Input Label', 'bixola-core' ),
                'condition' => [
                    'design_style' => [ 'layout-1', 'layout-2', 'layout-3' ],
                ],
            ]
        );

        $this->add_responsive_control(
            'input_label_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .contact-page__input-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .appointment-two__input-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => [ 'layout-1', 'layout-2', 'layout-3' ],
                ],
            ]
        );

        $this->add_control(
            'input_label_color',
            [
                'label' => esc_html__( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-page__input-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .appointment-two__input-title' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => [ 'layout-1', 'layout-2', 'layout-3' ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'input_label_typography',
                'selector' => '{{WRAPPER}} .contact-page__input-title, .appointment-two__input-title',
                'condition' => [
                    'design_style' => [ 'layout-1', 'layout-2', 'layout-3' ],
                ],
            ]
        );

        $this->add_control(
            '_heading_style_input',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Input', 'bixola-core' ),
            ]
        );

        $this->start_controls_tabs( '_form_input_tabs' );
        
        $this->start_controls_tab(
            'form_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'bixola-core' ),
            ]
        );
        
        $this->add_control(
            'input_color',
            [
                'label'     => esc_html__( 'Color', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .appointment-one__input-box input' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .contact-page__input-box input input' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .appointment-two__input-box input' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .appointment-one__input-box textarea' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .contact-page__input-box input textarea' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .appointment-two__input-box textarea' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .appointment-one__input-box input::placeholder' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .contact-page__input-box input::placeholder' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .appointment-two__input-box input::placeholder' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .appointment-one__input-box textarea::placeholder' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .contact-page__input-box textarea::placeholder' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .appointment-two__input-box textarea::placeholder' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .cta-two__input-box input[type="email"]' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .cta-two__input-box input[type="email"]::placeholder' => 'color: {{VALUE}} !important',
                ],
            ]
        );

		$this->add_control(
            'input_border_color',
            [
                'label'     => esc_html__( 'Border', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .appointment-one__input-box input' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .contact-page__input-box input' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .appointment-one__input-box textarea' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .contact-page__input-box textarea' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .appointment-two__input-box input' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .appointment-two__input-box textarea' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .cta-two__input-box input[type="email"]' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'form_focus_tab',
            [
                'label' => esc_html__( 'Focus', 'bixola-core' ),
            ]
        );

        $this->add_control(
            'input_color_focus',
            [
                'label'     => esc_html__( 'Color', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .appointment-one__input-box input::focus' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .contact-page__input-box input::focus' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .appointment-one__input-box textarea::focus' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .contact-page__input-box textarea::focus' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .appointment-two__input-box input::focus' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .appointment-two__input-box textarea::focus' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .cta-two__input-box input[type="email"]::focus' => 'color: {{VALUE}} !important',
                ],
            ]
        );

		$this->add_control(
            'input_border_color_focus',
            [
                'label'     => esc_html__( 'Border', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .appointment-one__input-box input::focus' => 'border-color: {{VALUE}} !important',
                    '{{WRAPPER}} .contact-page__input-box input::focus' => 'border-color: {{VALUE}} !important',
                    '{{WRAPPER}} .appointment-one__input-box textarea::focus' => 'border-color: {{VALUE}} !important',
                    '{{WRAPPER}} .contact-page__input-box textarea::focus' => 'border-color: {{VALUE}} !important',
                    '{{WRAPPER}} .appointment-two__input-box input::focus' => 'border-color: {{VALUE}} !important',
                    '{{WRAPPER}} .appointment-two__input-box textarea::focus' => 'border-color: {{VALUE}} !important',
                    '{{WRAPPER}} .cta-two__input-box input[type="email"]::focus' => 'border-color: {{VALUE}} !important',
                ],
            ]
        );
        
        $this->end_controls_tab();
        
        $this->end_controls_tabs();

        $this->add_control(
            '_heading_style_button',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Button', 'bixola-core' ),
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs( 'button_tabs' );
        
        $this->start_controls_tab(
            'button_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'bixola-core' ),
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label'     => esc_html__( 'Color', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn.appointment-one__btn'    => 'color: {{VALUE}}',
                    '{{WRAPPER}} .thm-btn.contact-page__btn'    => 'color: {{VALUE}}',
                    '{{WRAPPER}} .thm-btn-two.appointment-two__btn'    => 'color: {{VALUE}}',
                    '{{WRAPPER}} .cta-two__btn.thm-btn-two'    => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_background',
            [
                'label'     => esc_html__( 'Background', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn.appointment-one__btn' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .thm-btn.contact-page__btn' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .thm-btn-two.appointment-two__btn' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .cta-two__btn.thm-btn-two' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .thm-btn.appointment-one__btn, .thm-btn.contact-page__btn, .thm-btn-two.appointment-two__btn, .cta-two__btn.thm-btn-two',
            ]
        );
        
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            '_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'bixola-core' ),
            ]
        );
        
        $this->add_control(
            'button_color_hover',
            [
                'label'     => esc_html__( 'Color', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn.appointment-one__btn:hover'    => 'color: {{VALUE}}',
                    '{{WRAPPER}} .thm-btn.contact-page__btn:hover'    => 'color: {{VALUE}}',
                    '{{WRAPPER}} .thm-btn-two.appointment-two__btn:hover'    => 'color: {{VALUE}}',
                    '{{WRAPPER}} .cta-two__btn.thm-btn-two:hover'    => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_background_hover',
            [
                'label'     => esc_html__( 'Background', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn.appointment-one__btn:before' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .thm-btn.contact-page__btn:before' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .thm-btn-two.appointment-two__btn:before' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .cta-two__btn.thm-btn-two:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border_hover',
                'selector' => '{{WRAPPER}} .thm-btn.appointment-one__btn:hover, .thm-btn.contact-page__btn:hover, .thm-btn-two.appointment-two__btn:hover, .cta-two__btn.thm-btn-two:hover',
            ]
        );
        
        $this->end_controls_tab();
        
        $this->end_controls_tabs();

        $this->add_control(
            'input_border_radius',
            [
                'label'     => esc_html__( 'Border Radius', 'bixola-core' ),
                'type'      => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .thm-btn.appointment-one__btn' => 'border-radius: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .thm-btn.contact-page__btn' => 'border-radius: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .thm-btn-two.appointment-two__btn' => 'border-radius: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .cta-two__btn.thm-btn-two' => 'border-radius: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .thm-btn.appointment-one__btn:before' => 'border-radius: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .thm-btn.contact-page__btn:before' => 'border-radius: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .thm-btn-two.appointment-two__btn:before' => 'border-radius: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .cta-two__btn.thm-btn-two:before' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_section();
	}
	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		?>

            <?php if ( $settings['design_style']  == 'layout-1' ):
                
                $this->add_render_attribute('title_args', 'class', 'bixola-el-section-title appointment-one__title');
            
            ?>

                <section class="appointment-one">
                    <div class="appointment-one__inner">
                        <div class="container">
                            <div class="row">
                                <div class="col-xl-4 col-lg-5">
                                    <div class="appointment-one__left">
                                        <?php
                                            if ( !empty($settings['section_title' ]) ) :
                                                printf( '<%1$s %2$s>%3$s</%1$s>',
                                                    tag_escape( $settings['section_title_tag'] ),
                                                    $this->get_render_attribute_string( 'title_args' ),
                                                    twinkle_kses( $settings['section_title' ] )
                                                    );
                                            endif;
                                        ?>
                                        <?php if ( !empty($settings['section_description']) ) : ?>
                                            <p class="bixola-el-section-description appointment-one__text">
                                                <?php echo twinkle_kses( $settings['section_description'] ); ?>
                                            </p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-xl-8 col-lg-7">
                                    <div class="appointment-one__right">
                                        <div class="appointment-one__form-box">
                                            <?php if( !empty($settings['select_contact_form']) ) : ?>
                                                <?php echo do_shortcode( '[contact-form-7  id="'.$settings['select_contact_form'].'"]' ); ?>
                                            <?php else : ?>
                                                <?php echo '<div class="alert alert-info"><p class="m-0">' . __('Please Select contact form.', 'bixola-core' ). '</p></div>'; ?>
                                            <?php endif; ?>
                                            <div class="result"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            <?php elseif ( $settings['design_style']  == 'layout-2' ):  
                
                $this->add_render_attribute('title_args', 'class', 'bixola-el-section-title contact-page__title');
                
            ?>

                <section class="bixola-el-section contact-page">
                    <div class="container">
                        <div class="row">
                            <div class="col-xl-6 col-lg-6">
                                <div class="contact-page__left">
                                    <?php
                                        if ( !empty($settings['section_title' ]) ) :
                                            printf( '<%1$s %2$s>%3$s</%1$s>',
                                                tag_escape( $settings['section_title_tag'] ),
                                                $this->get_render_attribute_string( 'title_args' ),
                                                twinkle_kses( $settings['section_title' ] )
                                                );
                                        endif;
                                    ?>
                                    <?php if ( !empty($settings['section_description']) ) : ?>
                                        <p class="bixola-el-section-description contact-page__sub-title">
                                            <?php echo twinkle_kses( $settings['section_description'] ); ?>
                                        </p>
                                    <?php endif; ?>
                                    <div class="contact-page__form-box">
                                        <?php if( !empty($settings['select_contact_form']) ) : ?>
                                            <?php echo do_shortcode( '[contact-form-7  id="'.$settings['select_contact_form'].'"]' ); ?>
                                        <?php else : ?>
                                            <?php echo '<div class="alert alert-info"><p class="m-0">' . __('Please Select contact form.', 'bixola-core' ). '</p></div>'; ?>
                                        <?php endif; ?>
                                        <div class="result"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6 col-lg-6">
                                <div class="contact-page__right">
                                    <iframe src="<?php print esc_url($settings['google_map_url']); ?>" class="google-map__one" allowfullscreen=""></iframe>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            <?php elseif ( $settings['design_style']  == 'layout-3' ):  
                $this->add_render_attribute('title_args', 'class', 'bixola-el-section-title appointment-two__section-title');

                if ( !empty($settings['section_image']['url']) ) {
                    $section_image = !empty($settings['section_image']['id']) ? wp_get_attachment_image_url( $settings['section_image']['id'], 'full') : $settings['section_image']['url'];
                    $section_image_alt = get_post_meta($settings["section_image"]["id"], "_wp_attachment_image_alt", true);
                }

            ?>

                <section class="bixola-el-section appointment-two">
                    <?php if ( !empty( $settings['shape_switch'] ) ) : ?>
                        <div class="appointment-two__shape-2 float-bob-x">
                            <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/appointment-two-shape-2.png" alt="">
                        </div>
                    <?php endif; ?>
                    <div class="container">
                        <div class="row">
                            <div class="col-xl-5 col-lg-5">
                                <div class="appointment-two__left">
                                    <div class="appointment-two__img wow slideInLeft" data-wow-delay="100ms" data-wow-duration="2500ms">
                                        <?php if ( !empty( $settings['section_image'] ) ) : ?>
                                            <img src="<?php print esc_url($section_image); ?>" alt="<?php print esc_attr($section_image_alt); ?>">
                                        <?php endif; ?>
                                        <?php if ( !empty( $settings['shape_switch'] ) ) : ?>
                                            <div class="appointment-two__shape-1 float-bob-y">
                                                <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/appointment-two-shape-1.png" alt="">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-7 col-lg-7">
                                <div class="appointment-two__right">
                                    <?php
                                        if ( !empty($settings['section_title' ]) ) :
                                            printf( '<%1$s %2$s>%3$s</%1$s>',
                                                tag_escape( $settings['section_title_tag'] ),
                                                $this->get_render_attribute_string( 'title_args' ),
                                                twinkle_kses( $settings['section_title' ] )
                                                );
                                        endif;
                                    ?>
                                    <?php if ( !empty($settings['section_description']) ) : ?>
                                        <p class="bixola-el-section-description appointment-two__text">
                                            <?php echo twinkle_kses( $settings['section_description'] ); ?>
                                        </p>
                                    <?php endif; ?>
                                    <div class="appointment-two__form-box">
                                        <?php if( !empty($settings['select_contact_form']) ) : ?>
                                            <?php echo do_shortcode( '[contact-form-7  id="'.$settings['select_contact_form'].'"]' ); ?>
                                        <?php else : ?>
                                            <?php echo '<div class="alert alert-info"><p class="m-0">' . __('Please Select contact form.', 'bixola-core' ). '</p></div>'; ?>
                                        <?php endif; ?>
                                        <div class="result"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            <?php elseif ( $settings['design_style']  == 'layout-4' ):  
                $this->add_render_attribute('title_args', 'class', 'bixola-el-section-title cta-two__title');

                if ( !empty($settings['section_image']['url']) ) {
                    $section_image = !empty($settings['section_image']['id']) ? wp_get_attachment_image_url( $settings['section_image']['id'], 'full') : $settings['section_image']['url'];
                    $section_image_alt = get_post_meta($settings["section_image"]["id"], "_wp_attachment_image_alt", true);
                }

            ?>


                <section class="cta-two">
                    <div class="container">
                        <div class="cta-two__inner">
                            <?php if ( !empty( $settings['shape_switch'] ) ) : ?>
                                <div class="cta-two__shape-1 img-bounce">
                                    <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/cta-two-shape-1.png" alt="">
                                </div>
                                <div class="cta-two__shape-2 float-bob-y">
                                    <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/cta-two-shape-2.png" alt="">
                                </div>
                            <?php endif; ?>
                            <?php
                                if ( !empty($settings['section_title' ]) ) :
                                    printf( '<%1$s %2$s>%3$s</%1$s>',
                                        tag_escape( $settings['section_title_tag'] ),
                                        $this->get_render_attribute_string( 'title_args' ),
                                        twinkle_kses( $settings['section_title' ] )
                                        );
                                endif;
                            ?>
                            <?php if( !empty($settings['select_contact_form']) ) : ?>
                                <?php echo do_shortcode( '[contact-form-7  id="'.$settings['select_contact_form'].'"]' ); ?>
                            <?php else : ?>
                                <?php echo '<div class="alert alert-info"><p class="m-0">' . __('Please Select contact form.', 'bixola-core' ). '</p></div>'; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </section>

            <?php endif; ?>

        <?php 
	}
}

$widgets_manager->register( new Bixola_Contact_Form() );