<?php
namespace BixolaCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
Use \Elementor\Core\Schemes\Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Bixola Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Bixola_About extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bixola_about';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'About', 'bixola-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'bixola-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bixola_core' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'bixola-core' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

        // layout Panel
        $this->start_controls_section(
            'design_layout',
            [
                'label' => esc_html__('Design Layout', 'bixola-core'),
				'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label' => esc_html__('Select Layout', 'bixola-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'bixola-core'),
                    'layout-2' => esc_html__('Layout 2', 'bixola-core'),
                    'layout-3' => esc_html__('Layout 3', 'bixola-core'),
                    'layout-4' => esc_html__('Layout 4', 'bixola-core'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            '_content_title',
            [
                'label' => esc_html__('Title & Content', 'bixola-core'),
				'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'section_subheading',
            [
                'label' => esc_html__('Subtitle', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('About Us', 'bixola-core'),
                'placeholder' => esc_html__('Type Subtitle Text', 'bixola-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_title',
            [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'We are the best agency <br> to improve your deals.', 'bixola-core' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_description',
            [
                'label' => esc_html__( 'Description', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer.', 'bixola-core' ),
            ]
        );

        $this->add_control(
            'section_description_two',
            [
                'label' => esc_html__( 'Description Two', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer.', 'bixola-core' ),
                'condition' => [
                    'design_style' => [ 'layout-2', 'layout-3' ],
                ],
            ]
        );

        $this->add_control(
            'section_description_three',
            [
                'label' => esc_html__( 'Description Two', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer.', 'bixola-core' ),
                'condition' => [
                    'design_style' => [ 'layout-4' ],
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_features_one',
            [
                'label' => esc_html__( 'Features List', 'bixola-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => [ 'layout-1' ],
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'features_icon_type',
            [
                'label' => esc_html__( 'Image Type', 'text-domain' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'icon',
                'options' => [
                    'icon' => esc_html__( 'Icon', 'text-domain' ),
                    'image' => esc_html__( 'Image', 'text-domain' ),
                ],
            ]
        );
        
        $repeater->add_control(
            'features_image_icon',
            [
                'label' => esc_html__( 'Upload Image', 'text-domain' ),
                'type' => Controls_Manager::MEDIA,
                'condition' => [
                    'features_icon_type' => 'image',
                ],
            ]
        );
        
        $repeater->add_control(
            'features_icon',
            [
                'label' => esc_html__( 'Icon', 'text-domain' ),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'label_block' => true,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
                'condition' => [
                    'features_icon_type' => 'icon',
                ],
            ]
        );

        $repeater->add_control(
            'features_title', [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'features_list_one',
            [
                'label' => esc_html__('Features - List', 'bixola-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'features_title' => __('Strategy Craft Consultancy my consul', 'bixola-core'),
                    ],
                    [
                        'features_title' => __('Growth Sphere Solutions here', 'bixola-core')
                    ],
                    [
                        'features_title' => __('Visionary Business Alliesde our design', 'bixola-core')
                    ]
                ],
                'title_field' => '{{{ features_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_features_two',
            [
                'label' => esc_html__( 'Features List', 'bixola-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => [ 'layout-4' ],
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'features_title', [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'features_list_two',
            [
                'label' => esc_html__('Features - Left', 'bixola-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'features_title' => __('Core leve Design', 'bixola-core'),
                    ],
                    [
                        'features_title' => __('Pure Hand Work', 'bixola-core')
                    ],
                ],
                'title_field' => '{{{ features_title }}}',
            ]
        );

        $repeater->add_control(
            'features_title_two', [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'features_list_three',
            [
                'label' => esc_html__('Features - Right', 'bixola-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'features_title_two' => __('Solid Metarial', 'bixola-core')
                    ],
                    [
                        'features_title_two' => __('24/7 Online Support', 'bixola-core')
                    ],
                ],
                'title_field' => '{{{ features_title_two }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_about_image',
            [
                'label' => esc_html__('Image', 'bixola-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'shape_switch',
            [
                'label' => esc_html__( 'Show/Hide Shape', 'bixola-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'bixola-core' ),
                'label_off' => esc_html__( 'Hide', 'bixola-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'about_image',
            [
                'label' => esc_html__( 'Upload Image', 'bixola-core' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'about_image_two',
            [
                'label' => esc_html__( 'Upload Image', 'bixola-core' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'design_style' => [ 'layout-1', 'layout-3' ],
                ],
            ]
        );

        $this->add_control(
            'video_url',
            [
                'label' => esc_html__( 'Video URL', 'bixola-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'https://www.youtube.com/watch?v=Get7rqXYrbQ',
                'label_block' => true,
                'condition' => [
                    'design_style' => [ 'layout-2' ],
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_button',
            [
                'label' => esc_html__('Button', 'bixola-core'),
                'condition' => [
                    'design_style' => ['layout-1', 'layout-2', 'layout-4'],
                ],
            ]
        );

        $this->add_control(
            'bixola_button_text',
            [
                'label' => esc_html__('Button Text', 'bixola-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Learn More', 'bixola-core' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'bixola_btn_link_type',
            [
                'label' => esc_html__('Button Link Type', 'bixola-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'label_block' => true,
            ]
        );

        $this->add_control(
            'bixola_btn_link',
            [
                'label' => esc_html__('Button link', 'bixola-core'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('https://your-link.com', 'bixola-core'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'condition' => [
                    'bixola_btn_link_type' => '1',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'bixola_btn_page_link',
            [
                'label' => esc_html__('Select Button Page', 'bixola-core'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => bixola_get_all_pages(),
                'condition' => [
                    'bixola_btn_link_type' => '2',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_fun_fact',
            [
                'label' => esc_html__( 'Fun Fact', 'bixola-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => [ 'layout-2', 'layout-3' ],
                ],
            ]
        );

        $this->add_control(
            '_content_heading_fun_fact_one',
            [
                'label' => esc_html__( 'Fun Fact One', 'text-domain' ),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'fun_fact_count', [
                'label' => esc_html__( 'Count Number', 'bixola-core' ),
                'default' => '10',
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'fun_fact_sign', [
                'label' => esc_html__( 'Count Sign', 'bixola-core' ),
                'default' => esc_html__( '+', 'bixola-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'fun_fact_title', [
                'label' => esc_html__( 'Title', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'default' => __( 'Years Of <br> Experience', 'bixola-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            '_content_heading_fun_fact_two',
            [
                'label' => esc_html__( 'Fun Fact Two', 'text-domain' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'fun_fact_count_two', [
                'label' => esc_html__( 'Count Number', 'bixola-core' ),
                'default' => '8',
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'fun_fact_sign_two', [
                'label' => esc_html__( 'Count Sign', 'bixola-core' ),
                'default' => esc_html__( 'K', 'bixola-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'fun_fact_title_two', [
                'label' => esc_html__( 'Title', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'default' => __( 'Completed <br> project', 'bixola-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_year_experience',
            [
                'label' => esc_html__( 'Years of Experiences', 'bixola-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => [ 'layout-3', 'layout-4' ],
                ],
            ]
        );

        $this->add_control(
            'year_experiences_count', [
                'label' => esc_html__('Count Number', 'bixola-core'),
                'default' => '10',
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'year_experiences_sign', [
                'label' => esc_html__('Count Sign', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'default' => esc_html__('+', 'bixola-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'year_experiences_title', [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'default' => esc_html__('Years Of Experiences', 'bixola-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_design_layout',
            [
                'label' => esc_html__( 'Design Layout',  'text-domain'  ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_responsive_control(
            'design_layout_margin',
            [
                'label' => esc_html__( 'Margin', 'text-domain' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'design_layout_padding',
            [
                'label' => esc_html__( 'Padding', 'text-domain' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'design_layout_background',
            [
                'label' => esc_html__( 'Background', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_section();

		$this->start_controls_section(
			'_style_title',
			[
				'label' => __( 'Title & Content', 'bixola-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
            '_style_heading_subheading',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Subheading', 'bixola-core' ),
                'separator' => 'before',
                'condition' => [
                    'design_style' => ['layout-1', 'layout-2', 'layout-3', 'layout-4'],
                ],
            ]
        );

        $this->add_responsive_control(
            'subheading_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-sub-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => ['layout-1', 'layout-2', 'layout-3', 'layout-4'],
                ],
            ]
        );

        $this->add_control(
            'subheading_color',
            [
                'label' => __( 'Text Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-sub-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subheading_typography',
                'selector' => '{{WRAPPER}} .bixola-el-sub-title',
                'condition' => [
                    'design_style' => ['layout-1', 'layout-2', 'layout-3', 'layout-4'],
                ],
            ]
        );

        $this->add_control(
            '_style_heading_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Title', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-title' => 'padding-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Text Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .bixola-el-title',
            ]
        );

        // Description
        $this->add_control(
            '_content_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Description', 'bixola-core' ),
                'separator' => 'before',
                'condition' => [
                    'design_style' => ['layout-1', 'layout-2', 'layout-3', 'layout-4'],
                ],
            ]
        );

        $this->add_responsive_control(
            'description_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-desc' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => ['layout-1', 'layout-2', 'layout-3', 'layout-4'],
                ],
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => __( 'Text Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-desc' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => ['layout-1', 'layout-2', 'layout-3', 'layout-4'],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'selector' => '{{WRAPPER}} .bixola-el-desc',
                'condition' => [
                    'design_style' => ['layout-1', 'layout-2', 'layout-3', 'layout-4'],
                ],
            ]
        );

		$this->end_controls_section();

        // Features List
		$this->start_controls_section(
			'features_list_style',
			[
				'label' => __( 'Features List', 'bixola-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'design_style' => ['layout-1', 'layout-2', 'layout-3'],
                ],
			]
		);

        $this->add_control(
			'features_list_title',
			[
				'label' => esc_html__( 'Feature Title', 'bixola-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
			]
		);

        $this->add_responsive_control(
            'features_list_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bixola-fea-el-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'features_list_title_color',
            [
                'label' => __( 'Text', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-fea-el-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'features_list_title_typography',
                'selector' => '{{WRAPPER}} .bixola-fea-el-title',
            ]
        );

		$this->end_controls_section();


        // Fun Fact Style
        $this->start_controls_section(
			'funfact_list_style',
			[
				'label' => __( 'Fun Fact', 'bixola-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'design_style' => ['layout-1', 'layout-2', 'layout-3'],
                ],
			]
		);

        $this->add_control(
            'funfact_title_color',
            [
                'label' => __( 'Text', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fun-fact-el-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'funfact_title_typography',
                'selector' => '{{WRAPPER}} .fun-fact-el-title',
            ]
        );

        $this->add_control(
			'funfact_number_text',
			[
				'label' => esc_html__( 'Number', 'bixola-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
            'funfact_number_color',
            [
                'label' => __( 'Text', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fun-fact-el-number' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'funfact_num_typography',
                'selector' => '{{WRAPPER}} .fun-fact-el-number',
            ]
        );

		$this->end_controls_section();

        // Button
        $this->start_controls_section(
			'bixola_button_style',
			[
				'label' => __( 'Button', 'bixola-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->start_controls_tabs( 'tabs_button_style' );

        $this->start_controls_tab(
            'button_tab',
            [
                'label' => esc_html__( 'Normal', 'bixola-core' ),
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label'     => esc_html__( 'Text', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-button'    => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_background',
            [
                'label'     => esc_html__( 'Background', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-button' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'icon_border',
				'selector' => '{{WRAPPER}} .bixola-el-button'
			]
		);

        $this->add_responsive_control(
			'icon_border_radius',
			[
				'label' => __( 'Border Radius', 'bixola-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .bixola-el-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'bixola-core' ),
            ]
        );

        $this->add_control(
            'button_color_hover',
            [
                'label'     => esc_html__( 'Text', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-button:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_background_hover',
            [
                'label'     => esc_html__( 'Background', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-button:hover' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .bixola-el-button::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_hover_border_color',
            [
                'label'     => esc_html__( 'Border Color', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-button:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'button_border_radius',
            [
                'label'     => esc_html__( 'Border Radius', 'bixola-core' ),
                'type'      => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-button' => 'border-radius: {{SIZE}}px;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__( 'Typography', 'bixola-core' ),
                'name'     => 'button_typography',
                'selector' => '{{WRAPPER}} .bixola-el-button',
            ]
        );

        $this->add_control(
            'button_padding',
            [
                'label'      => esc_html__( 'Padding', 'bixola-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .bixola-el-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button_margin',
            [
                'label'      => esc_html__( 'Margin', 'bixola-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .bixola-el-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_section();


        // Award Wining Style Control
		$this->start_controls_section(
			'award_style',
			[
				'label' => __( 'Award Wining', 'bixola-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'design_style' => ['layout-3'],
                ],
			]
		);

        // Title
        $this->add_control(
            '_award_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Title', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'award_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-award-title' => 'padding-bottom: {{SIZE}}{{UNIT}};',
                ],
                'default' => [
					'unit' => 'px',
					'size' => 60,
				],
            ]
        );

        $this->add_control(
            'award_color',
            [
                'label' => __( 'Text Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-award-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'award_typography',
                'selector' => '{{WRAPPER}} .bixola-el-award-title',
            ]
        );

        // Description
        $this->add_control(
            '_content_award_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Description', 'bixola-core' ),
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'award_description_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-award-desc' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'award_description_color',
            [
                'label' => __( 'Text Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-award-desc' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'award_description_typography',
                'selector' => '{{WRAPPER}} .bixola-el-award-desc',
            ]
        );

		$this->end_controls_section();

        // video Button style control
        $this->start_controls_section(
            '_section_video_button_style',
            [
                'label' => esc_html__('Video Button', 'bixola-core'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'design_style' => ['layout-4'],
                ],
            ]
        );

        $this->start_controls_tabs('_tabs_video_button');

        $this->start_controls_tab(
            '_tab_video_button_normal',
            [
                'label' => esc_html__('Normal', 'bixola-core'),
            ]
        );

        $this->add_control(
            'video_icon_color',
            [
                'label' => esc_html__('Play Icon Color', 'bixola-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} a.bixola-el-video-btn svg path' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'video_icon_bg_color',
            [
                'label' => esc_html__('Play Icon BG Color', 'bixola-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-video-btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_video_normal_border_color',
            [
                'label'     => esc_html__( 'Border Color', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-video-btn' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_size',
            [
                'label' => esc_html__('Button Size', 'bixola-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 700,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-video-btn' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_video_button_hover',
            [
                'label' => esc_html__('Hover', 'bixola-core'),
            ]
        );

        $this->add_control(
            'video_icon_hover_color',
            [
                'label' => esc_html__('Play Icon Color', 'bixola-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} a.bixola-el-video-btn:hover svg path' => 'fill: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'video_icon_hover_bg_color',
            [
                'label' => esc_html__('Play Icon BG Color', 'bixola-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} a.bixola-el-video-btn:hover::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_video_border_color',
            [
                'label'     => esc_html__( 'Border Color', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-video-btn:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

        if ( !empty($settings['about_image']['url']) ) {
            $about_image = !empty($settings['about_image']['id']) ? wp_get_attachment_image_url( $settings['about_image']['id'], 'large') : $settings['about_image']['url'];
            $about_image_alt = get_post_meta($settings["about_image"]["id"], "_wp_attachment_image_alt", true);
        }

        if ( !empty($settings['about_image_two']['url']) ) {
            $about_image_two = !empty($settings['about_image_two']['id']) ? wp_get_attachment_image_url( $settings['about_image_two']['id'], 'large') : $settings['about_image_two']['url'];
            $about_image_two_alt = get_post_meta($settings["about_image_two"]["id"], "_wp_attachment_image_alt", true);
        }

		?>

        <?php if ( $settings['design_style']  == 'layout-1' ):

            if ('2' == $settings['bixola_btn_link_type']) {
                $this->add_render_attribute('bixola-button-arg', 'href', get_permalink($settings['bixola_btn_page_link']));
                $this->add_render_attribute('bixola-button-arg', 'target', '_self');
                $this->add_render_attribute('bixola-button-arg', 'rel', 'nofollow');
                $this->add_render_attribute('bixola-button-arg', 'class', 'bixola-el-button about-one__btn thm-btn' );
            } else {
                if ( ! empty( $settings['bixola_btn_link']['url'] ) ) {
                    $this->add_link_attributes( 'bixola-button-arg', $settings['bixola_btn_link'] );
                    $this->add_render_attribute('bixola-button-arg', 'class', 'bixola-el-button about-one__btn thm-btn');
                }
            }

        ?>

            <section class="bixola-el-section about-one">
                <?php if ( !empty ( $settings['shape_switch'] ) ) : ?>
                    <div class="about-one__shape-3 float-bob-y">
                        <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/about-one-shape-3.png" alt="<?php print esc_html( 'shape', 'bixola-core' ); ?>">
                    </div>
                    <div class="about-one__shape-4 img-bounce">
                        <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/about-one-shape-4.png" alt="<?php print esc_html( 'shape', 'bixola-core' ); ?>">
                    </div>
                <?php endif; ?>
                <div class="container">
                    <div class="row">
                        <div class="col-xl-6">
                            <div class="about-one__left">
                                <div class="about-one__img-box wow slideInLeft" data-wow-delay="100ms"
                                    data-wow-duration="2500ms">
                                    <?php if(!empty($about_image)) : ?>
                                        <div class="about-one__img">
                                            <img src="<?php echo esc_url($about_image); ?>" alt="<?php echo esc_attr($about_image_alt); ?>">
                                        </div>
                                    <?php endif; ?>
                                    <?php if(!empty($about_image_two)) : ?>
                                        <div class="about-one__img-2">
                                            <img src="<?php echo esc_url($about_image_two); ?>" alt="<?php echo esc_attr($about_image_two_alt); ?>">
                                        </div>
                                    <?php endif; ?>
                                    <?php if ( !empty ( $settings['shape_switch'] ) ) : ?>
                                        <div class="about-one__shape-1 float-bob-x">
                                            <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/about-one-shape-1.png" alt="<?php print esc_html( 'shape', 'bixola-core' ); ?>">
                                        </div>
                                        <div class="about-one__shape-2 float-bob-y">
                                            <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/about-one-shape-2.png" alt="<?php print esc_html( 'shape', 'bixola-core' ); ?>">
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="about-one__right">
                                <div class="section-title text-left">
                                    <?php if(!empty($settings['section_subheading'])): ?>
                                        <div class="section-title__tagline-box">
                                            <p class="bixola-el-subheading section-title__tagline"><?php echo $settings['section_subheading']; ?></p>
                                        </div>
                                    <?php endif; ?>
                                    <?php if(!empty($settings['section_title'])): ?>
                                        <h2 class="bixola-el-section-title section-title__title"><?php echo $settings['section_title']; ?></h2>
                                    <?php endif; ?>
                                </div>
                                <?php if(!empty($settings['section_description'])): ?>
                                    <p class="bixola-el-description about-one__text"><?php echo $settings['section_description']; ?></p>
                                <?php endif; ?>
                                <ul class="about-one__points list-unstyled">
                                    <?php foreach ($settings['features_list_one'] as $index => $item) : ?>
                                        <?php if(!empty($item['features_title'])): ?>
                                            <li>
                                                <?php if ( $item['features_icon_type']  == 'image' ): ?>
                                                    <div class="icon">
                                                        <img class="img-fluid" src="<?php echo $item['features_image_icon']['url']; ?>" alt="<?php echo get_post_meta(attachment_url_to_postid($item['features_image_icon']['url']), '_wp_attachment_image_alt', true); ?>">
                                                    </div>
                                                <?php elseif ( $item['features_icon_type']  == 'icon' ): ?>
                                                    <div class="icon">
                                                        <?php bixola_render_icon($item, 'features_icon' ); ?>
                                                    </div>
                                                <?php endif; ?>
                                                <div class="text">
                                                    <p><?php echo twinkle_kses($item['features_title']); ?></p>
                                                </div>
                                            </li>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </ul>
                                <?php if(!empty($settings['bixola_button_text'])): ?>
                                    <div class="about-one__btn-box">
                                        <a <?php echo $this->get_render_attribute_string( 'bixola-button-arg' ); ?>>
                                            <?php echo $settings['bixola_button_text']; ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        <?php elseif ( $settings['design_style']  == 'layout-2' ) : 

            // Link
            if ('2' == $settings['bixola_btn_link_type']) {
                $this->add_render_attribute('bixola-button-arg', 'href', get_permalink($settings['bixola_btn_page_link']));
                $this->add_render_attribute('bixola-button-arg', 'target', '_self');
                $this->add_render_attribute('bixola-button-arg', 'rel', 'nofollow');
                $this->add_render_attribute('bixola-button-arg', 'class', 'bixola-el-button about-two__btn thm-btn-two');
            } else {
                if ( ! empty( $settings['bixola_btn_link']['url'] ) ) {
                    $this->add_link_attributes( 'bixola-button-arg', $settings['bixola_btn_link'] );
                    $this->add_render_attribute('bixola-button-arg', 'class', 'bixola-el-button about-two__btn thm-btn-two');
                }
            }
        ?>

            <section class="bixola-el-section about-two">
                <?php if ( !empty ( $settings['shape_switch'] ) ) : ?>
                    <div class="about-two__shape-2 zoominout">
                        <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/about-two-shape-2.png" alt="<?php print esc_html( 'shape', 'bixola-core' ); ?>">
                    </div>
                    <div class="about-two__shape-3 float-bob-y">
                        <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/about-two-shape-3.png" alt="<?php print esc_html( 'shape', 'bixola-core' ); ?>">
                    </div>
                <?php endif; ?>
                <div class="container">
                    <div class="row">
                        <div class="col-xl-6 col-lg-6">
                            <div class="about-two__left">
                                <?php if(!empty($settings['section_title'])): ?>
                                    <h2 class="bixola-el-title about-two__title">
                                        <?php echo $settings['section_title']; ?>
                                    </h2>
                                <?php endif; ?>

                                <?php if(!empty($settings['section_description'])): ?>
                                    <p class="bixola-el-description about-two__text">
                                        <?php echo $settings['section_description']; ?>
                                    </p>
                                <?php endif; ?>

                                <?php if(!empty($settings['section_description_two'])): ?>
                                    <p class="bixola-el-description-two about-two__text-2">
                                        <?php echo $settings['section_description_two']; ?>
                                    </p>
                                <?php endif; ?>

                                <ul class="about-two__points list-unstyled">
                                    <?php if ( !empty ($settings['fun_fact_title']) ) : ?>
                                        <li>
                                            <div class="about-two__count count-box">
                                                <h3
                                                    class="count-text"
                                                    data-stop="<?php print esc_attr($settings['fun_fact_count']); ?>"
                                                    data-speed="1500">
                                                    <?php print esc_html( '00', 'bixola-core' ); ?>
                                                </h3>
                                                <?php if ( !empty ($settings['fun_fact_sign']) ) : ?>
                                                    <span><?php print twinkle_kses($settings['fun_fact_sign']); ?></span>
                                                <?php endif; ?>
                                            </div>
                                            <p><?php print twinkle_kses($settings['fun_fact_title']); ?></p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if ( !empty ($settings['fun_fact_title_two']) ) : ?>
                                        <li>
                                            <div class="about-two__count count-box">
                                                <h3
                                                    class="count-text"
                                                    data-stop="<?php print esc_attr($settings['fun_fact_count_two']); ?>"
                                                    data-speed="1500">
                                                    <?php print esc_html( '00', 'bixola-core' ); ?>
                                                </h3>
                                                <?php if ( !empty ($settings['fun_fact_sign_two']) ) : ?>
                                                    <span><?php print twinkle_kses($settings['fun_fact_sign_two']); ?></span>
                                                <?php endif; ?>
                                            </div>
                                            <p><?php print twinkle_kses($settings['fun_fact_title_two']); ?></p>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                                <?php if(!empty($settings['bixola_button_text'])): ?>
                                    <div class="about-two__btn-box">
                                        <a <?php echo $this->get_render_attribute_string( 'bixola-button-arg' ); ?>>
                                            <?php echo $settings['bixola_button_text']; ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-6">
                            <div class="about-two__right">
                                <div class="about-two__img wow slideInRight" data-wow-delay="100ms" data-wow-duration="2500ms">
                                    <?php if ( !empty ( $settings['shape_switch'] ) ) : ?>
                                        <div class="about-two__shape-1 img-bounce">
                                            <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/about-two-shape-1.png" alt="<?php print esc_html( 'shape', 'bixola-core' ); ?>">
                                        </div>
                                    <?php endif; ?>
                                    <?php if ( !empty ( $about_image ) ) : ?>
                                        <img src="<?php print esc_url($about_image); ?>" alt="<?php print esc_attr($about_image_alt); ?>">
                                    <?php endif; ?>
                                    <?php if ( !empty($settings['video_url']) ) : ?>
                                        <div class="about-two__video-link">
                                            <a href="<?php print esc_url($settings['video_url']); ?>" class="video-popup">
                                                <div class="about-two__video-icon">
                                                    <span class="fa fa-play"></span>
                                                    <i class="ripple"></i>
                                                </div>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>


        <?php elseif ( $settings['design_style']  == 'layout-3' ) : 

            if ('2' == $settings['bixola_btn_link_type']) {
                $this->add_render_attribute('bixola-button-arg', 'href', get_permalink($settings['bixola_btn_page_link']));
                $this->add_render_attribute('bixola-button-arg', 'target', '_self');
                $this->add_render_attribute('bixola-button-arg', 'rel', 'nofollow');
                $this->add_render_attribute('bixola-button-arg', 'class', 'bixola-el-button rs-btn');
            } else {
                if ( ! empty( $settings['bixola_btn_link']['url'] ) ) {
                    $this->add_link_attributes( 'bixola-button-arg', $settings['bixola_btn_link'] );
                    $this->add_render_attribute('bixola-button-arg', 'class', 'bixola-el-button rs-btn');
                }
            }
        ?>

            <section class="bixola-el-section about-three">
                <?php if ( !empty ( $settings['shape_switch'] ) ) : ?>
                    <div class="about-three__shape-5">
                        <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/about-three-shape-5.png" alt="<?php print esc_html( 'shape', 'bixola-core' ); ?>">
                    </div>
                    <div class="about-three__shape-3 float-bob-x">
                        <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/about-three-shape-3.png" alt="<?php print esc_html( 'shape', 'bixola-core' ); ?>">
                    </div>
                    <div class="about-three__shape-4 float-bob-y">
                        <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/about-three-shape-4.png" alt="<?php print esc_html( 'shape', 'bixola-core' ); ?>">
                    </div>
                <?php endif; ?>
                <div class="container">
                    <div class="row">
                        <div class="col-xl-6">
                            <div class="about-three__left">
                                <div class="about-three__img wow slideInLeft" data-wow-delay="100ms" data-wow-duration="2500ms">
                                    <?php if ( !empty ($about_image) ) : ?>
                                        <img src="<?php echo esc_url($about_image); ?>" alt="<?php echo esc_attr($about_image_alt); ?>">
                                    <?php endif; ?>
                                    <div class="about-three__experience">
                                        <div class="about-three__experience-count count-box">
                                            <h3 class="count-text" data-stop="<?php print esc_attr($settings['year_experiences_count']); ?>" data-speed="1500">
                                                <?php print esc_html( '00', 'bixola-core' ); ?>
                                            </h3>
                                            <span><?php print twinkle_kses($settings['year_experiences_sign']); ?></span>
                                        </div>
                                        <p class="about-three__experience-text">
                                            <?php print twinkle_kses($settings['year_experiences_title']); ?>
                                        </p>
                                    </div>
                                    <?php if ( !empty ( $settings['shape_switch'] ) ) : ?>
                                        <div class="about-three__shape-1 zoominout">
                                            <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/about-three-shape-1.png" alt="">
                                        </div>
                                        <div class="about-three__shape-2 float-bob-y">
                                            <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/about-three-shape-2.png" alt="">
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="about-three__right">
                                <div class="section-title-three text-left">
                                    <?php if ( !empty( $settings['section_subheading'] ) ) : ?>
                                        <div class="section-title-three__tagline-box">
                                            <p class="bixola-el-section-subheading section-title-three__tagline">
                                                <?php print twinkle_kses($settings['section_subheading']); ?>
                                            </p>
                                        </div>
                                    <?php endif; ?>
                                    <?php if ( !empty( $settings['section_title'] ) ) : ?>
                                        <h2 class="bixola-el-section-title section-title-three__title">
                                            <?php print twinkle_kses($settings['section_title']); ?>
                                        </h2>
                                    <?php endif; ?>
                                </div>
                                <?php if ( !empty( $settings['section_description'] ) ) : ?>
                                    <p class="bixola-el-section-description about-three__text-1">
                                        <?php print twinkle_kses($settings['section_description']); ?>
                                    </p>
                                <?php endif; ?>
                                <?php if ( !empty( $settings['section_description_two'] ) ) : ?>
                                    <p class="bixola-el-section-two about-three__text-2">
                                        <?php print twinkle_kses($settings['section_description_two']); ?>
                                    </p>
                                <?php endif; ?>
                                
                                <ul class="about-three__points list-unstyled">
                                    <?php if ( !empty ($settings['fun_fact_title']) ) : ?>
                                        <li>
                                            <div class="about-three__points-count count-box">
                                                <h3
                                                    class="count-text"
                                                    data-stop="<?php print esc_attr($settings['fun_fact_count']); ?>"
                                                    data-speed="1500">
                                                    <?php print esc_html( '00', 'bixola-core' ); ?>
                                                </h3>
                                                <?php if ( !empty ($settings['fun_fact_sign']) ) : ?>
                                                    <span><?php print twinkle_kses($settings['fun_fact_sign']); ?></span>
                                                <?php endif; ?>
                                            </div>
                                            <p class="about-three__points-text">
                                                <?php print twinkle_kses($settings['fun_fact_title']); ?>
                                            </p>
                                        </li>
                                    <?php endif; ?>
                                    <?php if ( !empty ($settings['fun_fact_title_two']) ) : ?>
                                        <li>
                                            <div class="about-three__points-count count-box">
                                                <h3
                                                    class="count-text"
                                                    data-stop="<?php print esc_attr($settings['fun_fact_count_two']); ?>"
                                                    data-speed="1500">
                                                    <?php print esc_html( '00', 'bixola-core' ); ?>
                                                </h3>
                                                <?php if ( !empty ($settings['fun_fact_sign_two']) ) : ?>
                                                    <span><?php print twinkle_kses($settings['fun_fact_sign_two']); ?></span>
                                                <?php endif; ?>
                                            </div>
                                            <p class="about-three__points-text">
                                                <?php print twinkle_kses($settings['fun_fact_title_two']); ?>
                                            </p>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        <?php elseif ( $settings['design_style']  == 'layout-4' ) :

            if ('2' == $settings['bixola_btn_link_type']) {
                $this->add_render_attribute( 'bixola-button-arg', 'href', get_permalink($settings['bixola_btn_page_link']) );
                $this->add_render_attribute( 'bixola-button-arg', 'target', '_self' );
                $this->add_render_attribute( 'bixola-button-arg', 'rel', 'nofollow' );
                $this->add_render_attribute( 'bixola-button-arg', 'class', 'bixola-el-button about-four__btn thm-btn' );
            } else {
                if ( ! empty( $settings['bixola_btn_link']['url'] ) ) {
                    $this->add_link_attributes( 'bixola-button-arg', $settings['bixola_btn_link'] );
                    $this->add_render_attribute( 'bixola-button-arg', 'class', 'bixola-el-button about-four__btn thm-btn' );
                }
            }

        ?>

            <section class="bixola-el-section about-four">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-6">
                            <div class="about-four__left">
                                <div class="about-four__img wow slideInLeft" data-wow-delay="100ms" data-wow-duration="2500ms">
                                    <?php if ( !empty ($about_image) ) : ?>
                                        <img src="<?php echo esc_url($about_image); ?>" alt="<?php echo esc_attr($about_image_alt); ?>">
                                    <?php endif; ?>
                                    <div class="about-four__experience">
                                        <div class="about-four__experience-count count-box">
                                            <h3 class="count-text" data-stop="<?php print esc_attr($settings['year_experiences_count']); ?>" data-speed="1500">
                                                <?php print esc_html( '00', 'bixola-core' ); ?>
                                            </h3>
                                            <span><?php print twinkle_kses($settings['year_experiences_sign']); ?></span>
                                        </div>
                                        <p class="about-four__experience-text">
                                            <?php print twinkle_kses($settings['year_experiences_title']); ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="about-four__right">
                                <div class="section-title-three text-left">
                                    <?php if ( !empty( $settings['section_subheading'] ) ) : ?>
                                        <div class="section-title-three__tagline-box">
                                            <p class="bixola-el-section-subheading section-title-three__tagline">
                                                <?php print twinkle_kses($settings['section_subheading']); ?>
                                            </p>
                                        </div>
                                    <?php endif; ?>
                                    <?php if ( !empty( $settings['section_title'] ) ) : ?>
                                        <h2 class="bixola-el-section-title section-title-three__title">
                                            <?php print twinkle_kses($settings['section_title']); ?>
                                        </h2>
                                    <?php endif; ?>
                                </div>
                                <?php if ( !empty( $settings['section_description'] ) ) : ?>
                                    <p class="bixola-el-section-description about-four__text-1">
                                        <?php print twinkle_kses($settings['section_description']); ?>
                                    </p>
                                <?php endif; ?>
                                <?php if ( !empty( $settings['section_description_two'] ) ) : ?>
                                    <p class="bixola-el-section-description-two about-four__text-2">
                                        <?php print twinkle_kses($settings['section_description_two']); ?>
                                    </p>
                                <?php endif; ?>
                                <?php if ( !empty( $settings['section_description_three'] ) ) : ?>
                                    <p class="bixola-el-section-description-three about-four__text-3">
                                        <?php print twinkle_kses($settings['section_description_three']); ?>
                                    </p>
                                <?php endif; ?>
                                <div class="about-four__points-box">
                                    <ul class="about-four__points list-unstyled">
                                        <?php foreach ($settings['features_list_two'] as $index => $item) : ?>
                                            <?php if(!empty($item['features_title'])): ?>
                                                <li>
                                                    <div class="about-four__points-shape-1"></div>
                                                    <p><?php echo twinkle_kses($item['features_title']); ?></p>
                                                </li>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </ul>
                                    <ul class="about-four__points about-four__points-2 list-unstyled">
                                        <?php foreach ($settings['features_list_three'] as $index => $item) : ?>
                                            <?php if(!empty($item['features_title_two'])): ?>
                                                <li>
                                                    <div class="about-four__points-shape-1"></div>
                                                    <p><?php echo twinkle_kses($item['features_title_two']); ?></p>
                                                </li>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                                <div class="about-four__btn-box">
                                    <a <?php echo $this->get_render_attribute_string( 'bixola-button-arg' ); ?>>
                                        <?php echo $settings['bixola_button_text']; ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        <?php endif;
	}
}

$widgets_manager->register( new Bixola_About() );