<?php 
class BixolaServicesPost 
{
	function __construct() {
		add_action( 'init', array( $this, 'register_custom_post_type' ) );
		add_action( 'init', array( $this, 'create_cat' ) );
		add_filter( 'template_include', array( $this, 'services_template_include' ) );
	}
	
	public function services_template_include( $template ) {
		if ( is_singular( 'services' ) ) {
			return $this->get_template( 'single-services.php');
		}
		return $template;
	}
	
	public function get_template( $template ) {
		if ( $theme_file = locate_template( array( $template ) ) ) {
			$file = $theme_file;
		} 
		else {
			$file = BIXOLA_CORE_ADDONS_DIR . '/include/template/'. $template;
		}
		return apply_filters( __FUNCTION__, $file, $template );
	}
	
	
	public function register_custom_post_type() {
		$labels = array(
			'name'                  => esc_html_x( 'Services', 'Post Type General Name', 'bixola-core' ),
			'singular_name'         => esc_html_x( 'Service', 'Post Type Singular Name', 'bixola-core' ),
			'menu_name'             => esc_html__( 'Services', 'bixola-core' ),
			'name_admin_bar'        => esc_html__( 'Service', 'bixola-core' ),
			'archives'              => esc_html__( 'Item Archives', 'bixola-core' ),
			'parent_item_colon'     => esc_html__( 'Parent Item:', 'bixola-core' ),
			'all_items'             => esc_html__( 'All Items', 'bixola-core' ),
			'add_new_item'          => esc_html__( 'Add New Service', 'bixola-core' ),
			'add_new'               => esc_html__( 'Add New', 'bixola-core' ),
			'new_item'              => esc_html__( 'New Item', 'bixola-core' ),
			'edit_item'             => esc_html__( 'Edit Item', 'bixola-core' ),
			'update_item'           => esc_html__( 'Update Item', 'bixola-core' ),
			'view_item'             => esc_html__( 'View Item', 'bixola-core' ),
			'search_items'          => esc_html__( 'Search Item', 'bixola-core' ),
			'not_found'             => esc_html__( 'Not found', 'bixola-core' ),
			'not_found_in_trash'    => esc_html__( 'Not found in Trash', 'bixola-core' ),
			'featured_image'        => esc_html__( 'Featured Image', 'bixola-core' ),
			'set_featured_image'    => esc_html__( 'Set featured image', 'bixola-core' ),
			'remove_featured_image' => esc_html__( 'Remove featured image', 'bixola-core' ),
			'use_featured_image'    => esc_html__( 'Use as featured image', 'bixola-core' ),
			'inserbt_into_item'     => esc_html__( 'Insert into item', 'bixola-core' ),
			'uploaded_to_this_item' => esc_html__( 'Uploaded to this item', 'bixola-core' ),
			'items_list'            => esc_html__( 'Items list', 'bixola-core' ),
			'items_list_navigation' => esc_html__( 'Items list navigation', 'bixola-core' ),
			'filter_items_list'     => esc_html__( 'Filter items list', 'bixola-core' ),
		);

		$args   = array(
			'label'                 => esc_html__( 'Service', 'bixola-core' ),
			'labels'                => $labels,
			'supports'              => array( 'title', 'editor', 'excerpt', 'thumbnail'),
			'hierarchical'          => false,
			'public'                => true,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'menu_position'         => 5,
			'menu_icon'   			=> 'dashicons-shield',
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => true,
			'can_export'            => true,
			'has_archive'           => true,		
			'exclude_from_search'   => false,
			'publicly_queryable'    => true,
			'capability_type'       => 'page',
		);

		register_post_type( 'services', $args );
	}
	
	public function create_cat() {
		$labels = array(
			'name'                       => esc_html_x( 'Service Categories', 'Taxonomy General Name', 'bixola-core' ),
			'singular_name'              => esc_html_x( 'Service Categories', 'Taxonomy Singular Name', 'bixola-core' ),
			'menu_name'                  => esc_html__( 'Service Categories', 'bixola-core' ),
			'all_items'                  => esc_html__( 'All Service Category', 'bixola-core' ),
			'parent_item'                => esc_html__( 'Parent Item', 'bixola-core' ),
			'parent_item_colon'          => esc_html__( 'Parent Item:', 'bixola-core' ),
			'new_item_name'              => esc_html__( 'New Service Category Name', 'bixola-core' ),
			'add_new_item'               => esc_html__( 'Add New Service Category', 'bixola-core' ),
			'edit_item'                  => esc_html__( 'Edit Service Category', 'bixola-core' ),
			'update_item'                => esc_html__( 'Update Service Category', 'bixola-core' ),
			'view_item'                  => esc_html__( 'View Service Category', 'bixola-core' ),
			'separate_items_with_commas' => esc_html__( 'Separate items with commas', 'bixola-core' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove items', 'bixola-core' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used', 'bixola-core' ),
			'popular_items'              => esc_html__( 'Popular Service Category', 'bixola-core' ),
			'search_items'               => esc_html__( 'Search Service Category', 'bixola-core' ),
			'not_found'                  => esc_html__( 'Not Found', 'bixola-core' ),
			'no_terms'                   => esc_html__( 'No Service Category', 'bixola-core' ),
			'items_list'                 => esc_html__( 'Service Category list', 'bixola-core' ),
			'items_list_navigation'      => esc_html__( 'Service Category list navigation', 'bixola-core' ),
		);

		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
		);

		register_taxonomy('services-cat','services', $args );
	}

}

new BixolaServicesPost();