<?php if ( !defined( 'ABSPATH' ) ) {die;} // Cannot access directly.

CSF::createWidget( 'bixola_footer_contact_info_two', array(
    'title'       => 'Bixola Footer Contact Info Two',
    'classname'   => 'bixola_footer_contact_info_two',
    'description' => 'Show Footer Contact Info Two Widget By Bixola',
    'fields'      => array(

        array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => esc_html__( 'Title', 'bixola-core' ),
        ),

        array(
            'id'    => 'address',
            'type'  => 'text',
            'title' => esc_html__( 'Address', 'bixola-core' ),
            'default' => esc_html__( '915 Hill Street, USA', 'bixola-core' ),
        ),

        array(
            'id'    => 'phone_number_label',
            'type'  => 'text',
            'title' => esc_html__( 'Phone Number Label', 'bixola-core' ),
            'default' => esc_html__( '+1(333) 000-0000', 'bixola-core' ),
        ),

        array(
            'id'    => 'phone_number',
            'type'  => 'text',
            'title' => esc_html__( 'Phone Number Link', 'bixola-core' ),
            'default' => '+13330000000',
        ),

        array(
            'id'    => 'mail_id',
            'type'  => 'text',
            'title' => esc_html__( 'Mail ID', 'bixola-core' ),
            'default' => esc_html__( 'example@email.com', 'bixola-core' ),
        ),

        array(
            'id'    => 'working_time_label',
            'type'  => 'text',
            'title' => esc_html__( 'Phone Number Link', 'bixola-core' ),
            'default' => esc_html__( 'Working Time', 'bixola-core' ),
        ),

        array(
            'id'    => 'working_time',
            'type'  => 'text',
            'title' => esc_html__( 'Working Time', 'bixola-core' ),
            'default' => __( 'Mon - Sat: 9:00 AM - 5:00 PM <br> Sunday Close', 'bixola-core' ),
        ),

    ),
) );

if ( !function_exists( 'bixola_footer_contact_info_two' ) ) {
    function bixola_footer_contact_info_two( $args, $instance ) {

        echo $args['before_widget'];

		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
		}

		?>

			<ul class="footer-widget-two__contact-list list-unstyled">
				<?php if( !empty ( $instance['address'] ) ): ?>
					<li>
						<div class="icon">
							<span class="icon-location-1"></span>
						</div>
						<p><?php print esc_html($instance['address']); ?></p>
					</li>
				<?php endif; ?>
				<?php if( !empty ( $instance['phone_number_label'] ) ): ?>
					<li>
						<div class="icon">
							<span class="icon-phone"></span>
						</div>
						<p>
							<a href="tel:<?php print esc_attr($instance['phone_number']); ?>">
								<?php print esc_html($instance['phone_number_label']); ?>
							</a>
						</p>
					</li>
				<?php endif; ?>
				<?php if( !empty ( $instance['mail_id'] ) ): ?>
					<li>
						<div class="icon">
							<span class="icon-envelope"></span>
						</div>
						<p>
							<a href="mailto:<?php print esc_attr($instance['mail_id']); ?>">
								<?php print esc_html($instance['mail_id']); ?>
							</a>
						</p>
					</li>
				<?php endif; ?>
			</ul>
			<?php if( !empty ( $instance['working_time_label'] ) ): ?>
				<div class="footer-widget-two__work-time">
					<div class="footer-widget-two__title-box">
						<h3 class="footer-widget-two__title">
							<?php print esc_html($instance['working_time_label']); ?>
						</h3>
					</div>
					<p class="footer-widget-two__work-time-text">
						<?php print twinkle_kses($instance['working_time']); ?>
					</p>
				</div>
			<?php endif; ?>

		<?php

        echo $args['after_widget'];

    }
}