<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

function bixola_custom_icons_tab( $custom_icons_included = array() ) {

	$custom_icons = array(
		'icon-chat-1',
		'icon-phone-call',
		'icon-gmail',
		'icon-location-2',
		'icon-user-2',
		'icon-category',
		'icon-date11',
		'icon-location11',
		'icon-website1',
		'icon-check',
		'icon-icon-business-audit',
		'icon-icon-tax-strategy',
		'icon-financial-advice',
		'icon-icon-insurance-strategy',
		'icon-icon-start-ups',
		'icon-icon-manage-investment',
		'icon-report',
		'icon-planning',
		'icon-financial-advices11',
		'icon-tax-strategy11',
		'icon-icon-years-experience',
		'icon-icon-team-members',
		'icon-icon-successful-project',
		'icon-icon-satisfied-clients',
		'icon-bank-building',
		'icon-assets',
		'icon-icon-business-consulting',
		'icon-icon-customer-support',
		'icon-solution',
		'icon-diversity',
		'icon-woman',
		'icon-business-advice',
		'icon-risk-management',
		'icon-right-arrow1',
	);

    $custom_icons_included['bixola-icons'] = array(
		'name'          => 'bixola-icons',
		'label'         => esc_html__( 'Bixola Icons', 'bixola-core' ),
		'labelIcon'     => 'bixola-icon',
        'prefix'        => '',
        'displayPrefix' => '',
        'url'           => BIXOLA_CORE_ADDONS_ASSETS . 'vendors/bixola-icons/bixola-icons.css',
		'icons'         => $custom_icons,
		'ver'           => '1.0.0',
    );

	return $custom_icons_included;
}
        
// Register Icons
add_filter( 'elementor/icons_manager/additional_tabs', 'bixola_custom_icons_tab' );