<?php
namespace BixolaCore\Widgets;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
use \Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Bixola
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Bixola_Work_Process extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bixola_work_process';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Work Process', 'bixola-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'bixola-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bixola_core' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'bixola-core' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

        $this->start_controls_section(
            '_content_title',
            [
                'label' => esc_html__( 'Title & Content', 'bixola-core' ),
            ]
        );

        $this->add_control(
            'section_title',
            [
                'label' => esc_html__( 'Title', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Our Work process', 'bixola-core' ),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_work_process',
            [
                'label' => esc_html__('Work Process', 'bixola-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'shape_switch',
            [
                'label' => esc_html__( 'Shape Switch', 'text-domain' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'text-domain' ),
                'label_off' => esc_html__( 'Hide', 'text-domain' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'work_process_title', [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'work_process_description',
            [
                'label' => esc_html__('Description', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('wLorem ipsum dolor sit amet designersi consectetur adipiscing here', 'bixola-core'),
                'placeholder' => esc_html__('Type section description here', 'bixola-core'),
            ]
        );

        $this->add_control(
            'work_process_list',
            [
                'label' => esc_html__('Work Process', 'bixola-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'work_process_title' => __('Identifying Problems', 'bixola-core'),
                        'work_process_description' => __('Lorem ipsum dolor sit amet, adipiscing elit, sed do eiusmod ut dolore magna aliqua.', 'bixola-core'),
                    ],
                    [
                        'work_process_title' => __('Research Your Problem', 'bixola-core'),
                        'work_process_description' => __('Lorem ipsum dolor sit amet, adipiscing elit, sed do eiusmod ut dolore magna aliqua.', 'bixola-core'),
                    ],
                    [
                        'work_process_title' => __('Solutions Your Problem', 'bixola-core'),
                        'work_process_description' => __('Lorem ipsum dolor sit amet, adipiscing elit, sed do eiusmod ut dolore magna aliqua.', 'bixola-core'),
                    ],
                    [
                        'work_process_title' => __('Consultation With Experts', 'bixola-core'),
                        'work_process_description' => __('Lorem ipsum dolor sit amet, adipiscing elit, sed do eiusmod ut dolore magna aliqua.', 'bixola-core'),
                    ],
                ],
                'title_field' => '{{{ work_process_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_style_design_layout',
            [
                'label' => esc_html__( 'Design Layout', 'bixola-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'design_layout_margin',
            [
                'label' => esc_html__( 'Margin', 'bixola-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'design_layout_padding',
            [
                'label' => esc_html__( 'Padding', 'bixola-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'design_layout_background',
            [
                'label' => esc_html__( 'Background', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_style_title',
            [
                'label' => esc_html__( 'Title', 'bixola-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            '_heading_style_title',
            [
                'label' => esc_html__( 'Title', 'bixola-core' ),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_responsive_control(
            'section_title_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .section__title-two' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'section_title_color',
            [
                'label' => esc_html__( 'Text Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section__title-two' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'section_title_typography',
                'selector' => '{{WRAPPER}} .section__title-two',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_style_work_process',
            [
                'label' => esc_html__( 'Work Process', 'bixola-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            '_heading_style_work_process_number',
            [
                'label' => esc_html__( 'Number', 'bixola-core' ),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->start_controls_tabs( '_tabs_work_process_number' );
        
        $this->start_controls_tab(
            'work_process_number_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'text-domain' ),
            ]
        );
        
        $this->add_control(
            'work_process_number_color',
            [
                'label' => esc_html__( 'Color', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .process-one__count:before' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'work_process_number_stroke_color',
            [
                'label' => esc_html__( 'Stroke Color', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .process-one__count:before' => '-webkit-text-stroke: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'work_process_number_background',
            [
                'label' => esc_html__( 'Background', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .process-one__count' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'work_process_number_border',
                'selector' => '{{WRAPPER}} .process-one__count',
            ]
        );
        
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'work_process_number_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'text-domain' ),
            ]
        );
        
        $this->add_control(
            'work_process_number_color_hover',
            [
                'label' => esc_html__( 'Color', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .process-one__single:hover .process-one__count:before' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'work_process_number_stroke_color_hover',
            [
                'label' => esc_html__( 'Stroke Color', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .process-one__single:hover .process-one__count:before' => '-webkit-text-stroke: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'work_process_number_background_hover',
            [
                'label' => esc_html__( 'Background', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .process-one__single:hover .process-one__count' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'work_process_number_border_hover',
                'selector' => '{{WRAPPER}} .process-one__single:hover .process-one__count',
            ]
        );
        
        $this->end_controls_tab();
        
        $this->end_controls_tabs();

        $this->add_control(
            '_heading_style_work_process',
            [
                'label' => esc_html__( 'Title', 'bixola-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'work_process_title_color',
            [
                'label' => esc_html__( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .process-one__title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'work_process_title_typography',
                'selector' => '{{WRAPPER}} .process-one__title',
            ]
        );

        $this->add_control(
            '_heading_style_work_process_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Description', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'work_process_description_color',
            [
                'label' => esc_html__( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .process-one__text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'work_process_description_typography',
                'selector' => '{{WRAPPER}} .process-one__text',
            ]
        );

        $this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $this->add_render_attribute('title_args', [
			'class' => 'section-title wow fade-in-bottom',
			'data-wow-delay' => '500ms',
		] );
         
	    ?>

            <section class="bixola-el-section process-one">
                <div class="container">
                    <?php if ( !empty( $settings['section_title'] ) ) : ?>
                        <h3 class="section__title-two">
                            <?php print twinkle_kses($settings['section_title']); ?>
                        </h3>
                    <?php endif; ?>
                    <div class="process-one__inner">
                        <?php if ( !empty( $settings['shape_switch'] ) ) : ?>
                            <div class="process-one__shape-1">
                                <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/process-one-shape-1.png" alt="">
                            </div>
                        <?php endif; ?>
                        <div class="row">
                            <?php foreach ($settings['work_process_list'] as $key => $item) : ?>
                                <div class="col-xl-3 col-lg-6 col-md-6">
                                    <div class="process-one__single">
                                        <div class="process-one__count"></div>
                                        <?php if(!empty($item['work_process_title' ])): ?>
                                            <h3 class="process-one__title">
                                                <?php echo twinkle_kses($item['work_process_title' ]); ?>
                                            </h3>
                                        <?php endif; ?>
                                        <?php if(!empty($item['work_process_description' ])): ?>
                                            <p class="process-one__text"><?php echo twinkle_kses($item['work_process_description' ]); ?></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </section>

        <?php
	}
}

$widgets_manager->register( new Bixola_Work_Process() );