<?php
namespace BixolaCore\Widgets;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;

use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Bixola Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Bixola_Timeline extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bixola_timeline';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Timeline', 'bixola-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'bixola-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bixola_core' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'bixola-core' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

        // layout Panel
        $this->start_controls_section(
            'bixola_layout',
            [
                'label' => esc_html__('Design Layout', 'bixola-core'),
            ]
        );

        $this->add_control(
            'bixola_design_style',
            [
                'label' => esc_html__('Select Layout', 'bixola-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'bixola-core'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_timeline_left',
            [
                'label' => esc_html__( 'Timeline Left', 'bixola-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'timeline_shape',
            [
                'label' => esc_html__( 'Shape ON/OFF', 'text-domain' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'text-domain' ),
                'label_off' => esc_html__( 'Hide', 'text-domain' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater->add_control(
            'timeline_date', [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'timeline_title', [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'timeline_description', [
                'label' => esc_html__('Subtitle', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'timeline_link_switcher',
            [
                'label' => esc_html__( 'Add link', 'bixola-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'bixola-core' ),
                'label_off' => esc_html__( 'No', 'bixola-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'timeline_link_type',
            [
                'label' => esc_html__( 'Link Type', 'bixola-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'condition' => [
                    'timeline_link_switcher' => 'yes'
                ]
            ]
        );

        $repeater->add_control(
            'timeline_link',
            [
                'label' => esc_html__( 'Link', 'bixola-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'https://your-link.com', 'bixola-core' ),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'condition' => [
                    'timeline_link_type' => '1',
                    'timeline_link_switcher' => 'yes',
                ]
            ]
        );

        $repeater->add_control(
            'timeline_page_link',
            [
                'label' => esc_html__( 'Select Page Link', 'bixola-core' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => bixola_get_all_pages(),
                'condition' => [
                    'timeline_link_type' => '2',
                    'timeline_link_switcher' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'timeline_list_left',
            [
                'label' => esc_html__( 'Timeline List', 'bixola-core' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'timeline_date' => __( 'Jan 01, 2017', 'bixola-core' ),
                        'timeline_title' => __( 'Our first big project', 'bixola-core' ),
                        'timeline_description' => __( 'Wouldn’t it be better practice to use get the title in this case the post object’s data member.', 'bixola-core' ),
                    ],
                    [
                        'timeline_date' => __( 'Nov 25, 2017', 'bixola-core' ),
                        'timeline_title' => __( 'Company of the year', 'bixola-core' ),
                        'timeline_description' => __( 'Wouldn’t it be better practice to use get the title in this case the post object’s data member.', 'bixola-core' ),
                    ],
                    [
                        'timeline_date' => __( 'feb 06, 2017', 'bixola-core' ),
                        'timeline_title' => __( 'Best Business consulting', 'bixola-core' ),
                        'timeline_description' => __( 'Wouldn’t it be better practice to use get the title in this case the post object’s data member.', 'bixola-core' ),
                    ],
                ],
                'title_field' => '{{{ timeline_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_timeline_right',
            [
                'label' => esc_html__( 'Timeline Right', 'bixola-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'timeline_shape',
            [
                'label' => esc_html__( 'Shape ON/OFF', 'text-domain' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'text-domain' ),
                'label_off' => esc_html__( 'Hide', 'text-domain' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater->add_control(
            'timeline_date', [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'timeline_title', [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'timeline_description', [
                'label' => esc_html__('Subtitle', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'timeline_link_switcher',
            [
                'label' => esc_html__( 'Add link', 'bixola-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'bixola-core' ),
                'label_off' => esc_html__( 'No', 'bixola-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'timeline_link_type',
            [
                'label' => esc_html__( 'Link Type', 'bixola-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'condition' => [
                    'timeline_link_switcher' => 'yes'
                ]
            ]
        );

        $repeater->add_control(
            'timeline_link',
            [
                'label' => esc_html__( 'Link', 'bixola-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'https://your-link.com', 'bixola-core' ),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'condition' => [
                    'timeline_link_type' => '1',
                    'timeline_link_switcher' => 'yes',
                ]
            ]
        );

        $repeater->add_control(
            'timeline_page_link',
            [
                'label' => esc_html__( 'Select Page Link', 'bixola-core' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => bixola_get_all_pages(),
                'condition' => [
                    'timeline_link_type' => '2',
                    'timeline_link_switcher' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'timeline_list_right',
            [
                'label' => esc_html__( 'Timeline List', 'bixola-core' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'timeline_date' => __( 'Aug 14, 2016', 'bixola-core' ),
                        'timeline_title' => __( 'Started in houston', 'bixola-core' ),
                        'timeline_description' => __( 'Wouldn’t it be better practice to use get the title in this case the post object’s data member.', 'bixola-core' ),
                    ],
                    [
                        'timeline_date' => __( 'Mar 06, 2017', 'bixola-core' ),
                        'timeline_title' => __( 'International Branch', 'bixola-core' ),
                        'timeline_description' => __( 'Wouldn’t it be better practice to use get the title in this case the post object’s data member.', 'bixola-core' ),
                    ],
                    [
                        'timeline_date' => __( 'Feb 21, 2018', 'bixola-core' ),
                        'timeline_title' => __( '100% Project Milectone', 'bixola-core' ),
                        'timeline_description' => __( 'Wouldn’t it be better practice to use get the title in this case the post object’s data member.', 'bixola-core' ),
                    ],
                ],
                'title_field' => '{{{ timeline_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'bixola_faq_price_content',
            [
                'label' => esc_html__('Price Info', 'bixola-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'bixola_design_style' => ['layout-2'],
                ],
            ]
        );

        $this->add_control(
            'bixola_price',
            [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Price', 'bixola-core'),
                'placeholder' => esc_html__('Type Heading Text', 'bixola-core'),
                'label_block' => true,
                'condition' => [
                    'bixola_design_style' => ['layout-2'],
                ],
            ]
        );

        $this->add_control(
            'bixola_price_btn',
            [
                'label' => esc_html__('Button Text', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Free Try', 'bixola-core'),
                'placeholder' => esc_html__('Type Button Text', 'bixola-core'),
                'label_block' => true,
                'condition' => [
                    'bixola_design_style' => ['layout-2'],
                ],
            ]
        );

        $this->add_control(
            'bixola_price_btn_url',
            [
                'label' => esc_html__('URL', 'bixola-core'),
                'type' => Controls_Manager::TEXT,
                'default' => '#',
                'title' => esc_html__('BTN url', 'bixola-core'),
                'label_block' => true,
                'condition' => [
                    'bixola_design_style' => ['layout-2'],
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_style_design_layout',
            [
                'label' => esc_html__( 'Design Layout',  'text-domain'  ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_responsive_control(
            'design_layout_margin',
            [
                'label' => esc_html__( 'Margin', 'text-domain' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'design_layout_padding',
            [
                'label' => esc_html__( 'Padding', 'text-domain' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'design_layout_background',
            [
                'label' => esc_html__( 'Background', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bixola-el-section' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            '_section_timeline_list_style',
            [
                'label' => __( 'Timeline Left/Right', 'bixola-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            '_heading_style_bar',
            [
                'label' => __( 'Bar', 'bixola-core' ),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'timeline_bar_background',
            [
                'label' => esc_html__( 'Background', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-history__inner::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            '_heading_style_timeline_icon',
            [
                'label' => esc_html__( 'Icon', 'text-domain' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs( '_tabs_timeline_icon' );
        
        $this->start_controls_tab(
            'timeline_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'text-domain' ),
            ]
        );
        
        $this->add_control(
            'timeline_icon_color',
            [
                'label' => esc_html__( 'Color', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-history__down-arrow span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'timeline_icon_background',
            [
                'label' => esc_html__( 'Background', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-history__down-arrow span' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'timeline_icon_border',
            [
                'label' => esc_html__( 'Border', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-history__down-arrow span::after' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'timeline_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'text-domain' ),
            ]
        );
        
        $this->add_control(
            'timeline_icon_color_hover',
            [
                'label' => esc_html__( 'Color', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-history__down-arrow span:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'timeline_icon_background_hover',
            [
                'label' => esc_html__( 'Background', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-history__down-arrow span:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'timeline_icon_border_hover',
            [
                'label' => esc_html__( 'Border', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-history__down-arrow span:hover::after' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_tab();
        
        $this->end_controls_tabs();

        $this->add_control(
            '_heading_style_pointer',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Pointer', 'bixola-core' ),
            ]
        );

        $this->add_control(
            'timeline_layout_pointer_color',
            [
                'label' => esc_html__( 'Color', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-history__list-shape-11::after' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'timeline_layout_pointer_background',
            [
                'label' => esc_html__( 'Background', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-history__list-shape-11::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'timeline_layout_pointer_border',
            [
                'label' => esc_html__( 'Border', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-history__list-shape-11::before' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            '_heading_style_timeline_date',
            [
                'label' => __( 'Date', 'bixola-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'timeline_date_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'text-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .company-history__date' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'timeline_date_color',
            [
                'label' => __( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-history__date' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'timeline_date_typography',
                'selector' => '{{WRAPPER}} .company-history__date',
            ]
        );

        $this->add_control(
            '_heading_style_timeline_title',
            [
                'label' => __( 'Title', 'bixola-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'timeline_title_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'text-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .company-history__title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'timeline_title_color',
            [
                'label' => __( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-history__title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'timeline_title_typography',
                'selector' => '{{WRAPPER}} .company-history__title',
            ]
        );

        $this->add_control(
            '_heading_style_timeline_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Description', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'timeline_description_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'text-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .company-history__text' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'timeline_description_color',
            [
                'label' => __( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-history__text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'timeline_description_typography',
                'selector' => '{{WRAPPER}} .company-history__text',
            ]
        );

        $this->add_control(
            '_heading_style_timeline_button',
            [
                'label' => esc_html__( 'Button', 'text-domain' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs( '_tabs_timeline_button' );
        
        $this->start_controls_tab(
            'timeline_button_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'text-domain' ),
            ]
        );
        
        $this->add_control(
            'timeline_button_color',
            [
                'label' => esc_html__( 'Color', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-history__arrow a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'timeline_button_background',
            [
                'label' => esc_html__( 'Background', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-history__arrow a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'timeline_button_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'text-domain' ),
            ]
        );
        
        $this->add_control(
            'timeline_button_color_hover',
            [
                'label' => esc_html__( 'Color', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-history__arrow a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'timeline_button_background_hover',
            [
                'label' => esc_html__( 'Background', 'text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-history__arrow a:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_tab();
        
        $this->end_controls_tabs();

        $this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
	?>
        <?php if ( $settings['bixola_design_style']  == 'layout-1' ) : ?>

            <section class="bixola-el-section company-history">
                <div class="container">
                    <div class="company-history__inner">
                        <div class="company-history__down-arrow">
                            <span class="icon-down-arrow-1"></span>
                        </div>
                        <div class="row">
                            <div class="col-xl-6 col-lg-6">
                                <div class="company-history__left">
                                    <ul class="company-history__list list-unstyled">
                                        <?php foreach ($settings['timeline_list_left'] as $item) : 
                                            if ('2' == $item['timeline_link_type']) {
                                                $link = get_permalink($item['timeline_page_link']);
                                                $target = '_self';
                                                $rel = 'nofollow';
                                            } else {
                                                $link = !empty($item['timeline_link']['url']) ? $item['timeline_link']['url'] : '';
                                                $target = !empty($item['timeline_link']['is_external']) ? '_blank' : '';
                                                $rel = !empty($item['timeline_link']['nofollow']) ? 'nofollow' : '';
                                            }
                                        ?>
                                        <li>
                                            <div class="company-history__list-single">
                                                <?php if ( !empty( $item['timeline_shape'] ) ) : ?>
                                                    <div class="company-history__list-shape-11"></div>
                                                    <div class="company-history__list-shape-box">
                                                        <div class="company-history__list-shape-1"></div>
                                                        <div class="company-history__list-shape-2"></div>
                                                        <div class="company-history__list-shape-3"></div>
                                                        <div class="company-history__list-shape-4"></div>
                                                        <div class="company-history__list-shape-5"></div>
                                                        <div class="company-history__list-shape-6"></div>
                                                        <div class="company-history__list-shape-7"></div>
                                                        <div class="company-history__list-shape-8"></div>
                                                        <div class="company-history__list-shape-9"></div>
                                                        <div class="company-history__list-shape-10"></div>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if ( !empty( $item['timeline_date'] ) ) : ?>
                                                    <span class="company-history__date">
                                                        <?php echo twinkle_kses($item['timeline_date']); ?>
                                                    </span>
                                                <?php endif; ?>
                                                <?php if ( !empty( $item['timeline_title'] ) ) : ?>
                                                    <h3 class="company-history__title">
                                                        <?php echo twinkle_kses($item['timeline_title']); ?>
                                                    </h3>
                                                <?php endif; ?>
                                                <?php if ( !empty( $item['timeline_description'] ) ) : ?>
                                                    <p class="company-history__text">
                                                        <?php echo twinkle_kses($item['timeline_description']); ?>
                                                    </p>
                                                <?php endif; ?>
                                                <div class="company-history__arrow">
                                                    <a target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>">
                                                        <span class="icon-right-arrow-11"></span>
                                                    </a>
                                                </div>
                                            </div>
                                        </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xl-6 col-lg-6">
                                <div class="company-history__right">
                                    <ul class="company-history__list list-unstyled">
                                        <?php foreach ($settings['timeline_list_right'] as $item) : 
                                            if ('2' == $item['timeline_link_type']) {
                                                $link = get_permalink($item['timeline_page_link']);
                                                $target = '_self';
                                                $rel = 'nofollow';
                                            } else {
                                                $link = !empty($item['timeline_link']['url']) ? $item['timeline_link']['url'] : '';
                                                $target = !empty($item['timeline_link']['is_external']) ? '_blank' : '';
                                                $rel = !empty($item['timeline_link']['nofollow']) ? 'nofollow' : '';
                                            }
                                        ?>
                                        <li>
                                            <div class="company-history__list-single">
                                                <?php if ( !empty( $item['timeline_shape'] ) ) : ?>
                                                    <div class="company-history__list-shape-11"></div>
                                                    <div class="company-history__list-shape-box">
                                                        <div class="company-history__list-shape-1"></div>
                                                        <div class="company-history__list-shape-2"></div>
                                                        <div class="company-history__list-shape-3"></div>
                                                        <div class="company-history__list-shape-4"></div>
                                                        <div class="company-history__list-shape-5"></div>
                                                        <div class="company-history__list-shape-6"></div>
                                                        <div class="company-history__list-shape-7"></div>
                                                        <div class="company-history__list-shape-8"></div>
                                                        <div class="company-history__list-shape-9"></div>
                                                        <div class="company-history__list-shape-10"></div>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if ( !empty( $item['timeline_date'] ) ) : ?>
                                                    <span class="company-history__date">
                                                        <?php echo twinkle_kses($item['timeline_date']); ?>
                                                    </span>
                                                <?php endif; ?>
                                                <?php if ( !empty( $item['timeline_title'] ) ) : ?>
                                                    <h3 class="company-history__title">
                                                        <?php echo twinkle_kses($item['timeline_title']); ?>
                                                    </h3>
                                                <?php endif; ?>
                                                <?php if ( !empty( $item['timeline_description'] ) ) : ?>
                                                    <p class="company-history__text">
                                                        <?php echo twinkle_kses($item['timeline_description']); ?>
                                                    </p>
                                                <?php endif; ?>
                                                <div class="company-history__arrow">
                                                    <a target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>">
                                                        <span class="icon-right-arrow-11"></span>
                                                    </a>
                                                </div>
                                            </div>
                                        </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        <?php elseif ( $settings['bixola_design_style']  == 'layout-2' ): ?>
            

        <?php endif; ?>
        
        <?php
	}
}

$widgets_manager->register( new Bixola_Timeline() );