<?php
namespace BixolaCore\Widgets;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Bixola Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Bixola_Hero_Slider extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bixola_hero_slider';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Hero Slider', 'bixola-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'bixola-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bixola_core' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'bixola-core' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

        // layout Panel
        $this->start_controls_section(
            '_content_design_layout',
            [
                'label' => esc_html__('Design Layout', 'bixola-core'),
            ]
        );
        $this->add_control(
            'design_style',
            [
                'label' => esc_html__('Select Layout', 'bixola-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'bixola-core'),
                    'layout-2' => esc_html__('Layout 2', 'bixola-core'),
                    'layout-3' => esc_html__('Layout 3', 'bixola-core'),
                    'layout-4' => esc_html__('Layout 4', 'bixola-core'),
                    'layout-5' => esc_html__('Layout 5', 'bixola-core'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->add_control(
            'shape_switch',
            [
                'label' => esc_html__( 'Shape ON/OFF', 'text-domain' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'text-domain' ),
                'label_off' => esc_html__( 'Hide', 'text-domain' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'design_style' => [ 'layout-1' ],
                ],
            ]
        );

        $this->end_controls_section();
		
		$this->start_controls_section(
            '_content_slider_one',
            [
                'label' => esc_html__('Slider', 'bixola-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => [ 'layout-1' ],
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'slider_image',
            [
                'label' => esc_html__('Upload Image', 'bixola-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ]
            ]
        );

        $repeater->add_control(
            'slider_subheading',
            [
                'label' => esc_html__( 'Subheading', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'WE CREAT DIGITAL PRODUCT', 'bixola-core' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'slider_title',
            [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('The Best Business <br> for Agency', 'bixola-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'slider_title_tag',
            [
                'label' => esc_html__('Title HTML Tag', 'bixola-core'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => esc_html__('H1', 'bixola-core'),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2' => [
                        'title' => esc_html__('H2', 'bixola-core'),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3' => [
                        'title' => esc_html__('H3', 'bixola-core'),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4' => [
                        'title' => esc_html__('H4', 'bixola-core'),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5' => [
                        'title' => esc_html__('H5', 'bixola-core'),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6' => [
                        'title' => esc_html__('H6', 'bixola-core'),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h2',
                'toggle' => false,
            ]
        );

        $repeater->add_control(
            'slider_description',
            [
                'label' => esc_html__('Description', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('We will help you to feel better and enjoy every single day of <br>may be the fastest growing health.', 'bixola-core'),
            ]
        );

        $repeater->add_control(
            'slider_button_switcher',
            [
                'label' => esc_html__( 'Button ON/OFF', 'bixola-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'bixola-core' ),
                'label_off' => esc_html__( 'No', 'bixola-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'slider_button_text',
            [
                'label' => esc_html__( 'Button Text', 'bixola-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Get In Touch', 'bixola-core' ),
                'label_block' => true,
                'condition' => [
                    'slider_button_switcher' => 'yes'
                ],
            ]
        );

        $repeater->add_control(
            'slider_button_link_type',
            [
                'label' => esc_html__( 'Button Link Type', 'bixola-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'condition' => [
                    'slider_button_switcher' => 'yes'
                ]
            ]
        );
        $repeater->add_control(
            'slider_button_link',
            [
                'label' => esc_html__( 'Button Link', 'bixola-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'https://your-link.com', 'bixola-core' ),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'condition' => [
                    'slider_button_link_type' => '1',
                    'slider_button_switcher' => 'yes',
                ]
            ]
        );
        $repeater->add_control(
            'slider_button_page_link',
            [
                'label' => esc_html__( 'Select Button Link Page', 'bixola-core' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => bixola_get_all_pages(),
                'condition' => [
                    'slider_button_link_type' => '2',
                    'slider_button_switcher' => 'yes',
                ]
            ]
        );

        $repeater->add_control(
            '_content_heading_video',
            [
                'label' => esc_html__( 'Video', 'bixola-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'slider_video_text',
            [
                'label' => esc_html__( 'Video Text', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Watch Video', 'bixola-core' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'slider_video_link',
            [
                'label' => esc_html__( 'Video URL', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'slider_list',
            [
                'label' => esc_html__('Slider List', 'bixola-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'slider_subheading' => __( 'WE CREAT DIGITAL PRODUCT', 'bixola-core' ),
                        'slider_title' => __( 'Get more of what <br> you want from your <br> business', 'bixola-core' ),
                        'slider_description' => __( 'Lorem Ipsum is simply dummy text of the printing and <br> typesetting industry. Lorem Ipsum has been.', 'bixola-core' ),
                        'slider_button' => __( 'Get Consulting', 'bixola-core' ),
                        'slider_video_text' => __( 'Watch Video', 'bixola-core' ),
                        'slider_video_link' => __( 'https://www.youtube.com/watch?v=Get7rqXYrbQ', 'bixola-core' ),
                    ],
                    [
                        'slider_subheading' => __( 'WE CREAT DIGITAL PRODUCT', 'bixola-core' ),
                        'slider_title' => __( 'Get more of what <br> you want from your <br> business', 'bixola-core' ),
                        'slider_description' => __( 'Lorem Ipsum is simply dummy text of the printing and <br> typesetting industry. Lorem Ipsum has been.', 'bixola-core' ),
                        'slider_button' => __( 'Get Consulting', 'bixola-core' ),
                        'slider_video_text' => __( 'Watch Video', 'bixola-core' ),
                        'slider_video_link' => __( 'https://www.youtube.com/watch?v=Get7rqXYrbQ', 'bixola-core' ),
                    ],
                    [
                        'slider_subheading' => __( 'WE CREAT DIGITAL PRODUCT', 'bixola-core' ),
                        'slider_title' => __( 'Get more of what <br> you want from your <br> business', 'bixola-core' ),
                        'slider_description' => __( 'Lorem Ipsum is simply dummy text of the printing and <br> typesetting industry. Lorem Ipsum has been.', 'bixola-core' ),
                        'slider_button' => __( 'Get Consulting', 'bixola-core' ),
                        'slider_video_text' => __( 'Watch Video', 'bixola-core' ),
                        'slider_video_link' => __( 'https://www.youtube.com/watch?v=Get7rqXYrbQ', 'bixola-core' ),
                    ],
                ],
                'title_field' => '{{{ slider_title }}}',
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
            '_content_slider_two',
            [
                'label' => esc_html__('Slider', 'bixola-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => [ 'layout-2' ],
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'slider_image',
            [
                'label' => esc_html__('Upload Image', 'bixola-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ]
            ]
        );

        $repeater->add_control(
            'slider_title',
            [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('The Best Business <br> for Agency', 'bixola-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'slider_title_tag',
            [
                'label' => esc_html__('Title HTML Tag', 'bixola-core'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => esc_html__('H1', 'bixola-core'),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2' => [
                        'title' => esc_html__('H2', 'bixola-core'),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3' => [
                        'title' => esc_html__('H3', 'bixola-core'),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4' => [
                        'title' => esc_html__('H4', 'bixola-core'),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5' => [
                        'title' => esc_html__('H5', 'bixola-core'),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6' => [
                        'title' => esc_html__('H6', 'bixola-core'),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h2',
                'toggle' => false,
            ]
        );

        $repeater->add_control(
            'slider_description',
            [
                'label' => esc_html__('Description', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('We will help you to feel better and enjoy every single day of <br>may be the fastest growing health.', 'bixola-core'),
            ]
        );

        $repeater->add_control(
            'slider_button_switcher',
            [
                'label' => esc_html__( 'Button ON/OFF', 'bixola-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'bixola-core' ),
                'label_off' => esc_html__( 'No', 'bixola-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'slider_button_text',
            [
                'label' => esc_html__( 'Button Text', 'bixola-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Get In Touch', 'bixola-core' ),
                'label_block' => true,
                'condition' => [
                    'slider_button_switcher' => 'yes'
                ],
            ]
        );

        $repeater->add_control(
            'slider_button_link_type',
            [
                'label' => esc_html__( 'Button Link Type', 'bixola-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'condition' => [
                    'slider_button_switcher' => 'yes'
                ]
            ]
        );
        $repeater->add_control(
            'slider_button_link',
            [
                'label' => esc_html__( 'Button Link', 'bixola-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'https://your-link.com', 'bixola-core' ),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'condition' => [
                    'slider_button_link_type' => '1',
                    'slider_button_switcher' => 'yes',
                ]
            ]
        );
        $repeater->add_control(
            'slider_button_page_link',
            [
                'label' => esc_html__( 'Select Button Link Page', 'bixola-core' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => bixola_get_all_pages(),
                'condition' => [
                    'slider_button_link_type' => '2',
                    'slider_button_switcher' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'slider_list_two',
            [
                'label' => esc_html__('Slider List', 'bixola-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'slider_title' => __( 'We grow & manage <br> your business', 'bixola-core' ),
                        'slider_description' => __( 'Lorem Ipsum is simply dummy text of the printing and typesetting.', 'bixola-core' ),
                        'slider_button' => __( 'Find Consultant', 'bixola-core' ),
                    ],
                    [
                        'slider_title' => __( 'We grow & manage <br> your business', 'bixola-core' ),
                        'slider_description' => __( 'Lorem Ipsum is simply dummy text of the printing and typesetting.', 'bixola-core' ),
                        'slider_button' => __( 'Find Consultant', 'bixola-core' ),
                    ],
                    [
                        'slider_title' => __( 'We grow & manage <br> your business', 'bixola-core' ),
                        'slider_description' => __( 'Lorem Ipsum is simply dummy text of the printing and typesetting.', 'bixola-core' ),
                        'slider_button' => __( 'Find Consultant', 'bixola-core' ),
                    ],
                ],
                'title_field' => '{{{ slider_title }}}',
            ]
        );

        $this->end_controls_section();
		
		$this->start_controls_section(
            '_content_slider_three',
            [
                'label' => esc_html__('Slider', 'bixola-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => [ 'layout-3' ],
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'slider_image',
            [
                'label' => esc_html__('Upload Image', 'bixola-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ]
            ]
        );

        $repeater->add_control(
            'slider_title',
            [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('The Best Business <br> for Agency', 'bixola-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'slider_title_tag',
            [
                'label' => esc_html__('Title HTML Tag', 'bixola-core'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => esc_html__('H1', 'bixola-core'),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2' => [
                        'title' => esc_html__('H2', 'bixola-core'),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3' => [
                        'title' => esc_html__('H3', 'bixola-core'),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4' => [
                        'title' => esc_html__('H4', 'bixola-core'),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5' => [
                        'title' => esc_html__('H5', 'bixola-core'),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6' => [
                        'title' => esc_html__('H6', 'bixola-core'),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h2',
                'toggle' => false,
            ]
        );

        $repeater->add_control(
            'slider_description',
            [
                'label' => esc_html__('Description', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('We will help you to feel better and enjoy every single day of <br>may be the fastest growing health.', 'bixola-core'),
            ]
        );

        $repeater->add_control(
            'slider_button_switcher',
            [
                'label' => esc_html__( 'Button ON/OFF', 'bixola-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'bixola-core' ),
                'label_off' => esc_html__( 'No', 'bixola-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'slider_button_text',
            [
                'label' => esc_html__( 'Button Text', 'bixola-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Get In Touch', 'bixola-core' ),
                'label_block' => true,
                'condition' => [
                    'slider_button_switcher' => 'yes'
                ],
            ]
        );

        $repeater->add_control(
            'slider_button_link_type',
            [
                'label' => esc_html__( 'Button Link Type', 'bixola-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'condition' => [
                    'slider_button_switcher' => 'yes'
                ]
            ]
        );
        $repeater->add_control(
            'slider_button_link',
            [
                'label' => esc_html__( 'Button Link', 'bixola-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'https://your-link.com', 'bixola-core' ),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'condition' => [
                    'slider_button_link_type' => '1',
                    'slider_button_switcher' => 'yes',
                ]
            ]
        );
        $repeater->add_control(
            'slider_button_page_link',
            [
                'label' => esc_html__( 'Select Button Link Page', 'bixola-core' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => bixola_get_all_pages(),
                'condition' => [
                    'slider_button_link_type' => '2',
                    'slider_button_switcher' => 'yes',
                ]
            ]
        );

        $repeater->add_control(
            'slider_button_switcher_two',
            [
                'label' => esc_html__( 'Secondary Button ON/OFF', 'bixola-core' ),
                'description' => esc_html__( 'Only used for layout 2', 'bixola-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'bixola-core' ),
                'label_off' => esc_html__( 'No', 'bixola-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'slider_button_text_two',
            [
                'label' => esc_html__( 'Button Text', 'bixola-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Get In Touch', 'bixola-core' ),
                'label_block' => true,
                'condition' => [
                    'slider_button_switcher_two' => 'yes'
                ],
            ]
        );

        $repeater->add_control(
            'slider_button_link_type_two',
            [
                'label' => esc_html__( 'Button Link Type', 'bixola-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'condition' => [
                    'slider_button_switcher_two' => 'yes'
                ]
            ]
        );

        $repeater->add_control(
            'slider_button_link_two',
            [
                'label' => esc_html__( 'Button Link', 'bixola-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'https://your-link.com', 'bixola-core' ),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'condition' => [
                    'slider_button_link_type_two' => '1',
                    'slider_button_switcher_two' => 'yes',
                ]
            ]
        );

        $repeater->add_control(
            'slider_button_page_link_two',
            [
                'label' => esc_html__( 'Select Button Link Page', 'bixola-core' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => bixola_get_all_pages(),
                'condition' => [
                    'slider_button_link_type_two' => '2',
                    'slider_button_switcher_two' => 'yes',
                ]
            ]
        );

        $repeater->add_control(
            '_content_heading_video',
            [
                'label' => esc_html__( 'Video', 'bixola-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'slider_video_text',
            [
                'label' => esc_html__( 'Video Text', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Watch Video', 'bixola-core' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'slider_video_link',
            [
                'label' => esc_html__( 'Video URL', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'slider_list_three',
            [
                'label' => esc_html__('Slider List', 'bixola-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'slider_subheading' => __( 'WE CREAT DIGITAL PRODUCT', 'bixola-core' ),
                        'slider_title' => __( 'Get more of what <br> you want from your <br> business', 'bixola-core' ),
                        'slider_description' => __( 'Lorem Ipsum is simply dummy text of the printing and <br> typesetting industry. Lorem Ipsum has been.', 'bixola-core' ),
                        'slider_button' => __( 'Get Consulting', 'bixola-core' ),
                        'slider_video_text' => __( 'Watch Video', 'bixola-core' ),
                        'slider_video_link' => __( 'https://www.youtube.com/watch?v=Get7rqXYrbQ', 'bixola-core' ),
                    ],
                    [
                        'slider_subheading' => __( 'WE CREAT DIGITAL PRODUCT', 'bixola-core' ),
                        'slider_title' => __( 'Get more of what <br> you want from your <br> business', 'bixola-core' ),
                        'slider_description' => __( 'Lorem Ipsum is simply dummy text of the printing and <br> typesetting industry. Lorem Ipsum has been.', 'bixola-core' ),
                        'slider_button' => __( 'Get Consulting', 'bixola-core' ),
                        'slider_video_text' => __( 'Watch Video', 'bixola-core' ),
                        'slider_video_link' => __( 'https://www.youtube.com/watch?v=Get7rqXYrbQ', 'bixola-core' ),
                    ],
                    [
                        'slider_subheading' => __( 'WE CREAT DIGITAL PRODUCT', 'bixola-core' ),
                        'slider_title' => __( 'Get more of what <br> you want from your <br> business', 'bixola-core' ),
                        'slider_description' => __( 'Lorem Ipsum is simply dummy text of the printing and <br> typesetting industry. Lorem Ipsum has been.', 'bixola-core' ),
                        'slider_button' => __( 'Get Consulting', 'bixola-core' ),
                        'slider_video_text' => __( 'Watch Video', 'bixola-core' ),
                        'slider_video_link' => __( 'https://www.youtube.com/watch?v=Get7rqXYrbQ', 'bixola-core' ),
                    ],
                ],
                'title_field' => '{{{ slider_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_slider_four',
            [
                'label' => esc_html__('Slider', 'bixola-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => [ 'layout-4', 'layout-5' ],
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'slider_image',
            [
                'label' => esc_html__('Upload Image', 'bixola-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ]
            ]
        );

        $repeater->add_control(
            'slider_title',
            [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('The Best Business <br> for Agency', 'bixola-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'slider_title_tag',
            [
                'label' => esc_html__('Title HTML Tag', 'bixola-core'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => esc_html__('H1', 'bixola-core'),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2' => [
                        'title' => esc_html__('H2', 'bixola-core'),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3' => [
                        'title' => esc_html__('H3', 'bixola-core'),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4' => [
                        'title' => esc_html__('H4', 'bixola-core'),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5' => [
                        'title' => esc_html__('H5', 'bixola-core'),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6' => [
                        'title' => esc_html__('H6', 'bixola-core'),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h2',
                'toggle' => false,
            ]
        );

        $repeater->add_control(
            'slider_description',
            [
                'label' => esc_html__('Description', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('We will help you to feel better and enjoy every single day of <br>may be the fastest growing health.', 'bixola-core'),
            ]
        );

        $repeater->add_control(
            'slider_button_switcher',
            [
                'label' => esc_html__( 'Button ON/OFF', 'bixola-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'bixola-core' ),
                'label_off' => esc_html__( 'No', 'bixola-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'slider_button_text',
            [
                'label' => esc_html__( 'Button Text', 'bixola-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Get In Touch', 'bixola-core' ),
                'label_block' => true,
                'condition' => [
                    'slider_button_switcher' => 'yes'
                ],
            ]
        );

        $repeater->add_control(
            'slider_button_link_type',
            [
                'label' => esc_html__( 'Button Link Type', 'bixola-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'condition' => [
                    'slider_button_switcher' => 'yes'
                ]
            ]
        );
        $repeater->add_control(
            'slider_button_link',
            [
                'label' => esc_html__( 'Button Link', 'bixola-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'https://your-link.com', 'bixola-core' ),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'condition' => [
                    'slider_button_link_type' => '1',
                    'slider_button_switcher' => 'yes',
                ]
            ]
        );
        $repeater->add_control(
            'slider_button_page_link',
            [
                'label' => esc_html__( 'Select Button Link Page', 'bixola-core' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => bixola_get_all_pages(),
                'condition' => [
                    'slider_button_link_type' => '2',
                    'slider_button_switcher' => 'yes',
                ]
            ]
        );

        $repeater->add_control(
            '_content_heading_video',
            [
                'label' => esc_html__( 'Video', 'bixola-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'slider_video_text',
            [
                'label' => esc_html__( 'Video Text', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Watch Video', 'bixola-core' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'slider_video_link',
            [
                'label' => esc_html__( 'Video URL', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'slider_list_four',
            [
                'label' => esc_html__('Slider List', 'bixola-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'slider_title' => __( 'Get more of what <br> you want from your <br> business', 'bixola-core' ),
                        'slider_description' => __( 'Lorem Ipsum is simply dummy text of the printing and <br> typesetting industry. Lorem Ipsum has been.', 'bixola-core' ),
                        'slider_button' => __( 'Get Consulting', 'bixola-core' ),
                        'slider_video_text' => __( 'Watch Video', 'bixola-core' ),
                        'slider_video_link' => __( 'https://www.youtube.com/watch?v=Get7rqXYrbQ', 'bixola-core' ),
                    ],
                    [
                        'slider_title' => __( 'Get more of what <br> you want from your <br> business', 'bixola-core' ),
                        'slider_description' => __( 'Lorem Ipsum is simply dummy text of the printing and <br> typesetting industry. Lorem Ipsum has been.', 'bixola-core' ),
                        'slider_button' => __( 'Get Consulting', 'bixola-core' ),
                        'slider_video_text' => __( 'Watch Video', 'bixola-core' ),
                        'slider_video_link' => __( 'https://www.youtube.com/watch?v=Get7rqXYrbQ', 'bixola-core' ),
                    ],
                    [
                        'slider_title' => __( 'Get more of what <br> you want from your <br> business', 'bixola-core' ),
                        'slider_description' => __( 'Lorem Ipsum is simply dummy text of the printing and <br> typesetting industry. Lorem Ipsum has been.', 'bixola-core' ),
                        'slider_button' => __( 'Get Consulting', 'bixola-core' ),
                        'slider_video_text' => __( 'Watch Video', 'bixola-core' ),
                        'slider_video_link' => __( 'https://www.youtube.com/watch?v=Get7rqXYrbQ', 'bixola-core' ),
                    ],
                ],
                'title_field' => '{{{ slider_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_style_design_layout',
            [
                'label' => esc_html__( 'Design Layout',  'bixola-core'  ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'design_layout_gradient',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .banner-4-active__item, .banner-5-active__item.has--media::before',
            ]
        );

        $this->add_responsive_control(
            'design_layout_padding',
            [
                'label' => esc_html__( 'Padding', 'bixola-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .banner-4-active__item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'shape_color_one',
            [
                'label' => esc_html__( 'Shape 1', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .small-shape-1 svg path' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .small-shape-2 svg path' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .big-shape-3 svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'shape_color_two',
            [
                'label' => esc_html__( 'Shape 2', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .big-shape-1 svg path' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .big-shape-2 svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_section();

		$this->start_controls_section(
            '_style_slider',
            [
                'label' => esc_html__( 'Slider', 'bixola-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
 
        $this->add_control(
            '_heading_style_dots',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Dots', 'bixola-core' ),
                'separator' => 'before',
            ]
        );
        
        $this->start_controls_tabs( '_dots_style_tabs' );
        
        $this->start_controls_tab(
            'dots_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'bixola-core' ),
            ]
        );

        $this->add_control(
            'dots_border',
            [
                'label' => esc_html__( 'Border', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-4-active .banner-4-pagination .swiper-pagination-bullet' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .banner-5-active .banner-4-pagination .swiper-pagination-bullet' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_control(
            'dots_background',
            [
                'label' => esc_html__( 'Background', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-4-active .banner-4-pagination .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .banner-5-active .banner-4-pagination .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'arrow_active_tab',
            [
                'label' => esc_html__( 'Active', 'bixola-core' ),
            ]
        );

        $this->add_control(
            'arrow_border_active',
            [
                'label' => esc_html__( 'Border', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-4-active .banner-4-pagination .swiper-pagination-bullet-active' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .banner-5-active .banner-4-pagination .swiper-pagination-bullet-active' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_control(
            'arrow_background_active',
            [
                'label' => esc_html__( 'Background', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-4-active .banner-4-pagination .swiper-pagination-bullet-active' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .banner-5-active .banner-4-pagination .swiper-pagination-bullet-active' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_tab();
        
        $this->end_controls_tabs();

        // Title    
        $this->add_control(
            '_subheading_title',
            [
                'label' => esc_html__( 'Subheading', 'bixola-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'subheading_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .banner-4-active__item-content > span' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .banner-5-active__item-content p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'subheading_color',
            [
                'label' => esc_html__( 'Text Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-4-active__item-content > span' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .banner-5-active__item-content p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subheading_typography',
                'selector' => '{{WRAPPER}} .banner-4-active__item-content > span, .banner-5-active__item-content p',
            ]
        );

        // Title    
        $this->add_control(
            '_heading_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Title', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .banner-4-active__item-content .title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .banner-5-active__item-content .title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-4-active__item-content .title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .banner-5-active__item-content .title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .banner-4-active__item-content .title, .banner-5-active__item-content .title',
            ]
        );

        // Description
        $this->add_control(
            '_content_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Description', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'description_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .banner-4-active__item-content .description p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .banner-5-active__item-content .description p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => esc_html__( 'Text Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-4-active__item-content .description p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .banner-5-active__item-content .description p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'selector' => '{{WRAPPER}} .banner-4-active__item-content .description p, .banner-5-active__item-content .description p',
            ]
        );

        $this->add_control(
            '_heading_style_phone_icon',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Phone Icon', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'phone_icon_color',
            [
                'label' => esc_html__( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-4-active__item-content-contact .icon-wrapper i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'phone_icon_background',
            [
                'label' => esc_html__( 'Background', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-4-active__item-content-contact .icon-wrapper' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            '_heading_style_phone_label',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Phone Label', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'phone_label_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .banner-4-active__item-content-contact-text span' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'phone_label_color',
            [
                'label' => esc_html__( 'Text Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-4-active__item-content-contact-text span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'phone_label_typography',
                'selector' => '{{WRAPPER}} .banner-4-active__item-content-contact-text span',
            ]
        );

        $this->add_control(
            '_heading_style_phone',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Phone', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'phone_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .banner-4-active__item-content-contact-text a h5' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'phone_color',
            [
                'label' => esc_html__( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-4-active__item-content-contact-text a h5' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'phone_color_hover',
            [
                'label' => esc_html__( 'Color (Hover)', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-4-active__item-content-contact-text a:hover h5' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'phone_typography',
                'selector' => '{{WRAPPER}} .banner-4-active__item-content-contact-text a h5',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
			'bixola_button_style',
			[
				'label' => esc_html__( 'Button', 'bixola-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->start_controls_tabs( 'tabs_button_style' );

        $this->start_controls_tab(
            'button_tab',
            [
                'label' => esc_html__( 'Normal', 'bixola-core' ),
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label'     => esc_html__( 'Color', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rs-btn' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .rs-btn svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_background',
            [
                'label'     => esc_html__( 'Background', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rs-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .rs-btn',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'bixola-core' ),
            ]
        );

        $this->add_control(
            'button_color_hover',
            [
                'label'     => esc_html__( 'Color', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rs-btn:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .rs-btn:hover svg path' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_background_hover',
            [
                'label'     => esc_html__( 'Background', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rs-btn:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border_hover',
                'selector' => '{{WRAPPER}} .rs-btn:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'button_border_radius',
            [
                'label'     => esc_html__( 'Border Radius', 'bixola-core' ),
                'type'      => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .rs-btn' => 'border-radius: {{SIZE}}px;',
                    '{{WRAPPER}} .rs-btn:before' => 'border-radius: {{SIZE}}px;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__( 'Typography', 'bixola-core' ),
                'name'     => 'button_typography',
                'selector' => '{{WRAPPER}} .rs-btn',
            ]
        );

        $this->add_control(
            'button_padding',
            [
                'label'      => esc_html__( 'Padding', 'bixola-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .rs-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button_margin',
            [
                'label'      => esc_html__( 'Margin', 'bixola-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .rs-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            '_heading_style_secondary_button',
            [
                'label' => esc_html__( 'Button', 'bixola-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs( 'tabs_button_style_secondary' );

        $this->start_controls_tab(
            'secondary_button_tab',
            [
                'label' => esc_html__( 'Normal', 'bixola-core' ),
            ]
        );

        $this->add_control(
            'secondary_button_color',
            [
                'label'     => esc_html__( 'Color', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rs-btn.btn-border-blue' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'secondary_button_background',
            [
                'label'     => esc_html__( 'Background', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rs-btn.btn-border-blue' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'secondary_button_border',
                'selector' => '{{WRAPPER}} .rs-btn.btn-border-blue',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'secondary_button_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'bixola-core' ),
            ]
        );

        $this->add_control(
            'secondary_button_color_hover',
            [
                'label'     => esc_html__( 'Color', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rs-btn.btn-border-blue:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'secondary_button_background_hover',
            [
                'label'     => esc_html__( 'Background', 'bixola-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rs-btn.btn-border-blue:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'secondary_button_border_hover',
                'selector' => '{{WRAPPER}} .rs-btn.btn-border-blue:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'secondary_button_border_radius',
            [
                'label'     => esc_html__( 'Border Radius', 'bixola-core' ),
                'type'      => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .rs-btn.btn-border-blue' => 'border-radius: {{SIZE}}px;',
                    '{{WRAPPER}} .rs-btn.btn-border-blue:before' => 'border-radius: {{SIZE}}px;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__( 'Typography', 'bixola-core' ),
                'name'     => 'secondary_button_typography',
                'selector' => '{{WRAPPER}} .rs-btn.btn-border-blue',
            ]
        );

        $this->add_control(
            'secondary_button_padding',
            [
                'label'      => esc_html__( 'Padding', 'bixola-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .rs-btn.btn-border-blue' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'secondary_button_margin',
            [
                'label'      => esc_html__( 'Margin', 'bixola-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .rs-btn.btn-border-blue' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>

		<?php if ( $settings['design_style']  == 'layout-1' ): ?>

            <section class="main-slider">
                <div class="main-slider__carousel owl-carousel owl-theme thm-owl__carousel">
                    <?php foreach ($settings['slider_list'] as $item) :
                        $this->add_render_attribute('title_args', 'class', 'bixola-el-title main-slider__title');
                        $this->add_render_attribute('title_args', 'data-wow-delay', '2s');

                        if ( !empty($item['slider_image']['url']) ) {
                            $slider_image = !empty($item['slider_image']['id']) ? wp_get_attachment_image_url( $item['slider_image']['id'], 'full') : $item['slider_image']['url'];
                            $slider_image_alt = get_post_meta($item["slider_image"]["id"], "_wp_attachment_image_alt", true);
                        }

                        // btn Link
                        if ('2' == $item['slider_button_link_type']) {
                            $link = get_permalink($item['slider_button_page_link']);
                            $target = '_self';
                            $rel = 'nofollow';
                        } else {
                            $link = !empty($item['slider_button_link']['url']) ? $item['slider_button_link']['url'] : '';
                            $target = !empty($item['slider_button_link']['is_external']) ? '_blank' : '';
                            $rel = !empty($item['slider_button_link']['nofollow']) ? 'nofollow' : '';
                        }
                    ?>
                        <div class="item main-slider__slide-1">
                            <div class="main-slider__bg" data-background="<?php print esc_url($slider_image); ?>"></div>
                            
                            <?php if (!empty($settings['shape_switch'])) : ?>
                                <div class="main-slider__shape-1 rotate-me">
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/shapes/main-slider-shape-1.png" alt="<?php print esc_attr( 'shape', 'bixola-core' ); ?>">
                                </div>
                                <div class="main-slider__shape-2 float-bob-x">
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/shapes/main-slider-shape-2.png" alt="<?php print esc_attr( 'shape', 'bixola-core' ); ?>">
                                </div>
                            <?php endif; ?>

                            <div class="container">
                                <div class="main-slider__content">
                                    <?php if (!empty($item['slider_subheading'])) : ?>
                                        <p class="bixola-el-subheading main-slider__sub-title"><?php echo twinkle_kses( $item['slider_subheading'] ); ?></p>
                                    <?php endif; ?>
                                    <?php
                                        if ($item['slider_title_tag']) :
                                            printf('<%1$s %2$s>%3$s</%1$s>',
                                                tag_escape($item['slider_title_tag']),
                                                $this->get_render_attribute_string('title_args'),
                                                twinkle_kses($item['slider_title'])
                                            );
                                        endif;
                                    ?>
                                    <?php if (!empty($item['slider_description'])) : ?>
                                    <p class="bixola-el-description main-slider__text"><?php echo twinkle_kses( $item['slider_description'] ); ?></p>
                                    <?php endif; ?>
                                    <div class="main-slider__btn-and-video-box">
                                        <?php if (!empty($item['slider_button_text'])) : ?>
                                            <div class="main-slider__btn-box">
                                                <a target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>" class="bixola-el-button thm-btn main-slider__btn">
                                                    <?php echo twinkle_kses($item['slider_button_text']); ?>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                        <?php if (!empty($item['slider_video_link'])) : ?>
                                            <div class="main-slider__video-link">
                                                <a href="<?php print esc_url($item['slider_video_link']); ?>" class="video-popup">
                                                    <div class="main-slider__video-icon">
                                                        <span class="fa fa-play"></span>
                                                        <i class="ripple"></i>
                                                    </div>
                                                </a>
                                                <?php if (!empty($item['slider_video_text'])) : ?>
                                                    <h4 class="main-slider__video-text">
                                                        <?php print esc_html($item['slider_video_text']); ?>
                                                    </h4>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </section>
           		
        <?php elseif ( $settings['design_style']  == 'layout-2' ): ?>

            <section class="main-slider-two">
                <div class="main-slider-two__carousel owl-carousel owl-theme thm-owl__carousel">
                    <?php foreach ($settings['slider_list_two'] as $item) :
                        $this->add_render_attribute('title_args', 'class', 'bixola-el-title main-slider-two__title');

                        if ( !empty($item['slider_image']['url']) ) {
                            $slider_image = !empty($item['slider_image']['id']) ? wp_get_attachment_image_url( $item['slider_image']['id'], 'full') : $item['slider_image']['url'];
                            $slider_image_alt = get_post_meta($item["slider_image"]["id"], "_wp_attachment_image_alt", true);
                        }

                        // btn Link
                        if ('2' == $item['slider_button_link_type']) {
                            $link = get_permalink($item['slider_button_page_link']);
                            $target = '_self';
                            $rel = 'nofollow';
                        } else {
                            $link = !empty($item['slider_button_link']['url']) ? $item['slider_button_link']['url'] : '';
                            $target = !empty($item['slider_button_link']['is_external']) ? '_blank' : '';
                            $rel = !empty($item['slider_button_link']['nofollow']) ? 'nofollow' : '';
                        }
                    ?>
                    <div class="item main-slider-two__slide-1">
                        <div class="main-slider-two__bg" data-background="<?php print esc_url($slider_image); ?>"></div>

                        <?php if (!empty($settings['shape_switch'])) : ?>
                            <div class="main-slider-two__shape-1 float-bob-y">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/shapes/main-slider-two-shape-1.png" alt="<?php print esc_attr( 'shape', 'bixola-core' ); ?>">
                            </div>
                            <div class="main-slider-two__shape-2 img-bounce">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/shapes/main-slider-two-shape-2.png" alt="<?php print esc_attr( 'shape', 'bixola-core' ); ?>">
                            </div>
                        <?php endif; ?>

                        <div class="container">
                            <div class="main-slider-two__content">
                                <?php
                                    if ($item['slider_title_tag']) :
                                        printf('<%1$s %2$s>%3$s</%1$s>',
                                            tag_escape($item['slider_title_tag']),
                                            $this->get_render_attribute_string('title_args'),
                                            twinkle_kses($item['slider_title'])
                                        );
                                    endif;
                                ?>
                                <?php if (!empty($item['slider_description'])) : ?>
                                    <p class="main-slider-two__text"><?php echo twinkle_kses( $item['slider_description'] ); ?></p>
                                <?php endif; ?>
                                <?php if (!empty($item['slider_button_text'])) : ?>
                                    <div class="main-slider-two__btn-box">
                                        <a target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>" class="bixola-el-button thm-btn main-slider-two__btn">
                                            <?php echo twinkle_kses($item['slider_button_text']); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </section>

        <?php elseif ( $settings['design_style']  == 'layout-3' ): ?>

            <section class="main-slider-three">
                <div class="main-slider-three__carousel owl-carousel owl-theme thm-owl__carousel">
                    <?php foreach ($settings['slider_list_three'] as $item) :
                        $this->add_render_attribute('title_args', 'class', 'bixola-el-title main-slider-three__title');

                        if ( !empty($item['slider_image']['url']) ) {
                            $slider_image = !empty($item['slider_image']['id']) ? wp_get_attachment_image_url( $item['slider_image']['id'], 'full') : $item['slider_image']['url'];
                            $slider_image_alt = get_post_meta($item["slider_image"]["id"], "_wp_attachment_image_alt", true);
                        }

                        // btn Link
                        if ('2' == $item['slider_button_link_type']) {
                            $link = get_permalink($item['slider_button_page_link']);
                            $target = '_self';
                            $rel = 'nofollow';
                        } else {
                            $link = !empty($item['slider_button_link']['url']) ? $item['slider_button_link']['url'] : '';
                            $target = !empty($item['slider_button_link']['is_external']) ? '_blank' : '';
                            $rel = !empty($item['slider_button_link']['nofollow']) ? 'nofollow' : '';
                        }

                        // btn Link
                        if ('2' == $item['slider_button_link_type_two']) {
                            $link = get_permalink($item['slider_button_page_link_two']);
                            $target = '_self';
                            $rel = 'nofollow';
                        } else {
                            $link = !empty($item['slider_button_link_two']['url']) ? $item['slider_button_link_two']['url'] : '';
                            $target = !empty($item['slider_button_link_two']['is_external']) ? '_blank' : '';
                            $rel = !empty($item['slider_button_link_two']['nofollow']) ? 'nofollow' : '';
                        }
                    ?>
                    <div class="item main-slider-three__slide-1">

                        <div class="main-slider-three__img">
                            <img src="<?php print esc_url($slider_image); ?>" alt="<?php print esc_url($slider_image_alt); ?>">
                        </div>

                        <div class="main-slider-three__shape-1 rotate-me">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/shapes/main-slider-three-shape-1.png" alt="<?php print esc_attr( 'shape', 'bixola-core' ); ?>">
                        </div>
                        <div class="main-slider-three__shape-2 img-bounce">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/shapes/main-slider-three-shape-2.png" alt="<?php print esc_attr( 'shape', 'bixola-core' ); ?>">
                        </div>
                        <div class="main-slider-three__shape-3 shape-mover">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/shapes/main-slider-three-shape-3.png" alt="<?php print esc_attr( 'shape', 'bixola-core' ); ?>">
                        </div>

                        <div class="container">
                            <div class="main-slider-three__content">
                                <?php
                                    if ($item['slider_title_tag']) :
                                        printf('<%1$s %2$s>%3$s</%1$s>',
                                            tag_escape($item['slider_title_tag']),
                                            $this->get_render_attribute_string('title_args'),
                                            twinkle_kses($item['slider_title'])
                                        );
                                    endif;
                                ?>
                                <?php if (!empty($item['slider_description'])) : ?>
                                    <p class="main-slider-three__text"><?php echo twinkle_kses( $item['slider_description'] ); ?></p>
                                <?php endif; ?>
                                <?php if (!empty($item['slider_button_text'])) : ?>
                                    <div class="main-slider-three__btn-box">
                                        <a target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>" class="bixola-el-button thm-btn main-slider__btn-1">
                                            <?php echo twinkle_kses($item['slider_button_text']); ?>
                                        </a>
                                        <?php if (!empty($item['slider_button_text_two'])) : ?>
                                            <a target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>" class="bixola-el-button thm-btn main-slider__btn-2">
                                                <?php echo twinkle_kses($item['slider_button_text_two']); ?>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </section>

        <?php elseif ( $settings['design_style']  == 'layout-4' ): ?>

            <section class="main-slider">
                <div class="main-slider__carousel owl-carousel owl-theme thm-owl__carousel">
                    <?php foreach ($settings['slider_list_four'] as $item) :
                        $this->add_render_attribute('title_args', 'class', 'bixola-el-title main-slider__title');

                        if ( !empty($item['slider_image']['url']) ) {
                            $slider_image = !empty($item['slider_image']['id']) ? wp_get_attachment_image_url( $item['slider_image']['id'], 'full') : $item['slider_image']['url'];
                            $slider_image_alt = get_post_meta($item["slider_image"]["id"], "_wp_attachment_image_alt", true);
                        }

                        // btn Link
                        if ('2' == $item['slider_button_link_type']) {
                            $link = get_permalink($item['slider_button_page_link']);
                            $target = '_self';
                            $rel = 'nofollow';
                        } else {
                            $link = !empty($item['slider_button_link']['url']) ? $item['slider_button_link']['url'] : '';
                            $target = !empty($item['slider_button_link']['is_external']) ? '_blank' : '';
                            $rel = !empty($item['slider_button_link']['nofollow']) ? 'nofollow' : '';
                        }
                    ?>
                        <div class="item main-slider__slide-1">
                            <div class="main-slider__bg" data-background="<?php print esc_url($slider_image); ?>"></div>
                            
                            <?php if (!empty($settings['shape_switch'])) : ?>
                                <div class="main-slider__shape-1 rotate-me">
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/shapes/main-slider-shape-1.png" alt="<?php print esc_attr( 'shape', 'bixola-core' ); ?>">
                                </div>
                                <div class="main-slider__shape-2 float-bob-x">
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/shapes/main-slider-shape-2.png" alt="<?php print esc_attr( 'shape', 'bixola-core' ); ?>">
                                </div>
                            <?php endif; ?>

                            <div class="container">
                                <div class="main-slider__content">
                                    <?php if (!empty($item['slider_subheading'])) : ?>
                                        <p class="bixola-el-subheading main-slider__sub-title"><?php echo twinkle_kses( $item['slider_subheading'] ); ?></p>
                                    <?php endif; ?>
                                    <?php
                                        if ($item['slider_title_tag']) :
                                            printf('<%1$s %2$s>%3$s</%1$s>',
                                                tag_escape($item['slider_title_tag']),
                                                $this->get_render_attribute_string('title_args'),
                                                twinkle_kses($item['slider_title'])
                                            );
                                        endif;
                                    ?>
                                    <?php if (!empty($item['slider_description'])) : ?>
                                        <p class="bixola-el-description main-slider__text"><?php echo twinkle_kses( $item['slider_description'] ); ?></p>
                                    <?php endif; ?>
                                    <div class="main-slider__btn-and-video-box">
                                        <?php if (!empty($item['slider_button_text'])) : ?>
                                            <div class="main-slider__btn-box">
                                                <a target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>" class="bixola-el-button thm-btn main-slider__btn">
                                                    <?php echo twinkle_kses($item['slider_button_text']); ?>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                        <?php if (!empty($item['slider_video_link'])) : ?>
                                            <div class="main-slider__video-link">
                                                <a href="<?php print esc_url($item['slider_video_link']); ?>" class="video-popup">
                                                    <div class="main-slider__video-icon">
                                                        <span class="fa fa-play"></span>
                                                        <i class="ripple"></i>
                                                    </div>
                                                </a>
                                                <?php if (!empty($item['slider_video_text'])) : ?>
                                                    <h4 class="main-slider__video-text">
                                                        <?php print esc_html($item['slider_video_text']); ?>
                                                    </h4>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </section>

        <?php elseif ( $settings['design_style']  == 'layout-5' ): ?>

            <section class="main-slider-four">
                <div class="main-slider-four__carousel owl-carousel owl-theme thm-owl__carousel">
                    <?php foreach ($settings['slider_list_four'] as $item) :
                        $this->add_render_attribute('title_args', 'class', 'bixola-el-title main-slider-four__title');

                        if ( !empty($item['slider_image']['url']) ) {
                            $slider_image = !empty($item['slider_image']['id']) ? wp_get_attachment_image_url( $item['slider_image']['id'], 'full') : $item['slider_image']['url'];
                            $slider_image_alt = get_post_meta($item["slider_image"]["id"], "_wp_attachment_image_alt", true);
                        }

                        // btn Link
                        if ('2' == $item['slider_button_link_type']) {
                            $link = get_permalink($item['slider_button_page_link']);
                            $target = '_self';
                            $rel = 'nofollow';
                        } else {
                            $link = !empty($item['slider_button_link']['url']) ? $item['slider_button_link']['url'] : '';
                            $target = !empty($item['slider_button_link']['is_external']) ? '_blank' : '';
                            $rel = !empty($item['slider_button_link']['nofollow']) ? 'nofollow' : '';
                        }
                    ?>
                    <div class="item main-slider-four__slide-1">

                        <div class="main-slider-four__bg" data-background="<?php print esc_url($slider_image); ?>"></div>

                        <?php if (!empty($settings['shape_switch'])) : ?>
                            <div class="main-slider-four__shape-1 float-bob-y">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/shapes/main-slider-four-shape-1.png" alt="<?php print esc_attr( 'shape', 'bixola-core' ); ?>">
                            </div>

                            <div class="main-slider-four__shape-2 float-bob-x">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/shapes/main-slider-four-shape-2.png" alt="<?php print esc_attr( 'shape', 'bixola-core' ); ?>">
                            </div>
                        <?php endif; ?>

                        <div class="container">
                            <div class="main-slider-four__content">
                                <?php
                                    if ($item['slider_title_tag']) :
                                        printf('<%1$s %2$s>%3$s</%1$s>',
                                            tag_escape($item['slider_title_tag']),
                                            $this->get_render_attribute_string('title_args'),
                                            twinkle_kses($item['slider_title'])
                                        );
                                    endif;
                                ?>
                                <?php if (!empty($item['slider_description'])) : ?>
                                    <p class="bixola-el-description main-slider-four__text"><?php echo twinkle_kses( $item['slider_description'] ); ?></p>
                                <?php endif; ?>
                                <div class="main-slider-four__btn-and-video-box">
                                    <?php if (!empty($item['slider_button_text'])) : ?>
                                        <div class="main-slider-four__btn-box">
                                            <a target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>" class="bixola-el-button thm-btn main-slider-four__btn">
                                                <?php echo twinkle_kses($item['slider_button_text']); ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                    <?php if (!empty($item['slider_video_link'])) : ?>
                                        <div class="main-slider-four__video-link">
                                            <a href="<?php print esc_url($item['slider_video_link']); ?>" class="video-popup">
                                                <div class="main-slider-four__video-icon">
                                                    <span class="fa fa-play"></span>
                                                    <i class="ripple"></i>
                                                </div>
                                            </a>
                                            <?php if (!empty($item['slider_video_text'])) : ?>
                                                <h4 class="main-slider-four__video-text">
                                                    <?php print esc_html($item['slider_video_text']); ?>
                                                </h4>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </section>
        
        <?php endif; ?>


		<?php 
	}
}

$widgets_manager->register( new Bixola_Hero_Slider() );