<?php
namespace BixolaCore\Widgets;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Utils;
use \Elementor\Control_Media;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Xlab Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Xlab_Fun_Fact extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'xlab_fun_fact';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Fun Fact', 'bixola-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'xlab-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'xlab_core' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'bixola-core' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {
        $this->start_controls_section(
            'section_title',
            [
                'label' => esc_html__('Desigin Layout', 'bixola-core'),
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label' => esc_html__( 'Style', 'bixola-core' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'layout-1',
                'options' => [
                    'layout-1' => esc_html__( 'Layout 1', 'bixola-core' ),
                    'layout-2'  => esc_html__( 'Layout 2', 'bixola-core' ),
                    'layout-3'  => esc_html__( 'Layout 3', 'bixola-core' ),
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'xlab_fun_fact',
            [
                'label' => esc_html__('Fun Fact', 'bixola-core'),
                'description' => esc_html__( 'Control all the style settings from Style tab', 'bixola-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'xlab_fun_fact_icon_switcher',
			[
				'label' => esc_html__( 'Image Type', 'bixola-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'icon',
				'options' => [
					'image' => esc_html__( 'Image', 'bixola-core' ),
					'icon' => esc_html__( 'Icon', 'bixola-core' ),
                    'svg' => esc_html__('SVG', 'bixola-core'),
				],
			]
		);
        $this->add_control(
            'xlab_box_icon_svg',
            [
                'show_label' => false,
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'placeholder' => esc_html__('SVG Code Here', 'rr-core'),
                'condition' => [
                    'xlab_fun_fact_icon_switcher' => 'svg'
                ]
            ]
        );
        $this->add_control(
            'xlab_fun_fact_image',
            [
                'label' => esc_html__('Upload Image', 'bixola-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'xlab_fun_fact_icon_switcher' => 'image',
                ],
            ]
        );

        if (xlab_is_elementor_version('<', '2.6.0')) {
            $this->add_control(
                'xlab_fun_fact_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'icon-certificate-1',
                    'condition' => [
                        'xlab_fun_fact_icon_switcher' => 'icon',
                    ],
                ]
            );
        } else {
            $this->add_control(
                'xlab_fun_fact_selected_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'icon-certificate-1',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'xlab_fun_fact_icon_switcher' => 'icon',
                    ],
                ]
            );
        }

        $this->add_control(
            'xlab_fun_fact_title', [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => xlab_get_allowed_html_desc( 'basic' ),
                'default' => esc_html__('Happy Clients', 'bixola-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'xlab_fun_fact_count', [
                'label' => esc_html__('Count Number', 'bixola-core'),
                'default' => '53',
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'xlab_fun_fact_percent', [
                'label' => esc_html__('Count Percent', 'bixola-core'),
                'description' => xlab_get_allowed_html_desc( 'basic' ),
                'default' => esc_html__('K', 'bixola-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

    






        
        $this->start_controls_section(
            '_section_fun_fact_style',
            [
                'label' => __( 'Fun Fact', 'bixola-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            '_heading_layout',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Layout', 'bixola-core' ),
            ]
        );

        $this->add_responsive_control(
            'layout_bottom_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .work-progress__item, .work-progress-2__item, .work-progress-4__item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __( 'Content Padding', 'bixola-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .work-progress__item, .work-progress-2__item, .work-progress-4__item ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'content_background',
            [
                'label' => __( 'Content Background', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .work-progress__item, .work-progress-2__item, .work-progress-4__item ' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'label'    => esc_html__( 'Border', 'bixola-core' ),
                'name'     => 'content_border',
                'selector' => '{{WRAPPER}} .work-progress__item, .work-progress-2__item, .work-progress-4__item',
            ]
        );

        $this->add_control(
            '_heading_icon',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Icon', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'icon_bottom_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .work-progress__item .icon-box' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .work-progress-4__item-icon .icon-box' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __( 'Icon Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .work-progress__item .icon-box i::before' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .work-progress-4__item-icon .icon-box i::before' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __( 'Icon Size', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .work-progress__item .icon-box i::before' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .work-progress-4__item-icon .icon-box i::before' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            '_content_count',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Count', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'count_left_spacing',
            [
                'label' => __( 'Left Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .work-progress__item-text h2' => 'margin-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .work-progress-2__item-text h2' => 'margin-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .work-progress-4__item-text h2' => 'margin-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .work-progress__item-text h2 span' => 'margin-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .work-progress-2__item-text h2 span' => 'margin-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .work-progress-4__item-text h2 span' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'count_color',
            [
                'label' => __( 'Text Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .work-progress__item-text h2' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .work-progress-2__item-text h2' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .work-progress-4__item-text h2' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .work-progress__item-text h2 span' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .work-progress-2__item-text h2 span' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .work-progress-4__item-text h2 span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'count_typography',
                'selector' => '{{WRAPPER}} .work-progress__item-text h2, .work-progress-2__item-text h2, .work-progress-4__item-text h2 ',
            ]
        );

        $this->add_control(
            '_content_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Title', 'bixola-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'title_top_spacing',
            [
                'label' => __( 'Top Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .color-white, .work-progress-4__item-text span' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Text Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .color-white, .work-progress-4__item-text span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .color-white, .work-progress-4__item-text span',
            ]
        );

        $this->end_controls_section();
	}
    
	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0 
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		?>

<?php if ( $settings['design_style']  == 'layout-1' ): ?>
<div class="work-progress__item d-flex align-items-center justify-content-center mb-30 wow fadeIn animated"
    data-bg-color="#0D2216" data-wow-delay=".3s">
    <div class="work-progress__item-icon">
        <?php if (!empty($settings['xlab_fun_fact_image']['url'])): ?>
        <div class="icon-box">
            <img src="<?php echo $settings['xlab_fun_fact_image']['url']; ?>"
                alt="<?php echo get_post_meta(attachment_url_to_postid($settings['xlab_fun_fact_image']['url']), '_wp_attachment_image_alt', true); ?>">
        </div>
        <?php endif; ?>
        <?php if (!empty($settings['xlab_fun_fact_icon']) || !empty($settings['xlab_fun_fact_selected_icon']['value'])) : ?>
        <div class="icon-box">
            <?php xlab_render_icon($settings, 'xlab_fun_fact_icon', 'xlab_fun_fact_selected_icon'); ?>
        </div>
        <?php endif; ?>
    </div>
    <div class="work-progress__item-text">
        <?php if(!empty($settings['xlab_fun_fact_count'])): ?>
        <h2 class="title color-white mb-0"><span
                class="counter"><?php echo esc_attr($settings['xlab_fun_fact_count' ]); ?></span><?php echo twinkle_kses($settings['xlab_fun_fact_percent' ]); ?>
        </h2>
        <?php endif; ?>
        <?php if(!empty($settings['xlab_fun_fact_title'])): ?>
        <p class="color-white"><?php echo twinkle_kses($settings['xlab_fun_fact_title' ]); ?></p>
        <?php endif; ?>
    </div>
</div>
<?php elseif ( $settings['design_style']  == 'layout-2' ): ?>
<div class="work-progress-2__item d-flex align-items-center wow fadeIn  animated" data-wow-delay=".6s"
    style="visibility: visible; animation-delay: 0.6s; animation-name: fadeIn;">
    <div class="work-progress-2__item-icon">
        <?php if (!empty($settings['xlab_fun_fact_image']['url'])): ?>
        <div class="icon-box">
            <img src="<?php echo $settings['xlab_fun_fact_image']['url']; ?>"
                alt="<?php echo get_post_meta(attachment_url_to_postid($settings['xlab_fun_fact_image']['url']), '_wp_attachment_image_alt', true); ?>">
        </div>
        <?php endif; ?>
        <?php if (!empty($settings['xlab_fun_fact_icon']) || !empty($settings['xlab_fun_fact_selected_icon']['value'])) : ?>
        <div class="icon-box">
            <?php xlab_render_icon($settings, 'xlab_fun_fact_icon', 'xlab_fun_fact_selected_icon'); ?>
        </div>
        <?php endif; ?>
    </div>
    <div class="work-progress-2__item-text">
        <?php if(!empty($settings['xlab_fun_fact_count'])): ?>
        <h2 class="title color-white mb-10 mb-xs-5"><span
                class="counter"><?php echo esc_attr($settings['xlab_fun_fact_count' ]); ?></span><?php echo twinkle_kses($settings['xlab_fun_fact_percent' ]); ?>
        </h2>
        <?php endif; ?>
        <?php if(!empty($settings['xlab_fun_fact_title'])): ?>
        <p class="color-white"><?php echo twinkle_kses($settings['xlab_fun_fact_title' ]); ?></p>
        <?php endif; ?>
    </div>
</div>
<?php elseif ( $settings['design_style']  == 'layout-3' ): ?>
<div class="work-progress-4__item d-flex justify-content-between align-items-center  wow fadeIn  animated"
    data-wow-delay=".2s" data-bg-color="#fff">
    <div class="work-progress-4__item-text">
        <?php if(!empty($settings['xlab_fun_fact_title'])): ?>
        <span><?php echo twinkle_kses($settings['xlab_fun_fact_title' ]); ?></span>
        <?php endif; ?>
        <h2><span class="counter"><?php echo esc_attr($settings['xlab_fun_fact_count' ]); ?></span>+</h2>
    </div>
    <div class="work-progress-4__item-icon d-flex align-items-center justify-content-center" data-bg-color="#00D563">
    <?php if (!empty($settings['xlab_fun_fact_image']['url'])): ?>
        <div class="icon-box">
            <img src="<?php echo $settings['xlab_fun_fact_image']['url']; ?>"
                alt="<?php echo get_post_meta(attachment_url_to_postid($settings['xlab_fun_fact_image']['url']), '_wp_attachment_image_alt', true); ?>">
        </div>
        <?php endif; ?>
        <?php if (!empty($settings['xlab_fun_fact_icon']) || !empty($settings['xlab_fun_fact_selected_icon']['value'])) : ?>
        <div class="icon-box">
            <?php xlab_render_icon($settings, 'xlab_fun_fact_icon', 'xlab_fun_fact_selected_icon'); ?>
        </div>
        <?php endif; ?>
        <?php if (!empty($settings['xlab_box_icon_svg'])): ?>
        <?php echo $settings['xlab_box_icon_svg']; ?>
        <?php endif; ?>     
    </div>
</div>
<?php endif; ?>
<?php 
	}
}

$widgets_manager->register( new Xlab_Fun_Fact() );