<?php
namespace BixolaCore\Widgets;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Bixola Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Bixola_Faq extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bixola_faq';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Faq', 'bixola-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'bixola-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bixola_core' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'bixola-core' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {
        
        $this->start_controls_section(
            '_content_design_layout',
            [
                'label' => esc_html__('Design Layout', 'bixola-core'),
            ]
        );
        $this->add_control(
            'design_style',
            [
                'label' => esc_html__('Select Layout', 'bixola-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'bixola-core'),
                    'layout-2' => esc_html__('Layout 2', 'bixola-core'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->add_control(
            'section_image',
            [
                'label' => esc_html__( 'Choose Image', 'text-domain' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_title',
            [
                'label' => esc_html__('Title & Description', 'bixola-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'section_subheading',
            [
                'label' => esc_html__( 'Subheading', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'FAQs', 'bixola-core' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_title',
            [
                'label' => esc_html__( 'Title', 'bixola-core' ),
                'description' => bixola_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Frequently asked questions', 'bixola-core' ),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_faq',
            [
                'label' => esc_html__( 'FAQ List', 'bixola-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'faq_active',
            [
                'label' => esc_html__( 'Open', 'bixola-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'bixola-core' ),
                'label_off' => esc_html__( 'Hide', 'bixola-core' ),
                'return_value' => 'active',
                'default' => '',
            ]
        );

        $repeater->add_control(
            'faq_no', [
                'label' => esc_html__( 'No.', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'faq_title', [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'faq_description', [
                'label' => esc_html__('Description', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'faq_list',
            [
                'label' => esc_html__('Faq List', 'bixola-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'faq_active' => 'active',
                        'faq_no' => __( 'Q1.', 'bixola-core' ),
                        'faq_title' => esc_html__( 'What activities are done in the development?', 'bixola-core' ),
                        'faq_description' => esc_html__( 'Follow these 6 steps and you’ll get your Help Scout account up and running in no time. If you like to get a full tour of Help Scout and all its features, attend one of our weekly live demos or take a video tour.', 'bixola-core'),
                    ],
                    [
                        'faq_no' => __( 'Q2.', 'bixola-core' ),
                        'faq_title' => esc_html__( 'How can i use landbook When should I use a Tag?', 'bixola-core' ),
                        'faq_description' => esc_html__( 'Follow these 6 steps and you’ll get your Help Scout account up and running in no time. If you like to get a full tour of Help Scout and all its features, attend one of our weekly live demos or take a video tour.', 'bixola-core'),
                    ],
                    [
                        'faq_no' => __( 'Q3.', 'bixola-core' ),
                        'faq_title' => esc_html__( 'Are social media good for the business growth?', 'bixola-core' ),
                        'faq_description' => esc_html__( 'Follow these 6 steps and you’ll get your Help Scout account up and running in no time. If you like to get a full tour of Help Scout and all its features, attend one of our weekly live demos or take a video tour.', 'bixola-core'),
                    ],
                    [
                        'faq_no' => __( 'Q4.', 'bixola-core' ),
                        'faq_title' => esc_html__( 'How often should i work on the digital marketing?', 'bixola-core' ),
                        'faq_description' => esc_html__( 'Follow these 6 steps and you’ll get your Help Scout account up and running in no time. If you like to get a full tour of Help Scout and all its features, attend one of our weekly live demos or take a video tour.', 'bixola-core'),
                    ],
                    [
                        'faq_no' => __( 'Q5.', 'bixola-core' ),
                        'faq_title' => esc_html__( 'What are the different types of marketing solutions?', 'bixola-core' ),
                        'faq_description' => esc_html__( 'Follow these 6 steps and you’ll get your Help Scout account up and running in no time. If you like to get a full tour of Help Scout and all its features, attend one of our weekly live demos or take a video tour.', 'bixola-core'),
                    ],
                ],
                'title_field' => '{{{ faq_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_faq_two',
            [
                'label' => esc_html__( 'FAQ List', 'bixola-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'layout-2',
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'faq_active',
            [
                'label' => esc_html__( 'Open', 'bixola-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'bixola-core' ),
                'label_off' => esc_html__( 'Hide', 'bixola-core' ),
                'return_value' => 'active',
                'default' => '',
            ]
        );

        $repeater->add_control(
            'faq_title', [
                'label' => esc_html__('Title', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'faq_description', [
                'label' => esc_html__('Description', 'bixola-core'),
                'description' => bixola_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'faq_list_two',
            [
                'label' => esc_html__('Faq List', 'bixola-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'faq_active' => 'active',
                        'faq_title' => esc_html__( 'What activities are done in the development?', 'bixola-core' ),
                        'faq_description' => esc_html__( 'Follow these 6 steps and you’ll get your Help Scout account up and running in no time. If you like to get a full tour of Help Scout and all its features, attend one of our weekly live demos or take a video tour.', 'bixola-core'),
                    ],
                    [
                        'faq_title' => esc_html__( 'How can i use landbook When should I use a Tag?', 'bixola-core' ),
                        'faq_description' => esc_html__( 'Follow these 6 steps and you’ll get your Help Scout account up and running in no time. If you like to get a full tour of Help Scout and all its features, attend one of our weekly live demos or take a video tour.', 'bixola-core'),
                    ],
                    [
                        'faq_title' => esc_html__( 'Are social media good for the business growth?', 'bixola-core' ),
                        'faq_description' => esc_html__( 'Follow these 6 steps and you’ll get your Help Scout account up and running in no time. If you like to get a full tour of Help Scout and all its features, attend one of our weekly live demos or take a video tour.', 'bixola-core'),
                    ],
                    [
                        'faq_title' => esc_html__( 'How often should i work on the digital marketing?', 'bixola-core' ),
                        'faq_description' => esc_html__( 'Follow these 6 steps and you’ll get your Help Scout account up and running in no time. If you like to get a full tour of Help Scout and all its features, attend one of our weekly live demos or take a video tour.', 'bixola-core'),
                    ],
                    [
                        'faq_title' => esc_html__( 'What are the different types of marketing solutions?', 'bixola-core' ),
                        'faq_description' => esc_html__( 'Follow these 6 steps and you’ll get your Help Scout account up and running in no time. If you like to get a full tour of Help Scout and all its features, attend one of our weekly live demos or take a video tour.', 'bixola-core'),
                    ],
                ],
                'title_field' => '{{{ faq_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'_style_design_layout',
			[
				'label' => __( 'Design Layout', 'bixola-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_responsive_control(
            'design_layout_bottom_spacing',
            [
                'label' => __( 'Bottom Spacing', 'bixola-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .faq-content .accordion-item:not(:last-of-type)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Design Style Control
        // Faq List
        $this->start_controls_section(
            '_section_faq_list_style',
            [
                'label' => __( 'Faq List', 'bixola-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            '_heading_faq_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Title', 'bixola-core' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'faq_title_typography',
                'selector' => '{{WRAPPER}} .faq-content .accordion-item .accordion-header .accordion-button',
            ]
        );

        $this->add_responsive_control(
            'faq_title_padding',
            [
                'label' => __( 'Padding', 'bixola-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-content .accordion-item .accordion-header .accordion-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'faq_title_border_radius',
            [
                'label' => __( 'Border Radius', 'bixola-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-content .accordion-item .accordion-header .accordion-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'faq_list_tabs' );

        $this->start_controls_tab(
            'faq_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'bixola-core' ),
            ]
        );

        $this->add_control(
            'faq_title_color',
            [
                'label' => __( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-content .accordion-item .accordion-header .accordion-button' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'faq_title_background',
            [
                'label' => __( 'Background', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-content .accordion-item .accordion-header .accordion-button' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'faq_active_tab',
            [
                'label' => esc_html__( 'Active', 'bixola-core' ),
            ]
        );

        $this->add_control(
            'faq_title_color_active',
            [
                'label' => __( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-content .accordion-item .accordion-header .accordion-button:not(.collapsed)' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'faq_title_background_active',
            [
                'label' => __( 'Background', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-content .accordion-item .accordion-header .accordion-button:not(.collapsed)' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            '_heading_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Description', 'bixola-core' ),
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'faq_description_color',
            [
                'label' => __( 'Color', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-content .accordion-item .accordion-body' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'faq_description_background',
            [
                'label' => __( 'Background', 'bixola-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-content .accordion-item .accordion-body' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'faq_description_typography',
                'selector' => '{{WRAPPER}} .faq-content .accordion-item .accordion-body',
            ]
        );

        $this->add_responsive_control(
            'faq_description_padding',
            [
                'label' => __( 'Padding', 'bixola-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-content .accordion-item .accordion-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'faq_description_border_radius',
            [
                'label' => __( 'Border Radius', 'bixola-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-content .accordion-item .accordion-body' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
        $settings = $this->get_settings_for_display();
	
        if ( !empty($settings['section_image']['url']) ) {
            $section_image = !empty($settings['section_image']['id']) ? wp_get_attachment_image_url( $settings['section_image']['id'], 'full') : $settings['section_image']['url'];
            $section_image_alt = get_post_meta($settings["section_image"]["id"], "_wp_attachment_image_alt", true);
        }
    
        ?>

        <?php if ( $settings['design_style']  == 'layout-1' ) : ?>

            <section class="bixola-el-section faq-one">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-5 col-lg-5">
                            <div class="faq-one__left">
                                <div class="section-title text-left">
                                    <?php if ( !empty( $settings['section_subheading'] ) ) : ?>
                                        <div class="section-title__tagline-box">
                                            <p class="bixola-el-section-subheading section-title__tagline">
                                                <?php print twinkle_kses($settings['section_subheading']); ?>
                                            </p>
                                        </div>
                                    <?php endif; ?>
                                    <?php if ( !empty( $settings['section_title'] ) ) : ?>
                                        <h2 class="bixola-el-section-title section-title__title">
                                            <?php print twinkle_kses($settings['section_title']); ?>
                                        </h2>
                                    <?php endif; ?>
                                </div>
                                <div class="faq-one__img">
                                    <?php if ( !empty( $section_image ) ) : ?>
                                        <img src="<?php print esc_url($section_image); ?>" alt="<?php print esc_attr($section_image_alt); ?>">
                                    <?php endif; ?>
                                    <?php if ( !empty( $settings['shape_switch'] ) ) : ?>
                                        <div class="faq-one__shape-1 float-bob-y">
                                            <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/faq-one-shape-1.png" alt="">
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-7 col-lg-7">
                            <div class="faq-one__right">
                                <div class="accrodion-grp" data-grp-name="faq-one-accrodion">
                                    <?php foreach ($settings['faq_list'] as $id => $item) : ?>
                                    <div class="accrodion <?php echo esc_attr($item['faq_active']); ?>">
                                        <div class="accrodion-title">
                                            <h4>
                                                <?php if ( !empty( $item['faq_no' ] ) ) : ?>
                                                    <span><?php echo twinkle_kses($item['faq_no' ]); ?></span>
                                                <?php endif; ?>
                                                <?php echo twinkle_kses($item['faq_title' ]); ?>
                                            </h4>
                                        </div>
                                        <div class="accrodion-content">
                                            <div class="inner">
                                                <p><?php echo twinkle_kses($item['faq_description' ]); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        <?php elseif ( $settings['design_style']  == 'layout-2' ) : ?>

            <section class="bixola-el-section faq-two">
                <?php if ( !empty( $settings['shape_switch'] ) ) : ?>
                    <div class="faq-two__shape-1 float-bob-y">
                        <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/faq-two-shape-1.png" alt="">
                    </div>
                    <div class="faq-two__shape-2 img-bounce">
                        <img src="<?php print get_template_directory_uri(); ?>/assets/images/shapes/faq-two-shape-2.png" alt="">
                    </div>
                <?php endif; ?>
                <div class="container">
                    <div class="faq-two__inner">
                        <div class="section-title text-center">
                            <?php if ( !empty( $settings['section_subheading'] ) ) : ?>
                                <div class="section-title__tagline-box">
                                    <p class="bixola-el-section-subheading section-title__tagline">
                                        <?php print twinkle_kses($settings['section_subheading']); ?>
                                    </p>
                                </div>
                            <?php endif; ?>
                            <?php if ( !empty( $settings['section_title'] ) ) : ?>
                                <h3 class="bixola-el-section-title section__title-two">
                                    <?php print twinkle_kses($settings['section_title']); ?>
                                </h3>
                            <?php endif; ?>
                        </div>
                        <div class="accrodion-grp" data-grp-name="faq-two-accrodion">
                            <?php foreach ($settings['faq_list_two'] as $id => $item) : ?>
                                <div class="accrodion <?php echo esc_attr($item['faq_active']); ?>">
                                    <div class="accrodion-title">
                                        <h4><?php echo twinkle_kses($item['faq_title' ]); ?></h4>
                                    </div>
                                    <div class="accrodion-content">
                                        <div class="inner">
                                            <p><?php echo twinkle_kses($item['faq_description' ]); ?></p>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </section>

        <?php endif; ?>

        <?php
	}
}

$widgets_manager->register( new Bixola_Faq() );